/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesUtils;
import com.ibm.ws.management.commands.properties.resources.mapping.PropertyData;
import com.ibm.ws.management.commands.properties.resources.mapping.SectionData;
import com.ibm.ws.management.commands.properties.resources.properties.Props;
import com.ibm.ws.management.commands.properties.resources.properties.Section;
import com.ibm.ws.management.wasresource.common.WASResource;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteProperties {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(DeleteProperties.class, "DeleteProperties", "com.ibm.ws.management.resources.configservice");

    public static void deleteProperties(ConfigService cs, Session session, SectionData[] sectionDataArray, Section[] sections) throws Exception {
        DeleteProperties.deleteProperties(cs, session, sectionDataArray, sections, null);
    }

    public static void deleteProperties(ConfigService cs, Session session, SectionData[] sectionDataArray, Section[] sections, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteProperties", new Object[]{cs, session, sectionDataArray, sections});
        }
        for (int i = 0; i < sections.length; ++i) {
            DeleteProperties.deleteProperties(cs, session, sectionDataArray[i], sections[i], res);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteProperties");
        }
    }

    public static void deleteProperties(ConfigService cs, Session session, SectionData sectionData, Section section) throws Exception {
        DeleteProperties.deleteProperties(cs, session, sectionData, section, null);
    }

    public static void deleteProperties(ConfigService cs, Session session, SectionData sectionData, Section section, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteProperties", new Object[]{cs, session, sectionData, section});
        }
        DeleteProperties.logReport(res, "ADMG0818I", new Object[]{DeleteProperties.getSectionInfo(sectionData)});
        if (section.getNameField() != null) {
            DeleteProperties.deletePropertiesNameValue(cs, session, section.getSectionHeaderProperties(), section.getProps(), sectionData, res);
        } else {
            DeleteProperties.deleteProperties(cs, session, section.getSectionHeaderProperties(), section.getProps(), sectionData, res);
        }
        DeleteProperties.logReport(res, "ADMG0819I", new Object[]{DeleteProperties.getSectionInfo(sectionData)});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteProperties");
        }
    }

    public static void deleteProperties(ConfigService cs, Session session, Properties sectionProps, Props[] props, SectionData sectionData) throws Exception {
        DeleteProperties.deleteProperties(cs, session, sectionProps, props, sectionData, null);
    }

    public static void deleteProperties(ConfigService cs, Session session, Properties sectionProps, Props[] props, SectionData sectionData, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteProperties", new Object[]{cs, session, sectionProps, props, sectionData});
        }
        String configIdString = sectionProps.getProperty("RESOURCEID");
        ObjectName cfgId = null;
        if (DeleteProperties.isCfgId(configIdString)) {
            cfgId = ConfigServiceHelper.createObjectName(new ConfigDataId(configIdString));
        } else {
            try {
                cfgId = PropertiesUtils.convertConfigScopeToConfigObject(null, configIdString, session, cs);
            }
            catch (Exception e) {
                DeleteProperties.logReport(res, "ADMG0806I", new Object[]{configIdString});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setProperties");
                }
                return;
            }
        }
        String delete = sectionProps.getProperty("DELETE");
        if (delete != null && delete.equals("true")) {
            DeleteProperties.logReport(res, "ADMG0808I", new Object[]{configIdString});
            cs.deleteConfigData(session, cfgId);
        } else {
            ArrayList<String> attrList = new ArrayList<String>();
            for (int j = 0; props != null && j < props.length; ++j) {
                if (DeleteProperties.readOnly(props[j].getName(), sectionData) || !DeleteProperties.valuePresent(props[j])) continue;
                attrList.add(DeleteProperties.getAttrName(sectionData, props[j].getName()));
            }
            String[] attributes = attrList.toArray(new String[0]);
            StringBuffer sb = new StringBuffer("{");
            for (int i = 0; attributes != null && i < attributes.length; ++i) {
                sb.append(attributes[i]).append(",");
            }
            if (sb.lastIndexOf(",") > 0) {
                sb.deleteCharAt(sb.lastIndexOf(","));
                sb.append("}");
            }
            DeleteProperties.logReport(res, "ADMG0828I", new Object[]{sb.toString()});
            cs.unsetAttributes(session, cfgId, attributes);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteProperties", props);
        }
    }

    private static boolean valuePresent(Props prop) {
        if (prop.getValue() != null && !prop.getValue().equals("null")) {
            return true;
        }
        return prop.getValues() != null && prop.getValues().size() > 0;
    }

    private static void deletePropertiesNameValue(ConfigService cs, Session session, Properties sectionProps, Props[] props, SectionData sectionData) throws Exception {
        DeleteProperties.deletePropertiesNameValue(cs, session, sectionProps, props, sectionData, null);
    }

    private static void deletePropertiesNameValue(ConfigService cs, Session session, Properties sectionProps, Props[] props, SectionData sectionData, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deletePropertiesNameValue", new Object[]{cs, session, sectionProps, props, sectionData});
        }
        String configIdString = sectionProps.getProperty("RESOURCEID");
        ObjectName cfgId = null;
        if (DeleteProperties.isCfgId(configIdString)) {
            cfgId = ConfigServiceHelper.createObjectName(new ConfigDataId(configIdString));
        } else {
            try {
                cfgId = PropertiesUtils.convertConfigScopeToConfigObject(null, configIdString, session, cs);
            }
            catch (Exception e) {
                DeleteProperties.logReport(res, "ADMG0806I", new Object[]{configIdString});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setProperties");
                }
                return;
            }
        }
        String delete = sectionProps.getProperty("DELETE");
        if (delete != null && delete.equals("true")) {
            String attrName = sectionData.getAttrName();
            String nameField = sectionData.getName();
            String valueField = sectionData.getValue();
            DeleteProperties.logReport(res, "ADMG0814I", new Object[]{cfgId, sectionData.getAttrName()});
            DeleteProperties.deleteAllProperties(cs, session, nameField, valueField, attrName, cfgId, res);
        } else {
            String attrName = sectionData.getAttrName();
            String nameField = sectionData.getName();
            String valueField = sectionData.getValue();
            AttributeList newAttrs = new AttributeList();
            ArrayList newProps = new ArrayList();
            String collectionType = sectionData.getCollectionType();
            for (int i = 0; props != null && i < props.length; ++i) {
                String pName = props[i].getName();
                DeleteProperties.deleteProperty(cs, session, nameField, valueField, attrName, cfgId, pName, res);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deletePropertiesNameValue");
        }
    }

    private static boolean isCfgId(String cfgId) {
        boolean res = false;
        if (cfgId.indexOf("cells/") >= 0 && cfgId.indexOf(124) > 0) {
            res = true;
        }
        return res;
    }

    private static String getAttrName(SectionData sectionData, String pName) {
        String res = pName;
        PropertyData[] pData = sectionData.getPropertiesData();
        for (int i = 0; pData != null && i < pData.length; ++i) {
            if (!pData[i].getPropName().equals(pName)) continue;
            res = pData[i].getAttrName();
        }
        return res;
    }

    private static void deleteProperty(ConfigService cs, Session session, String nameField, String valueField, String attrName, ObjectName cfgId, String pName, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteProperty", new Object[]{cs, session, nameField, valueField, attrName, pName});
        }
        boolean found = false;
        AttributeList oldAttrs = cs.getAttributes(session, cfgId, new String[]{attrName}, false);
        if (oldAttrs == null || oldAttrs.size() <= 0) {
            return;
        }
        List oldProps = (List)((Attribute)oldAttrs.get(0)).getValue();
        if (oldProps == null || oldProps.size() <= 0) {
            return;
        }
        for (ObjectName prop : oldProps) {
            String oldName = (String)cs.getAttribute(session, prop, nameField);
            if (!oldName.equals(pName)) continue;
            found = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting property " + oldName);
            }
            cs.deleteConfigData(session, prop);
            break;
        }
        if (!found) {
            DeleteProperties.logReport(res, "ADMG0829I", new Object[]{pName});
        } else {
            DeleteProperties.logReport(res, "ADMG0830I", new Object[]{pName});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteProperty");
        }
    }

    private static void deleteAllProperties(ConfigService cs, Session session, String nameField, String valueField, String attrName, ObjectName cfgId, WASResource res) throws Exception {
        AttributeList oldAttrs;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteAllProperties", new Object[]{cs, session, nameField, valueField, attrName, cfgId});
        }
        if ((oldAttrs = cs.getAttributes(session, cfgId, new String[]{attrName}, false)) == null || oldAttrs.size() <= 0) {
            return;
        }
        List oldProps = (List)((Attribute)oldAttrs.get(0)).getValue();
        if (oldProps == null || oldProps.size() <= 0) {
            return;
        }
        for (ObjectName prop : oldProps) {
            String oldName = (String)cs.getAttribute(session, prop, nameField);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting property " + oldName);
            }
            DeleteProperties.logReport(res, "ADMG0813I", new Object[]{oldName});
            cs.deleteConfigData(session, prop);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteAllProperties");
        }
    }

    private static boolean readOnly(String pName, SectionData sectionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readOnly", new Object[]{pName, sectionData});
        }
        boolean result = false;
        PropertyData[] pData = sectionData.getPropertiesData();
        for (int i = 0; i < pData.length; ++i) {
            String name = pData[i].getPropName();
            if (!pName.equals(name) || !pData[i].isReadOnly()) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readOnly", new Boolean(result));
        }
        return result;
    }

    private static void logReport(WASResource res, String key, Object[] objs) {
        try {
            FileOutputStream os = (FileOutputStream)res.getReferenceProperties().get("REPORTFILE_OS");
            if (os != null) {
                ConfigPropertiesHelper.logReport(res, os, key, objs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSectionInfo(SectionData sectionData) {
        return sectionData.getType() + ":" + sectionData.getContainingType();
    }
}

