/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.common;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesUtils;
import com.ibm.ws.management.commands.properties.resources.mapping.CommandInfo;
import com.ibm.ws.management.commands.properties.resources.mapping.PropertyData;
import com.ibm.ws.management.commands.properties.resources.mapping.SectionData;
import com.ibm.ws.management.commands.properties.resources.properties.Props;
import com.ibm.ws.management.commands.properties.resources.properties.Section;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.wasresource.common.PropWASResource;
import com.ibm.ws.management.wasresource.common.WASResource;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import java.io.FileOutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EObject;

public class ApplyProperties {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ApplyProperties.class, "ApplyProperties", "com.ibm.ws.management.resources.configservice");
    private static HashMap parentChildRelations = new HashMap();
    private static HashMap intermediateObjects;
    private static HashMap typeToAttrNameMappings;

    public static void setProperties(ConfigService cs, Session session, SectionData[] sectionDataArray, Section[] sections, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{cs, session, sectionDataArray, sections});
        }
        for (int i = 0; i < sections.length; ++i) {
            ApplyProperties.setProperties(cs, session, sectionDataArray[i], sections[i], res);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public static void setProperties(ConfigService cs, Session session, SectionData sectionData, Section[] sections, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{cs, session, sectionData, sections});
        }
        for (int i = 0; i < sections.length; ++i) {
            ApplyProperties.setProperties(cs, session, sectionData, sections[i], res);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public static void setProperties(ConfigService cs, Session session, SectionData sectionData, Section section, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{cs, session, sectionData, section});
        }
        ApplyProperties.logReport(res, "ADMG0818I", new Object[]{ApplyProperties.getSectionInfo(sectionData)});
        if (section.getNameField() != null) {
            ApplyProperties.setPropertiesNameValue(cs, session, section.getSectionHeaderProperties(), section.getProps(), sectionData, res);
        } else {
            ApplyProperties.setProperties(cs, session, section.getSectionHeaderProperties(), section.getProps(), sectionData, res);
        }
        ApplyProperties.logReport(res, "ADMG0819I", new Object[]{ApplyProperties.getSectionInfo(sectionData)});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public static void setProperties(ConfigService cs, Session session, Properties sectionProps, Props[] props, SectionData sectionData, WASResource res) throws Exception {
        ObjectName cfgId;
        block100: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setProperties", new Object[]{cs, session, sectionProps, props});
            }
            String configIdString = sectionProps.getProperty("RESOURCEID");
            cfgId = null;
            if (ApplyProperties.isCfgId(configIdString)) {
                cfgId = ConfigServiceHelper.createObjectName(new ConfigDataId(configIdString));
            } else {
                try {
                    cfgId = PropertiesUtils.convertConfigScopeToConfigObject(null, configIdString, session, cs);
                }
                catch (Exception e) {
                    try {
                        AttributeList attrList = ApplyProperties.getAttributeList(sectionData, props);
                        ObjectName parent = res.getConfigData();
                        cfgId = ApplyProperties.createConfigObject(cs, session, parent, configIdString, sectionData.getAttrName(), sectionData.getType(), attrList);
                    }
                    catch (Exception ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Invalid config id specified " + configIdString);
                        }
                        cfgId = null;
                    }
                    if (cfgId != null) break block100;
                    ApplyProperties.logReport(res, "ADMG0806I", new Object[]{configIdString});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "setProperties");
                    }
                    return;
                }
            }
        }
        AttributeList attrList = new AttributeList();
        AttributeList oldAttrs = cs.getAttributes(session, cfgId, null, false);
        PropertyData[] pData = sectionData.getPropertiesData();
        ArrayList alreadyProcessed = new ArrayList();
        ApplyProperties.reportInvalidProperties(pData, props, res);
        for (int i = 0; i < pData.length; ++i) {
            ArrayList lst;
            ArrayList sList;
            ArrayList lst2;
            Object oldVal;
            String pName = pData[i].getPropName();
            String aName = pData[i].getAttrName();
            String pValue = null;
            List pValues = null;
            int pIndex = ApplyProperties.getIndex(props, pName);
            if (pIndex == -1) continue;
            String pTypeActual = props[pIndex].getType();
            String pTypeFromMetadata = pData[i].getType();
            String pType = new String(pTypeActual);
            if (pTypeActual != null && pType != null && !pTypeActual.equals(pType)) {
                ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pTypeActual, pType});
            }
            if (alreadyProcessed.contains(pName)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Property " + pName + " is already processed earlier by a command");
                continue;
            }
            Object cmdResultValue = null;
            CommandInfo getCmdInfo = sectionData.getGetCommandInfo(pName);
            if (getCmdInfo != null && (cmdResultValue = getCmdInfo.execute(cs, session, cfgId, null)) != null) {
                Attribute cmdResultAttribute = new Attribute(pName, cmdResultValue);
                oldAttrs.add(cmdResultAttribute);
            }
            if (ApplyProperties.readOnly(pName, sectionData)) {
                String pCurrentValue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Property " + pName + " is readonly. Will not be modified");
                }
                if ((pCurrentValue = ApplyProperties.compareReadOnlyValue(pName, props[pIndex], pData[i], oldAttrs, res)) != null) {
                    ApplyProperties.logReport(res, "ADMG0835I", new Object[]{pName, props[pIndex].getValue(), pCurrentValue});
                    if (ApplyProperties.isValidating(res)) continue;
                    throw new Exception(TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0835I", new Object[]{pName, props[pIndex].getValue(), pCurrentValue}));
                }
                ApplyProperties.logReport(res, "ADMG0807I", new Object[]{pName});
                continue;
            }
            CommandInfo cmdInfo = sectionData.getSetCommandInfo(pName);
            if (cmdInfo != null) {
                cmdInfo.execute(cs, session, cfgId, props);
                List propsProcessed = cmdInfo.getPropertiesProcessed(props);
                alreadyProcessed.addAll(propsProcessed);
                continue;
            }
            boolean isArray = props[pIndex].isArray();
            if (!pType.equals(pTypeActual)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attribute type specified in properties file does not match with actual attribute type ", new Object[]{sectionData.getType(), aName, pName, pType, pTypeActual});
                }
                ApplyProperties.logReport(res, "ADMG0807I", new Object[]{sectionData.getType(), aName, pName, pType, pTypeActual});
            }
            if (isArray) {
                pValues = props[pIndex].getValues();
                pValue = props[pIndex].getValue();
            } else {
                pValue = props[pIndex].getValue();
            }
            if (pValue != null && pValue.equals("null")) {
                pValue = null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property being processed " + pValue + " " + pType);
            }
            if (pType.startsWith("String")) {
                oldVal = ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                if (pType.startsWith("String*") || oldVal instanceof ArrayList) {
                    Object obj;
                    ArrayList arrList = (ArrayList)oldVal;
                    pType = arrList.size() > 0 ? ((obj = arrList.get(0)) instanceof Integer ? "integer*" : (obj instanceof Long ? "long*" : (obj instanceof Boolean ? "boolean*" : (obj instanceof Float ? "float*" : (obj instanceof ObjectName ? "ObjectName*" : "String*"))))) : "String*";
                } else if (oldVal instanceof String) {
                    pType = "String";
                } else if (oldVal instanceof Boolean) {
                    pType = "boolean";
                } else if (oldVal instanceof Integer) {
                    pType = "integer";
                } else if (oldVal instanceof Long) {
                    pType = "long";
                } else if (oldVal instanceof Float) {
                    pType = "float";
                } else if (oldVal instanceof ObjectName) {
                    pType = "ObjectName";
                }
            }
            if (pType.startsWith("String*")) {
                oldVal = (ArrayList)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                lst2 = ApplyProperties.parseListValue(pValue);
                if (oldVal != null && ((AbstractCollection)oldVal).containsAll(lst2)) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ""});
                ConfigServiceHelper.setAttributeValue(attrList, aName, lst2);
                continue;
            }
            if (pType.startsWith("String")) {
                oldVal = (String)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                if (pName.equals("password") || pName.equals("serverPassword")) {
                    pValue = PasswordUtil.passwordDecode((String)pValue);
                }
                if (pValue == null && oldVal != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, oldVal});
                    continue;
                }
                if (pValue == null && oldVal == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (oldVal != null && ((String)oldVal).equals(pValue)) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (pValue == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Changing attr " + pValue + " Old value = " + (String)oldVal);
                }
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                ConfigServiceHelper.setAttributeValue(attrList, aName, pValue);
                continue;
            }
            if (pType.startsWith("boolean") && pType.endsWith("*")) {
                oldVal = (ArrayList)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                sList = ApplyProperties.convertToList(pValue);
                lst = ApplyProperties.convertToBoolean(sList);
                if (pValue == null && oldVal != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, oldVal});
                    continue;
                }
                if (pValue == null && oldVal == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (!ApplyProperties.checkBooleans(sList) && ApplyProperties.isValidating(res)) {
                    ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                    continue;
                }
                if (oldVal != null && ApplyProperties.checkBooleans(sList) && ((AbstractCollection)oldVal).containsAll(lst)) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (pValue == null) continue;
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ApplyProperties.convertToString((ArrayList)oldVal)});
                ConfigServiceHelper.setAttributeValue(attrList, aName, lst);
                continue;
            }
            if (pType.startsWith("boolean") && !pType.endsWith("*")) {
                oldVal = (Boolean)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                if (pValue == null && oldVal != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, oldVal});
                    continue;
                }
                if (pValue == null && oldVal == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (!ApplyProperties.checkBoolean(pValue) && ApplyProperties.isValidating(res)) {
                    ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                    continue;
                }
                if (oldVal != null && ApplyProperties.checkBoolean(pValue) && ((Boolean)oldVal).equals(new Boolean(pValue))) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (pValue == null) continue;
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                ConfigServiceHelper.setAttributeValue(attrList, aName, new Boolean(pValue));
                continue;
            }
            if (pType.startsWith("int") && pType.endsWith("*")) {
                oldVal = (ArrayList)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                sList = ApplyProperties.convertToList(pValue);
                lst = ApplyProperties.convertToInteger(sList);
                if (pValue == null && oldVal != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, oldVal});
                    continue;
                }
                if (pValue == null && oldVal == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (!ApplyProperties.checkInts(sList) && ApplyProperties.isValidating(res)) {
                    ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                    continue;
                }
                if (oldVal != null && ApplyProperties.checkInts(sList) && ((AbstractCollection)oldVal).containsAll(lst)) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (pValue == null) continue;
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ApplyProperties.convertToString((ArrayList)oldVal)});
                ConfigServiceHelper.setAttributeValue(attrList, aName, lst);
                continue;
            }
            if (pType.startsWith("int") && !pType.endsWith("*")) {
                oldVal = (Integer)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                if (pValue == null && oldVal != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, oldVal});
                    continue;
                }
                if (pValue == null && oldVal == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (!ApplyProperties.checkInt(pValue) && ApplyProperties.isValidating(res)) {
                    ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                    continue;
                }
                if (oldVal != null && ApplyProperties.checkInt(pValue) && ((Integer)oldVal).equals(new Integer(pValue))) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (pValue == null) continue;
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                ConfigServiceHelper.setAttributeValue(attrList, aName, new Integer(pValue));
                continue;
            }
            if (pType.startsWith("long") && pType.endsWith("*")) {
                oldVal = (ArrayList)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                sList = ApplyProperties.convertToList(pValue);
                lst = ApplyProperties.convertToLong(sList);
                if (pValue == null && oldVal != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, oldVal});
                    continue;
                }
                if (pValue == null && oldVal == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (!ApplyProperties.checkLongs(sList) && ApplyProperties.isValidating(res)) {
                    ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                    continue;
                }
                if (oldVal != null && ApplyProperties.checkLongs(sList) && ((AbstractCollection)oldVal).containsAll(lst)) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (pValue == null) continue;
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ApplyProperties.convertToString((ArrayList)oldVal)});
                ConfigServiceHelper.setAttributeValue(attrList, aName, lst);
                continue;
            }
            if (pType.startsWith("long") && !pType.endsWith("*")) {
                oldVal = (Long)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                if (pValue == null && oldVal != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, oldVal});
                    continue;
                }
                if (pValue == null && oldVal == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (!ApplyProperties.checkLong(pValue) && ApplyProperties.isValidating(res)) {
                    ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                    continue;
                }
                if (oldVal != null && ApplyProperties.checkLong(pValue) && ((Long)oldVal).equals(new Long(pValue))) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (pValue == null) continue;
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                ConfigServiceHelper.setAttributeValue(attrList, aName, new Long(pValue));
                continue;
            }
            if (pType.startsWith("float") && pType.endsWith("*")) {
                oldVal = (ArrayList)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                sList = ApplyProperties.convertToList(pValue);
                lst = ApplyProperties.convertToFloat(sList);
                if (pValue == null && oldVal != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, oldVal});
                    continue;
                }
                if (pValue == null && oldVal == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (!ApplyProperties.checkFloats(sList) && ApplyProperties.isValidating(res)) {
                    ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                    continue;
                }
                if (oldVal != null && ApplyProperties.checkFloats(sList) && ((AbstractCollection)oldVal).containsAll(lst)) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (pValue == null) continue;
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ApplyProperties.convertToString((ArrayList)oldVal)});
                ConfigServiceHelper.setAttributeValue(attrList, aName, lst);
                continue;
            }
            if (pType.startsWith("float") && !pType.endsWith("*")) {
                oldVal = (Float)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                if (pValue == null && oldVal != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, oldVal});
                    continue;
                }
                if (pValue == null && oldVal == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (!ApplyProperties.checkFloat(pValue) && ApplyProperties.isValidating(res)) {
                    ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                    continue;
                }
                if (oldVal != null && ApplyProperties.checkFloat(pValue) && ((Float)oldVal).equals(new Float(pValue))) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (pValue == null) continue;
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                ConfigServiceHelper.setAttributeValue(attrList, aName, new Float(pValue));
                continue;
            }
            if (pType.startsWith("ENUM") && !pType.endsWith("*")) {
                oldVal = (String)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                if (pValue == null && oldVal != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, oldVal});
                    continue;
                }
                if (pValue == null && oldVal == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (!ApplyProperties.checkENUM(pValue, pData[i].getEnumValues()) && ApplyProperties.isValidating(res)) {
                    ApplyProperties.logReport(res, "ADMG0832I", new Object[]{pName, pValue, pData[i].getEnumValues()});
                    continue;
                }
                if (oldVal != null && ApplyProperties.checkENUM(pValue, pData[i].getEnumValues()) && ((String)oldVal).equals(pValue)) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (pValue == null) continue;
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                ConfigServiceHelper.setAttributeValue(attrList, aName, pValue);
                continue;
            }
            if (pType.startsWith("ObjectName*")) {
                oldVal = (ArrayList)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                lst2 = ApplyProperties.parseListValue(pValue);
                ArrayList<ObjectName> newVals = new ArrayList<ObjectName>();
                ArrayList oldValues = ApplyProperties.convertObjectNameListToStringArray((ArrayList)oldVal);
                if (oldValues != null && oldValues.containsAll(lst2)) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ""});
                String actualType = pType;
                StringTokenizer st = new StringTokenizer(new String(pType), "()");
                if (st.hasMoreTokens()) {
                    actualType = st.nextToken();
                    actualType = st.hasMoreTokens() ? st.nextToken() : pType;
                }
                String attrName = ApplyProperties.getAttrName(actualType);
                String containingType = ApplyProperties.getParentType(actualType);
                for (String val : lst2) {
                    ObjectName on = ApplyProperties.getObjectName(cs, session, ApplyProperties.getImplObj(cs, session, res.getConfigData(), res.getConfigType()), attrName, val, actualType, containingType);
                    if (on == null) continue;
                    newVals.add(on);
                }
                ConfigServiceHelper.setAttributeValue(attrList, aName, newVals);
                continue;
            }
            if (pType.startsWith("ObjectName")) {
                String displayName;
                oldVal = (ObjectName)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                String string = displayName = oldVal == null ? null : ConfigServiceHelper.getDisplayName((ObjectName)oldVal);
                if (pValue == null && displayName != null) {
                    ApplyProperties.logReport(res, "ADMG0836I", new Object[]{pName, displayName});
                    continue;
                }
                if (pValue == null && displayName == null) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (displayName != null && displayName.equals(pValue)) {
                    ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                    continue;
                }
                if (displayName == null || pValue == null) continue;
                ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                String actualType = pType;
                StringTokenizer st = new StringTokenizer(new String(pType), "()");
                if (st.hasMoreTokens()) {
                    actualType = st.nextToken();
                    actualType = st.hasMoreTokens() ? st.nextToken() : pType;
                }
                String attrName = ApplyProperties.getAttrName(actualType);
                String containingType = ApplyProperties.getParentType(actualType);
                ObjectName on = ApplyProperties.getObjectName(cs, session, ApplyProperties.getImplObj(cs, session, res.getConfigData(), res.getConfigType()), attrName, pValue, actualType, containingType);
                if (on == null) continue;
                ConfigServiceHelper.setAttributeValue(attrList, aName, on);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "unknown type of attribute ", pName);
        }
        cs.setAttributes(session, cfgId, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties", props);
        }
    }

    private static void setPropertiesNameValue(ConfigService cs, Session session, Properties sectionProps, Props[] props, SectionData sectionData, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPropertiesNameValue", new Object[]{cs, session, sectionProps, props});
        }
        String configIdString = sectionProps.getProperty("RESOURCEID");
        ObjectName cfgId = null;
        if (ApplyProperties.isCfgId(configIdString)) {
            cfgId = ConfigServiceHelper.createObjectName(new ConfigDataId(configIdString));
        } else {
            try {
                cfgId = PropertiesUtils.convertConfigScopeToConfigObject(null, configIdString, session, cs);
            }
            catch (Exception e) {
                ApplyProperties.logReport(res, "ADMG0806I", new Object[]{configIdString});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setPropertiesNameValue");
                }
                return;
            }
        }
        String attrName = sectionData.getAttrName();
        String nameField = sectionData.getName();
        String valueField = sectionData.getValue();
        AttributeList newAttrs = new AttributeList();
        ArrayList newProps = new ArrayList();
        String collectionType = sectionData.getCollectionType();
        for (int i = 0; props != null && i < props.length; ++i) {
            String pName = props[i].getName();
            String pValue = props[i].getValue();
            String pType = props[i].getType();
            boolean required = props[i].isRequired();
            List pValues = props[i].getValues();
            AttributeList attrList = new AttributeList();
            if ((pValues == null || pValues.size() <= 0) && pValue != null && !pValue.equals("") && ApplyProperties.propertyChanged(cs, session, nameField, valueField, attrName, cfgId, pName, pValue, pType, required, res)) {
                ConfigServiceHelper.setAttributeValue(attrList, nameField, pName);
                if (pValue != null) {
                    String configObjectType;
                    if (pType.equals("integer")) {
                        if (sectionData.isPropTypeRequired() && pType != null) {
                            if (!ApplyProperties.checkInt(pValue)) {
                                ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                                if (!ApplyProperties.isValidating(res)) {
                                    throw new WASResourceException("Invalid type spcecified for property=" + pName + " type required=" + pType + " value specified=" + pValue);
                                }
                            }
                            ConfigServiceHelper.setAttributeValue(attrList, valueField, pValue);
                        } else {
                            ConfigServiceHelper.setAttributeValue(attrList, valueField, new Integer(pValue));
                        }
                    } else if (pType.equals("long")) {
                        if (sectionData.isPropTypeRequired() && pType != null) {
                            if (!ApplyProperties.checkLong(pValue)) {
                                ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                                if (!ApplyProperties.isValidating(res)) {
                                    throw new WASResourceException("Invalid type spcecified for property=" + pName + " type required=" + pType + " value specified=" + pValue);
                                }
                            }
                            ConfigServiceHelper.setAttributeValue(attrList, valueField, pValue);
                        } else {
                            ConfigServiceHelper.setAttributeValue(attrList, valueField, new Long(pValue));
                        }
                    } else if (pType.equals("float")) {
                        if (sectionData.isPropTypeRequired() && pType != null) {
                            if (!ApplyProperties.checkFloat(pValue)) {
                                ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                                if (!ApplyProperties.isValidating(res)) {
                                    throw new WASResourceException("Invalid type spcecified for property=" + pName + " type required=" + pType + " value specified=" + pValue);
                                }
                            }
                            ConfigServiceHelper.setAttributeValue(attrList, valueField, pValue);
                        } else {
                            ConfigServiceHelper.setAttributeValue(attrList, valueField, new Float(pValue));
                        }
                    } else if (pType.equals("boolean")) {
                        if (sectionData.isPropTypeRequired() && pType != null) {
                            if (!ApplyProperties.checkBoolean(pValue)) {
                                ApplyProperties.logReport(res, "ADMG0831I", new Object[]{pName, pValue, pType});
                                if (!ApplyProperties.isValidating(res)) {
                                    throw new WASResourceException("Invalid type spcecified for property=" + pName + " type required=" + pType + " value specified=" + pValue);
                                }
                            }
                            ConfigServiceHelper.setAttributeValue(attrList, valueField, pValue);
                        } else {
                            ConfigServiceHelper.setAttributeValue(attrList, valueField, new Boolean(pValue));
                        }
                    } else if (pType.startsWith("ObjectName*")) {
                        configObjectType = ApplyProperties.getConfigObjectType(pType);
                    } else if (pType.startsWith("ObjectName")) {
                        configObjectType = ApplyProperties.getConfigObjectType(pType);
                    } else if (pValue != null && !pValue.equals("null")) {
                        ConfigServiceHelper.setAttributeValue(attrList, valueField, pValue);
                    }
                }
            } else if (pValues != null && pValues.size() > 0) {
                if (pType == null || pType.equals("String")) {
                    pType = "String*";
                }
                if (ApplyProperties.propertyChanged(cs, session, nameField, valueField, attrName, cfgId, pName, pValue, pType, required, res)) {
                    ConfigServiceHelper.setAttributeValue(attrList, valueField, pValues);
                    ConfigServiceHelper.setAttributeValue(attrList, nameField, pName);
                }
            }
            if (attrList.size() <= 0) continue;
            if (sectionData.isPropRequired() && required) {
                ConfigServiceHelper.setAttributeValue(attrList, "required", new Boolean("true"));
            }
            if (sectionData.isPropTypeRequired() && pType != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "type", ApplyProperties.getJavaType(pType));
            }
            ObjectName prop = cs.createConfigData(session, cfgId, attrName, collectionType, attrList);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Property changed", prop);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPropertiesNameValue");
        }
    }

    private static boolean propertyChanged(ConfigService cs, Session session, String nameField, String valueField, String attrName, ObjectName cfgId, String pName, String pValue, String propType, boolean requiredFlag, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertyChanged", new Object[]{cs, session, nameField, valueField, pName, pValue, propType, new Boolean(requiredFlag)});
        }
        boolean result = true;
        boolean found = false;
        AttributeList oldAttrs = cs.getAttributes(session, cfgId, new String[]{attrName}, false);
        if (oldAttrs == null || oldAttrs.size() <= 0) {
            return result;
        }
        List oldProps = (List)((Attribute)oldAttrs.get(0)).getValue();
        if (oldProps == null || oldProps.size() <= 0) {
            return result;
        }
        for (ObjectName prop : oldProps) {
            String oldName;
            if (valueField != null && !valueField.equals("null")) {
                oldName = (String)cs.getAttribute(session, prop, nameField);
                if (!oldName.equals(pName)) continue;
                found = true;
                Object obj = cs.getAttribute(session, prop, valueField);
                if (propType != null) {
                    if (propType.endsWith("String*")) {
                        ArrayList vals = ApplyProperties.parseListValue(pValue);
                        ArrayList oldVals = (ArrayList)obj;
                        if (oldVals != null && oldVals.containsAll(vals)) {
                            ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                            result = false;
                            break;
                        }
                        ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ""});
                        cs.deleteConfigData(session, prop);
                        break;
                    }
                    if (propType.endsWith("int*") || propType.endsWith("integer*")) {
                        ArrayList vals = ApplyProperties.parseListValue(pValue);
                        vals = ApplyProperties.convertToInteger(vals);
                        ArrayList oldVals = (ArrayList)obj;
                        if (oldVals != null && oldVals.containsAll(vals)) {
                            ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                            result = false;
                            break;
                        }
                        ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ""});
                        cs.deleteConfigData(session, prop);
                        break;
                    }
                    if (propType.endsWith("long*")) {
                        ArrayList vals = ApplyProperties.parseListValue(pValue);
                        vals = ApplyProperties.convertToLong(vals);
                        ArrayList oldVals = (ArrayList)obj;
                        if (oldVals != null && oldVals.containsAll(vals)) {
                            ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                            result = false;
                            break;
                        }
                        ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ""});
                        cs.deleteConfigData(session, prop);
                        break;
                    }
                    if (propType.endsWith("float*")) {
                        ArrayList vals = ApplyProperties.parseListValue(pValue);
                        vals = ApplyProperties.convertToFloat(vals);
                        ArrayList oldVals = (ArrayList)obj;
                        if (oldVals != null && oldVals.containsAll(vals)) {
                            ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                            result = false;
                            break;
                        }
                        ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ""});
                        cs.deleteConfigData(session, prop);
                        break;
                    }
                    if (propType.endsWith("boolean*")) {
                        ArrayList vals = ApplyProperties.parseListValue(pValue);
                        vals = ApplyProperties.convertToBoolean(vals);
                        ArrayList oldVals = (ArrayList)obj;
                        if (oldVals != null && oldVals.containsAll(vals)) {
                            ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                            result = false;
                            break;
                        }
                        ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, ""});
                        cs.deleteConfigData(session, prop);
                        break;
                    }
                    if (propType.startsWith("String")) {
                        if (obj != null) {
                            String oldValue = obj.toString();
                            if (pName.equals("password") || pName.equals("serverPassword")) {
                                pValue = PasswordUtil.passwordDecode((String)pValue);
                            }
                            if (oldValue != null && oldValue.equals(pValue)) {
                                result = false;
                                ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                                break;
                            }
                            ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldValue});
                            cs.deleteConfigData(session, prop);
                            break;
                        }
                        result = false;
                        break;
                    }
                    if (propType.startsWith("int")) {
                        Integer val = new Integer(pValue);
                        Integer oldVal = null;
                        oldVal = obj instanceof String ? new Integer((String)obj) : (Integer)obj;
                        if (oldVal != null && oldVal.equals(val)) {
                            ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                            result = false;
                            break;
                        }
                        ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                        cs.deleteConfigData(session, prop);
                        break;
                    }
                    if (propType.startsWith("float")) {
                        Float val = new Float(pValue);
                        Float oldVal = null;
                        oldVal = obj instanceof String ? new Float((String)obj) : (Float)obj;
                        if (oldVal != null && oldVal.equals(val)) {
                            ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                            result = false;
                            break;
                        }
                        ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                        cs.deleteConfigData(session, prop);
                        break;
                    }
                    if (propType.startsWith("long")) {
                        Long val = new Long(pValue);
                        Long oldVal = null;
                        oldVal = obj instanceof String ? new Long((String)obj) : (Long)obj;
                        if (oldVal != null && oldVal.equals(val)) {
                            ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                            result = false;
                            break;
                        }
                        ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                        cs.deleteConfigData(session, prop);
                        break;
                    }
                    if (!propType.startsWith("boolean")) break;
                    Boolean val = new Boolean(pValue);
                    Boolean oldVal = null;
                    oldVal = obj instanceof String ? new Boolean((String)obj) : (Boolean)obj;
                    if (oldVal != null && oldVal.equals(val)) {
                        ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                        result = false;
                        break;
                    }
                    ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldVal});
                    cs.deleteConfigData(session, prop);
                    break;
                }
                if (obj instanceof String) {
                    if (obj != null) {
                        String oldValue = obj.toString();
                        if (oldValue != null && oldValue.equals(pValue)) {
                            result = false;
                            ApplyProperties.logReport(res, "ADMG0810I", new Object[]{pName, pValue});
                            break;
                        }
                        ApplyProperties.logReport(res, "ADMG0811I", new Object[]{pName, pValue, oldValue});
                        cs.deleteConfigData(session, prop);
                        break;
                    }
                    result = false;
                    break;
                }
                result = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "unexpected type found ", obj);
                break;
            }
            oldName = (String)cs.getAttribute(session, prop, nameField);
            if (!oldName.equals(pName)) continue;
            result = false;
            found = true;
            break;
        }
        if (!found) {
            ApplyProperties.logReport(res, "ADMG0827I", new Object[]{pName, pValue});
            if (tc.isAuditEnabled()) {
                Tr.audit(tc, "creating new property for " + attrName + ":" + pName + "=" + pValue);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertyChanged", new Boolean(result));
        }
        return result;
    }

    private static boolean propertyChanged(ConfigService cs, Session session, String nameField, String valueField, String attrName, ObjectName cfgId, String pName, ArrayList pValues) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertyChanged", new Object[]{cs, session, pName, pValues});
        }
        boolean result = true;
        boolean found = false;
        AttributeList oldAttrs = cs.getAttributes(session, cfgId, new String[]{attrName}, false);
        if (oldAttrs == null || oldAttrs.size() <= 0) {
            return result;
        }
        List oldProps = (List)((Attribute)oldAttrs.get(0)).getValue();
        if (oldProps == null || oldProps.size() <= 0) {
            return result;
        }
        for (ObjectName prop : oldProps) {
            if (valueField != null && !valueField.equals("null")) {
                String oldName = (String)cs.getAttribute(session, prop, nameField);
                if (!oldName.equals(pName)) continue;
                found = true;
                Object obj = cs.getAttribute(session, prop, valueField);
                if (obj instanceof ArrayList) {
                    ArrayList oldValue = (ArrayList)obj;
                    if (oldValue != null && oldValue.containsAll(pValues)) {
                        result = false;
                        if (!tc.isAuditEnabled()) break;
                        Tr.audit(tc, "Not changing value for this attr as the new value is same as the exusting value " + attrName + ":" + pName + "=" + pValues);
                        break;
                    }
                    if (tc.isAuditEnabled()) {
                        Tr.audit(tc, "Changing value for " + attrName + ":" + pName + "=" + pValues + " old Value was " + oldValue);
                    }
                    cs.deleteConfigData(session, prop);
                    break;
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "unexpected type found ", obj);
                break;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "unexpected problem with ", prop);
        }
        if (!found && tc.isAuditEnabled()) {
            Tr.audit(tc, "creating new property for " + attrName + ":" + pName + "=" + pValues);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertyChanged", new Boolean(result));
        }
        return result;
    }

    public static int getIndex(Props[] props, String pName) {
        for (int i = 0; props != null && i < props.length; ++i) {
            if (!props[i].getName().equals(pName)) continue;
            return i;
        }
        return -1;
    }

    private static String getValue(Props[] props, String pName) {
        String pValue = null;
        for (int i = 0; props != null && i < props.length; ++i) {
            if (!props[i].getName().equals(pName)) continue;
            pValue = props[i].getValue();
        }
        return pValue;
    }

    private static String getType(Props[] props, String pName) {
        String pType = null;
        for (int i = 0; props != null && i < props.length; ++i) {
            if (!props[i].getName().equals(pName)) continue;
            pType = props[i].getType();
        }
        return pType;
    }

    private static boolean isArray(Props[] props, String pName) {
        boolean res = false;
        for (int i = 0; props != null && i < props.length; ++i) {
            if (!props[i].getName().equals(pName)) continue;
            res = props[i].isArray();
        }
        return res;
    }

    private static List getValues(Props[] props, String pName) {
        for (int i = 0; props != null && i < props.length; ++i) {
            if (!props[i].getName().equals(pName)) continue;
            return props[i].getValues();
        }
        return new ArrayList();
    }

    private static boolean isCfgId(String cfgId) {
        boolean res = false;
        if (cfgId.indexOf("cells/") >= 0 && cfgId.indexOf(124) > 0) {
            res = true;
        }
        return res;
    }

    public static AttributeList getAttributeList(SectionData sectionData, Props[] props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeList", new Object[]{sectionData, props});
        }
        AttributeList attrList = new AttributeList();
        PropertyData[] pData = sectionData.getPropertiesData();
        for (int i = 0; i < pData.length; ++i) {
            String pName = pData[i].getPropName();
            String aName = pData[i].getAttrName();
            String pValue = null;
            List pValues = null;
            int pIndex = ApplyProperties.getIndex(props, pName);
            if (pIndex == -1) continue;
            String pType = props[pIndex].getType();
            String pTypeActual = pData[i].getType();
            boolean isArray = props[pIndex].isArray();
            if (!pType.equals(pTypeActual)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attribute type specified in properties file does not match with actual attribute type ", new Object[]{sectionData.getType(), aName, pName, pType, pTypeActual});
                }
                if (tc.isAuditEnabled()) {
                    Tr.audit(tc, "Attribute type specified in properties file does not match with actual attribute type ", new Object[]{sectionData.getType(), aName, pName, pType, pTypeActual});
                }
            }
            if (isArray) {
                pValues = props[pIndex].getValues();
            } else {
                pValue = props[pIndex].getValue();
                if (pValue != null && pValue.equals("null")) {
                    pValue = null;
                }
            }
            if (pValue == null && (pValues == null || pValues.size() <= 0)) continue;
            if (pType.startsWith("String")) {
                ConfigServiceHelper.setAttributeValue(attrList, aName, pValue);
                continue;
            }
            if (pType.startsWith("boolean")) {
                ConfigServiceHelper.setAttributeValue(attrList, aName, new Boolean(pValue));
                continue;
            }
            if (pType.startsWith("int")) {
                ConfigServiceHelper.setAttributeValue(attrList, aName, new Integer(pValue));
                continue;
            }
            if (pType.startsWith("long")) {
                ConfigServiceHelper.setAttributeValue(attrList, aName, new Long(pValue));
                continue;
            }
            if (pType.startsWith("float")) {
                ConfigServiceHelper.setAttributeValue(attrList, aName, new Float(pValue));
                continue;
            }
            if (pType.startsWith("ENUM")) {
                ConfigServiceHelper.setAttributeValue(attrList, aName, pValue);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "unknown type of attribute ", pName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeList", attrList);
        }
        return attrList;
    }

    private static ArrayList parseListValue(String value) {
        String val;
        int inx;
        ArrayList<String> vals = new ArrayList<String>();
        if (value.startsWith("{") && (inx = (val = new String(value)).lastIndexOf(125)) > 0) {
            val = val.substring(1, inx);
            StringTokenizer st = new StringTokenizer(val, ",");
            while (st.hasMoreTokens()) {
                String v = st.nextToken();
                vals.add(v);
            }
        }
        return vals;
    }

    private static String getConfigObjectType(String pType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigObjectType", pType);
        }
        String result = null;
        StringTokenizer st = new StringTokenizer(pType, "(:)");
        String type = st.nextToken();
        if (st.hasMoreTokens()) {
            result = st.nextToken();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigObjectType", result);
        }
        return result;
    }

    private static String getConfigObjectAttrName(String pType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigObjectAttrName", pType);
        }
        String result = null;
        StringTokenizer st = new StringTokenizer(pType, "(:)");
        String type = st.nextToken();
        if (st.hasMoreTokens()) {
            String cfgType = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            result = st.nextToken();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigObjectAttrName", result);
        }
        return result;
    }

    private static ObjectName getObject(ConfigService cs, Session session, ObjectName parent, String attrName, String pValue, String pType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject", new Object[]{cs, session, parent, attrName, pValue, pType});
        }
        String relationshipName = pType;
        ObjectName result = null;
        ObjectName[] ons = cs.resolve(session, parent, relationshipName);
        if (ons != null) {
            for (int i = 0; i < ons.length; ++i) {
                ObjectName on = ons[i];
                if (!ConfigServiceHelper.getDisplayName(on).equals(pValue)) continue;
                result = on;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject", result);
        }
        return result;
    }

    private static boolean objectExists(ConfigService cs, Session session, ObjectName parent, String attrName, String pValue, String pType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectExists", new Object[]{cs, session, parent, attrName, pValue, pType});
        }
        String relationshipName = pType + "=";
        boolean found = false;
        ObjectName[] ons = cs.getRelationship(session, parent, relationshipName);
        if (ons != null) {
            for (int i = 0; i < ons.length; ++i) {
                ObjectName on = ons[i];
                if (!ConfigServiceHelper.getDisplayName(on).equals(pValue)) continue;
                found = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectExists", new Boolean(found));
        }
        return found;
    }

    private static ObjectName createObjectName(ConfigService cs, Session session, ObjectName parent, String attrName, String pValue, String pType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectName", new Object[]{cs, session, parent, attrName, pValue, pType});
        }
        String attributeName = attrName;
        AttributeList attrList = new AttributeList();
        if (pValue != null) {
            attrList.add(new Attribute("name", pValue));
        }
        ObjectName on = cs.createConfigData(session, parent, attributeName, pType, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createObjectName", on);
        }
        return on;
    }

    private static String getRelationName(ConfigService cs, Session session, ObjectName parent, ObjectName child) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationName", new Object[]{cs, session, parent, child});
        }
        String result = null;
        String childType = ConfigServiceHelper.getConfigDataType(child);
        String parentType = ConfigServiceHelper.getConfigDataType(parent);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parent type = " + parentType + " child type = " + childType);
        }
        result = ApplyProperties.getRelationName(cs, session, parentType, childType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationName", result);
        }
        return result;
    }

    private static String getRelationName(ConfigService cs, Session session, String parentType, String childType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationName", new Object[]{cs, session, parentType, childType});
        }
        String result = null;
        AttributeList aList = cs.getRelationshipsMetaInfo(parentType);
        boolean found = false;
        block0: for (int i = 0; !found && i < aList.size(); ++i) {
            Attribute at = (Attribute)aList.get(i);
            AttributeList al = (AttributeList)at.getValue();
            String name = at.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name of Attr is " + name);
            }
            if (name.equals("parent")) continue;
            String value = (String)at.getValue();
            for (int j = 0; j < al.size(); ++j) {
                Attribute a = (Attribute)al.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name of sub attr is " + a.getName());
                }
                if (!a.getName().equals("_Attribute_MetaInfo_Type") || !(a.getValue() instanceof String)) continue;
                String currentChildType = (String)a.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "val: " + currentChildType);
                }
                if (!currentChildType.equals(childType)) continue;
                found = true;
                result = value;
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationName", result);
        }
        return result;
    }

    public static String getAttrName(String childType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttrName", childType);
        }
        if (childType.endsWith("InboundChannel")) {
            childType = "InboundChannel";
        } else if (childType.endsWith("OutboundChannnel")) {
            childType = "OutboundChannel";
        }
        String attrName = (String)typeToAttrNameMappings.get(childType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttrName", attrName);
        }
        return attrName;
    }

    public static String getParentType(String childType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentType", childType);
        }
        if (childType.endsWith("InboundChannel")) {
            childType = "InboundChannel";
        } else if (childType.endsWith("OutboundChannnel")) {
            childType = "OutboundChannel";
        }
        String pType = (String)parentChildRelations.get(childType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentType", pType);
        }
        return pType;
    }

    private static ObjectName getObjectName(ConfigService cs, Session session, ObjectName implementingObj, String attrName, String attrVal, String configType, String containingType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", new Object[]{cs, session, implementingObj, attrName, attrVal, configType, containingType});
        }
        ObjectName on = null;
        String relationshipName = containingType + "=";
        boolean found = false;
        ObjectName[] ons = null;
        if (containingType != null) {
            ons = cs.resolve(session, implementingObj, relationshipName);
            on = ApplyProperties.getObject(cs, session, ons[0], attrName, attrVal, configType);
        } else {
            on = ApplyProperties.getObject(cs, session, implementingObj, attrName, attrVal, configType);
        }
        if (on == null) {
            ApplyProperties.createObjectName(cs, session, ons[0], attrName, attrVal, configType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", on);
        }
        return on;
    }

    private static ArrayList convertObjectNameListToStringArray(ArrayList onList) {
        ArrayList<String> aList = new ArrayList<String>();
        for (ObjectName on : onList) {
            aList.add(ConfigServiceHelper.getDisplayName(on));
        }
        return aList;
    }

    private static String getType(String type) {
        if (type.endsWith("String")) {
            return "String";
        }
        if (type.endsWith("Integer")) {
            return "integer";
        }
        if (type.endsWith("Long")) {
            return "long";
        }
        if (type.endsWith("Float")) {
            return "float";
        }
        if (type.endsWith("Boolean")) {
            return "boolean";
        }
        if (type.endsWith("[Ljava.lang.String;")) {
            return "String*";
        }
        if (type.endsWith("[Ljava.lang.Integer;")) {
            return "integer*";
        }
        if (type.endsWith("[Ljava.lang.Long;")) {
            return "long*";
        }
        if (type.endsWith("[Ljava.lang.Boolean;")) {
            return "boolean*";
        }
        return "String";
    }

    private static String getJavaType(String type) {
        if (type.startsWith("String")) {
            return "java.lang.String";
        }
        if (type.startsWith("int")) {
            return "java.lang.Integer";
        }
        if (type.startsWith("float")) {
            return "java.lang.Float";
        }
        if (type.startsWith("long")) {
            return "java.long.Long";
        }
        if (type.startsWith("boolean")) {
            return "java.lang.Boolean";
        }
        if (type.endsWith("String*")) {
            return "[Ljava.lang.String;";
        }
        if (type.endsWith("int*") || type.endsWith("integer*")) {
            return "[Ljava.lang.Integer;";
        }
        if (type.endsWith("long*")) {
            return "[Ljava.lang.Long;";
        }
        if (type.endsWith("float*")) {
            return "[Ljava.lang.Float;";
        }
        if (type.endsWith("boolean*")) {
            return "[Ljava.lang.Boolean;";
        }
        return "java.lang.String";
    }

    private static ArrayList convertToInteger(ArrayList in) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 0; i < in.size(); ++i) {
            String s = (String)in.get(i);
            lst.add(new Integer(s));
        }
        return lst;
    }

    private static ArrayList convertToBoolean(ArrayList in) {
        ArrayList<Boolean> lst = new ArrayList<Boolean>();
        for (int i = 0; i < in.size(); ++i) {
            String s = (String)in.get(i);
            lst.add(new Boolean(s));
        }
        return lst;
    }

    private static ArrayList convertToLong(ArrayList in) {
        ArrayList<Long> lst = new ArrayList<Long>();
        for (int i = 0; i < in.size(); ++i) {
            String s = (String)in.get(i);
            lst.add(new Long(s));
        }
        return lst;
    }

    private static ArrayList convertToFloat(ArrayList in) {
        ArrayList<Float> lst = new ArrayList<Float>();
        for (int i = 0; i < in.size(); ++i) {
            String s = (String)in.get(i);
            lst.add(new Float(s));
        }
        return lst;
    }

    private static boolean readOnly(String pName, SectionData sectionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readOnly", new Object[]{pName, sectionData});
        }
        boolean result = false;
        PropertyData[] pData = sectionData.getPropertiesData();
        for (int i = 0; i < pData.length; ++i) {
            String name = pData[i].getPropName();
            if (!pName.equals(name) || !pData[i].isReadOnly()) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readOnly", new Boolean(result));
        }
        return result;
    }

    private static ObjectName createConfigObject(ConfigService cs, Session session, ObjectName parent, String cfgId, String attrName, String type, AttributeList attrList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, parent, cfgId, attrName, type, attrList});
        }
        ObjectName on = null;
        if (parent != null && attrName != null) {
            on = cs.createConfigData(session, parent, attrName, type, attrList);
        } else {
            String cId = cfgId;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cId = " + cId);
            }
            if (ConfigPropertiesHelper.isScopeId(cId)) {
                ObjectName parentObj;
                int inx = cId.lastIndexOf(":");
                String pId = cId.substring(0, inx);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pId = " + pId);
                }
                if ((parentObj = parent) == null) {
                    parentObj = PropertiesUtils.convertConfigScopeToConfigObject(null, pId, session, cs);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parent = " + parentObj);
                }
                on = cs.createConfigDataByTemplate(session, parentObj, type, attrList, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new Obj = " + on);
                }
            } else if (parent != null) {
                on = cs.createConfigDataByTemplate(session, parent, type, attrList, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new Obj = " + on);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", on);
        }
        return on;
    }

    public static void logReport(WASResource res, String key, Object[] objs) {
        try {
            PropWASResource pres;
            FileOutputStream os = (FileOutputStream)res.getReferenceProperties().get("REPORTFILE_OS");
            if (os != null) {
                ConfigPropertiesHelper.logReport(res, os, key, objs);
            }
            if (res instanceof PropWASResource && (pres = (PropWASResource)res).isValidating() && key != null && ConfigPropertiesHelper.isError(key)) {
                pres.setValidationError(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSectionInfo(SectionData sectionData) {
        return sectionData.getType() + ":" + sectionData.getContainingType();
    }

    public static boolean checkInt(String val) {
        boolean result = true;
        try {
            Integer i = Integer.valueOf(val);
        }
        catch (NumberFormatException ne) {
            result = false;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private static boolean isValidating(WASResource res) {
        PropWASResource pRes;
        boolean isValidating;
        boolean result = false;
        if (res instanceof PropWASResource && (isValidating = (pRes = (PropWASResource)res).isValidating())) {
            result = true;
        }
        return result;
    }

    private static boolean checkLong(String val) {
        boolean result = true;
        try {
            Long i = Long.valueOf(val);
        }
        catch (NumberFormatException ne) {
            result = false;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private static boolean checkFloat(String val) {
        boolean result = true;
        try {
            Float i = Float.valueOf(val);
        }
        catch (NumberFormatException ne) {
            result = false;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private static boolean checkBoolean(String val) {
        boolean result = true;
        return result;
    }

    private static boolean checkENUM(String val, String[] vals) {
        boolean result = false;
        for (int i = 0; i < vals.length; ++i) {
            if (!val.equals(vals[i])) continue;
            result = true;
            break;
        }
        return result;
    }

    private static void reportInvalidProperties(PropertyData[] pData, Props[] props, WASResource res) {
        if (!ApplyProperties.isValidating(res)) {
            return;
        }
        for (int j = 0; j < props.length; ++j) {
            String key = props[j].getName();
            boolean found = false;
            for (int i = 0; i < pData.length; ++i) {
                if (!pData[i].getPropName().equals(key)) continue;
                found = true;
            }
            if (found) continue;
            ApplyProperties.logReport(res, "ADMG0834I", new Object[]{key});
        }
    }

    private static String compareReadOnlyValue(String pName, Props props, PropertyData pData, AttributeList oldAttrs, WASResource res) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareReadOnlyValue", new Object[]{pName, props, pData, oldAttrs});
        }
        Object result = null;
        try {
            String aName = pData.getAttrName();
            String pValue = props.getValue();
            List pValues = props.getValues();
            String pType = pData.getType();
            if (pValue != null || pValues != null && pValues.size() > 0) {
                ArrayList lst;
                Object oldVal;
                if (pType.startsWith("String")) {
                    oldVal = ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                    if (pType.startsWith("String*") || oldVal instanceof ArrayList) {
                        Object obj;
                        ArrayList arrList = (ArrayList)oldVal;
                        pType = arrList.size() > 0 ? ((obj = arrList.get(0)) instanceof Integer ? "integer*" : (obj instanceof Long ? "long*" : (obj instanceof Boolean ? "boolean*" : (obj instanceof Float ? "float*" : (obj instanceof ObjectName ? "ObjectName*" : "String*"))))) : "String*";
                    } else if (oldVal instanceof String) {
                        pType = "String";
                    } else if (oldVal instanceof Boolean) {
                        pType = "boolean";
                    } else if (oldVal instanceof Integer) {
                        pType = "integer";
                    } else if (oldVal instanceof Long) {
                        pType = "long";
                    } else if (oldVal instanceof Float) {
                        pType = "float";
                    } else if (oldVal instanceof ObjectName) {
                        pType = "ObjectName";
                    }
                }
                if (pType.startsWith("String*")) {
                    oldVal = (ArrayList)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                    lst = ApplyProperties.parseListValue(pValue);
                    if (oldVal == null || !((AbstractCollection)oldVal).containsAll(lst)) {
                        result = lst.toString();
                    }
                } else if (pType.startsWith("String")) {
                    oldVal = (String)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                    if (oldVal == null || !((String)oldVal).equals(pValue)) {
                        result = oldVal;
                    }
                } else if (pType.startsWith("boolean") && !pType.endsWith("*")) {
                    oldVal = (Boolean)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                    if (oldVal == null || !((Boolean)oldVal).equals(new Boolean(pValue))) {
                        result = ((Boolean)oldVal).toString();
                    }
                } else if (pType.startsWith("int") && !pType.endsWith("*")) {
                    oldVal = (Integer)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                    if (oldVal == null || !((Integer)oldVal).equals(new Integer(pValue))) {
                        result = ((Integer)oldVal).toString();
                    }
                } else if (pType.startsWith("long") && !pType.endsWith("*")) {
                    oldVal = (Long)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                    if (oldVal == null || !((Long)oldVal).equals(new Long(pValue))) {
                        result = ((Long)oldVal).toString();
                    }
                } else if (pType.startsWith("float") && !pType.endsWith("*")) {
                    oldVal = (Long)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                    if (oldVal == null || !((Long)oldVal).equals(new Float(pValue))) {
                        result = ((Long)oldVal).toString();
                    }
                } else if (pType.startsWith("ENUM") && !pType.endsWith("*")) {
                    oldVal = (String)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                    if (oldVal == null || !((String)oldVal).equals(pValue)) {
                        result = oldVal;
                    }
                } else if (pType.startsWith("ObjectName*")) {
                    oldVal = (ArrayList)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                    lst = ApplyProperties.parseListValue(pValue);
                    ArrayList newVals = new ArrayList();
                    ArrayList oldValues = ApplyProperties.convertObjectNameListToStringArray((ArrayList)oldVal);
                    if (!(oldValues != null && oldValues.containsAll(lst) || oldValues == null || lst.isEmpty())) {
                        result = oldValues.toString();
                    }
                } else if (pType.startsWith("ObjectName")) {
                    String displayName;
                    oldVal = (ObjectName)ApplyProperties.getCurrentAttrVal(oldAttrs, aName);
                    String string = displayName = oldVal == null ? null : ConfigServiceHelper.getDisplayName((ObjectName)oldVal);
                    if (!(displayName != null && displayName.equals(pValue) || displayName == null)) {
                        result = displayName;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unknown type of attribute ", pName);
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception validating readonly attribute ", e);
            }
            result = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareReadOnlyValue", result);
        }
        return result;
    }

    public static boolean isIntermediateObject(String objType) {
        boolean result = false;
        if (intermediateObjects.get(objType) != null) {
            result = true;
        }
        return result;
    }

    public static String getIntermediateAttrName(String objType) {
        return (String)intermediateObjects.get(objType);
    }

    private static Object getCurrentAttrVal(AttributeList oldAttrs, String aName) {
        Object obj = null;
        try {
            obj = ConfigServiceHelper.getAttributeValue(oldAttrs, aName);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute is not set ", aName);
            }
            obj = null;
        }
        return obj;
    }

    private static String convertToString(ArrayList arr) {
        String pValue = "{";
        boolean firstTime = true;
        for (Object obj : arr) {
            if (!firstTime) {
                pValue = pValue.concat(",");
            } else {
                firstTime = false;
            }
            pValue = pValue.concat(obj.toString());
        }
        pValue = pValue.concat("}");
        return pValue;
    }

    private static ArrayList convertToList(String str) {
        StringTokenizer st = new StringTokenizer(new String(str), "{},");
        ArrayList<String> lst = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            lst.add(st.nextToken());
        }
        return lst;
    }

    private static boolean checkInts(ArrayList lst) {
        for (int i = 0; lst != null && i < lst.size(); ++i) {
            String val = (String)lst.get(i);
            if (ApplyProperties.checkInt(val)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkLongs(ArrayList lst) {
        for (int i = 0; lst != null && i < lst.size(); ++i) {
            String val = (String)lst.get(i);
            if (ApplyProperties.checkLong(val)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkFloats(ArrayList lst) {
        for (int i = 0; lst != null && i < lst.size(); ++i) {
            String val = (String)lst.get(i);
            if (ApplyProperties.checkFloat(val)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkBooleans(ArrayList lst) {
        for (int i = 0; lst != null && i < lst.size(); ++i) {
            String val = (String)lst.get(i);
            if (ApplyProperties.checkBoolean(val)) continue;
            return false;
        }
        return true;
    }

    private static ObjectName getImplObj(ConfigService cs, Session session, ObjectName on, String implType) throws Exception {
        EObject parentObj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getImplObj", new Object[]{on, implType, session, cs});
        }
        ObjectName result = on;
        EObject eObj = MOFUtil.convertToEObject(session, on);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "eObj=", eObj);
        }
        String parentType = ConfigServiceHelper.getConfigDataType(on);
        implType = PropertiesUtils.getRootObjectType(ConfigServiceHelper.getConfigDataId(on).toString());
        ArrayList scopeElements = new ArrayList();
        ObjectName pObj = on;
        while (parentType != null && !parentType.equals(implType) && (parentObj = eObj.eContainer()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentObj=", parentObj);
            }
            pObj = MOFUtil.createObjectName(parentObj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pObj=", pObj);
            }
            parentType = ConfigServiceHelper.getConfigDataType(pObj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentType=", parentType);
            }
            eObj = parentObj;
            result = pObj;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getImplObj", result);
        }
        return result;
    }

    static {
        parentChildRelations.put("ThreadPool", "ThreadPoolManager");
        parentChildRelations.put("Chain", "TransportChannelService");
        parentChildRelations.put("InboundChannel", "TransportChannelService");
        parentChildRelations.put("OutboundChannel", "TransportChannelService");
        intermediateObjects = new HashMap();
        intermediateObjects.put("J2EEResourcePropertySet", "propertySet");
        typeToAttrNameMappings = new HashMap();
        typeToAttrNameMappings.put("ThreadPool", "threadPools");
        typeToAttrNameMappings.put("Chain", "chains");
        typeToAttrNameMappings.put("InboundChannel", "transportChannels");
        typeToAttrNameMappings.put("OutboundChannel", "transportChannels");
    }
}

