/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.properties.resources.common.SectionedProperties;
import com.ibm.ws.management.wasresource.capability.IConfiguration;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResource;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;

public class ServerClusterDeploymentExt
extends WASResource
implements IConfiguration {
    private static final TraceComponent tc = Tr.register(ServerClusterDeploymentExt.class, null, null);

    public String getResourceType() {
        return "ServerCluster";
    }

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        super.initialize(eprRefProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{scope, containmentPath, this});
        }
        List result = null;
        if (containmentPath == null || containmentPath.equals("")) {
            containmentPath = this.getResourceType();
        }
        result = containmentPath.equals("NONEXISTENTRESOURCE") ? super.getConfigResourceInstanceForCreate(containmentPath, false, this.getResourceType()) : super.getConfigResourceInstances(session, scope, containmentPath, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances");
        }
        return result;
    }

    public String[] validateProperties(Properties props) {
        return null;
    }

    public SectionedProperties[] getCreateTemplateProperties() throws WASResourceException {
        return null;
    }

    public SectionedProperties[] getDeleteTemplateProperties() throws WASResourceException {
        return null;
    }

    private boolean isFiltered(String cType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFiltered", this.getResourceType());
        }
        boolean filtered = false;
        String[] types = (String[])this.getReferenceProperties().get("SELECTEDSUBTYPES");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "selected types ", types);
        }
        if (types != null && types.length > 0) {
            filtered = true;
            for (int i = 0; i < types.length; ++i) {
                if (!cType.equals(types[i])) continue;
                filtered = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFiltered", new Boolean(filtered));
        }
        return filtered;
    }

    private boolean isFiltered() {
        return this.isFiltered(this.getResourceType());
    }

    public Properties getProperties() throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
        }
        Properties props = new Properties();
        if (this.isFiltered()) {
            return null;
        }
        try {
            String apps = this.getProperty("deployedApps");
            props.setProperty("deployedApps", apps);
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    public String getProperty(String name) throws UnknownResourceTypeException, WASResourceException {
        String propValue = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty", name);
        }
        try {
            String apps = null;
            try {
                apps = this.getAllDeployedModules(this.getConfigService(), this.getSession());
            }
            catch (Exception e) {
                throw new WASResourceException(e);
            }
            if (name.equals("deployedApps")) {
                propValue = apps;
            }
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty", propValue);
        }
        return propValue;
    }

    public void setProperty(String name, String value) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty", new Object[]{name, value});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty");
        }
    }

    public void setProperties(Properties props) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", props);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public List getRelationships(int type, boolean recursive) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{new Integer(type), new Boolean(recursive)});
        }
        ArrayList result = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", result);
        }
        return result;
    }

    public List getAllPropertyNames() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllPropertyNames");
        }
        ArrayList result = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllPropertyNames", result);
        }
        return result;
    }

    public String getUniqueId() throws WASResourceException {
        return this.getResourceType() + "DeploymentTargetExtension";
    }

    public List getRelationships(String cfgType, int relationType, boolean recursive) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationShips", new Object[]{new Integer(relationType), new Boolean(recursive)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationShips", null);
        }
        return null;
    }

    private String getAllDeployedApps(ConfigService cs, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllDeployedApps", new Object[]{cs, session});
        }
        String deps = "Deployment=";
        ObjectName[] apps = cs.resolve(session, deps);
        String retVal = "{";
        boolean firstTime = true;
        String clusterName = null;
        if (this.getConfigData() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAllDeployedApps", null);
            }
            return null;
        }
        clusterName = ConfigServiceHelper.getDisplayName(this.getConfigData());
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "DeploymentTarget");
        for (int i = 0; apps != null && i < apps.length; ++i) {
            ObjectName[] deployedTargets = cs.queryConfigObjects(session, apps[i], pattern, null);
            String appName = ConfigServiceHelper.getDisplayName(apps[i]);
            for (int j = 0; deployedTargets != null && j < deployedTargets.length; ++j) {
                String cName;
                String type = ConfigServiceHelper.getConfigDataType(deployedTargets[j]);
                if (!type.equals("ClusteredTarget") || !(cName = ConfigServiceHelper.getDisplayName(deployedTargets[j])).equals(clusterName)) continue;
                if (firstTime) {
                    retVal = retVal.concat(appName);
                    firstTime = false;
                    continue;
                }
                retVal = retVal.concat(",").concat(appName);
            }
        }
        retVal = retVal.concat("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllDeployedApps", retVal);
        }
        return retVal;
    }

    private String getAllDeployedModules(ConfigService cs, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllDeployedModules", new Object[]{cs, session});
        }
        String deps = "Deployment=";
        ObjectName[] apps = cs.resolve(session, deps);
        String retVal = "{";
        boolean firstTime = true;
        String clusterName = null;
        if (this.getConfigData() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAllDeployedModules", null);
            }
            return null;
        }
        clusterName = ConfigServiceHelper.getDisplayName(this.getConfigData());
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ModuleDeployment");
        for (int i = 0; apps != null && i < apps.length; ++i) {
            ObjectName[] deployedModules = cs.queryConfigObjects(session, apps[i], pattern, null);
            String appName = ConfigServiceHelper.getDisplayName(apps[i]);
            for (int j = 0; deployedModules != null && j < deployedModules.length; ++j) {
                String moduleName = (String)cs.getAttribute(session, deployedModules[j], "uri");
                ObjectName pattern1 = ConfigServiceHelper.createObjectName(null, "DeploymentTargetMapping");
                ObjectName[] targetMappings = cs.queryConfigObjects(session, deployedModules[j], pattern1, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "modules", targetMappings);
                }
                for (int k = 0; targetMappings != null && k < targetMappings.length; ++k) {
                    ObjectName target = (ObjectName)cs.getAttribute(session, targetMappings[k], "target");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "module", target);
                    }
                    String type = ConfigServiceHelper.getConfigDataType(target);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "module type", type);
                    }
                    if (!type.equals("ClusteredTarget")) continue;
                    String cName = ConfigServiceHelper.getDisplayName(target);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "name ", cName);
                    }
                    if (!cName.equals(clusterName)) continue;
                    if (firstTime) {
                        retVal = retVal.concat(appName + ":" + moduleName);
                        firstTime = false;
                        continue;
                    }
                    retVal = retVal.concat(",").concat(moduleName);
                }
            }
        }
        retVal = retVal.concat("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllDeployedModules", retVal);
        }
        return retVal;
    }
}

