/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.common.SectionedProperties;
import com.ibm.ws.management.wasresource.common.PropWASResource;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceManager;
import com.ibm.ws.management.wasresource.common.WASResourceReferenceParameters;
import com.ibm.ws.management.wasresource.common.WASResourcesConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;

public class ServerCluster
extends PropWASResource {
    private static final TraceComponent tc = Tr.register(ServerCluster.class, null, null);
    private boolean includeMembers = false;

    public String getResourceType() {
        return "ServerCluster";
    }

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        super.initialize(eprRefProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public SectionedProperties[] getCreateTemplateProperties() throws WASResourceException {
        SectionedProperties[] props = null;
        try {
            Boolean create = (Boolean)this.getReferenceProperties().get("CREATERESOURCE");
            ArrayList<SectionedProperties> allProps = new ArrayList<SectionedProperties>();
            if (create != null && create.booleanValue()) {
                String configType;
                String resType = this.getCurrentResourceType();
                String string = configType = this.getConfigData() != null ? ConfigServiceHelper.getConfigDataType(this.getConfigData()) : null;
                if (resType != null && resType.equals(this.getResourceType()) && (configType == null || configType != null && configType.equals(resType))) {
                    SectionedProperties[] props1 = ConfigPropertiesHelper.getPropertiesForCommand("createCluster", this, true);
                    for (int i = 0; props1 != null && i < props1.length; ++i) {
                        allProps.add(props1[i]);
                    }
                }
            }
            if (allProps.size() > 0) {
                props = allProps.toArray(new SectionedProperties[0]);
            }
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        return props;
    }

    public SectionedProperties[] getDeleteTemplateProperties() throws WASResourceException {
        SectionedProperties[] props = null;
        try {
            Boolean delete = (Boolean)this.getReferenceProperties().get("DELETERESOURCE");
            ArrayList<SectionedProperties> allProps = new ArrayList<SectionedProperties>();
            if (delete != null && delete.booleanValue()) {
                String configType;
                String resType = this.getCurrentResourceType();
                String string = configType = this.getConfigData() != null ? ConfigServiceHelper.getConfigDataType(this.getConfigData()) : null;
                if (resType != null && resType.equals(this.getResourceType()) && (configType == null || configType != null && configType.equals(resType))) {
                    SectionedProperties[] props1 = ConfigPropertiesHelper.getPropertiesForCommand("deleteCluster", this, false);
                    if (props1 != null && props1.length > 0) {
                        SectionedProperties sp = props1[0];
                        String comments = sp.getComments();
                        StringBuffer sb = new StringBuffer(comments);
                        sb = sb.append("\n# Update ResourceId field with actual clusterName ( ResourceId=ServerCluster=clusterName ) \n#\n");
                        sp.setComments(sb.toString());
                    }
                    for (int i = 0; props1 != null && i < props1.length; ++i) {
                        allProps.add(props1[i]);
                    }
                }
            }
            if (allProps.size() > 0) {
                props = allProps.toArray(new SectionedProperties[0]);
            }
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        return props;
    }

    public Properties getProperties() throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
        }
        Properties props = new Properties();
        props = super.getProperties();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    public String getProperty(String name) throws UnknownResourceTypeException, WASResourceException {
        String propValue = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty", name);
        }
        propValue = super.getProperty(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty", propValue);
        }
        return propValue;
    }

    public void setProperty(String name, String value) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty", new Object[]{name, value});
        }
        super.setProperty(name, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty");
        }
    }

    public void setProperties(Properties props) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", props);
        }
        super.setProperties(props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public List getRelationships(int type, boolean recursive) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{new Integer(type), new Boolean(recursive)});
        }
        List result = super.getRelationships(type, recursive);
        if (this.includeMembers()) {
            try {
                String configType;
                String location = configType = "Server";
                List servers = WASResourceManager.getInstance().queryResource(this.getSession(), configType, null, location);
                if (servers != null) {
                    String cName = (String)this.getConfigService().getAttribute(this.getSession(), this.getConfigData(), "name");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Clustername is " + cName);
                    }
                    Iterator itr = servers.iterator();
                    while (itr.hasNext()) {
                        WASResourceReferenceParameters refParam = (WASResourceReferenceParameters)itr.next();
                        HashMap map = refParam.getReferenceProperties();
                        String serverId = (String)map.get(WASResourcesConstants.WAS_WSDM_Resource_ConfigID);
                        ObjectName serverObj = ConfigServiceHelper.createObjectName(new ConfigDataId(serverId));
                        String clusterName = (String)this.getConfigService().getAttribute(this.getSession(), serverObj, "clusterName");
                        if (clusterName != null && clusterName.equals(cName)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "cluster member " + serverObj);
                            continue;
                        }
                        itr.remove();
                    }
                    result.addAll(servers);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", result);
        }
        return result;
    }

    public List getAllPropertyNames() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllPropertyNames");
        }
        List result = super.getAllPropertyNames();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllPropertyNames", result);
        }
        return result;
    }

    public void setIncludeMembers(boolean includeMembers) {
        this.includeMembers = includeMembers;
    }

    private boolean includeMembers() {
        return this.includeMembers;
    }
}

