/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.management.commands.properties.resources.common.SectionedProperties;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.wasresource.capability.IConfiguration;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResource;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;

public class NodeMetadataExt
extends WASResource
implements IConfiguration {
    private static final TraceComponent tc = Tr.register(NodeMetadataExt.class, null, null);

    public String getResourceType() {
        return "Node";
    }

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        super.initialize(eprRefProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{scope, containmentPath, this});
        }
        List result = null;
        if (containmentPath == null || containmentPath.equals("")) {
            containmentPath = this.getResourceType();
        }
        result = containmentPath.equals("NONEXISTENTRESOURCE") ? super.getConfigResourceInstanceForCreate(containmentPath, false, this.getResourceType()) : super.getConfigResourceInstances(session, scope, containmentPath, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances");
        }
        return result;
    }

    public String[] validateProperties(Properties props) {
        return null;
    }

    public SectionedProperties[] getCreateTemplateProperties() throws WASResourceException {
        return null;
    }

    public SectionedProperties[] getDeleteTemplateProperties() throws WASResourceException {
        return null;
    }

    private boolean isFiltered(String cType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFiltered", this.getResourceType());
        }
        boolean filtered = false;
        String[] types = (String[])this.getReferenceProperties().get("SELECTEDSUBTYPES");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "selected types ", types);
        }
        if (types != null && types.length > 0) {
            filtered = true;
            for (int i = 0; i < types.length; ++i) {
                if (!cType.equals(types[i])) continue;
                filtered = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFiltered", new Boolean(filtered));
        }
        return filtered;
    }

    private boolean isFiltered() {
        return this.isFiltered(this.getResourceType());
    }

    public Properties getProperties() throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
        }
        Properties props = new Properties();
        if (this.isFiltered()) {
            return null;
        }
        try {
            String nodeName = ConfigServiceHelper.getDisplayName(this.getConfigData());
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(this.getSession());
            ManagedObjectMetadataHelper metadataHelper = workSpace.getMetadataHelper();
            boolean result = metadataHelper.isNodeZOS(nodeName);
            if (result) {
                props.setProperty("nodeOS", "ZOS");
            } else {
                props.setProperty("nodeOS", "distributed");
            }
            String version = metadataHelper.getNodeBaseProductVersion(nodeName);
            props.setProperty("nodeVersion", version);
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    public String getProperty(String name) throws UnknownResourceTypeException, WASResourceException {
        String propValue = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty", name);
        }
        String result = null;
        try {
            String nodeName = ConfigServiceHelper.getDisplayName(this.getConfigData());
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(this.getSession());
            ManagedObjectMetadataHelper metadataHelper = workSpace.getMetadataHelper();
            if (name.equals("nodeOS")) {
                boolean res = metadataHelper.isNodeZOS(nodeName);
                result = res ? "ZOS" : "distributed";
            } else if (name.equals("nodeVersion")) {
                result = metadataHelper.getNodeBaseProductVersion(nodeName);
            }
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty", propValue);
        }
        return propValue;
    }

    public void setProperty(String name, String value) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty", new Object[]{name, value});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty");
        }
    }

    public void setProperties(Properties props) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", props);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public List getRelationships(int type, boolean recursive) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{new Integer(type), new Boolean(recursive)});
        }
        ArrayList result = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", result);
        }
        return result;
    }

    public List getAllPropertyNames() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllPropertyNames");
        }
        ArrayList result = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllPropertyNames", result);
        }
        return result;
    }

    public String getUniqueId() throws WASResourceException {
        return this.getResourceType() + "MetadataExtension";
    }

    public List getRelationships(String cfgType, int relationType, boolean recursive) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationShips", new Object[]{new Integer(relationType), new Boolean(recursive)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationShips", null);
        }
        return null;
    }
}

