/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.management.commands.properties.resources.common.SectionedProperties;
import com.ibm.ws.management.wasresource.common.PropWASResource;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class AuthorizationTableExt
extends PropWASResource {
    private static final TraceComponent tc = Tr.register(AuthorizationTableExt.class, null, null);

    public String getResourceType() {
        return "AuthorizationTableExt";
    }

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{scope, containmentPath, this});
        }
        List result = null;
        if (containmentPath == null || containmentPath.equals("")) {
            containmentPath = this.getResourceType();
        }
        result = containmentPath.equals("NONEXISTENTRESOURCE") ? super.getConfigResourceInstanceForCreate(containmentPath, false, this.getResourceType()) : super.getConfigResourceInstances(session, scope, containmentPath, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances", result);
        }
        return result;
    }

    public SectionedProperties[] getCreateTemplateProperties() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCreateTemplateProperties");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCreateTemplateProperties", null);
        }
        return null;
    }

    public SectionedProperties[] getDeleteTemplateProperties() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeleteTemplateProperties");
        }
        SectionedProperties[] props = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeleteTemplateProperties", props);
        }
        return props;
    }

    public Properties getProperties() throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", this);
        }
        Properties props = new Properties();
        List allRoles = this.getAllPropertyNames();
        for (int i = 0; i < allRoles.size(); ++i) {
            String pName = (String)allRoles.get(i);
            props.setProperty(pName, this.getProperty(pName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    public String getProperty(String name) throws UnknownResourceTypeException, WASResourceException {
        String propValue = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty", name);
        }
        try {
            propValue = this.getPropertyValue(name);
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty", propValue);
        }
        return propValue;
    }

    public void setProperty(String name, String value) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty", new Object[]{name, value});
        }
        try {
            this.setPropertyValue(name, value);
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty");
        }
    }

    public void setProperties(Properties props) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", props);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String pName = (String)e.nextElement();
            this.setProperty(pName, props.getProperty(pName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public List getRelationships(int type, boolean recursive) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{new Integer(type), new Boolean(recursive)});
        }
        List result = null;
        result = super.getRelationships(type, recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", result);
        }
        return result;
    }

    public List getAllPropertyNames() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllPropertyNames");
        }
        ArrayList<String> result = new ArrayList<String>();
        String cId = this.getConfigID();
        int inx = cId.lastIndexOf("|");
        int einx = cId.lastIndexOf("#");
        String name = cId.substring(inx + 1, einx);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "name = " + name);
        }
        if (name.equals("admin-authz.xml")) {
            result.add("administrator");
            result.add("configurator");
            result.add("operator");
            result.add("monitor");
            result.add("deployer");
            result.add("auditor");
            result.add("adminsecuritymanager");
        } else if (name.equals("naming-authz.xml")) {
            result.add("CosNamingRead");
            result.add("CosNamingWrite");
            result.add("CosNamingCreate");
            result.add("CosNamingDelete");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllPropertyNames", result);
        }
        return result;
    }

    private String getPropertyValue(String pName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyValue", pName);
        }
        String result = this.getMappedUsers(pName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyValue", result);
        }
        return result;
    }

    private void setPropertyValue(String pName, String pValue) throws Exception {
        Boolean deleteObj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPropertyValue", new Object[]{pName, pValue});
        }
        boolean delete = (deleteObj = (Boolean)this.getReferenceProperties().get("DELETERESOURCE")) == null ? false : deleteObj;
        this.setUsers(pValue, pName, delete);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPropertyValue");
        }
    }

    private String getMappedUsers(String roleName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMappedUsers", roleName);
        }
        String result = null;
        boolean cell = false;
        String cId = this.getConfigID();
        int inx = cId.lastIndexOf("|");
        int einx = cId.lastIndexOf("#");
        String name = cId.substring(inx + 1, einx);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "name = " + name);
        }
        if (name.equals("admin-authz.xml")) {
            cell = true;
        } else if (name.equals("naming-authz.xml")) {
            cell = false;
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMappedUsers", result);
            }
            return result;
        }
        CommandMgr cmdMgr = this.getCmdMgr(this.getConfigService());
        AdminCommand cmd = null;
        cmd = cell ? cmdMgr.createCommand("listUserIDsOfAuthorizationGroup") : cmdMgr.createCommand("listUsersForNamingRoles");
        if (cell) {
            cmd.setParameter("authorizationGroupName", "CellAuthorizationGroup");
        }
        cmd.setConfigSession(this.getSession());
        cmd.execute();
        HashMap users = null;
        CommandResult res = cmd.getCommandResult();
        if (res.isSuccessful()) {
            users = (HashMap)res.getResult();
        }
        String userString = AuthorizationTableExt.convertHashMapToString(users, roleName, "user");
        cmd = cell ? cmdMgr.createCommand("listGroupIDsOfAuthorizationGroup") : cmdMgr.createCommand("listGroupsForNamingRoles");
        if (cell) {
            cmd.setParameter("authorizationGroupName", "CellAuthorizationGroup");
        }
        cmd.setConfigSession(this.getSession());
        cmd.execute();
        res = cmd.getCommandResult();
        HashMap groups = null;
        if (res.isSuccessful()) {
            groups = (HashMap)res.getResult();
        }
        String groupString = AuthorizationTableExt.convertHashMapToString(groups, roleName, "group");
        result = userString.substring(0, userString.length() - 1) + groupString.substring(1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMappedUsers", result);
        }
        return result;
    }

    private CommandMgr getCmdMgr(ConfigService configService) throws Exception {
        CommandMgr cmdMgr = null;
        cmdMgr = configService instanceof ConfigServiceProxy ? CommandMgr.getCommandMgr(((ConfigServiceProxy)configService).getAdminClient()) : CommandMgr.getCommandMgr();
        return cmdMgr;
    }

    private static String convertHashMapToString(HashMap map, String roleName, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertHashMapToString", map);
        }
        String result = "{";
        List users = (List)map.get(roleName);
        for (int i = 0; users != null && i < users.size(); ++i) {
            String userName;
            if (i != 0) {
                result = result + ",";
            }
            result = !AuthorizationTableExt.specialSubject(userName = (String)users.get(i)) ? result + type + ":" + userName : result + "special:" + userName;
        }
        result = result + "}";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertHashMapToString", result);
        }
        return result;
    }

    private static String convertListToString(List lst) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertListToString", lst);
        }
        String result = "{";
        for (int i = 0; lst != null && i < lst.size(); ++i) {
            if (i != 0) {
                result = result + ",";
            }
            String resName = (String)lst.get(i);
            result = result + resName;
        }
        result = result + "}";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertListToString", result);
        }
        return result;
    }

    private static boolean specialSubject(String name) {
        return name.equals("ALLAUTHENTICATEDINTRUSTEDREALMS") || name.equals("EVERYONE") || name.equals("ALLAUTHENTICATED") || name.equals("SERVERID") || name.equals("PRIMARYADMINID");
    }

    private void setUsers(String users, String roleName, boolean delete) throws Exception {
        String userName;
        int i;
        ArrayList<String> specialList;
        ArrayList<String> groupList;
        ArrayList<String> userList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUsers", new Object[]{users, roleName});
        }
        boolean cell = false;
        String cId = this.getConfigID();
        int inx = cId.lastIndexOf("|");
        int einx = cId.lastIndexOf("#");
        String name = cId.substring(inx + 1, einx);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "name = " + name);
        }
        if (name.equals("admin-authz.xml")) {
            cell = true;
        } else if (name.equals("naming-authz.xml")) {
            cell = false;
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setUsers");
            }
            return;
        }
        String groupName = null;
        if (cell) {
            groupName = "CellAuthorizationGroup";
        }
        List newUsersLst = this.getValues(users);
        String existingUsers = this.getMappedUsers(roleName);
        List existingUserList = this.getValues(existingUsers);
        if (!delete) {
            if (newUsersLst.containsAll(existingUserList) && newUsersLst.size() == existingUserList.size()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setUsers no change");
                }
                return;
            }
            userList = new ArrayList();
            groupList = new ArrayList();
            specialList = new ArrayList();
            for (i = 0; existingUserList != null && i < existingUserList.size(); ++i) {
                userName = (String)existingUserList.get(i);
                if (userName.startsWith("user:")) {
                    userList.add(userName.substring(5));
                    continue;
                }
                if (userName.startsWith("group:")) {
                    groupList.add(userName.substring(6));
                    continue;
                }
                if (!userName.startsWith("special:")) continue;
                specialList.add(userName.substring(8));
            }
            this.addRemoveUsers(userList, groupName, roleName, true);
            this.addRemoveGroups(groupList, specialList, groupName, roleName, true);
        }
        userList = new ArrayList<String>();
        groupList = new ArrayList<String>();
        specialList = new ArrayList<String>();
        for (i = 0; newUsersLst != null && i < newUsersLst.size(); ++i) {
            userName = (String)newUsersLst.get(i);
            if (userName.startsWith("user:")) {
                userList.add(userName.substring(5));
                continue;
            }
            if (userName.startsWith("group:")) {
                groupList.add(userName.substring(6));
                continue;
            }
            if (!userName.startsWith("special:")) continue;
            specialList.add(userName.substring(8));
        }
        this.addRemoveUsers(userList, groupName, roleName, delete);
        this.addRemoveGroups(groupList, specialList, groupName, roleName, delete);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUsers");
        }
    }

    private List getValues(String value) {
        String val;
        int inx;
        ArrayList<String> vals = new ArrayList<String>();
        if (value.startsWith("{") && (inx = (val = new String(value)).indexOf(125)) > 0) {
            val = val.substring(0, val.indexOf(125));
            StringTokenizer st = new StringTokenizer(val, "{,}");
            while (st.hasMoreTokens()) {
                String v = st.nextToken();
                vals.add(v);
            }
        }
        return vals;
    }

    private void addRemoveUsers(List userList, String groupName, String roleName, boolean delete) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoveUsers", new Object[]{userList, roleName, groupName, new Boolean(delete)});
        }
        CommandMgr cmdMgr = this.getCmdMgr(this.getConfigService());
        AdminCommand cmd = null;
        cmd = !delete ? (groupName != null ? cmdMgr.createCommand("mapUsersToAdminRole") : cmdMgr.createCommand("mapUsersToNamingRole")) : (groupName != null ? cmdMgr.createCommand("removeUsersFromAdminRole") : cmdMgr.createCommand("removeUsersFromNamingRole"));
        cmd.setConfigSession(this.getSession());
        if (groupName != null) {
            cmd.setParameter("authorizationGroupName", groupName);
        }
        cmd.setParameter("roleName", roleName);
        cmd.setParameter("userids", userList.toArray(new String[0]));
        cmd.execute();
        CommandResult res = cmd.getCommandResult();
        if (res.isSuccessful()) {
            String msg = null;
            msg = delete ? "deleted userids " : "added userids ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg + userList + " to authorization group " + groupName);
            }
        } else {
            String msg = null;
            msg = delete ? "failed to delete userids " : "failed to add userids ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg + userList + " to authorization group " + groupName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoveUsers");
        }
    }

    private void addRemoveGroups(List groupList, List specialList, String groupName, String roleName, boolean delete) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoveGroups", new Object[]{groupList, specialList, roleName, groupName, new Boolean(delete)});
        }
        CommandMgr cmdMgr = this.getCmdMgr(this.getConfigService());
        AdminCommand cmd = null;
        cmd = !delete ? (groupName != null ? cmdMgr.createCommand("mapGroupsToAdminRole") : cmdMgr.createCommand("mapGroupsToNamingRole")) : (groupName != null ? cmdMgr.createCommand("removeGroupsFromAdminRole") : cmdMgr.createCommand("removeGroupsFromNamingRole"));
        cmd.setConfigSession(this.getSession());
        if (groupName != null) {
            cmd.setParameter("authorizationGroupName", groupName);
        }
        cmd.setParameter("roleName", roleName);
        cmd.setParameter("groupids", groupList.toArray(new String[0]));
        cmd.setParameter("specialSubjects", specialList.toArray(new String[0]));
        cmd.execute();
        CommandResult res = cmd.getCommandResult();
        if (res.isSuccessful()) {
            String msg = null;
            msg = delete ? "deleted groupids " : "added groupids ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg + groupList + " to authorization group " + groupName);
            }
        } else {
            String msg = null;
            msg = delete ? "failed to delete groupids " : "failed to add groupids ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg + groupList + " to authorization group " + groupName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoveGroups");
        }
    }
}

