/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.nodegroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.ws.management.commands.nodegroup.NodeGroupConfigException;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class NodeGroupHelper {
    private static TraceComponent tc = Tr.register(NodeGroupHelper.class, "management", "com.ibm.ws.management.resources.configservice");
    private static ResourceBundle RESOURCE_BUNDLE = null;
    private static Locale _locale = null;
    private static int NODEGROUP_NOT_JOIN = 0;
    private static int NODEGROUP_JOIN = 1;
    private static int NODEGROUP_CONVERT_JOIN = 2;

    private NodeGroupHelper() throws AdminException {
    }

    public static void setLocale(Locale locale) {
        _locale = locale;
    }

    public static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }

    public static String[] getNodeGroupMembers(Session session, ConfigService configService, String nodeGroupName) throws ConfigServiceException {
        if (nodeGroupName == null) {
            return new String[0];
        }
        ArrayList<String> nodes = new ArrayList<String>();
        try {
            ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + nodeGroupName);
            if (nodeGroups == null || nodeGroups.length == 0) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{nodeGroupName}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
            ObjectName nodeGroup = nodeGroups[0];
            AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"members"}, false);
            List members = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName member : members) {
                String nodeMember = (String)configService.getAttribute(session, member, "nodeName");
                nodes.add(nodeMember);
            }
        }
        catch (Exception ex) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.configservice", "ADMG0011E", new Object[]{ex}, null));
        }
        String[] result = new String[nodes.size()];
        nodes.toArray(result);
        return result;
    }

    private static String[] getGroupMemberShip(Session session, ConfigService configService, String name, ObjectName node) throws ConfigServiceException {
        if (node == null) {
            return new String[0];
        }
        ArrayList<String> groups = new ArrayList<String>();
        String nodeName = ConfigServiceHelper.getDisplayName(node);
        try {
            ObjectName cell;
            if (node != null && (cell = configService.getRelationship(session, node, "parent")[0]) != null) {
                ObjectName[] matches = configService.getRelationship(session, cell, "NodeGroup");
                for (int i = 0; i < matches.length; ++i) {
                    AttributeList attrList = configService.getAttributes(session, matches[i], new String[]{"members"}, false);
                    List members = (List)((Attribute)attrList.get(0)).getValue();
                    for (ObjectName member : members) {
                        String group;
                        String nodeMember = (String)configService.getAttribute(session, member, "nodeName");
                        if (!nodeMember.equals(nodeName) || (group = (String)configService.getAttribute(session, matches[i], "name")).equals(name)) continue;
                        groups.add(group);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.configservice", "ADMG0011E", new Object[]{ex}, null));
        }
        String[] result = new String[groups.size()];
        groups.toArray(result);
        return result;
    }

    private static String[] getServerClusterMemberShip(Session session, ConfigService configService, String name, ObjectName node) throws ConfigServiceException {
        if (node == null) {
            return new String[0];
        }
        ArrayList<String> clusters = new ArrayList<String>();
        try {
            String nodeName = ConfigServiceHelper.getDisplayName(node);
            ObjectName cell = configService.getRelationship(session, node, "parent")[0];
            if (cell != null) {
                ObjectName[] matches = configService.getRelationship(session, cell, "ServerCluster");
                for (int i = 0; i < matches.length; ++i) {
                    AttributeList list = configService.getAttributes(session, matches[i], new String[]{"nodeGroupName"}, false);
                    String nodeGroupName = (String)((Attribute)list.get(0)).getValue();
                    AttributeList attrList = configService.getAttributes(session, matches[i], new String[]{"members"}, false);
                    List members = (List)((Attribute)attrList.get(0)).getValue();
                    for (ObjectName member : members) {
                        String nodeMember = (String)configService.getAttribute(session, member, "nodeName");
                        if (!nodeMember.equals(nodeName) || !nodeGroupName.equals(name)) continue;
                        String cluster = (String)configService.getAttribute(session, matches[i], "name");
                        clusters.add(cluster);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.configservice", "ADMG0011E", new Object[]{ex}, null));
        }
        String[] result = new String[clusters.size()];
        clusters.toArray(result);
        return result;
    }

    public static ObjectName removeNodeGroupMember(Session session, ConfigService configService, String name, String nodeName) throws ConfigServiceException, ConnectorException, NodeGroupConfigException, AdminException {
        String[] groups;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodeGroupMember", new Object[]{session, name, nodeName});
        }
        ObjectName node = null;
        ObjectName nodeGroup = null;
        ObjectName member2 = null;
        ObjectName[] nodes = configService.resolve(session, "Node=" + nodeName);
        if (nodes == null || nodes.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG9218E", new Object[]{nodeName}, null);
            throw new NodeGroupConfigException(msg);
        }
        node = nodes[0];
        ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + name);
        if (nodeGroups == null || nodeGroups.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{name}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        nodeGroup = nodeGroups[0];
        String[] clusters = NodeGroupHelper.getServerClusterMemberShip(session, configService, name, node);
        if (clusters.length > 0) {
            boolean alldynamic = true;
            for (int i = 0; i < clusters.length && (alldynamic &= NodeGroupHelper.isXDDynamicCluster(session, clusters[i])); ++i) {
            }
            if (!alldynamic) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0451E", new Object[]{nodeName, name}, null);
                throw new NodeGroupConfigException(msg);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All the clusters are dynamic clusters");
            }
        }
        if ((groups = NodeGroupHelper.getGroupMemberShip(session, configService, name, node)).length > 0) {
            AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"members"}, false);
            List members = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName member2 : members) {
                String nodeMember;
                if (member2 == null || !(nodeMember = (String)configService.getAttribute(session, member2, "nodeName")).equals(nodeName)) continue;
                if (NodeGroupHelper.isSysplexNodeGroup(session, configService, name)) {
                    String msg = NodeGroupHelper.getFormattedMessage("ADMG0459E", new Object[]{nodeName, name}, null);
                    throw new NodeGroupConfigException(msg);
                }
                configService.deleteConfigData(session, member2);
                break;
            }
        } else {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0452E", new Object[]{nodeName, name}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodeGroupMember", member2);
        }
        return member2;
    }

    public static ObjectName addNodeGroupMember(Session session, ConfigService configService, String name, String nodeName) throws ConfigServiceException, ConnectorException, AdminException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNodeGroupMember", new Object[]{session, name, nodeName});
        }
        ObjectName nodeGroupObject = null;
        ObjectName nodeGroupMember = null;
        ObjectName node = null;
        ManagedObjectMetadataHelper metadataHelper = NodeGroupHelper.getMetadataHelper(session);
        boolean isPlexNodeGroup = NodeGroupHelper.isSysplexNodeGroup(session, configService, name);
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("nodeName", nodeName));
        ObjectName[] nodes = configService.resolve(session, "Node=" + nodeName);
        if (nodes == null || nodes.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG9218E", new Object[]{nodeName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        node = nodes[0];
        if (!NodeGroupHelper.isManagedNode(session, configService, node)) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0492E", new Object[]{nodeName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName[] nodeGroupObjects = configService.resolve(session, "NodeGroup=" + name);
        if (nodeGroupObjects == null || nodeGroupObjects.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{name}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        nodeGroupObject = nodeGroupObjects[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "NodeGroupMember");
        ObjectName[] currentMemberObjects = configService.queryConfigObjects(session, nodeGroupObject, pattern, null);
        if (currentMemberObjects.length == 0) {
            if (!metadataHelper.isNodeZOS(nodeName) && isPlexNodeGroup) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{nodeName, name}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
            nodeGroupMember = configService.createConfigData(session, nodeGroupObject, "members", "NodeGroupMember", attrList);
        } else {
            for (int i = 0; i < currentMemberObjects.length; ++i) {
                String currentNode = (String)configService.getAttribute(session, currentMemberObjects[i], "nodeName");
                if (i == 0) {
                    NodeGroupHelper.validate(session, configService, currentNode, nodeName, name, metadataHelper);
                }
                if (currentNode == null || !currentNode.equals(nodeName)) continue;
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0454E", new Object[]{nodeName, name}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
            nodeGroupMember = configService.createConfigData(session, nodeGroupObject, "members", "NodeGroupMember", attrList);
        }
        if (!isPlexNodeGroup) {
            NodeGroupHelper.addToSysplexNodeGroupIfNeeded(session, configService, name, nodeName, metadataHelper);
        } else {
            NodeGroupHelper.modifyNodeProperty(session, configService, nodeName, name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNodeGroupMember", new Object[]{nodeGroupMember});
        }
        return nodeGroupMember;
    }

    private static void addToSysplexNodeGroupIfNeeded(Session session, ConfigService configService, String name, String nodeName, ManagedObjectMetadataHelper metadataHelper) throws ConfigServiceException, ConnectorException, NodeGroupConfigException, AdminException {
        Properties prop;
        String plex1;
        String plexNG;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSysplexNodeGroupIfNeeded", new Object[]{nodeName});
        }
        ObjectName member = null;
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("nodeName", nodeName));
        boolean found = false;
        if (metadataHelper.isNodeZOS(nodeName) && (plexNG = NodeGroupHelper.getNodeGroupFromSysplexName(session, configService, plex1 = ((String)(prop = metadataHelper.getAccessor().getMetadataProperties(nodeName)).get("com.ibm.websphere.nodeSysplexName")).trim())) != null) {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "NodeGroupMember");
            ObjectName nodeGroup = configService.resolve(session, "NodeGroup=" + plexNG)[0];
            ObjectName[] members = configService.queryConfigObjects(session, nodeGroup, pattern, null);
            for (int i = 0; i < members.length; ++i) {
                String currentNode = (String)configService.getAttribute(session, members[i], "nodeName");
                if (currentNode == null || !currentNode.equals(nodeName)) continue;
                found = true;
                break;
            }
            if (!found) {
                member = configService.createConfigData(session, nodeGroup, "members", "NodeGroupMember", attrList);
                NodeGroupHelper.modifyNodeProperty(session, configService, nodeName, plexNG);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSysplexNodeGroupIfNeeded", member);
        }
    }

    public static ObjectName removeNodeGroup(Session session, ConfigService configService, String name) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodeGroup", new Object[]{session, name});
        }
        if (name.equalsIgnoreCase("DefaultNodeGroup")) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0457E", new Object[]{name}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName nodeGroup = null;
        ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + name);
        if (nodeGroups == null || nodeGroups.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{name}, null);
            throw new NodeGroupConfigException(msg);
        }
        nodeGroup = nodeGroups[0];
        List members = (List)configService.getAttribute(session, nodeGroup, "members");
        if (members.size() != 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0456E", new Object[]{name}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        configService.deleteConfigData(session, nodeGroup);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodeGroup", nodeGroup);
        }
        return nodeGroup;
    }

    public static ObjectName createNodeGroup(Session session, ConfigService configService, String name, String shortName, String description) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeGroup", new Object[]{session, name, shortName, description});
        }
        ObjectName nodeGroup = null;
        if (name != null && name.length() > 0) {
            String[] groups = NodeGroupHelper.listNodeGroups(session, configService);
            for (int i = 0; i < groups.length; ++i) {
                if (!groups[i].equalsIgnoreCase(name)) continue;
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0493E", new Object[]{name}, null);
                throw new NodeGroupConfigException(msg);
            }
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("name", name));
            attrList.add(new Attribute("shortName", shortName));
            attrList.add(new Attribute("description", description));
            nodeGroup = configService.createConfigData(session, cell, "NodeGroup", null, attrList);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createNodeGroup", new Object[]{nodeGroup});
            }
        }
        return nodeGroup;
    }

    public static ObjectName modifyNodeGroup(Session session, ConfigService configService, String name, String shortName, String description) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyNodeGroup", new Object[]{session, name, shortName, description});
        }
        ObjectName nodeGroup = null;
        if (name != null && name.length() > 0) {
            ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + name);
            if (nodeGroups == null || nodeGroups.length == 0) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{name}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
            nodeGroup = nodeGroups[0];
            AttributeList attrList = new AttributeList();
            if (shortName != null) {
                attrList.add(new Attribute("shortName", shortName));
            }
            if (description != null) {
                attrList.add(new Attribute("description", description));
            }
            configService.setAttributes(session, nodeGroup, attrList);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "modifyNodeGroup", new Object[]{nodeGroup});
            }
        }
        return nodeGroup;
    }

    public static String[] listNodeGroups(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listNodeGroups");
        }
        ArrayList<String> list = new ArrayList<String>();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName[] matches = configService.getRelationship(session, cell, "NodeGroup");
        for (int i = 0; i < matches.length; ++i) {
            String group = (String)configService.getAttribute(session, matches[i], "name");
            list.add(group);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listNodeGroups", result);
        }
        return result;
    }

    public static String[] listNodeGroups(Session session, ConfigService configService, String nodeName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listNodeGroups", nodeName);
        }
        if (nodeName == null || nodeName.length() == 0) {
            return NodeGroupHelper.listNodeGroups(session, configService);
        }
        ArrayList<String> list = new ArrayList<String>();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName[] matches = configService.getRelationship(session, cell, "NodeGroup");
        for (int i = 0; i < matches.length; ++i) {
            AttributeList attrList = configService.getAttributes(session, matches[i], new String[]{"members"}, false);
            List members = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName member : members) {
                String nodeMember = (String)configService.getAttribute(session, member, "nodeName");
                if (!nodeMember.equals(nodeName)) continue;
                String group = (String)configService.getAttribute(session, matches[i], "name");
                list.add(group);
            }
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listNodeGroups", result);
        }
        return result;
    }

    public static String[] listNodes(Session session, ConfigService configService, String nodeGroup) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listNodes", nodeGroup);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (nodeGroup != null && nodeGroup.length() > 0) {
            return NodeGroupHelper.getNodeGroupMembers(session, configService, nodeGroup);
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName[] matches = configService.getRelationship(session, cell, "Node");
        for (int i = 0; i < matches.length; ++i) {
            String node = (String)configService.getAttribute(session, matches[i], "name");
            list.add(node);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listNodes", result);
        }
        return result;
    }

    public static ObjectName createNodeGroupProperty(Session session, ConfigService configService, String nodeGroupName, String name, String value, String description, Boolean required, String validationExpression) throws NodeGroupConfigException, ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeGroupProperty", new Object[]{nodeGroupName, name, value, description, required, validationExpression});
        }
        ObjectName result = null;
        ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + nodeGroupName);
        if (nodeGroups == null || nodeGroups.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{nodeGroupName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName nodeGroup = nodeGroups[0];
        if (!NodeGroupHelper.validateNodeGroupProperty(session, configService, nodeGroup, name)) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0458E", new Object[]{name, nodeGroupName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("name", name));
        attrList.add(new Attribute("value", value));
        attrList.add(new Attribute("description", description));
        attrList.add(new Attribute("required", required));
        attrList.add(new Attribute("validationExpression", validationExpression));
        result = configService.createConfigData(session, nodeGroup, "properties", null, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNodeGroupProperty", result);
        }
        return result;
    }

    public static ObjectName modifyNodeGroupProperty(Session session, ConfigService configService, String nodeGroupName, String name, String value, String description, Boolean required, String validationExpression) throws ConfigServiceException, NodeGroupConfigException, ConnectorException, AdminException {
        ObjectName[] nodeGroups;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyNodeGroupProperty", new Object[]{nodeGroupName, name, value, description, required, validationExpression});
        }
        if ((nodeGroups = configService.resolve(session, "NodeGroup=" + nodeGroupName)) == null || nodeGroups.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{nodeGroupName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName nodeGroup = nodeGroups[0];
        ObjectName property2 = null;
        AttributeList newList = new AttributeList();
        AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"properties"}, false);
        List props = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName property2 : props) {
            String propName = (String)configService.getAttribute(session, property2, "name");
            if (!propName.equals(name)) continue;
            newList.add(new Attribute("name", name));
            if (value != null) {
                newList.add(new Attribute("value", value));
            }
            if (description != null) {
                newList.add(new Attribute("description", description));
            }
            if (required != null && required.booleanValue()) {
                newList.add(new Attribute("required", required));
            } else {
                newList.add(new Attribute("required", new Boolean(false)));
            }
            if (validationExpression != null) {
                newList.add(new Attribute("validationExpression", validationExpression));
            }
            configService.setAttributes(session, property2, newList);
            if (NodeGroupHelper.isSysplexNodeGroup(session, configService, nodeGroupName)) {
                NodeGroupHelper.modifyMatchingCellLevelVar(session, configService, nodeGroup, name, value);
                NodeGroupHelper.modifyMatchingNode5LevelVar(session, configService, nodeGroup, name, value);
            }
            return property2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyNodeGroupProperty");
        }
        return null;
    }

    public static ObjectName removeNodeGroupProperty(Session session, ConfigService configService, String nodeGroupName, String name) throws ConfigServiceException, NodeGroupConfigException, ConnectorException {
        ObjectName[] nodeGroups;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodeGroupProperty", new Object[]{nodeGroupName, name});
        }
        if ((nodeGroups = configService.resolve(session, "NodeGroup=" + nodeGroupName)) == null || nodeGroups.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{nodeGroupName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName nodeGroup = nodeGroups[0];
        ObjectName property2 = null;
        AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"properties"}, false);
        List props = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName property2 : props) {
            String propName = (String)configService.getAttribute(session, property2, "name");
            if (!propName.equals(name)) continue;
            configService.deleteConfigData(session, property2);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodeGroupProperty", property2);
        }
        return property2;
    }

    public static boolean isNodeInNodeGroup(Session session, ConfigService configService, String node, String groupName) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (node != null && node.length() != 0 && groupName != null && groupName.length() != 0) {
            ObjectName nodeGroup = null;
            ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + groupName);
            if (nodeGroups == null || nodeGroups.length <= 0) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{groupName}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
            nodeGroup = nodeGroups[0];
            AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"members"}, false);
            List members = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName member : members) {
                String nodeMember = (String)configService.getAttribute(session, member, "nodeName");
                if (!node.equals(nodeMember)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getFormattedMessage(String key, Object[] args, String msg) {
        try {
            RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", NodeGroupHelper.getLocale());
            String result = RESOURCE_BUNDLE.getString(key);
            if (result == null) {
                return msg;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (msg == null) {
                return msg;
            }
            return MessageFormat.format(msg, args);
        }
        catch (NullPointerException npe) {
            return msg;
        }
    }

    private static boolean validateNodeGroupProperty(Session session, ConfigService configService, ObjectName nodeGroup, String name) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateNodeGroupProperty", new Object[]{nodeGroup, name});
        }
        AttributeList newList = new AttributeList();
        AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"properties"}, false);
        List props = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName property : props) {
            String propName = (String)configService.getAttribute(session, property, "name");
            if (name == null || !propName.equals(name)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSysplexNodeGroup(Session session, ConfigService configService, String name) throws ConfigServiceException, ConnectorException, NodeGroupConfigException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSysplexNodeGroup", new Object[]{name});
        }
        boolean result = false;
        ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + name);
        if (nodeGroups == null || nodeGroups.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{name}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName nodeGroup = nodeGroups[0];
        AttributeList newList = new AttributeList();
        AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"properties"}, false);
        List props = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName property : props) {
            String propName = (String)configService.getAttribute(session, property, "name");
            if (!propName.equals("was.sysplexName")) continue;
            result = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isSysplexNodeGroup", new Boolean(result));
        }
        return result;
    }

    public static String getNodeGroupFromSysplexName(Session session, ConfigService configService, String sysplexName) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeGroupFromSysplexName", sysplexName);
        }
        String result = null;
        boolean found = false;
        if (sysplexName != null && sysplexName.length() > 0) {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
            ObjectName[] matches = configService.getRelationship(session, cell, "NodeGroup");
            for (int i = 0; i < matches.length; ++i) {
                AttributeList attrList = configService.getAttributes(session, matches[i], new String[]{"properties"}, false);
                List props = (List)((Attribute)attrList.get(0)).getValue();
                for (ObjectName property : props) {
                    String propName = (String)configService.getAttribute(session, property, "name");
                    if (!propName.equals("was.sysplexName")) continue;
                    String plex = (String)configService.getAttribute(session, property, "value");
                    plex = plex.trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "plex", plex);
                    }
                    if (!plex.equals(sysplexName.trim())) continue;
                    result = (String)configService.getAttribute(session, matches[i], "name");
                    found = true;
                    break;
                }
                if (found) break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeGroupFromSysplexName", result);
        }
        return result;
    }

    public static String getSysplexName(Session session, ConfigService configService, String nodeGroup) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSysplexName", new Object[]{nodeGroup});
        }
        String result = null;
        ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + nodeGroup);
        if (nodeGroups == null || nodeGroups.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{nodeGroup}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName nodeGroupObj = nodeGroups[0];
        AttributeList attrList = configService.getAttributes(session, nodeGroupObj, new String[]{"properties"}, false);
        List props = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName property : props) {
            String propName = (String)configService.getAttribute(session, property, "name");
            if (!propName.equals("was.sysplexName")) continue;
            result = (String)configService.getAttribute(session, property, "value");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSysplexName", result);
        }
        return result;
    }

    public static Properties getSysplexNodeGroupProperties(Session session, ConfigService configService, String name) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSysplexNodeGroupProperties", new Object[]{name});
        }
        Properties result = new Properties();
        ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + name);
        if (nodeGroups == null || nodeGroups.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{name}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName nodeGroup = nodeGroups[0];
        AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"properties"}, false);
        List props = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName property : props) {
            String propName = (String)configService.getAttribute(session, property, "name");
            if (!propName.startsWith("was.")) continue;
            String propValue = (String)configService.getAttribute(session, property, "value");
            result.put(propName, propValue);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSysplexNodeGroupProperties", result);
        }
        return result;
    }

    public static String[] listNodeGroupProperties(Session session, ConfigService configService, String name) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listNodeGroupProperties", new Object[]{name});
        }
        ArrayList<String> result = new ArrayList<String>();
        ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + name);
        if (nodeGroups == null || nodeGroups.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{name}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName nodeGroup = nodeGroups[0];
        AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"properties"}, false);
        List props = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName property : props) {
            String propName = (String)configService.getAttribute(session, property, "name");
            String val = (String)configService.getAttribute(session, property, "value");
            result.add(propName + "=" + val);
        }
        String[] array = new String[result.size()];
        result.toArray(array);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listNodeGroupProperties", array);
        }
        return array;
    }

    public static String getSysplexNodeGroup(Session session, ConfigService configService, String nodeName) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSysplexNodeGroup", new Object[]{nodeName});
        }
        String result = null;
        ObjectName[] nodes = configService.resolve(session, "Node=" + nodeName);
        if (nodes == null || nodes.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG9218E", new Object[]{nodeName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName node = nodes[0];
        AttributeList attrList = configService.getAttributes(session, node, new String[]{"properties"}, false);
        List props = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName property : props) {
            String propName = (String)configService.getAttribute(session, property, "name");
            if (!(propName != null & propName.length() > 0) || !propName.equals("was.sysplexNodeGroup")) continue;
            result = (String)configService.getAttribute(session, property, "value");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSysplexNodeGroup", result);
        }
        return result;
    }

    private static ObjectName createNodeProperty(Session session, ConfigService configService, ObjectName node, String name, String value) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeProperty", new Object[]{node});
        }
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("name", name));
        attrList.add(new Attribute("value", value));
        ObjectName prop = configService.createConfigData(session, node, "properties", null, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNodeProperty", new Object[]{prop});
        }
        return prop;
    }

    private static void modifyNodeProperty(Session session, ConfigService configService, String nodeName, String nodeGroup) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        ObjectName[] nodes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyNodeProperty", new Object[]{nodeName});
        }
        if ((nodes = configService.resolve(session, "Node=" + nodeName)) == null || nodes.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG9218E", new Object[]{nodeName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName node = nodes[0];
        AttributeList attrList = configService.getAttributes(session, node, new String[]{"properties"}, false);
        List props = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName property : props) {
            String propName = (String)configService.getAttribute(session, property, "name");
            if (!propName.equals("was.sysplexNodeGroup")) continue;
            AttributeList list = new AttributeList();
            list.add(new Attribute("value", nodeGroup));
            configService.setAttributes(session, property, list);
        }
    }

    public static ObjectName createSysplexNodeGroup(Session session, ConfigService configService, String name, String shortName, String description, Map props) throws ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSysplexNodeGroup", new Object[]{session, name, shortName, description, props});
        }
        ObjectName nodeGroup = null;
        if (name != null && name.length() > 0) {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("name", name));
            attrList.add(new Attribute("shortName", shortName));
            attrList.add(new Attribute("description", description));
            NodeGroupHelper.validateNodeGroupShortName(session, configService, shortName);
            nodeGroup = configService.createConfigData(session, cell, "NodeGroup", null, attrList);
            if (nodeGroup != null) {
                AttributeList prop = new AttributeList();
                for (Map.Entry entry : props.entrySet()) {
                    String propName = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    prop.add(new Attribute("name", propName));
                    prop.add(new Attribute("value", value));
                    ObjectName result = configService.createConfigData(session, nodeGroup, "properties", null, prop);
                    prop.clear();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSysplexNodeGroup", new Object[]{nodeGroup});
            }
        }
        return nodeGroup;
    }

    public static String getCellName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        String cellName = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        cellName = ConfigServiceHelper.getDisplayName(cell);
        return cellName;
    }

    private static String getFirstNodeGroupMember(Session session, ConfigService configService, String name) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        String memberName = null;
        ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + name);
        if (nodeGroups == null || nodeGroups.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{name}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        ObjectName nodeGroup = nodeGroups[0];
        AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"members"}, false);
        List members = (List)((Attribute)attrList.get(0)).getValue();
        Iterator iter = members.iterator();
        if (iter.hasNext()) {
            ObjectName member = (ObjectName)iter.next();
            memberName = (String)configService.getAttribute(session, member, "nodeName");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFirstNodeGroupMember", memberName);
        }
        return memberName;
    }

    public static boolean hasZosNode(Session session, ConfigService configService, String name) throws ConfigServiceException, ConnectorException, AdminException {
        ManagedObjectMetadataHelper metadataHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasZosNode", name);
        }
        boolean result = false;
        String member = NodeGroupHelper.getFirstNodeGroupMember(session, configService, name);
        if (member != null && member.length() > 0 && (metadataHelper = NodeGroupHelper.getMetadataHelper(session)).isNodeZOS(member)) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasZosNode", new Boolean(result));
        }
        return result;
    }

    public static boolean hasDistributedNode(Session session, ConfigService configService, String name) throws ConfigServiceException, ConnectorException, AdminException {
        ManagedObjectMetadataHelper metadataHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasDistributedNode", name);
        }
        boolean result = false;
        String member = NodeGroupHelper.getFirstNodeGroupMember(session, configService, name);
        if (member != null && member.length() > 0 && !(metadataHelper = NodeGroupHelper.getMetadataHelper(session)).isNodeZOS(member)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isNodeZOS: true");
            }
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasDistributedNode", new Boolean(result));
        }
        return result;
    }

    public static List listCandidateNodes(Session session, ConfigService configService, String name) throws ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCandidateNodes");
        }
        ManagedObjectMetadataHelper metadataHelper = NodeGroupHelper.getMetadataHelper(session);
        if (NodeGroupHelper.hasDistributedNode(session, configService, name)) {
            return NodeGroupHelper.listDistributedNodes(session, configService, metadataHelper);
        }
        if (NodeGroupHelper.hasZosNode(session, configService, name)) {
            return NodeGroupHelper.listZosNodes(session, configService, name, metadataHelper);
        }
        return NodeGroupHelper.getAllManagedNodes(session, configService);
    }

    public static List getAllNodes(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException, AdminException {
        ArrayList<Node> list = new ArrayList<Node>();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName[] matches = configService.getRelationship(session, cell, "Node");
        for (int i = 0; i < matches.length; ++i) {
            Node wccmNode = (Node)MOFUtil.convertToEObject(session, matches[i]);
            list.add(wccmNode);
        }
        return list;
    }

    private static List listDistributedNodes(Session session, ConfigService configService, ManagedObjectMetadataHelper metadataHelper) throws ConfigServiceException, ConnectorException, AdminException {
        ArrayList<Node> list = new ArrayList<Node>();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName[] matches = configService.getRelationship(session, cell, "Node");
        for (int i = 0; i < matches.length; ++i) {
            String node = (String)configService.getAttribute(session, matches[i], "name");
            if (metadataHelper.isNodeZOS(node)) continue;
            Node wccmNode = (Node)MOFUtil.convertToEObject(session, matches[i]);
            list.add(wccmNode);
        }
        return list;
    }

    private static List listZosNodes(Session session, ConfigService configService, String name, ManagedObjectMetadataHelper metadataHelper) throws ConfigServiceException, ConnectorException, AdminException {
        Properties prop;
        String sysplexName;
        ArrayList<Node> list = new ArrayList<Node>();
        String firstMember = NodeGroupHelper.getFirstNodeGroupMember(session, configService, name);
        if (firstMember != null && firstMember.length() > 0 && (sysplexName = (String)(prop = metadataHelper.getAccessor().getMetadataProperties(firstMember)).get("com.ibm.websphere.nodeSysplexName")) != null && sysplexName.length() > 0) {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
            ObjectName[] matches = configService.getRelationship(session, cell, "Node");
            for (int i = 0; i < matches.length; ++i) {
                String plexName;
                String node = (String)configService.getAttribute(session, matches[i], "name");
                if (!metadataHelper.isNodeZOS(node) || (plexName = (String)(prop = metadataHelper.getAccessor().getMetadataProperties(node)).get("com.ibm.websphere.nodeSysplexName")) == null || plexName.length() <= 0 || !plexName.equals(sysplexName) || firstMember.equals(node)) continue;
                Node wccmNode = (Node)MOFUtil.convertToEObject(session, matches[i]);
                list.add(wccmNode);
            }
        }
        return list;
    }

    private static void validate(Session session, ConfigService configService, String firstNode, String nodeName, String nodeGroup, ManagedObjectMetadataHelper metadataHelper) throws AdminException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{firstNode, nodeName, nodeGroup});
        }
        if (!metadataHelper.isNodeZOS(firstNode) && !metadataHelper.isNodeZOS(nodeName)) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Not z/OS nodes ", new Object[]{firstNode, nodeName});
            }
            if (NodeGroupHelper.isSysplexNodeGroup(session, configService, nodeGroup)) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{nodeName, nodeGroup}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
        } else if (metadataHelper.isNodeZOS(firstNode) && metadataHelper.isNodeZOS(nodeName)) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "z/OS nodes ", new Object[]{firstNode, nodeName});
            }
            if (NodeGroupHelper.isSysplexNodeGroup(session, configService, nodeGroup) && metadataHelper.compareNodeVersion(nodeName, "5") == 0) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0490E", new Object[]{nodeName, nodeGroup}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
            Properties prop1 = metadataHelper.getAccessor().getMetadataProperties(firstNode);
            String plex1 = ((String)prop1.get("com.ibm.websphere.nodeSysplexName")).trim();
            Properties prop2 = metadataHelper.getAccessor().getMetadataProperties(nodeName);
            String plex2 = ((String)prop2.get("com.ibm.websphere.nodeSysplexName")).trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "plex1,plex2", new Object[]{plex1, plex2});
            }
            if (plex1 == null || plex2 == null || !plex1.equals(plex2)) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0421E", new Object[]{nodeName, nodeGroup}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
        } else {
            if (metadataHelper.isNodeZOS(firstNode) && !metadataHelper.isNodeZOS(nodeName)) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{nodeName, nodeGroup}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
            if (!metadataHelper.isNodeZOS(firstNode) && metadataHelper.isNodeZOS(nodeName)) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0420E", new Object[]{nodeName, nodeGroup}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
        }
    }

    public static int canNodeJoinNodeGroup(Session session, ConfigService configService, String nodeName, String platform, String version, String sysplexName, String nodeGroupName) throws AdminException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canNodeJoinNodeGroup", new Object[]{nodeName, platform, sysplexName, nodeGroupName});
        }
        ManagedObjectMetadataHelper metadataHelper = NodeGroupHelper.getMetadataHelper(session);
        String firstNode = NodeGroupHelper.getFirstNodeGroupMember(session, configService, nodeGroupName);
        if (firstNode != null && firstNode.length() > 0) {
            String _platform = metadataHelper.getNodePlatformOS(firstNode);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "canNodeJoinNodeGroup: firstNode,platform", new Object[]{firstNode, _platform});
            }
            if (!platform.equalsIgnoreCase("os390") && !metadataHelper.isNodeZOS(firstNode)) {
                if (nodeGroupName.equals("DefaultNodeGroup") || !NodeGroupHelper.isSysplexNodeGroup(session, configService, nodeGroupName)) {
                    return NODEGROUP_JOIN;
                }
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{nodeName, nodeGroupName}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
            if (platform.equalsIgnoreCase("os390") && metadataHelper.isNodeZOS(firstNode)) {
                Properties prop = metadataHelper.getAccessor().getMetadataProperties(firstNode);
                String plex = ((String)prop.get("com.ibm.websphere.nodeSysplexName")).trim();
                if (plex == null || sysplexName == null || !plex.equals(sysplexName.trim())) {
                    String msg = NodeGroupHelper.getFormattedMessage("ADMG0421E", new Object[]{nodeName, nodeGroupName}, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, msg);
                    }
                    throw new NodeGroupConfigException(msg);
                }
                return NODEGROUP_JOIN;
            }
            if (!metadataHelper.isNodeZOS(firstNode) && platform.equalsIgnoreCase("os390")) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0420E", new Object[]{nodeName, nodeGroupName}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
            if (metadataHelper.isNodeZOS(firstNode) && !platform.equalsIgnoreCase("os390")) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{nodeName, nodeGroupName}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
        } else {
            if (platform.equalsIgnoreCase("os390")) {
                if (NodeGroupHelper.isSysplexNodeGroup(session, configService, nodeGroupName)) {
                    return NODEGROUP_JOIN;
                }
                String ng = NodeGroupHelper.getNodeGroupFromSysplexName(session, configService, sysplexName);
                if (ng == null) {
                    return NODEGROUP_CONVERT_JOIN;
                }
                return NODEGROUP_JOIN;
            }
            if (!platform.equalsIgnoreCase("os390")) {
                if (!NodeGroupHelper.isSysplexNodeGroup(session, configService, nodeGroupName)) {
                    return NODEGROUP_JOIN;
                }
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{nodeName, nodeGroupName}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
        }
        return NODEGROUP_NOT_JOIN;
    }

    public static List getNodeGroups(Session session, ConfigService configService, String nodeName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeGroups", nodeName);
        }
        ArrayList<NodeGroup> list = new ArrayList<NodeGroup>();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName[] matches = configService.getRelationship(session, cell, "NodeGroup");
        for (int i = 0; i < matches.length; ++i) {
            AttributeList attrList = configService.getAttributes(session, matches[i], new String[]{"members"}, false);
            List members = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName member : members) {
                String nodeMember = (String)configService.getAttribute(session, member, "nodeName");
                if (!nodeMember.equals(nodeName)) continue;
                NodeGroup nodeGroup = (NodeGroup)MOFUtil.convertToEObject(session, matches[i]);
                list.add(nodeGroup);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeGroups", list);
        }
        return list;
    }

    public static void removeNodeFromNodeGroups(Session session, ConfigService configService, String nodeName) throws ConfigServiceException, ConnectorException, NodeGroupConfigException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodeFromNodeGroups", new Object[]{session, nodeName});
        }
        ObjectName node = null;
        Object nodeGroup = null;
        ObjectName[] nodes = configService.resolve(session, "Node=" + nodeName);
        if (nodes == null || nodes.length == 0) {
            String msg = NodeGroupHelper.getFormattedMessage("ADMG9218E", new Object[]{nodeName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
        node = nodes[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName[] matches = configService.getRelationship(session, cell, "NodeGroup");
        for (int i = 0; i < matches.length; ++i) {
            AttributeList attrList = configService.getAttributes(session, matches[i], new String[]{"members"}, false);
            List members = (List)((Attribute)attrList.get(0)).getValue();
            int count = members.size();
            for (ObjectName member : members) {
                String nodeMember = (String)configService.getAttribute(session, member, "nodeName");
                if (!nodeMember.equals(nodeName)) continue;
                if (count == 1) {
                    NodeGroupHelper.cleanupSysplexProperties(session, configService, matches[i]);
                }
                configService.deleteConfigData(session, member);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodeFromNodeGroups");
        }
    }

    public static void cleanupSysplexProperties(Session session, ConfigService configService, ObjectName nodeGroup) throws ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSysplexProperties", nodeGroup);
        }
        AttributeList attrList = configService.getAttributes(session, nodeGroup, new String[]{"properties"}, false);
        List props = (List)((Attribute)attrList.get(0)).getValue();
        for (ObjectName property : props) {
            configService.deleteConfigData(session, property);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupSysplexProperties");
        }
    }

    public static ObjectName convertToSysplexNodeGroup(Session session, ConfigService configService, String name, String shortName, Properties props) throws ConfigServiceException, ConnectorException, AdminException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToSysplexNodeGroup", new Object[]{session, name, props});
        }
        ObjectName nodeGroup = null;
        if (name != null && name.length() > 0) {
            ObjectName[] nodeGroups = configService.resolve(session, "NodeGroup=" + name);
            if (nodeGroups == null || nodeGroups.length == 0) {
                String msg = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{name}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new NodeGroupConfigException(msg);
            }
            nodeGroup = nodeGroups[0];
            if (shortName != null && shortName.length() > 0) {
                NodeGroupHelper.validateNodeGroupShortName(session, configService, shortName);
            }
            AttributeList list = new AttributeList();
            ConfigServiceHelper.setAttributeValue(list, "shortName", shortName);
            configService.setAttributes(session, nodeGroup, list);
            list.clear();
            String nodeSysplexNameKey = "sysplexName";
            String groupSysplexNameKey = "was.sysplexName";
            String nodeSysplexName = props.getProperty(nodeSysplexNameKey);
            Enumeration<Object> _enum = props.keys();
            while (_enum.hasMoreElements()) {
                String propName = (String)_enum.nextElement();
                if (propName.equals(nodeSysplexNameKey)) continue;
                String value = propName.equals(groupSysplexNameKey) && nodeSysplexName != null ? nodeSysplexName : props.getProperty(propName);
                list.add(new Attribute("name", propName));
                list.add(new Attribute("value", value));
                ObjectName result = configService.createConfigData(session, nodeGroup, "properties", null, list);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertToSysplexNodeGroup", new Object[]{nodeGroup});
            }
        }
        return nodeGroup;
    }

    public static void validateNodeGroupShortName(Session session, ConfigService configService, String shortName) throws NodeGroupConfigException, ConfigServiceException, ConnectorException, AdminException {
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName[] matches = configService.getRelationship(session, cell, "NodeGroup");
        for (int i = 0; i < matches.length; ++i) {
            String _shortName;
            String nodeGroup = (String)configService.getAttribute(session, matches[i], "name");
            if (!NodeGroupHelper.isSysplexNodeGroup(session, configService, nodeGroup) || (_shortName = (String)configService.getAttribute(session, matches[i], "shortName")) == null || _shortName.length() <= 0 || !_shortName.equalsIgnoreCase(shortName)) continue;
            String msg = NodeGroupHelper.getFormattedMessage("ADMG0489E", new Object[]{shortName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new NodeGroupConfigException(msg);
        }
    }

    public static void modifyMatchingCellLevelVar(Session session, ConfigService configService, ObjectName nodeGroup, String name, String value) throws NodeGroupConfigException, ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyMatchingCellLevelVar ", new Object[]{nodeGroup, name, value});
        }
        Object cellName = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ManagedObjectMetadataHelper metadataHelper = NodeGroupHelper.getMetadataHelper(session);
        ObjectName varMap = configService.getRelationship(session, cell, "VariableMap")[0];
        pattern = ConfigServiceHelper.createObjectName(null, "NodeGroupMember");
        ObjectName[] currentMemberObjects = configService.queryConfigObjects(session, nodeGroup, pattern, null);
        pattern = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        block0: for (int i = 0; i < currentMemberObjects.length; ++i) {
            String nodeName = (String)configService.getAttribute(session, currentMemberObjects[i], "nodeName");
            if (!metadataHelper.isNodeZOS(nodeName) || metadataHelper.compareNodeVersion(nodeName, "5") != 0 || !name.startsWith("was.")) continue;
            String propName = name.substring(4);
            ObjectName[] entries = configService.queryConfigObjects(session, varMap, pattern, null);
            for (int k = 0; k < entries.length; ++k) {
                String symName = (String)configService.getAttribute(session, entries[k], "symbolicName");
                if (symName == null || symName.length() <= 0 || !symName.equals(propName)) continue;
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("value", value));
                configService.setAttributes(session, entries[k], attrList);
                continue block0;
            }
        }
    }

    public static void modifyMatchingNode5LevelVar(Session session, ConfigService configService, ObjectName nodeGroup, String name, String value) throws NodeGroupConfigException, ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyMatchingNode5LevelVar", new Object[]{nodeGroup, name, value});
        }
        Object cellName = null;
        ObjectName node = null;
        ObjectName varMap = null;
        ObjectName pattern = null;
        ManagedObjectMetadataHelper metadataHelper = NodeGroupHelper.getMetadataHelper(session);
        pattern = ConfigServiceHelper.createObjectName(null, "NodeGroupMember");
        ObjectName[] currentMemberObjects = configService.queryConfigObjects(session, nodeGroup, pattern, null);
        pattern = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        block0: for (int i = 0; i < currentMemberObjects.length; ++i) {
            String nodeName = (String)configService.getAttribute(session, currentMemberObjects[i], "nodeName");
            if (!metadataHelper.isNodeZOS(nodeName) || metadataHelper.compareNodeVersion(nodeName, "5") != 0 || !name.equalsIgnoreCase("was.WAS_DAEMON_ONLY_protocol_iiop_listenIPAddress") && !name.equalsIgnoreCase("was.WAS_DAEMON_daemon_start_command")) continue;
            node = configService.resolve(session, "Node=" + nodeName)[0];
            varMap = configService.getRelationship(session, node, "VariableMap")[0];
            String propName = name.substring(4);
            ObjectName[] entries = configService.queryConfigObjects(session, varMap, pattern, null);
            for (int k = 0; k < entries.length; ++k) {
                String symName = (String)configService.getAttribute(session, entries[k], "symbolicName");
                if (symName == null || symName.length() <= 0 || !symName.equals(propName)) continue;
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("value", value));
                configService.setAttributes(session, entries[k], attrList);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyMatchingNode5LevelVar");
        }
    }

    private static ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigServiceException, AdminException, ConnectorException {
        WorkSpace ws = WorkspaceHelper.getWorkspace(session);
        return ws.getMetadataHelper();
    }

    public static String getCellType(Session session, ConfigService configService) throws ConfigServiceException, AdminException, ConnectorException {
        if (!NodeGroupHelper.checkAccess("monitor")) {
            throw new ConfigServiceException("Access Denied to perform getCellType operation. User does not have monitor role.");
        }
        final Session sessionFinal = session;
        final ConfigService configServiceFinal = configService;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            String obj = (String)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return NodeGroupHelper.getCellTypeInternal(sessionFinal, configServiceFinal);
                }
            });
            return obj;
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
    }

    private static String getCellTypeInternal(Session session, ConfigService configService) throws ConfigServiceException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellType()");
        }
        String type = null;
        ManagedObjectMetadataHelper metadata2 = NodeGroupHelper.getMetadataHelper(session);
        boolean zNode = false;
        boolean dNode = false;
        boolean distributedCellType = NodeGroupHelper.isDistributedCell(session, configService);
        String[] nodes = NodeGroupHelper.listNodes(session, configService, null);
        for (int i = 0; i < nodes.length; ++i) {
            if (!TemplateConfigHelper.isManagedNode(configService, session, nodes[i]) && distributedCellType) continue;
            if (metadata2.isNodeZOS(nodes[i])) {
                zNode = true;
                continue;
            }
            if (metadata2.isNodeZOS(nodes[i])) continue;
            dNode = true;
        }
        if (distributedCellType) {
            if (zNode && dNode) {
                type = "mixedcell";
            } else if (zNode && !dNode) {
                type = "zoscell";
            } else if (dNode && !zNode) {
                type = "distributedcell";
            }
        } else {
            type = zNode ? "zosbase" : "distributedbase";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellType", type);
        }
        return type;
    }

    private static boolean isDistributedCell(Session session, ConfigService configService) throws ConfigServiceException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDistributedCell()");
        }
        boolean isDistributed = false;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ManagedObjectMetadataHelper metadataHelper = NodeGroupHelper.getMetadataHelper(session);
        String cellType = (String)configService.getAttribute(session, cell, "cellType");
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "cellType", cellType);
        }
        if (cellType != null && cellType.length() > 0 && cellType.equals("DISTRIBUTED")) {
            isDistributed = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDistributedCell()", new Boolean(isDistributed));
        }
        return isDistributed;
    }

    public static boolean isManagedNode(Session session, ConfigService configService, ObjectName node) throws ConfigServiceException, NodeGroupConfigException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagedNode", node);
        }
        boolean isManagedNode = false;
        ObjectName serverIndex = configService.getRelationship(session, node, "ServerIndex")[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] entries = configService.queryConfigObjects(session, serverIndex, pattern, null);
        for (int k = 0; k < entries.length; ++k) {
            String serverType = (String)configService.getAttribute(session, entries[k], "serverType");
            if (serverType == null || serverType.length() <= 0) continue;
            if (serverType.equals("NODE_AGENT")) {
                isManagedNode = true;
                break;
            }
            if (!serverType.equals("DEPLOYMENT_MANAGER")) continue;
            isManagedNode = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isManagedNode", new Boolean(isManagedNode));
        }
        return isManagedNode;
    }

    public static List getAllManagedNodes(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getAllManagedNodes");
        }
        ArrayList<Node> list = new ArrayList<Node>();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName[] matches = configService.getRelationship(session, cell, "Node");
        for (int i = 0; i < matches.length; ++i) {
            if (!NodeGroupHelper.isManagedNode(session, configService, matches[i])) continue;
            Node wccmNode = (Node)MOFUtil.convertToEObject(session, matches[i]);
            list.add(wccmNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllManagedNodes", list);
        }
        return list;
    }

    private static boolean isXDDynamicCluster(Session session, String clusterName) throws ConfigServiceException {
        boolean dynamic;
        block8: {
            dynamic = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isDynamicCluster");
            }
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            RepositoryContextType dynamicClusterType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("dynamicclusters");
            try {
                Collection dynamicclusters;
                if (dynamicClusterType == null || (dynamicclusters = ws.findContext(dynamicClusterType)) == null) break block8;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dynamicclusters found=" + dynamicclusters.size());
                }
                Iterator itr = dynamicclusters.iterator();
                while (itr.hasNext()) {
                    String name = ((RepositoryContext)itr.next()).getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dynamiccluster found=" + name);
                    }
                    if (!name.equals(clusterName)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dynamic cluster matches cluster name");
                    }
                    dynamic = true;
                    break;
                }
            }
            catch (WorkSpaceException wse) {
                throw new ConfigServiceException(wse);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDynamicCluster");
        }
        return dynamic;
    }

    private static boolean checkAccess(String roleName) {
        boolean res = true;
        AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
        if (aa != null) {
            res = aa.isCallerInRole("Any-" + roleName);
        }
        return res;
    }
}

