/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.jmx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class JMXConnectorCommandProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(JMXConnectorCommandProvider.class, "management", "com.ibm.ws.management.resources.connectorcmd");

    public void setAdminProtocol(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAdminProtocol", cmd);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = cmd.getConfigSession();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "session", session);
        }
        ObjectName server = (ObjectName)cmd.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "server", server);
        }
        String conntype = (String)cmd.getParameter("conntype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "conntype", conntype);
        }
        if (conntype != null) {
            conntype = conntype.trim();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "conntype", conntype);
        }
        boolean validConn = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "iterating connectors");
        }
        for (int i = 0; i < AdminClient.CONNECTOR_TYPES.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking Connector: " + AdminClient.CONNECTOR_TYPES[i]);
            }
            if (!AdminClient.CONNECTOR_TYPES[i].equals(conntype)) continue;
            validConn = true;
            break;
        }
        if ("NONE".equals(conntype)) {
            validConn = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "valid connector: ", validConn);
        }
        if (!validConn) {
            throw new InvalidParameterValueException("setAdminProtocol", "conntype", conntype);
        }
        String mode = (String)cmd.getParameter("mode");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mode", mode);
        }
        if (mode == null || !"local".equalsIgnoreCase(mode) && !"remote".equalsIgnoreCase(mode)) {
            throw new InvalidParameterValueException("setAdminProtocol", "mode", mode);
        }
        if (server != null) {
            this.setAdminProtocolForServer(session, configService, conntype, mode, server);
        } else {
            ObjectName servPattern = ConfigServiceHelper.createObjectName(null, "Server");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "servPattern", servPattern);
            }
            ObjectName[] servers = configService.queryConfigObjects(session, null, servPattern, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "servers", servers);
            }
            for (int i = 0; i < servers.length; ++i) {
                this.setAdminProtocolForServer(session, configService, conntype, mode, servers[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAdminProtocol");
        }
    }

    private void setAdminProtocolForServer(Session session, ConfigService configService, String conntype, String mode, ObjectName server) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAdminProtocolForServer", new Object[]{session, configService, conntype, mode, server});
        }
        ObjectName adminServicePattern = ConfigServiceHelper.createObjectName(null, "AdminService");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adminServicePattern", adminServicePattern);
        }
        ObjectName[] adminServices = configService.queryConfigObjects(session, server, adminServicePattern, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adminServices", adminServices);
        }
        ObjectName adminService = adminServices[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adminService", adminService);
        }
        String connectorType = null;
        if (conntype.equals("SOAP")) {
            connectorType = "SOAPConnector";
        } else if (conntype.equals("RMI")) {
            connectorType = "RMIConnector";
        } else if (conntype.equals("JSR160RMI")) {
            connectorType = "JSR160RMIConnector";
        } else if (conntype.equals("IPC")) {
            connectorType = "IPCConnector";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "connectorType", connectorType);
        }
        ObjectName newConn = null;
        if (connectorType != null) {
            ObjectName jmxPattern = ConfigServiceHelper.createObjectName(null, connectorType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jmxPattern", jmxPattern);
            }
            ObjectName[] jmxConns = configService.queryConfigObjects(session, server, jmxPattern, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jmxConns", jmxConns);
            }
            newConn = jmxConns[0];
        } else {
            newConn = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "newConn", newConn);
        }
        ObjectName oldConn = null;
        ObjectName otherConn = null;
        ObjectName localConn = null;
        ObjectName remoteConn = null;
        AttributeList attrList = null;
        attrList = configService.getAttributes(session, adminService, new String[]{"localAdminProtocol"}, false);
        localConn = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "localAdminProtocol");
        attrList.clear();
        attrList = configService.getAttributes(session, adminService, new String[]{"remoteAdminProtocol"}, false);
        remoteConn = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "remoteAdminProtocol");
        if ("local".equalsIgnoreCase(mode)) {
            oldConn = localConn;
            otherConn = remoteConn;
        } else {
            oldConn = remoteConn;
            otherConn = localConn;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attrList", attrList);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "localConn", localConn);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "remoteConn", remoteConn);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "oldConn", oldConn);
        }
        if (oldConn == newConn || oldConn != null && oldConn.equals(newConn)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setAdminProtocol", "done = equal");
            }
            return;
        }
        AttributeList nAttrList = new AttributeList();
        if (newConn != null) {
            nAttrList.clear();
            nAttrList.add(new Attribute("enable", true));
            configService.setAttributes(session, newConn, nAttrList);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "newConn", newConn);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mode", mode);
        }
        if (newConn == null) {
            if ("local".equalsIgnoreCase(mode)) {
                configService.unsetAttributes(session, adminService, new String[]{"localAdminProtocol"});
            } else {
                configService.unsetAttributes(session, adminService, new String[]{"remoteAdminProtocol"});
            }
        } else {
            nAttrList.clear();
            if ("local".equalsIgnoreCase(mode)) {
                nAttrList.add(new Attribute("localAdminProtocol", newConn));
            } else {
                nAttrList.add(new Attribute("remoteAdminProtocol", newConn));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nAttrList", nAttrList);
            }
            configService.setAttributes(session, adminService, nAttrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAdminProtocolForServer");
        }
    }

    public void setAdminProtocolEnabled(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAdminProtocolEnabled", cmd);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = cmd.getConfigSession();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "session", session);
        }
        ObjectName server = (ObjectName)cmd.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "server", server);
        }
        String conntype = (String)cmd.getParameter("conntype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "conntype", conntype);
        }
        if (conntype != null) {
            conntype = conntype.trim();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "conntype", conntype);
        }
        boolean validConn = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Iterating connectors", AdminClient.CONNECTOR_TYPES);
        }
        for (int i = 0; i < AdminClient.CONNECTOR_TYPES.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking connector", AdminClient.CONNECTOR_TYPES[i]);
            }
            if (!AdminClient.CONNECTOR_TYPES[i].equals(conntype)) continue;
            validConn = true;
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "valid connector: ", validConn);
        }
        if (!validConn) {
            throw new InvalidParameterValueException("setAdminProtocolEnabled", "conntype", conntype);
        }
        String enable = (String)cmd.getParameter("enable");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enable", enable);
        }
        if (enable == null || !"true".equalsIgnoreCase(enable) && !"false".equalsIgnoreCase(enable)) {
            throw new InvalidParameterValueException("setAdminProtocolEnabled", "enable", enable);
        }
        if (server != null) {
            this.setAdminProtocolEnabledForServer(session, configService, conntype, enable, server);
        } else {
            ObjectName servPattern = ConfigServiceHelper.createObjectName(null, "Server");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "servPattern", servPattern);
            }
            ObjectName[] servers = configService.queryConfigObjects(session, null, servPattern, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "servers", servers);
            }
            for (int i = 0; i < servers.length; ++i) {
                this.setAdminProtocolEnabledForServer(session, configService, conntype, enable, servers[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAdminProtocol");
        }
    }

    private void setAdminProtocolEnabledForServer(Session session, ConfigService configService, String conntype, String enable, ObjectName server) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAdminProtocolEnabledForServer", server);
        }
        String connectorType = null;
        if (conntype.equals("SOAP")) {
            connectorType = "SOAPConnector";
        } else if (conntype.equals("RMI")) {
            connectorType = "RMIConnector";
        } else if (conntype.equals("JSR160RMI")) {
            connectorType = "JSR160RMIConnector";
        } else if (conntype.equals("IPC")) {
            connectorType = "IPCConnector";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "connectorType", connectorType);
        }
        ObjectName newConn = null;
        ObjectName jmxPattern = ConfigServiceHelper.createObjectName(null, connectorType);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jmxPattern", jmxPattern);
        }
        ObjectName[] jmxConns = configService.queryConfigObjects(session, server, jmxPattern, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jmxConns", jmxConns);
        }
        newConn = jmxConns[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "newConn", newConn);
        }
        AttributeList nAttrList = new AttributeList();
        if (newConn != null) {
            nAttrList.clear();
            nAttrList.add(new Attribute("enable", (boolean)new Boolean(enable)));
            configService.setAttributes(session, newConn, nAttrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAdminProtocolEnabledForServer");
        }
    }
}

