/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.helper;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.AdminCommandHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class AdminHelperCommandProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(AdminHelperCommandProvider.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final String[] processDefPropList = new String[]{"executableName", "workingDirectory", "executableTarget", "executableArguments", "executableTargetKind"};
    private static final String[] processDefPropListZOS = new String[]{"processType", "startCommand", "stopCommand", "terminateCommand", "startCommandArgs", "stopCommandArgs", "terminateCommandArgs"};
    private static final String[] jvmPropertiesList = new String[]{"classpath", "bootClasspath", "verboseModeClass", "verboseModeGarbageCollection", "verboseModeJNI", "initialHeapSize", "maximumHeapSize", "runHProf", "hprofArguments", "debugMode", "debugArgs", "genericJvmArguments", "executableJarFileName", "disableJIT", "osName", "internalClassAccessMode"};
    private static final String[] serverInstancePropList = new String[]{"enableMultipleServerInstances", "minimumNumOfInstances", "maximumNumberOfInstances"};
    private static String JVM_Mode_64 = "64bit";
    private static String JVM_Mode_31 = "31bit";
    private static String JAVA_HOME = "${WAS_HOME}/java64";
    private static String ORB_LOCALHOST = "com.ibm.CORBA.LocalHost";
    private static String ORB_MULTIHOME = "com.ibm.ws.orb.transport.useMultiHome";
    private static String JVM_MULTIHOME = "com.ibm.websphere.network.useMultiHome";

    public Boolean isFederated(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFederated", new Object[]{cmd});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + pattern + "\n");
        }
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + cell + "\n");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell Name is " + ConfigServiceHelper.getDisplayName(cell));
        }
        String cellType = (String)configService.getAttribute(session, cell, "cellType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell type is " + cellType);
        }
        Boolean result = new Boolean(cellType.equals("DISTRIBUTED"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFederated", result);
        }
        return result;
    }

    public List getDmgrProperties(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDmgrName", new Object[]{cmd});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        AttributeList dmgrAttriubtes = new AttributeList();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] serverEntries = configService.queryConfigObjects(session, null, pattern, null);
        for (int i = 0; i < serverEntries.length; ++i) {
            ObjectName serverEntry = serverEntries[i];
            String serverType = (String)configService.getAttribute(session, serverEntry, "serverType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server type is " + serverType);
            }
            if (!serverType.equals("DEPLOYMENT_MANAGER")) continue;
            String dmgrName = (String)configService.getAttribute(session, serverEntry, "serverName");
            ArrayList endpoints = (ArrayList)configService.getAttribute(session, serverEntry, "specialEndpoints", false);
            for (int j = 0; j < endpoints.size(); ++j) {
                ObjectName specEndpoint = (ObjectName)endpoints.get(j);
                if (!((String)configService.getAttribute(session, specEndpoint, "endPointName")).equals("SOAP_CONNECTOR_ADDRESS")) continue;
                ObjectName endpoint = (ObjectName)configService.getAttribute(session, specEndpoint, "endPoint", false);
                String hostname = (String)configService.getAttribute(session, endpoint, "host");
                Integer port = (Integer)configService.getAttribute(session, endpoint, "port");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dmgr host is " + hostname + " port is " + port);
                }
                ConfigServiceHelper.setAttributeValue(dmgrAttriubtes, "host", hostname);
                ConfigServiceHelper.setAttributeValue(dmgrAttriubtes, "port", port);
                ConfigServiceHelper.setAttributeValue(dmgrAttriubtes, "name", dmgrName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDmgrName", dmgrAttriubtes);
        }
        return dmgrAttriubtes;
    }

    public boolean setVariable(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVariable", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        String scope = (String)cmd.getParameter("scope");
        if (scope == null || scope.equals("")) {
            scope = "Cell";
        }
        try {
            ObjectName[] scopeObjects = AdminCommandHelper.getResources((Session)session, (ConfigService)configService, (String)scope);
            if (scopeObjects.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "scope", scope);
            }
            ObjectName scopeObject = scopeObjects[0];
            ObjectName variableMap = configService.getRelationship(session, scopeObject, "VariableMap")[0];
            AttributeList attrList = new AttributeList();
            String variableName = (String)cmd.getParameter("variableName");
            ConfigServiceHelper.setAttributeValue(attrList, "value", cmd.getParameter("variableValue"));
            ConfigServiceHelper.setAttributeValue(attrList, "description", cmd.getParameter("variableDescription"));
            boolean exist = false;
            ArrayList variables = (ArrayList)configService.getAttribute(session, variableMap, "entries", false);
            for (int i = 0; i < variables.size(); ++i) {
                ObjectName variable = (ObjectName)variables.get(i);
                String existingVariableName = (String)configService.getAttribute(session, variable, "symbolicName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing variable name is " + existingVariableName);
                }
                if (!existingVariableName.equals(variableName)) continue;
                configService.setAttributes(session, variable, attrList);
                exist = true;
            }
            if (!exist) {
                ConfigServiceHelper.setAttributeValue(attrList, "symbolicName", variableName);
                configService.createConfigData(session, variableMap, "entries", "VariableSubstitutionEntry", attrList);
            }
            bl = true;
            Object var17_17 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.setVariable", (String)"187");
                throw cse;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var17_18 = null;
                    if (!tc.isEntryEnabled()) break block11;
                    Tr.exit(tc, "setVariable");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVariable");
        }
        return bl;
    }

    public boolean removeVariable(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeVariable", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        String scope = (String)cmd.getParameter("scope");
        String variableName = (String)cmd.getParameter("variableName");
        if (scope == null || scope.equals("")) {
            scope = "Cell";
        }
        try {
            ObjectName[] scopeObjects = AdminCommandHelper.getResources((Session)session, (ConfigService)configService, (String)scope);
            if (scopeObjects.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "scope", scope);
            }
            ObjectName scopeObject = scopeObjects[0];
            ObjectName variableMap = configService.getRelationship(session, scopeObject, "VariableMap")[0];
            ArrayList variables = (ArrayList)configService.getAttribute(session, variableMap, "entries", false);
            for (int i = 0; i < variables.size(); ++i) {
                ObjectName variable = (ObjectName)variables.get(i);
                String existingVariableName = (String)configService.getAttribute(session, variable, "symbolicName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing variable name is " + existingVariableName);
                }
                if (!existingVariableName.equals(variableName)) continue;
                configService.deleteConfigData(session, variable);
            }
            bl = true;
            Object var15_15 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.removeVariable", (String)"187");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var15_16 = null;
                    if (!tc.isEntryEnabled()) break block11;
                    Tr.exit(tc, "removeVariable");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeVariable");
        }
        return bl;
    }

    public Object showVariables(AbstractAdminCommand cmd) throws Exception {
        AttributeList attributeList;
        ObjectName variableMap;
        Object results;
        String variableName;
        Session session;
        ConfigService configService;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "showVariables", cmd);
            }
            CommandProviderHelper helper = this.getCommandProviderHelper();
            configService = helper.getConfigService();
            session = cmd.getConfigSession();
            String scope = (String)cmd.getParameter("scope");
            variableName = (String)cmd.getParameter("variableName");
            if (scope == null || scope.equals("")) {
                scope = "Cell";
            }
            results = null;
            if (variableName == null || variableName.equals("")) {
                results = new AttributeList();
            }
            ObjectName[] scopeObjects = AdminCommandHelper.getResources((Session)session, (ConfigService)configService, (String)scope);
            if (scopeObjects.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "scope", scope);
            }
            ObjectName scopeObject = scopeObjects[0];
            ObjectName[] variableMaps = configService.getRelationship(session, scopeObject, "VariableMap");
            variableMap = null;
            if (variableMaps.length > 0) {
                variableMap = variableMaps[0];
                break block17;
            }
            results = new AttributeList();
            AttributeList attributeList2 = results;
            Object var18_15 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "showVariables");
            }
            return attributeList2;
        }
        try {
            ArrayList variables = (ArrayList)configService.getAttribute(session, variableMap, "entries", false);
            for (int i = 0; i < variables.size(); ++i) {
                String existingVariableValue;
                ObjectName variable = (ObjectName)variables.get(i);
                String existingVariableName = (String)configService.getAttribute(session, variable, "symbolicName");
                if (variableName == null || variableName.equals("")) {
                    existingVariableValue = (String)configService.getAttribute(session, variable, "value");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Existing variable name is " + existingVariableName + ".  Value is " + existingVariableValue);
                    }
                    ConfigServiceHelper.setAttributeValue((AttributeList)results, existingVariableName, existingVariableValue);
                    continue;
                }
                if (!existingVariableName.equals(variableName)) continue;
                existingVariableValue = (String)configService.getAttribute(session, variable, "value");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing variable name is " + existingVariableName + ".  Value is " + existingVariableValue);
                }
                results = existingVariableValue;
                break;
            }
            attributeList = results;
            Object var18_16 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.showVariables", (String)"257");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block18: {
                    Object var18_17 = null;
                    if (!tc.isEntryEnabled()) break block18;
                    Tr.exit(tc, "showVariables");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showVariables");
        }
        return attributeList;
    }

    public boolean setProcessDefinition(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProcessDefinition", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        AttributeList attrList = new AttributeList();
        try {
            int i;
            String workingDir;
            ArrayList setParameters = (ArrayList)cmd.listSetParams();
            String serverName = (String)cmd.getParameter("serverName");
            String nodeName = (String)cmd.getParameter("nodeName");
            String processType = (String)cmd.getParameter("processType");
            ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
            if (servers.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "scopeName", serverName);
            }
            ObjectName server = servers[0];
            ObjectName processDef = this.getProcessDefWithProcessType(session, configService, server, processType);
            if (setParameters.contains("executableName")) {
                String executableName = (String)cmd.getParameter("executableName");
                ConfigServiceHelper.setAttributeValue(attrList, "executableName", executableName);
            }
            if (setParameters.contains("workingDirectory") && (workingDir = (String)cmd.getParameter("workingDirectory")) != null && !workingDir.equals("")) {
                ConfigServiceHelper.setAttributeValue(attrList, "workingDirectory", workingDir);
            }
            if (setParameters.contains("executableTarget")) {
                String executableTarget = (String)cmd.getParameter("executableTarget");
                ConfigServiceHelper.setAttributeValue(attrList, "executableTarget", executableTarget);
            }
            if (setParameters.contains("executableArguments")) {
                String[] executableArg = (String[])cmd.getParameter("executableArguments");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "executableArg got is ", executableArg);
                }
                for (i = 0; i < executableArg.length; ++i) {
                    configService.addElement(session, processDef, "executableArguments", executableArg[i], -1);
                }
            }
            if (setParameters.contains("startCommand")) {
                String startCommand = (String)cmd.getParameter("startCommand");
                ConfigServiceHelper.setAttributeValue(attrList, "startCommand", startCommand);
            }
            if (setParameters.contains("startCommandArgs")) {
                String[] startCommandArgs = (String[])cmd.getParameter("startCommandArgs");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "startCommandArgs got is ", startCommandArgs);
                }
                for (i = 0; i < startCommandArgs.length; ++i) {
                    configService.addElement(session, processDef, "startCommandArgs", startCommandArgs[i], -1);
                }
            }
            if (setParameters.contains("stopCommand")) {
                String stopCommand = (String)cmd.getParameter("stopCommand");
                ConfigServiceHelper.setAttributeValue(attrList, "stopCommand", stopCommand);
            }
            if (setParameters.contains("stopCommandArgs")) {
                String[] stopCommandArgs = (String[])cmd.getParameter("stopCommandArgs");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopCommandArgs got is ", stopCommandArgs);
                }
                for (i = 0; i < stopCommandArgs.length; ++i) {
                    configService.addElement(session, processDef, "stopCommandArgs", stopCommandArgs[i], -1);
                }
            }
            if (setParameters.contains("terminateCommand")) {
                String terminateCommand = (String)cmd.getParameter("terminateCommand");
                ConfigServiceHelper.setAttributeValue(attrList, "terminateCommand", terminateCommand);
            }
            if (setParameters.contains("terminateCommandArgs")) {
                String[] terminateCommandArgs = (String[])cmd.getParameter("terminateCommandArgs");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "terminateCommandArgs got is ", terminateCommandArgs);
                }
                for (i = 0; i < terminateCommandArgs.length; ++i) {
                    configService.addElement(session, processDef, "terminateCommandArgs", terminateCommandArgs[i], -1);
                }
            }
            if (setParameters.contains("stopImmediateCommand")) {
                String stopImmediateCommand = (String)cmd.getParameter("stopImmediateCommand");
                ConfigServiceHelper.setAttributeValue(attrList, "stopImmediateCommand", stopImmediateCommand);
            }
            if (setParameters.contains("processType")) {
                if (processType.equalsIgnoreCase("Control") || processType.equalsIgnoreCase("Servant") || processType.equalsIgnoreCase("Adjunct")) {
                    ConfigServiceHelper.setAttributeValue(attrList, "processType", processType);
                } else {
                    throw new InvalidParameterValueException(cmd.getName(), "processType", processType);
                }
            }
            if (setParameters.contains("executableTargetKind")) {
                String executableTargetKind = (String)cmd.getParameter("executableTargetKind");
                if (!executableTargetKind.equalsIgnoreCase("JAVA_CLASS") && !executableTargetKind.equalsIgnoreCase("EXECUTABLE_JAR")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "executableTargetType is incorrect" + executableTargetKind);
                    }
                    throw new InvalidParameterValueException(cmd.getName(), "executableTargetKind", executableTargetKind);
                }
                ConfigServiceHelper.setAttributeValue(attrList, "executableTargetKind", executableTargetKind);
            }
            configService.setAttributes(session, processDef, attrList);
            bl = true;
            Object var16_17 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.setProcessDefinition", (String)"297");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block33: {
                    Object var16_18 = null;
                    if (!tc.isEntryEnabled()) break block33;
                    Tr.exit(tc, "setProcessDefinition");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProcessDefinition");
        }
        return bl;
    }

    public Object showProcessDefinition(AbstractAdminCommand cmd) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProcessDefinition", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        String serverName = (String)cmd.getParameter("serverName");
        String nodeName = (String)cmd.getParameter("nodeName");
        String propertyName = (String)cmd.getParameter("propertyName");
        String processType = (String)cmd.getParameter("processType");
        try {
            Object results;
            ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
            if (servers.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            ObjectName server = servers[0];
            ObjectName processDef = this.getProcessDefWithProcessType(session, configService, server, processType);
            if (propertyName != null && !propertyName.equals("")) {
                results = configService.getAttribute(session, processDef, propertyName, false);
            } else {
                Object attribute;
                int i;
                results = new AttributeList();
                for (i = 0; i < processDefPropList.length; ++i) {
                    propertyName = processDefPropList[i];
                    attribute = configService.getAttribute(session, processDef, propertyName, false);
                    ConfigServiceHelper.setAttributeValue((AttributeList)results, propertyName, attribute);
                }
                for (i = 0; i < processDefPropListZOS.length; ++i) {
                    propertyName = processDefPropListZOS[i];
                    attribute = configService.getAttribute(session, processDef, propertyName, false);
                    ConfigServiceHelper.setAttributeValue((AttributeList)results, propertyName, attribute);
                }
            }
            object = results;
            Object var16_17 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.showProcessDefinition", (String)"339");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var16_18 = null;
                    if (!tc.isEntryEnabled()) break block12;
                    Tr.exit(tc, "showProcessDefinition");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showProcessDefinition");
        }
        return object;
    }

    public boolean setJVMProperties(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMProperties", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        AttributeList attrList = new AttributeList();
        try {
            int i;
            ArrayList setParameters = (ArrayList)cmd.listSetParams();
            String serverName = (String)cmd.getParameter("serverName");
            String nodeName = (String)cmd.getParameter("nodeName");
            String processType = (String)cmd.getParameter("processType");
            ObjectName targetObj = (ObjectName)cmd.getTargetObject();
            if (targetObj != null) {
                if (nodeName != null) {
                    throw new InvalidParameterValueException(cmd.getName(), "Cannot specify nodeName and serverName  when target object is specified.", nodeName);
                }
                if (serverName != null) {
                    throw new InvalidParameterValueException(cmd.getName(), "Cannot specify nodeName and serverName  when target object is specified.", serverName);
                }
            } else {
                if (nodeName == null) {
                    throw new InvalidParameterValueException(cmd.getName(), "Need to specify nodeName and serverName  when target object is not specified.", nodeName);
                }
                if (serverName == null) {
                    throw new InvalidParameterValueException(cmd.getName(), "Need to specify nodeName and serverName  when target object is not specified.", serverName);
                }
            }
            ObjectName server = null;
            if (targetObj == null) {
                ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
                if (servers.length != 1) {
                    throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
                }
                server = servers[0];
            } else {
                server = targetObj;
            }
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            if (setParameters.contains("internalClassAccessMode")) {
                String internalClassAccessMode = (String)cmd.getParameter("internalClassAccessMode");
                if (internalClassAccessMode.equals("ALLOW") || internalClassAccessMode.equals("RESTRICT")) {
                    AttributeList internalClassAccessModeAttrList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(internalClassAccessModeAttrList, "internalClassAccessMode", internalClassAccessMode);
                    ObjectName[] jvms = configService.queryConfigObjects(session, server, pattern, null);
                    for (int jvmIndex = 0; jvmIndex < jvms.length; ++jvmIndex) {
                        ObjectName jvm = jvms[jvmIndex];
                        configService.setAttributes(session, jvm, internalClassAccessModeAttrList);
                    }
                } else {
                    throw new InvalidParameterValueException(cmd.getName(), "internalClassAccessMode", internalClassAccessMode);
                }
            }
            ObjectName processDef = this.getProcessDefWithProcessType(session, configService, server, processType);
            ObjectName jvm = configService.queryConfigObjects(session, processDef, pattern, null)[0];
            if (setParameters.contains("classpath")) {
                String[] classpath = (String[])cmd.getParameter("classpath");
                for (i = 0; i < classpath.length; ++i) {
                    configService.addElement(session, jvm, "classpath", classpath[i], -1);
                }
            }
            if (setParameters.contains("bootClasspath")) {
                String[] bootClasspath = (String[])cmd.getParameter("bootClasspath");
                for (i = 0; i < bootClasspath.length; ++i) {
                    configService.addElement(session, jvm, "bootClasspath", bootClasspath[i], -1);
                }
            }
            if (setParameters.contains("verboseModeClass")) {
                Boolean verboseModeClass = (Boolean)cmd.getParameter("verboseModeClass");
                ConfigServiceHelper.setAttributeValue(attrList, "verboseModeClass", verboseModeClass);
            }
            if (setParameters.contains("verboseModeGarbageCollection")) {
                Boolean verboseGB = (Boolean)cmd.getParameter("verboseModeGarbageCollection");
                ConfigServiceHelper.setAttributeValue(attrList, "verboseModeGarbageCollection", verboseGB);
            }
            if (setParameters.contains("verboseModeJNI")) {
                Boolean verboseJNI = (Boolean)cmd.getParameter("verboseModeJNI");
                ConfigServiceHelper.setAttributeValue(attrList, "verboseModeJNI", verboseJNI);
            }
            if (setParameters.contains("initialHeapSize")) {
                Integer initialHeapSize = (Integer)cmd.getParameter("initialHeapSize");
                ConfigServiceHelper.setAttributeValue(attrList, "initialHeapSize", initialHeapSize);
            }
            if (setParameters.contains("maximumHeapSize")) {
                Integer maxHeapSize = (Integer)cmd.getParameter("maximumHeapSize");
                ConfigServiceHelper.setAttributeValue(attrList, "maximumHeapSize", maxHeapSize);
            }
            if (setParameters.contains("runHProf")) {
                Boolean runHProf = (Boolean)cmd.getParameter("runHProf");
                ConfigServiceHelper.setAttributeValue(attrList, "runHProf", runHProf);
            }
            if (setParameters.contains("hprofArguments")) {
                String hprofArgu = (String)cmd.getParameter("hprofArguments");
                ConfigServiceHelper.setAttributeValue(attrList, "hprofArguments", hprofArgu);
            }
            if (setParameters.contains("debugMode")) {
                Boolean debugMode = (Boolean)cmd.getParameter("debugMode");
                ConfigServiceHelper.setAttributeValue(attrList, "debugMode", debugMode);
            }
            if (setParameters.contains("debugArgs")) {
                String debugArgu = (String)cmd.getParameter("debugArgs");
                ConfigServiceHelper.setAttributeValue(attrList, "debugArgs", debugArgu);
            }
            if (setParameters.contains("genericJvmArguments")) {
                String genericJVMArgu = (String)cmd.getParameter("genericJvmArguments");
                ConfigServiceHelper.setAttributeValue(attrList, "genericJvmArguments", genericJVMArgu);
            }
            if (setParameters.contains("executableJarFileName")) {
                String executableJAR = (String)cmd.getParameter("executableJarFileName");
                ConfigServiceHelper.setAttributeValue(attrList, "executableJarFileName", executableJAR);
            }
            if (setParameters.contains("disableJIT")) {
                Boolean disableJIT = (Boolean)cmd.getParameter("disableJIT");
                ConfigServiceHelper.setAttributeValue(attrList, "disableJIT", disableJIT);
            }
            if (setParameters.contains("osName")) {
                String osName = (String)cmd.getParameter("osName");
                ConfigServiceHelper.setAttributeValue(attrList, "osName", osName);
            }
            configService.setAttributes(session, jvm, attrList);
            bl = true;
            Object var19_20 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.setJVMProperties", (String)"498");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block37: {
                    Object var19_21 = null;
                    if (!tc.isEntryEnabled()) break block37;
                    Tr.exit(tc, "setJVMProperties");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJVMProperties");
        }
        return bl;
    }

    public boolean setJVMInitialHeapSize(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMInitialHeapSize", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        AttributeList attrList = new AttributeList();
        try {
            ArrayList setParameters = (ArrayList)cmd.listSetParams();
            String serverName = (String)cmd.getParameter("serverName");
            String nodeName = (String)cmd.getParameter("nodeName");
            String processType = (String)cmd.getParameter("processType");
            ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
            if (servers.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            ObjectName server = servers[0];
            ObjectName processDef = this.getProcessDefWithProcessType(session, configService, server, processType);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName jvm = configService.queryConfigObjects(session, processDef, pattern, null)[0];
            if (setParameters.contains("initialHeapSize")) {
                Integer initialHeapSize = (Integer)cmd.getParameter("initialHeapSize");
                ConfigServiceHelper.setAttributeValue(attrList, "initialHeapSize", initialHeapSize);
            }
            configService.setAttributes(session, jvm, attrList);
            bl = true;
            Object var17_18 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.setJVMInitialHeapSize", (String)"535");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var17_19 = null;
                    if (!tc.isEntryEnabled()) break block9;
                    Tr.exit(tc, "setJVMInitialHeapSize");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJVMInitialHeapSize");
        }
        return bl;
    }

    public boolean setJVMDebugMode(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMDebugMode", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        AttributeList attrList = new AttributeList();
        try {
            ArrayList setParameters = (ArrayList)cmd.listSetParams();
            String serverName = (String)cmd.getParameter("serverName");
            String nodeName = (String)cmd.getParameter("nodeName");
            String processType = (String)cmd.getParameter("processType");
            ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
            if (servers.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            ObjectName server = servers[0];
            ObjectName processDef = this.getProcessDefWithProcessType(session, configService, server, processType);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName jvm = configService.queryConfigObjects(session, processDef, pattern, null)[0];
            if (setParameters.contains("debugMode")) {
                Boolean debugMode = (Boolean)cmd.getParameter("debugMode");
                ConfigServiceHelper.setAttributeValue(attrList, "debugMode", debugMode);
            }
            configService.setAttributes(session, jvm, attrList);
            bl = true;
            Object var17_18 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.setJVMDebugMode", (String)"572");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var17_19 = null;
                    if (!tc.isEntryEnabled()) break block9;
                    Tr.exit(tc, "setJVMDebugMode");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJVMDebugMode");
        }
        return bl;
    }

    public boolean setGenericJVMArguments(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setGenericJVMArguments", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        AttributeList attrList = new AttributeList();
        try {
            ArrayList setParameters = (ArrayList)cmd.listSetParams();
            String serverName = (String)cmd.getParameter("serverName");
            String nodeName = (String)cmd.getParameter("nodeName");
            String processType = (String)cmd.getParameter("processType");
            ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
            if (servers.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            ObjectName server = servers[0];
            ObjectName processDef = this.getProcessDefWithProcessType(session, configService, server, processType);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName jvm = configService.queryConfigObjects(session, processDef, pattern, null)[0];
            if (setParameters.contains("genericJvmArguments")) {
                String genericJVMArgu = (String)cmd.getParameter("genericJvmArguments");
                ConfigServiceHelper.setAttributeValue(attrList, "genericJvmArguments", genericJVMArgu);
            }
            configService.setAttributes(session, jvm, attrList);
            bl = true;
            Object var17_18 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.setGenericJVMArguments", (String)"612");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var17_19 = null;
                    if (!tc.isEntryEnabled()) break block9;
                    Tr.exit(tc, "setGenericJVMArguments");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setGenericJVMArguments");
        }
        return bl;
    }

    public boolean setJVMMaxHeapSize(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMMaxHeapSize", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        AttributeList attrList = new AttributeList();
        try {
            ArrayList setParameters = (ArrayList)cmd.listSetParams();
            String serverName = (String)cmd.getParameter("serverName");
            String nodeName = (String)cmd.getParameter("nodeName");
            String processType = (String)cmd.getParameter("processType");
            ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
            if (servers.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            ObjectName server = servers[0];
            ObjectName processDef = this.getProcessDefWithProcessType(session, configService, server, processType);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName jvm = configService.queryConfigObjects(session, processDef, pattern, null)[0];
            if (setParameters.contains("maximumHeapSize")) {
                Integer maximumHeapSize = (Integer)cmd.getParameter("maximumHeapSize");
                ConfigServiceHelper.setAttributeValue(attrList, "maximumHeapSize", maximumHeapSize);
            }
            configService.setAttributes(session, jvm, attrList);
            bl = true;
            Object var17_18 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.setJVMMaxHeapSize", (String)"609");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var17_19 = null;
                    if (!tc.isEntryEnabled()) break block9;
                    Tr.exit(tc, "setJVMMaxHeapSize");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJVMMaxHeapSize");
        }
        return bl;
    }

    public Object showJVMProperties(AbstractAdminCommand cmd) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showJVMProperties", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        String serverName = (String)cmd.getParameter("serverName");
        String nodeName = (String)cmd.getParameter("nodeName");
        String processType = (String)cmd.getParameter("processType");
        String propertyName = (String)cmd.getParameter("propertyName");
        ObjectName targetObj = (ObjectName)cmd.getTargetObject();
        if (targetObj != null) {
            if (nodeName != null) {
                throw new InvalidParameterValueException(cmd.getName(), "Cannot specify nodeName and serverName  when target object is specified.", nodeName);
            }
            if (serverName != null) {
                throw new InvalidParameterValueException(cmd.getName(), "Cannot specify nodeName and serverName  when target object is specified.", serverName);
            }
        } else {
            if (nodeName == null) {
                throw new InvalidParameterValueException(cmd.getName(), "Need to specify nodeName and serverName  when target object is not specified.", nodeName);
            }
            if (serverName == null) {
                throw new InvalidParameterValueException(cmd.getName(), "Need to specify nodeName and serverName  when target object is not specified.", serverName);
            }
        }
        try {
            Object results;
            ObjectName server = null;
            if (targetObj == null) {
                ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
                if (servers.length != 1) {
                    throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
                }
                server = servers[0];
            } else {
                server = targetObj;
            }
            ObjectName processDef = this.getProcessDefWithProcessType(session, configService, server, processType);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName jvm = configService.queryConfigObjects(session, processDef, pattern, null)[0];
            if (propertyName != null && !propertyName.equals("")) {
                results = configService.getAttribute(session, jvm, propertyName, false);
            } else {
                results = new AttributeList();
                for (int i = 0; i < jvmPropertiesList.length; ++i) {
                    propertyName = jvmPropertiesList[i];
                    Object attribute = configService.getAttribute(session, jvm, propertyName, false);
                    ConfigServiceHelper.setAttributeValue((AttributeList)results, propertyName, attribute);
                }
            }
            object = results;
            Object var18_19 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.showJVMProperties", (String)"475");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block19: {
                    Object var18_20 = null;
                    if (!tc.isEntryEnabled()) break block19;
                    Tr.exit(tc, "showJVMProperties");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showJVMProperties");
        }
        return object;
    }

    public boolean setJVMSystemProperties(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMSystemProperties", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        AttributeList attrList = new AttributeList();
        try {
            ArrayList setParameters = (ArrayList)cmd.listSetParams();
            String serverName = (String)cmd.getParameter("serverName");
            String nodeName = (String)cmd.getParameter("nodeName");
            String processType = (String)cmd.getParameter("processType");
            ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
            if (servers.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            ObjectName server = servers[0];
            ObjectName processDef = this.getProcessDefWithProcessType(session, configService, server, processType);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName jvm = configService.queryConfigObjects(session, processDef, pattern, null)[0];
            if (setParameters.contains("propertyName")) {
                String propertyName = (String)cmd.getParameter("propertyName");
                ConfigServiceHelper.setAttributeValue(attrList, "name", propertyName);
            }
            if (setParameters.contains("propertyValue")) {
                String propertyValue = (String)cmd.getParameter("propertyValue");
                ConfigServiceHelper.setAttributeValue(attrList, "value", propertyValue);
            }
            configService.addElement(session, jvm, "systemProperties", attrList, -1);
            bl = true;
            Object var17_18 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.setJVMSystemProperties", (String)"517");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var17_19 = null;
                    if (!tc.isEntryEnabled()) break block10;
                    Tr.exit(tc, "setJVMSystemProperties");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJVMSystemProperties");
        }
        return bl;
    }

    public Object showJVMSystemProperties(AbstractAdminCommand cmd) throws Exception {
        AttributeList attributeList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showJVMProperties", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        String serverName = (String)cmd.getParameter("serverName");
        String nodeName = (String)cmd.getParameter("nodeName");
        String processType = (String)cmd.getParameter("processType");
        String propertyName = (String)cmd.getParameter("propertyName");
        Object results = null;
        if (propertyName == null || propertyName.equals("")) {
            results = new AttributeList();
        }
        try {
            ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
            if (servers.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            ObjectName server = servers[0];
            ObjectName processDef = this.getProcessDefWithProcessType(session, configService, server, processType);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName jvm = configService.queryConfigObjects(session, processDef, pattern, null)[0];
            ArrayList spList = (ArrayList)configService.getAttribute(session, jvm, "systemProperties");
            for (int i = 0; i < spList.size(); ++i) {
                String spValue;
                AttributeList attributes = (AttributeList)spList.get(i);
                String spName = (String)ConfigServiceHelper.getAttributeValue(attributes, "name");
                if (propertyName == null || propertyName.equals("")) {
                    spValue = (String)ConfigServiceHelper.getAttributeValue(attributes, "value");
                    ConfigServiceHelper.setAttributeValue((AttributeList)results, spName, spValue);
                    continue;
                }
                if (!spName.equalsIgnoreCase(propertyName)) continue;
                spValue = (String)ConfigServiceHelper.getAttributeValue(attributes, "value");
                results = spValue;
                break;
            }
            attributeList = results;
            Object var21_22 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.showJVMProperties", (String)"475");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var21_23 = null;
                    if (!tc.isEntryEnabled()) break block11;
                    Tr.exit(tc, "showJVMProperties");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showJVMProperties");
        }
        return attributeList;
    }

    public boolean setServerInstance(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerInstance", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ArrayList setParameters = (ArrayList)cmd.listSetParams();
        String serverName = (String)cmd.getParameter("serverName");
        String nodeName = (String)cmd.getParameter("nodeName");
        try {
            ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
            if (servers.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            ObjectName server = servers[0];
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerInstance");
            ObjectName[] serverInstList = configService.queryConfigObjects(session, server, pattern, null);
            if (serverInstList.length > 0) {
                ObjectName serverInst = serverInstList[0];
                if (serverInst != null) {
                    AttributeList attrList = new AttributeList();
                    if (setParameters.contains("enableMultipleServerInstances")) {
                        Boolean emsi = (Boolean)cmd.getParameter("enableMultipleServerInstances");
                        ConfigServiceHelper.setAttributeValue(attrList, "enableMultipleServerInstances", emsi);
                    }
                    if (setParameters.contains("minimumNumOfInstances")) {
                        Integer minNum = (Integer)cmd.getParameter("minimumNumOfInstances");
                        ConfigServiceHelper.setAttributeValue(attrList, "minimumNumOfInstances", minNum);
                    }
                    if (setParameters.contains("maximumNumberOfInstances")) {
                        Integer maxNum = (Integer)cmd.getParameter("maximumNumberOfInstances");
                        ConfigServiceHelper.setAttributeValue(attrList, "maximumNumberOfInstances", maxNum);
                    }
                    configService.setAttributes(session, serverInst, attrList);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot find serverInstance");
                }
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            bl = true;
            Object var16_17 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.setServerInstance", (String)"825");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block15: {
                    Object var16_18 = null;
                    if (!tc.isEntryEnabled()) break block15;
                    Tr.exit(tc, "setServerInstance");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerInstance");
        }
        return bl;
    }

    public Object showServerInstance(AbstractAdminCommand cmd) throws Exception {
        AttributeList attributeList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showServerInstance", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ArrayList setParameters = (ArrayList)cmd.listSetParams();
        String serverName = (String)cmd.getParameter("serverName");
        String nodeName = (String)cmd.getParameter("nodeName");
        String propertyName = (String)cmd.getParameter("propertyName");
        Object results = null;
        try {
            ObjectName[] servers = this.getScope(session, "Server", serverName, nodeName);
            if (servers.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            ObjectName server = servers[0];
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerInstance");
            ObjectName[] serverInstList = configService.queryConfigObjects(session, server, pattern, null);
            if (serverInstList.length > 0) {
                ObjectName serverInst = serverInstList[0];
                if (serverInst != null) {
                    if (propertyName != null && !propertyName.equals("")) {
                        results = configService.getAttribute(session, serverInst, propertyName, false);
                    } else {
                        results = new AttributeList();
                        for (int i = 0; i < serverInstancePropList.length; ++i) {
                            propertyName = serverInstancePropList[i];
                            Object attribute = configService.getAttribute(session, serverInst, propertyName, false);
                            ConfigServiceHelper.setAttributeValue((AttributeList)results, propertyName, attribute);
                        }
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot find serverInstance");
                }
                throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
            }
            attributeList = results;
            Object var18_18 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.showServerInstance", (String)"905");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block15: {
                    Object var18_19 = null;
                    if (!tc.isEntryEnabled()) break block15;
                    Tr.exit(tc, "showServerInstance");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showServerInstance");
        }
        return attributeList;
    }

    public boolean setTraceSpecification(AbstractAdminCommand cmd) throws Exception {
        boolean newTrace2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTraceSpecification", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ArrayList setParameters = (ArrayList)cmd.listSetParams();
        String serverName = (String)cmd.getParameter("serverName");
        String nodeName = (String)cmd.getParameter("nodeName");
        Boolean persist = (Boolean)cmd.getParameter("persist");
        try {
            if (setParameters.contains("traceSpecification")) {
                String newTrace2 = (String)cmd.getParameter("traceSpecification");
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService != null) {
                    Set match;
                    ObjectName traceServiceMBean = null;
                    if (serverName == null || serverName.equalsIgnoreCase("")) {
                        serverName = adminService.getProcessName();
                    }
                    StringBuffer queryString = new StringBuffer("WebSphere:type=TraceService");
                    if (nodeName != null && !nodeName.equalsIgnoreCase("")) {
                        queryString.append(",node=" + nodeName);
                    }
                    queryString.append(",process=" + serverName + ",*");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TraceServiceMean query string is " + queryString.toString());
                    }
                    if ((match = adminService.queryNames(new ObjectName(queryString.toString()), null)).size() == 1) {
                        traceServiceMBean = (ObjectName)match.iterator().next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TraceServiceMean is " + traceServiceMBean);
                        }
                        Attribute traceSpec = new Attribute("traceSpecification", newTrace2);
                        adminService.setAttribute(traceServiceMBean, traceSpec);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TraceServiceMean spec is is " + adminService.getAttribute(traceServiceMBean, "traceSpecification"));
                        }
                    }
                }
                if (persist.booleanValue()) {
                    ObjectName[] servers;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Persist is true.  Save the trace specification " + newTrace2 + " into the configuration");
                    }
                    if ((servers = this.getScope(session, "Server", serverName, nodeName)).length != 1) {
                        throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
                    }
                    ObjectName server = servers[0];
                    ObjectName pattern = ConfigServiceHelper.createObjectName(null, "TraceService");
                    ObjectName traceService = configService.queryConfigObjects(session, server, pattern, null)[0];
                    String trace = (String)configService.getAttribute(session, traceService, "startupTraceSpecification");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "current trace string is " + trace);
                    }
                    AttributeList attrList = new AttributeList();
                    attrList.add(new Attribute("startupTraceSpecification", newTrace2));
                    configService.setAttributes(session, traceService, attrList);
                }
            }
            newTrace2 = true;
            Object var18_19 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.configureTraceService", (String)"889");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                block19: {
                    Object var18_20 = null;
                    if (!tc.isEntryEnabled()) break block19;
                    Tr.exit(tc, "setTraceSpecification");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTraceSpecification");
        }
        return newTrace2;
    }

    private ObjectName[] getScope(Session session, String scope, String scopeName, String nodeName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScope", new Object[]{scope, scopeName, nodeName});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        StringBuffer scopeQueryString = new StringBuffer();
        if (scope != null && scope.equals("Cell")) {
            scopeQueryString.append(scope);
            if (scopeName != null && !scopeName.equals("")) {
                scopeQueryString.append("=");
                scopeQueryString.append(scopeName);
            }
        }
        if (nodeName != null && !nodeName.equals("")) {
            if (scopeQueryString.length() != 0) {
                scopeQueryString.append(":");
            }
            scopeQueryString.append("Node");
            scopeQueryString.append("=");
            scopeQueryString.append(nodeName);
        }
        if (scope != null && !scope.equals("Cell")) {
            if (scopeQueryString.length() != 0) {
                scopeQueryString.append(":");
            }
            scopeQueryString.append(scope);
            if (scopeName != null && !scopeName.equals("")) {
                scopeQueryString.append("=");
                scopeQueryString.append(scopeName);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeQueryString is " + scopeQueryString.toString());
        }
        ObjectName[] scopes = configService.resolve(session, scopeQueryString.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScope", scopes);
        }
        return scopes;
    }

    public boolean setJVMMode(AbstractAdminCommand cmd) throws Exception {
        boolean bl;
        ManagedObjectMetadataHelper metadataHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMMode", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName variableMap = null;
        String varName = "JAVA_HOME";
        String enable64bitProp = "private_Enable_zWAS_for_64bit";
        String scopeName = (String)cmd.getParameter("serverName");
        String nodeName = (String)cmd.getParameter("nodeName");
        ObjectName targetObj = (ObjectName)cmd.getTargetObject();
        if (targetObj != null) {
            if (nodeName != null) {
                throw new InvalidParameterValueException(cmd.getName(), "Cannot specify nodeName and serverName  when target object is specified.", nodeName);
            }
            if (scopeName != null) {
                throw new InvalidParameterValueException(cmd.getName(), "Cannot specify nodeName and serverName  when target object is specified.", scopeName);
            }
        } else {
            if (nodeName == null) {
                throw new InvalidParameterValueException(cmd.getName(), "Need to specify nodeName and serverName  when target object is not specified.", nodeName);
            }
            if (scopeName == null) {
                throw new InvalidParameterValueException(cmd.getName(), "Need to specify nodeName and serverName  when target object is not specified.", scopeName);
            }
        }
        Object serverObject = null;
        if (targetObj == null ? !(metadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper()).isNodeZOS(nodeName) : !this.isZOS(configService, session, targetObj)) {
            throw new CommandException("This command is only applicable to z/OS servers");
        }
        String mode = (String)cmd.getParameter("mode");
        boolean is31bit = true;
        if (mode != null && !mode.equals(JVM_Mode_31) && !mode.equals(JVM_Mode_64)) {
            throw new InvalidParameterValueException(cmd.getName(), "jvmMode: jvm modes are either \"31bit\" or \"64bit\" ", mode);
        }
        if (mode.equals(JVM_Mode_64)) {
            is31bit = false;
        }
        try {
            ObjectName scopeObject = null;
            if (targetObj == null) {
                ObjectName[] scopeObjects = this.getScope(session, "Server", scopeName, nodeName);
                if (scopeObjects.length != 1) {
                    throw new InvalidParameterValueException(cmd.getName(), "scopeName", scopeName);
                }
                scopeObject = scopeObjects[0];
            } else {
                scopeObject = targetObj;
            }
            boolean javaHomeExist = false;
            boolean enable64bitExist = false;
            AttributeList attrList = new AttributeList();
            ObjectName[] variableMaps = configService.getRelationship(session, scopeObject, "VariableMap");
            if (variableMaps == null || variableMaps.length == 0) {
                variableMap = configService.createConfigData(session, scopeObject, "VariableMap", null, new AttributeList());
            } else {
                variableMap = variableMaps[0];
                ArrayList variables = (ArrayList)configService.getAttribute(session, variableMap, "entries", false);
                for (int i = 0; i < variables.size(); ++i) {
                    ObjectName variable = (ObjectName)variables.get(i);
                    String existingVariableName = (String)configService.getAttribute(session, variable, "symbolicName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Existing variable name is " + existingVariableName);
                    }
                    if (existingVariableName.equals(varName)) {
                        if (is31bit) {
                            configService.deleteConfigData(session, variable);
                            continue;
                        }
                        ConfigServiceHelper.setAttributeValue(attrList, "value", JAVA_HOME);
                        configService.setAttributes(session, variable, attrList);
                        javaHomeExist = true;
                        attrList.clear();
                        continue;
                    }
                    if (!existingVariableName.equals(enable64bitProp)) continue;
                    if (is31bit) {
                        ConfigServiceHelper.setAttributeValue(attrList, "value", "false");
                        configService.setAttributes(session, variable, attrList);
                        attrList.clear();
                    } else {
                        ConfigServiceHelper.setAttributeValue(attrList, "value", "true");
                        configService.setAttributes(session, variable, attrList);
                        attrList.clear();
                    }
                    enable64bitExist = true;
                }
            }
            if (!javaHomeExist && !is31bit) {
                ConfigServiceHelper.setAttributeValue(attrList, "symbolicName", varName);
                ConfigServiceHelper.setAttributeValue(attrList, "value", JAVA_HOME);
                configService.createConfigData(session, variableMap, "entries", "VariableSubstitutionEntry", attrList);
                attrList.clear();
            }
            if (!enable64bitExist && !is31bit) {
                ConfigServiceHelper.setAttributeValue(attrList, "symbolicName", enable64bitProp);
                ConfigServiceHelper.setAttributeValue(attrList, "value", "true");
                configService.createConfigData(session, variableMap, "entries", "VariableSubstitutionEntry", attrList);
                attrList.clear();
            }
            if (targetObj != null) {
                this.setJVMModeProperty(cmd, targetObj, mode);
            } else {
                this.setJVMModeProperty(cmd, nodeName, scopeName, mode);
            }
            if (mode.equals(JVM_Mode_31)) {
                AdminHelperCommandProvider.resetHeapSize(session, configService, scopeObject);
            }
            bl = true;
            Object var24_26 = null;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.setJVMMode", (String)"969");
                throw cse;
            }
            catch (Throwable throwable) {
                block31: {
                    Object var24_27 = null;
                    if (!tc.isEntryEnabled()) break block31;
                    Tr.exit(tc, "setJVMMode");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJVMMode");
        }
        return bl;
    }

    public void setJVMModeProperty(AbstractAdminCommand cmd, String nodeName, String scopeName, String mode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMModeProperty", new Object[]{nodeName, scopeName, mode});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName[] scopeObjects = this.getScope(session, "Server", scopeName, nodeName);
        if (scopeObjects.length != 1) {
            throw new InvalidParameterValueException(cmd.getName(), "scopeName", scopeName);
        }
        ObjectName serverObject = scopeObjects[0];
        this.setJVMModeProperty(cmd, serverObject, mode);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJVMModeProperty");
        }
    }

    public void setJVMModeProperty(AbstractAdminCommand cmd, ObjectName targetObj, String mode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMModeProperty", new Object[]{targetObj, mode});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        String jvmModeProp = "was.com.ibm.websphere.zos.jvmmode";
        ObjectName serverObject = targetObj;
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, "value", mode);
        boolean exist = false;
        ObjectName processDefObject = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        ObjectName[] processDefs = configService.queryConfigObjects(session, serverObject, processDefObject, null);
        if (mode != null) {
            for (int j = 0; j < processDefs.length; ++j) {
                String processType = (String)configService.getAttribute(session, processDefs[j], "processType");
                if (!processType.equalsIgnoreCase("Control")) continue;
                ArrayList properties = (ArrayList)configService.getAttribute(session, processDefs[j], "environment", false);
                for (int i = 0; i < properties.size(); ++i) {
                    ObjectName prop = (ObjectName)properties.get(i);
                    String existingPropName = (String)configService.getAttribute(session, prop, "name");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Existing prop name is " + existingPropName);
                    }
                    if (existingPropName == null || !existingPropName.equals(jvmModeProp)) continue;
                    configService.setAttributes(session, prop, attrList);
                    exist = true;
                }
                if (exist) continue;
                ConfigServiceHelper.setAttributeValue(attrList, "name", jvmModeProp);
                configService.createConfigData(session, processDefs[j], "environment", null, attrList);
            }
        }
        this.updateServersStartCommandArgs(session, configService, processDefs, mode);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJVMModeProperty");
        }
    }

    public String getJVMMode(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJVMMode", cmd);
        }
        String mode = JVM_Mode_31;
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        String server = (String)cmd.getParameter("serverName");
        String node = (String)cmd.getParameter("nodeName");
        ObjectName targetObj = (ObjectName)cmd.getTargetObject();
        if (targetObj != null) {
            if (node != null) {
                throw new InvalidParameterValueException(cmd.getName(), "Cannot specify nodeName and serverName  when target object is specified.", node);
            }
            if (server != null) {
                throw new InvalidParameterValueException(cmd.getName(), "Cannot specify nodeName and serverName  when target object is specified.", server);
            }
        } else {
            if (node == null) {
                throw new InvalidParameterValueException(cmd.getName(), "Need to specify nodeName and serverName  when target object is not specified.", node);
            }
            if (server == null) {
                throw new InvalidParameterValueException(cmd.getName(), "Need to specify nodeName and serverName  when target object is not specified.", server);
            }
        }
        ObjectName serverObject = null;
        String jvmModeProp = "was.com.ibm.websphere.zos.jvmmode";
        if (targetObj == null) {
            ManagedObjectMetadataHelper metadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
            if (!metadataHelper.isNodeZOS(node)) {
                throw new CommandException("This command is only applicable to z/OS servers");
            }
            ObjectName[] scopeObjects = this.getScope(session, "Server", server, node);
            if (scopeObjects.length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "scopeName", server);
            }
            serverObject = scopeObjects[0];
        } else {
            if (!this.isZOS(configService, session, targetObj)) {
                throw new CommandException("This command is only applicable to z/OS servers");
            }
            serverObject = targetObj;
        }
        ObjectName processDefObject = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        ObjectName[] processDefs = configService.queryConfigObjects(session, serverObject, processDefObject, null);
        block0: for (int j = 0; j < processDefs.length; ++j) {
            String processType = (String)configService.getAttribute(session, processDefs[j], "processType");
            if (processType == null || !processType.equalsIgnoreCase("Control")) continue;
            ArrayList properties = (ArrayList)configService.getAttribute(session, processDefs[j], "environment", false);
            for (int i = 0; i < properties.size(); ++i) {
                ObjectName prop = (ObjectName)properties.get(i);
                String existingPropName = (String)configService.getAttribute(session, prop, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing prop name is " + existingPropName);
                }
                if (existingPropName == null || !existingPropName.equals(jvmModeProp)) continue;
                mode = (String)configService.getAttribute(session, prop, "value");
                continue block0;
            }
        }
        return mode;
    }

    private ObjectName getProcessDefWithProcessType(Session session, ConfigService configService, ObjectName server, String processType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessDef", new Object[]{server, processType});
        }
        ObjectName result = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        ObjectName[] processDefs = configService.queryConfigObjects(session, server, pattern, null);
        for (int i = 0; i < processDefs.length; ++i) {
            ObjectName processDef = processDefs[i];
            String defProcessType = (String)configService.getAttribute(session, processDef, "processType", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Process Definition ProcessType is " + defProcessType);
            }
            if (processType != null && !processType.equals("") && !processType.equals(defProcessType)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Process Definition ProcessType found");
            }
            result = processDef;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessDef", result);
        }
        if (result == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no process type with the type " + processType + " found.");
            }
            throw new InvalidParameterValueException("", "processType", processType);
        }
        return result;
    }

    public static void resetHeapSize(Session session, ConfigService configService, ObjectName serverObj) throws Exception {
        AttributeList attrList = new AttributeList();
        Integer initialHeapSize = new Integer(256);
        Integer maxHeapSize = new Integer(512);
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
        ObjectName[] jvms = configService.queryConfigObjects(session, serverObj, pattern, null);
        for (int i = 0; i < jvms.length; ++i) {
            ConfigServiceHelper.setAttributeValue(attrList, "initialHeapSize", initialHeapSize);
            ConfigServiceHelper.setAttributeValue(attrList, "maximumHeapSize", maxHeapSize);
            configService.setAttributes(session, jvms[i], attrList);
        }
    }

    public String getJavaHome(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJavaHome", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        String retVal = "";
        String javaHomeVar = "JAVA_HOME";
        String wasInstallRootVar = "WAS_INSTALL_ROOT";
        String scopeName = (String)cmd.getParameter("serverName");
        String nodeName = (String)cmd.getParameter("nodeName");
        ObjectName[] scopeObjects = null;
        String mode = (String)cmd.getParameter("mode");
        boolean is64bit = false;
        if (mode != null && !mode.equals(JVM_Mode_31) && !mode.equals(JVM_Mode_64)) {
            throw new InvalidParameterValueException(cmd.getName(), "jvmMode: jvm modes are either \"31bit\" or \"64bit\" ", mode);
        }
        if (mode != null && mode.length() > 0 && mode.equals(JVM_Mode_64)) {
            is64bit = true;
        }
        try {
            String processType;
            String javaHome = "";
            String wasHome = "";
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService != null && (processType = adminService.getProcessType()) != null && !processType.equalsIgnoreCase("DeploymentManager")) {
                VariableMap varMap = (VariableMap)WsServiceRegistry.getService((Object)this, VariableMap.class);
                wasHome = varMap.expand("${WAS_INSTALL_ROOT}");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "${WAS_INSTALL_ROOT} " + wasHome);
                }
                if (wasHome != null) {
                    retVal = !is64bit ? wasHome + "/java" : wasHome + "/java64";
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getJavaHome", retVal);
                    }
                    return retVal;
                }
            }
            if ((scopeObjects = this.getScope(session, "Node", nodeName, null)).length != 1) {
                throw new InvalidParameterValueException(cmd.getName(), "scopeName", scopeName);
            }
            ObjectName scopeObject = scopeObjects[0];
            ObjectName variableMap = configService.getRelationship(session, scopeObject, "VariableMap")[0];
            ArrayList variables = (ArrayList)configService.getAttribute(session, variableMap, "entries", false);
            for (int i = 0; i < variables.size(); ++i) {
                ObjectName variable = (ObjectName)variables.get(i);
                String variableName = (String)configService.getAttribute(session, variable, "symbolicName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "variable name is " + variableName);
                }
                if (variableName != null && variableName.equals(javaHomeVar)) {
                    javaHome = (String)configService.getAttribute(session, variable, "value");
                    continue;
                }
                if (variableName == null || !variableName.equals(wasInstallRootVar)) continue;
                wasHome = (String)configService.getAttribute(session, variable, "value");
            }
            retVal = !is64bit ? wasHome + "/java" : wasHome + "/java64";
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.admintasks.getJavaHome", (String)"969");
            throw cse;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJavaHome", retVal);
        }
        return retVal;
    }

    private void updateServersStartCommandArgs(Session session, ConfigService configService, ObjectName[] processDefs, String mode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServersStartCommandArgs", new Object[]{processDefs});
        }
        String startCommandArgs = "";
        StringBuilder sb = null;
        for (int i = 0; i < processDefs.length; ++i) {
            startCommandArgs = (String)((List)configService.getAttribute(session, processDefs[i], "startCommandArgs")).get(0);
            sb = new StringBuilder(startCommandArgs);
            String pattern1 = new String(",AMODE=64");
            String pattern2 = new String("AMODE=64,");
            int idx = sb.indexOf(pattern1);
            if (idx == -1) {
                idx = sb.indexOf(pattern2);
            }
            if (mode.equals(JVM_Mode_31)) {
                if (idx != -1) {
                    sb.delete(idx, idx + pattern1.length());
                }
            } else if (idx == -1) {
                sb.append(",AMODE=64");
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(sb.toString());
            AttributeList newList = new AttributeList();
            newList.add(new Attribute("startCommandArgs", list));
            configService.setAttributes(session, processDefs[i], newList);
        }
    }

    public void configureSingleHome(AdminCommand admincommand) throws Exception {
        this.configureDVIPAPrivate(admincommand, false);
    }

    public void configureDVIPA(AdminCommand cmd) throws Exception {
        this.configureDVIPAPrivate(cmd, true);
    }

    private void configureDVIPAPrivate(AdminCommand cmd, boolean multiHome) throws Exception {
        ObjectName[] orbArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureDVIPAPrivate", new Object[]{cmd});
        }
        ConfigService configservice2 = ConfigServiceFactory.getConfigService();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConfigService", configservice2);
        }
        Session session = cmd.getConfigSession();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session", session);
        }
        String serverName = (String)cmd.getParameter("serverName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerName", serverName);
        }
        if (serverName == null || serverName.trim().equals("")) {
            throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
        }
        String nodeName = (String)cmd.getParameter("nodeName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NodeName", nodeName);
        }
        if (nodeName == null || nodeName.trim().equals("")) {
            throw new InvalidParameterValueException(cmd.getName(), "nodeName", nodeName);
        }
        String hostName = (String)cmd.getParameter("hostName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "HostName", hostName);
        }
        if (hostName == null || hostName.trim().equals("")) {
            throw new InvalidParameterValueException(cmd.getName(), "hostName", hostName);
        }
        String serverQuery = "Node=" + nodeName + ":Server=" + serverName;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Spec", serverQuery);
        }
        ObjectName[] serverObjects = configservice2.resolve(session, serverQuery);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Matches", serverObjects);
        }
        ObjectName serverON = null;
        if (serverObjects.length <= 0) {
            throw new InvalidParameterValueException(cmd.getName(), "serverName", serverName);
        }
        serverON = serverObjects[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: ", serverON);
        }
        ObjectName orbQuery = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("_Websphere_Config_Data_Type", "ObjectRequestBroker");
        try {
            orbQuery = new ObjectName("WebSphere", hashtable);
        }
        catch (MalformedObjectNameException malformedobjectnameexception) {
            throw new Exception(malformedobjectnameexception.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "About to call queryConfigObjects.");
        }
        if ((orbArray = configservice2.queryConfigObjects(session, serverON, orbQuery, null)).length == 0) {
            throw new Exception("Could not find ORB");
        }
        ObjectName orbON = orbArray[0];
        Hashtable<String, String> qTable = new Hashtable<String, String>();
        ObjectName propQuery = null;
        qTable.put("_Websphere_Config_Data_Type", "Property");
        try {
            propQuery = new ObjectName("WebSphere", qTable);
        }
        catch (MalformedObjectNameException malformedobjectnameexception1) {
            throw new Exception(malformedobjectnameexception1.toString());
        }
        ObjectName[] props = configservice2.queryConfigObjects(session, orbON, propQuery, null);
        boolean orbLocalHostExists = false;
        boolean orbMultiHomeExists = false;
        String[] nameArray = new String[]{"name"};
        for (int i = 0; i < props.length; ++i) {
            AttributeList valList;
            ObjectName prop = props[i];
            AttributeList attrList = configservice2.getAttributes(session, prop, nameArray, false);
            String pName = (String)ConfigServiceHelper.getAttributeValue(attrList, "name");
            if (pName != null && pName.equals(ORB_LOCALHOST)) {
                if (multiHome) {
                    configservice2.deleteConfigData(session, prop);
                } else {
                    orbLocalHostExists = true;
                    valList = new AttributeList();
                    valList.add(new Attribute("value", hostName));
                    configservice2.setAttributes(session, prop, valList);
                }
            }
            if (pName == null || !pName.equals(ORB_MULTIHOME)) continue;
            orbMultiHomeExists = true;
            valList = new AttributeList();
            if (multiHome) {
                valList.add(new Attribute("value", "true"));
            } else {
                valList.add(new Attribute("value", "false"));
            }
            configservice2.setAttributes(session, prop, valList);
        }
        if (!multiHome && !orbLocalHostExists) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new ORB Localhost");
            }
            AttributeList list = new AttributeList();
            list.add(new Attribute("name", ORB_LOCALHOST));
            list.add(new Attribute("value", hostName));
            configservice2.createConfigDataByTemplate(session, orbON, "properties", list, null);
        }
        if (!multiHome && !orbMultiHomeExists) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new ORB Multihome");
            }
            AttributeList list = new AttributeList();
            list.add(new Attribute("name", ORB_MULTIHOME));
            list.add(new Attribute("value", "false"));
            configservice2.createConfigDataByTemplate(session, orbON, "properties", list, null);
        }
        ObjectName processDefQuery = null;
        Hashtable<String, String> defTable = new Hashtable<String, String>();
        defTable.put("_Websphere_Config_Data_Type", "ProcessDef");
        try {
            processDefQuery = new ObjectName("WebSphere", defTable);
        }
        catch (MalformedObjectNameException malformedobjectnameexception2) {
            throw new Exception(malformedobjectnameexception2.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "About to call queryConfigObjects.", processDefQuery);
        }
        ObjectName[] pDefs = configservice2.queryConfigObjects(session, serverON, processDefQuery, null);
        ObjectName pDef = null;
        if (pDefs.length == 1) {
            pDef = pDefs[0];
        } else {
            for (int j = 0; j < pDefs.length; ++j) {
                String processType = (String)configservice2.getAttribute(session, pDefs[j], "processType");
                if (processType == null || !processType.equals("Control")) continue;
                pDef = pDefs[j];
            }
        }
        if (pDef == null) {
            throw new Exception("Could not find process def");
        }
        ArrayList jvmList = (ArrayList)configservice2.getAttribute(session, pDef, "jvmEntries");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JVM List", jvmList);
        }
        AttributeList jvm = (AttributeList)jvmList.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JVM", jvm);
        }
        ObjectName jvmON = ConfigServiceHelper.createObjectName(jvm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JVM ON", jvmON);
        }
        ObjectName[] systemProps = configservice2.queryConfigObjects(session, jvmON, propQuery, null);
        boolean jvmMultiHomeExists = false;
        for (int i = 0; i < systemProps.length; ++i) {
            ObjectName prop = systemProps[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "systemProperty:", prop);
            }
            AttributeList attrList = configservice2.getAttributes(session, prop, nameArray, false);
            String pName = (String)ConfigServiceHelper.getAttributeValue(attrList, "name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name:", pName);
            }
            if (pName == null || !pName.equals(JVM_MULTIHOME)) continue;
            jvmMultiHomeExists = true;
            AttributeList valList = new AttributeList();
            if (multiHome) {
                valList.add(new Attribute("value", "true"));
            } else {
                valList.add(new Attribute("value", "false"));
            }
            configservice2.setAttributes(session, prop, valList);
        }
        if (!multiHome && !jvmMultiHomeExists) {
            AttributeList jvmProps = new AttributeList();
            jvmProps.add(new Attribute("_Websphere_Config_Data_Type", "Property"));
            jvmProps.add(new Attribute("name", JVM_MULTIHOME));
            jvmProps.add(new Attribute("value", "false"));
            ObjectName nProp = configservice2.createConfigDataByTemplate(session, jvmON, "systemProperties", jvmProps, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new JVM Property", nProp);
            }
        }
        ObjectName[] nodes = null;
        if (nodeName != null && nodeName.length() > 0) {
            nodes = configservice2.resolve(session, "Node=" + nodeName);
        }
        ObjectName serverIndexON = configservice2.getRelationship(session, (ObjectName)nodes[0], "ServerIndex")[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerIndex", serverIndexON);
        }
        ObjectName[] serverEntries = configservice2.resolve(session, "ServerEntry=" + serverName);
        for (int k = 0; k < serverEntries.length; ++k) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Pattern", serverEntries[k]);
        }
        ObjectName[] serverEntry = configservice2.queryConfigObjects(session, serverIndexON, serverEntries[0], null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverEntry", serverEntry);
        }
        ObjectName endPointON = ConfigServiceHelper.createObjectName(null, "EndPoint");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "endPointON", endPointON);
        }
        AttributeList hostList = new AttributeList();
        hostList.add(new Attribute("host", hostName));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "hostList", hostList);
        }
        for (int l = 0; l < serverEntry.length; ++l) {
            ObjectName[] se = configservice2.queryConfigObjects(session, serverEntry[l], endPointON, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SE", se);
            }
            for (int k = 0; k < se.length; ++k) {
                String origHost = (String)configservice2.getAttribute(session, se[k], "host");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original Host", origHost);
                }
                configservice2.setAttributes(session, se[k], hostList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureDVIPAPrivate", null);
        }
    }

    private boolean isZOS(ConfigService cs, Session session, ObjectName serverObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isZOS", new Object[]{cs, session, serverObj});
        }
        boolean result = false;
        PropertySet ps = TemplateConfigHelper.getPropertySetOfTemplate(cs, session, serverObj);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Property Set", ps);
        }
        if (ps != null) {
            EList props = ps.getProperties();
            for (Property p : props) {
                String name = p.getName();
                String val = p.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name ", name);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "value ", val);
                }
                if (name == null || !name.equals("com.ibm.websphere.nodeOperatingSystem")) continue;
                if (val == null || !val.equals("os390")) break;
                result = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isZOS", new Boolean(result));
        }
        return result;
    }
}

