/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.genericserver;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ExecutableTargetKind;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class GenericServerHelper {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(GenericServerHelper.class, "Admin", "com.ibm.ws.management.resources.unmgdnodeutils");

    public static void setProcDefValues(WorkSpace workSpace, String cellName, String nodeName, String serverName, String startCommand, String startCommandArgs, String executableTargetKind, String executableTarget, String workingDirectory, String stopCommand, String stopCommandArgs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProcDefValues()");
        }
        RepositoryContext serverContext = workSpace.findContext(cellName + "/nodes/" + nodeName + "/servers/" + serverName);
        WorkSpaceFile wsf = null;
        wsf = serverContext.getFile("server.xml");
        Resource resource = serverContext.getResourceSet().createResource(URI.createURI("server.xml"));
        resource.load(new HashMap());
        Server myServer = (Server)resource.getContents().get(0);
        EList processDefs = myServer.getProcessDefinitions();
        ProcessDef processDef = (ProcessDef)processDefs.get(0);
        if (startCommand != null) {
            processDef.setStartCommand(startCommand);
        }
        if (startCommandArgs != null) {
            GenericServerHelper.addArgsToList(processDef.getStartCommandArgs(), startCommandArgs);
        }
        if (executableTarget != null) {
            ((JavaProcessDef)processDef).setExecutableTarget(executableTarget);
        }
        if (executableTargetKind != null) {
            ((JavaProcessDef)processDef).setExecutableTargetKind(ExecutableTargetKind.get(executableTargetKind));
        }
        if (workingDirectory != null) {
            workingDirectory = workingDirectory.replace('\\', '/');
            processDef.setWorkingDirectory(workingDirectory);
        }
        if (stopCommand != null) {
            processDef.setStopCommand(stopCommand);
        }
        if (stopCommandArgs != null) {
            GenericServerHelper.addArgsToList(processDef.getStopCommandArgs(), stopCommandArgs);
        }
        resource.save(new HashMap());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProcDefValues()");
        }
    }

    public static String getTheCellName(WorkSpace ws) throws WorkSpaceException {
        RepositoryContextType cellType = ws.getMetaData().getContextType("cells");
        Collection jcellContexts = ws.findContext(cellType);
        Iterator ji = jcellContexts.iterator();
        RepositoryContext jjCellContext = (RepositoryContext)ji.next();
        return jjCellContext.getURI();
    }

    private static void addArgsToList(List argsList, String startCommandArgs) throws Exception {
        ArrayList jlist = GenericServerHelper.createArgsListFromString(startCommandArgs);
        for (int i = 0; i < jlist.size(); ++i) {
            argsList.add(jlist.get(i));
        }
    }

    private static ArrayList createArgsListFromString(String argsString) throws Exception {
        int tokenType;
        ArrayList<String> jlist = new ArrayList<String>();
        StringReader stringReader = new StringReader(argsString);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.commentChar(47);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        block8: while ((tokenType = streamTokenizer.nextToken()) != -1) {
            try {
                switch (tokenType) {
                    case -3: {
                        jlist.add(streamTokenizer.sval);
                        continue block8;
                    }
                    case -1: {
                        continue block8;
                    }
                    case 10: {
                        continue block8;
                    }
                    case -2: {
                        continue block8;
                    }
                }
                jlist.add(streamTokenizer.sval);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        stringReader.close();
        return jlist;
    }
}

