/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.cell;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.ContextUtil;
import com.ibm.ws.sm.workspace.ContextUtilFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class RenameCell
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RenameCell.class, "Admin", "com.ibm.ws.management.resources.configservice");
    private static ResourceBundle RESOURCE_BUNDLE = null;
    private static final String ISCCTX = "/applications/isclite.ear/deployments/isclite";
    private static final String ISCURI = "isclite.war/WEB-INF/components.xml";
    private static final String SETUPCMDSTR = "SET WAS_CELL=";
    private static final String FIRSTSTEPSTR = "--cellname ";
    String oldCellName = null;
    String newCellName = null;
    boolean regenCerts = false;
    boolean updateSetupCmd = false;
    boolean updateJaccContextID = true;
    ObjectName newCellObject = null;
    RepositoryContext newCellContext = null;
    ConfigService configService = null;
    Session session = null;
    boolean isND = false;
    Properties resultProps = null;

    public RenameCell(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public RenameCell(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            String msg = null;
            if (AdminServiceFactory.getAdminService() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error - can only run in local mode");
                }
                msg = this.getFormattedMessage("ADMG0101E", new Object[0], "This command only runs in local mode.");
                throw new CommandValidationException(msg);
            }
            this.newCellName = (String)this.getParameter("newCellName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new cell = " + this.newCellName);
            }
            if (!ConfigServiceHelper.checkIfNameValid(this.newCellName)) {
                msg = this.getFormattedMessage("ADMG0102E", new Object[]{this.newCellName}, "Invalid cell name: " + this.newCellName);
                throw new CommandValidationException(msg);
            }
            this.configService = ConfigServiceFactory.getConfigService();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName cell = this.configService.queryConfigObjects(this.session, null, pattern, null)[0];
            this.oldCellName = ConfigServiceHelper.getDisplayName(cell);
            this.regenCerts = Boolean.TRUE.equals((Boolean)this.getParameter("regenCerts"));
            this.updateSetupCmd = Boolean.TRUE.equals((Boolean)this.getParameter("changeSetupCmdBat"));
            this.updateJaccContextID = Boolean.TRUE.equals((Boolean)this.getParameter("updateJaccContextID"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "regenCerts: " + this.regenCerts + ", updateSetupCmd: " + this.updateSetupCmd + ", updateJaccContextID: " + this.updateJaccContextID);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newCellName = " + this.newCellName);
            }
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.cell.RenameCell.validate", (String)"54");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to validate the command", ex);
            }
            CommandValidationException exception = new CommandValidationException(ex, "unexpected exception during validation");
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        if (this.resultProps == null) {
            this.resultProps = new Properties();
        }
        try {
            this.session = this.getConfigSession();
            this.renameCellContext();
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.cell.RenameCell.beforeStepsExecuted", (String)"85");
            result.setException(new CommandException(th, "renameCell command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.newCellObject = this.configService.resolve(this.session, "Cell=" + this.newCellName)[0];
            String cellType = (String)this.configService.getAttribute(this.session, this.newCellObject, "cellType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellType = " + cellType);
            }
            this.isND = "DISTRIBUTED".equals(cellType);
            this.fixCellXML();
            this.fixApps();
            this.fixSecurityXML();
            if (this.regenCerts) {
                this.regenCerts();
            }
            if (this.updateSetupCmd) {
                this.fixSetupCmd();
            }
            this.resultProps.put("done", "true");
            System.setProperty("local.cell", this.newCellName);
            System.setProperty("__renamecellcmdexc__", this.oldCellName);
            result.setResult(this.resultProps);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.cell.RenameCell.afterStepsExecuted", (String)"126");
            result.setException(new CommandException(th, "renameCell command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private String getFormattedMessage(String key, Object[] args, String msg) {
        try {
            String result;
            if (RESOURCE_BUNDLE == null) {
                RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", this.getLocale());
            }
            if (RESOURCE_BUNDLE == null) {
                RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", Locale.getDefault());
            }
            if ((result = RESOURCE_BUNDLE.getString(key)) == null) {
                return msg;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (msg == null) {
                return msg;
            }
            return MessageFormat.format(msg, args);
        }
        catch (Throwable th) {
            return msg;
        }
    }

    private void renameCellContext() throws ConfigServiceException, WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renameCellContext");
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(this.session);
        RepositoryContext cellContext = workspace.findContext("cells/" + this.oldCellName);
        ContextUtil contextHelper = ContextUtilFactory.getUtil();
        this.newCellContext = contextHelper.rename(cellContext, this.newCellName);
        cellContext.delete(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renameCellContext");
        }
    }

    private void fixCellXML() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixCellXML");
        }
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("name", this.newCellName));
        this.configService.setAttributes(this.session, this.newCellObject, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixCellXML");
        }
    }

    private void fixApps() throws Exception {
        this.fixDeploymentXML();
        this.fixConsoleRegistry();
        this.fixAppInstallDirs();
    }

    private void fixSecurityXML() throws Exception {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixSecurityXML");
        }
        AttributeList attrList = new AttributeList();
        ObjectName pattern = null;
        ObjectName security = this.configService.getRelationship(this.session, this.newCellObject, "Security")[0];
        pattern = ConfigServiceHelper.createObjectName(null, "ManagementScope");
        ObjectName[] matches = this.configService.queryConfigObjects(this.session, security, pattern, null);
        for (i = 0; i < matches.length; ++i) {
            String scopeName = (String)this.configService.getAttribute(this.session, matches[i], "scopeName");
            if (scopeName == null || scopeName.length() <= 0) continue;
            String newScopeName = scopeName.replaceAll(this.oldCellName, this.newCellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scope name", newScopeName);
            }
            attrList.add(new Attribute("scopeName", newScopeName));
            this.configService.setAttributes(this.session, matches[i], attrList);
            attrList.clear();
        }
        pattern = ConfigServiceHelper.createObjectName(null, "KeyStore");
        matches = this.configService.queryConfigObjects(this.session, security, pattern, null);
        for (i = 0; i < matches.length; ++i) {
            String location = (String)this.configService.getAttribute(this.session, matches[i], "location");
            if (location == null || location.length() <= 0) continue;
            String newLocation = location.replaceAll(this.oldCellName, this.newCellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "location", newLocation);
            }
            attrList.add(new Attribute("location", newLocation));
            this.configService.setAttributes(this.session, matches[i], attrList);
            attrList.clear();
        }
        pattern = ConfigServiceHelper.createObjectName(null, "Property");
        matches = this.configService.queryConfigObjects(this.session, security, pattern, null);
        for (i = 0; i < matches.length; ++i) {
            String val = (String)this.configService.getAttribute(this.session, matches[i], "value");
            if (val == null || val.length() <= 0 || !val.contains(this.oldCellName)) continue;
            String newVal = val.replaceAll(this.oldCellName, this.newCellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "location", newVal);
            }
            attrList.add(new Attribute("value", newVal));
            this.configService.setAttributes(this.session, matches[i], attrList);
            attrList.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixSecurityXML");
        }
    }

    private void fixDeploymentXML() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixDeploymentXML");
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ApplicationDeployment");
        ObjectName[] matches = this.configService.queryConfigObjects(this.session, this.newCellObject, pattern, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "found apps: " + (matches != null ? matches.length : 0));
        }
        for (int i = 0; matches != null && i < matches.length; ++i) {
            String oldID;
            AttributeList attrList = this.configService.getAttributes(this.session, matches[i], new String[]{"binariesURL", "appContextIDForSecurity"}, false);
            String newBinURL = null;
            String newContextID = null;
            String binURL = (String)ConfigServiceHelper.getAttributeValue(attrList, "binariesURL");
            if (binURL != null) {
                if (binURL.contains("/" + this.oldCellName + "/")) {
                    newBinURL = binURL.replaceAll("/" + this.oldCellName + "/", "/" + this.newCellName + "/");
                } else if (binURL.contains("\\" + this.oldCellName + "\\")) {
                    newBinURL = binURL.replaceAll("\\" + this.oldCellName + "\\", "\\" + this.newCellName + "\\");
                }
            }
            if (this.updateJaccContextID && (oldID = (String)ConfigServiceHelper.getAttributeValue(attrList, "appContextIDForSecurity")) != null && oldID.contains(this.oldCellName)) {
                newContextID = oldID.replaceAll(this.oldCellName, this.newCellName);
            }
            attrList.clear();
            if (newBinURL != null) {
                attrList.add(new Attribute("binariesURL", newBinURL));
            }
            if (newContextID != null) {
                attrList.add(new Attribute("appContextIDForSecurity", newContextID));
            }
            if (attrList.size() <= 0) continue;
            this.configService.setAttributes(this.session, matches[i], attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixDeploymentXML");
        }
    }

    private void fixConsoleRegistry() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixConsoleRegistry");
        }
        WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(this.session.toString());
        RepositoryContext ctx = ws.findContext("cells/" + this.newCellName + ISCCTX);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isc ctx: " + ctx);
        }
        if (ctx != null && ctx.isAvailable(ISCURI)) {
            ctx.extract(ISCURI, false);
            InputStream is = ctx.getInputStream(ISCURI);
            int avail = is.available();
            byte[] bar = new byte[avail];
            is.read(bar);
            is.close();
            String contents = new String(bar);
            if (contents.contains(this.oldCellName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "contains old cell");
                }
                contents = contents.replaceAll(this.oldCellName, this.newCellName);
                OutputStream os = ctx.getOutputStream(ISCURI);
                os.write(contents.getBytes());
                os.flush();
                os.close();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "done writing file: isclite.war/WEB-INF/components.xml");
                }
                ctx.notifyChanged(1, ISCURI);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixConsoleRegistry");
        }
    }

    private void fixAppInstallDirs() throws Exception {
        String userRoot;
        File appInstall;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixAppInstallDirs");
        }
        if ((appInstall = new File((userRoot = System.getProperty("user.install.root")) + "/installedApps/" + this.oldCellName)).exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "renaming from " + appInstall + " to " + "installedApps/" + this.newCellName);
            }
            appInstall.renameTo(new File(userRoot + "/installedApps/" + this.newCellName));
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Does not exist: " + appInstall.getAbsolutePath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixAppInstallDirs");
        }
    }

    private void regenCerts() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "regenCerts");
        }
        try {
            String userRoot = System.getProperty("user.install.root");
            this.getResultProps().put("regenCerts", "true");
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in regenCert: " + th);
            }
            th.printStackTrace();
            this.getResultProps().put("regenCerts", "false");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "regenCerts");
        }
    }

    private void fixSetupCmd() {
        block6: {
            String userRoot;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "fixSetupCmd");
            }
            if ((userRoot = System.getProperty("user.install.root")) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user root: " + userRoot);
                }
                try {
                    this.readAndReplace(userRoot + "/bin/setupCmdLine.bat", SETUPCMDSTR + this.oldCellName, SETUPCMDSTR + this.newCellName);
                    this.readAndReplace(userRoot + "/bin/setupCmdLine.sh", SETUPCMDSTR + this.oldCellName, SETUPCMDSTR + this.newCellName);
                    this.getResultProps().put("setupcmdline", "true");
                    this.readAndReplace(userRoot + "/firststeps/firststeps.bat", FIRSTSTEPSTR + this.oldCellName, FIRSTSTEPSTR + this.newCellName);
                    this.readAndReplace(userRoot + "/firststeps/firststeps.sh", FIRSTSTEPSTR + this.oldCellName, FIRSTSTEPSTR + this.newCellName);
                    this.getResultProps().put("firststeps", "true");
                }
                catch (Throwable th) {
                    this.getResultProps().put("setupcmdline", (Object)false);
                    this.getResultProps().put("setupcmdline_exc", th.getMessage());
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Setup cmd failed", th);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixSetupCmd");
        }
    }

    private void readAndReplace(String fileName, String oldStr, String newStr) throws Exception {
        File f;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readAndReplace - " + fileName);
        }
        if ((f = new File(fileName)).exists()) {
            FileInputStream fin = new FileInputStream(f);
            int avail = fin.available();
            byte[] bar = new byte[avail];
            fin.read(bar);
            fin.close();
            String contents = new String(bar);
            if (contents.contains(oldStr)) {
                contents = contents.replaceAll(oldStr, newStr);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "replaced " + oldStr + " with " + newStr);
                }
                FileOutputStream os = new FileOutputStream(fileName);
                os.write(contents.getBytes());
                os.flush();
                os.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readAndReplace - " + fileName);
        }
    }

    public Properties getResultProps() {
        if (this.resultProps == null) {
            this.resultProps = new Properties();
        }
        return this.resultProps;
    }
}

