/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.authzgroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.authorizer.ResourceInstanceRelations;
import com.ibm.ws.management.authorizer.RoleRelations;
import com.ibm.ws.management.commands.authzgroup.AuditAuthzCommandProvider;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.util.AdminCommandHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class AuthzGroupCommandsProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(AuthzGroupCommandsProvider.class, "management", "com.ibm.ws.management.resources.configservice");

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        String cmdName = metadata2.getName();
        if (cmdName.equals("addResourceToAuthorizationGroup")) {
            return new AddResourceToAuthorizationGroupCmd(metadata2);
        }
        return super.createCommand(metadata2);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        String cmdName = cmdData.getName();
        if (cmdName.equals("addResourceToAuthorizationGroup")) {
            return new AddResourceToAuthorizationGroupCmd(cmdData);
        }
        return super.loadCommand(cmdData);
    }

    public String createAuthorizationGroup(AbstractAdminCommand cmd) throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthorizationGroup", new Object[]{cmd});
        }
        ObjectName authzGrpID = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + authzGrpName);
            }
            if (authzGrpName == null || authzGrpName.equals("CellAuthorizationGroup") || authzGrpName.equals("merge")) {
                throw new InvalidParameterValueException(cmd.getName(), "authorizationGroupName", authzGrpName);
            }
            ObjectName[] newAuthzGroup = this.getAuthzGroupObjectName(session, configService, authzGrpName);
            if (newAuthzGroup != null && newAuthzGroup.length > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authorization Group: " + authzGrpName + " already existed");
                }
                throw new InvalidParameterValueException(cmd.getName(), "authorizationGroupName", authzGrpName);
            }
            ObjectName cell = this.getCellObjectName(session, configService);
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, "name", authzGrpName);
            authzGrpID = configService.createConfigData(session, cell, "AuthorizationGroup", "AuthorizationGroup", attrList);
            this.createAuthzTableDocument(session, configService, authzGrpID);
            this.createAuditAuthzTableDocument(session, configService, authzGrpID);
            String authzGroupConfigId = ConfigServiceHelper.getConfigDataId(authzGrpID).toString();
            AttributeList resAttrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(resAttrList, "resourceName", authzGroupConfigId);
            ConfigServiceHelper.setAttributeValue(resAttrList, "resourceType", "AuthorizationGroup");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resources attributes to be set are " + resAttrList);
            }
            configService.createConfigData(session, authzGrpID, "members", "AuthorizationGroupMember", resAttrList);
            string = authzGroupConfigId;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.createAuthorizationGroup", (String)"88");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createAuthorizationGroup", authzGrpID);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuthorizationGroup", authzGrpID);
        }
        return string;
    }

    public boolean deleteAuthorizationGroup(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAuthorizationGroup", new Object[]{cmd});
        }
        try {
            ObjectName authzGrpObjName;
            ObjectName[] authzGrps;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name to delete is " + authzGrpName);
            }
            if ((authzGrps = this.getAuthzGroupObjectName(session, configService, authzGrpName)) != null && authzGrps.length == 1) {
                authzGrpObjName = authzGrps[0];
                ObjectName[] authzTables = this.getAdminAuthzTables(session, configService, authzGrpObjName);
                ObjectName authzTable = null;
                if (authzTables != null && authzTables.length != 0) {
                    for (int i = 0; i < authzTables.length; ++i) {
                        String authzFileName = ConfigServiceHelper.getDisplayName(authzTables[i]);
                        if (!authzFileName.equals("admin-authz.xml")) continue;
                        authzTable = authzTables[i];
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Found : " + authzFileName);
                        break;
                    }
                    configService.deleteConfigData(session, authzTable);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "No authorization group: " + authzGrpName + " found or more than one authorization group found");
                }
                throw new InvalidParameterValueException(cmd.getName(), "authorizationGroupName", authzGrpName);
            }
            configService.deleteConfigData(session, authzGrpObjName);
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.createAuthorizationGroup", (String)"88");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteAuthorizationGroup");
            }
        }
    }

    public boolean removeResourceFromAuthorizationGroup(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAuthorizationGroup", new Object[]{cmd});
        }
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            String resourceName = (String)cmd.getParameter("resourceName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorization group name is " + authzGrpName);
            }
            ObjectName resource = null;
            if (resourceName.contains("=")) {
                ObjectName[] resourceObjectNames = null;
                resourceObjectNames = AuthzGroupCommandsProvider.isResourceNameAnAssetsBlasOrCus(resourceName) ? AdminCommandHelper.getResourceForAssetsBlasOrCus((ConfigService)configService, (Session)session, (String)resourceName) : AdminCommandHelper.getResources((Session)session, (ConfigService)configService, (String)resourceName);
                if (resourceObjectNames == null || resourceObjectNames.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resource is not unique or does not exist. " + resourceName);
                    }
                    throw new InvalidParameterValueException(cmd.getName(), "resourceName", resourceName);
                }
                resource = resourceObjectNames[0];
            } else {
                resource = ConfigServiceHelper.createObjectName(new ConfigDataId(resourceName));
            }
            ObjectName authzGroup = null;
            if (authzGrpName == null || authzGrpName.equals("")) {
                ObjectName[] authzGroups2 = this.getAuthzGroupObjectName(session, configService, null);
                authzGroup = this.findAuthzGroupsWithGivenResource(session, configService, authzGroups2, resource);
            } else {
                ObjectName[] authzGroupsList = this.getAuthzGroupObjectName(session, configService, authzGrpName);
                if (authzGroupsList != null) {
                    authzGroup = authzGroupsList[0];
                }
            }
            if (authzGroup == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot find the authorization group which contains the resource, " + resourceName);
                }
                throw new InvalidParameterValueException(cmd.getName(), "resourceName", resourceName);
            }
            String resourceID = ConfigServiceHelper.getConfigDataId(resource).toString();
            String resourceType = ResourceInstanceRelations.getInstance().getResourceType(resourceID);
            if (resourceType != null && resourceType.equals("AuthorizationGroup")) {
                throw new InvalidParameterValueException(cmd.getName(), "resourceName", resourceName);
            }
            ArrayList members = (ArrayList)configService.getAttribute(session, authzGroup, "members", false);
            for (int j = 0; j < members.size(); ++j) {
                ObjectName member = (ObjectName)members.get(j);
                String memberName = (String)configService.getAttribute(session, member, "resourceName");
                if (!memberName.equals(resourceID)) continue;
                configService.deleteConfigData(session, member);
                break;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.createAuthorizationGroup", (String)"88");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteAuthorizationGroup");
            }
        }
    }

    public boolean mapUsersToAdminRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapUsersToAdminRole", new Object[]{cmd});
        }
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            String roleName = (String)cmd.getParameter("roleName");
            String[] userids = (String[])cmd.getParameter("userids");
            String[] accessIds = (String[])cmd.getParameter("accessids");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + authzGrpName);
            }
            if (!(lst = this.addRemoveRoleOrGroupID(session, configService, cmd.getName(), authzGrpName, roleName, userids, null, accessIds)).isEmpty()) {
                StringBuffer msg = new StringBuffer("Invalid userids are : ");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                throw new InvalidParameterValueException(cmd.getName(), "userids", msg.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.mapUsersToAdminRole", (String)"200");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapUsersToAdminRole");
            }
        }
    }

    public boolean mapGroupsToAdminRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapGroupsToAdminRole", new Object[]{cmd});
        }
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            String roleName = (String)cmd.getParameter("roleName");
            String[] gids = (String[])cmd.getParameter("groupids");
            String[] accessIds = (String[])cmd.getParameter("accessids");
            String[] specialSubjects = (String[])cmd.getParameter("specialSubjects");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + authzGrpName);
            }
            if (!(lst = this.addRemoveRoleOrGroupID(session, configService, cmd.getName(), authzGrpName, roleName, gids, specialSubjects, accessIds)).isEmpty()) {
                StringBuffer msg = new StringBuffer("Invalid groupids are : ");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                throw new InvalidParameterValueException(cmd.getName(), "groupids", msg.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.mapGroupsToAdminRole", (String)"241");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapGroupsToAdminRole");
            }
        }
    }

    public boolean removeUsersFromAdminRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUsersFromAdminRole", new Object[]{cmd});
        }
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            String roleName = (String)cmd.getParameter("roleName");
            String[] userids = (String[])cmd.getParameter("userids");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + authzGrpName);
            }
            if (!(lst = this.addRemoveRoleOrGroupID(session, configService, cmd.getName(), authzGrpName, roleName, userids, null, null)).isEmpty()) {
                StringBuffer msg = new StringBuffer("Invalid userids are : ");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                throw new InvalidParameterValueException(cmd.getName(), "userids", msg.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.removeUsersFromAdminRole", (String)"242");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeUsersFromAdminRole");
            }
        }
    }

    public boolean removeGroupsFromAdminRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeGroupsFromAdminRole", new Object[]{cmd});
        }
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            String roleName = (String)cmd.getParameter("roleName");
            String[] gids = (String[])cmd.getParameter("groupids");
            String[] specialSubjects = (String[])cmd.getParameter("specialSubjects");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + authzGrpName);
            }
            if (!(lst = this.addRemoveRoleOrGroupID(session, configService, cmd.getName(), authzGrpName, roleName, gids, specialSubjects, null)).isEmpty()) {
                StringBuffer msg = new StringBuffer("Invalid groupids are : ");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                throw new InvalidParameterValueException(cmd.getName(), "groupids", msg.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.removeGroupsFromAdminRole", (String)"258");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeGroupsFromAdminRole");
            }
        }
    }

    public List listAuthorizationGroups(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationGroups", new Object[]{cmd});
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            ObjectName[] authzGrps = this.getAuthzGroupObjectName(session, configService, null);
            if (authzGrps != null) {
                for (int i = 0; i < authzGrps.length; ++i) {
                    ObjectName authzGroup = authzGrps[i];
                    String authzGrpName = (String)configService.getAttribute(session, authzGroup, "name", false);
                    if (!this.checkAccess(authzGroup)) continue;
                    result.add(authzGrpName);
                }
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listAuthorizationGroups", (String)"300");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationGroups", result);
            }
        }
    }

    public List listResourcesOfAuthorizationGroup(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResourcesOfAuthorizationGroup", new Object[]{cmd});
        }
        ArrayList result = new ArrayList();
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            ObjectName[] authzGrps = this.getAuthzGroupObjectName(session, configService, authzGrpName);
            if (authzGrps != null && authzGrps.length == 1) {
                ObjectName authzGrpObjName = authzGrps[0];
                List list = this.getResourcesFromAuthorizationGroup(session, configService, authzGrpObjName);
                return list;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No authorization group: " + authzGrpName + " found or more than one authorization group found");
            }
            List list = null;
            return list;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listResourcesOfAuthorizationGroup", (String)"316");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listResourcesOfAuthorizationGroup", result);
            }
        }
    }

    public List listAuthorizationGroupsOfResource(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationGroupsOfResource", new Object[]{cmd});
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String resourceName = (String)cmd.getParameter("resourceName");
            Boolean traverseContainedResources = (Boolean)cmd.getParameter("traverseContainedResources");
            ObjectName[] resourceObjectNameList = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceName=" + resourceName);
            }
            if ((resourceObjectNameList = AuthzGroupCommandsProvider.isResourceNameAnAssetsBlasOrCus(resourceName) ? AdminCommandHelper.getResourceForAssetsBlasOrCus((ConfigService)configService, (Session)session, (String)resourceName) : AdminCommandHelper.getResources((Session)session, (ConfigService)configService, (String)resourceName)) != null && resourceObjectNameList.length == 1) {
                ObjectName[] authzGrps;
                ObjectName resourceObjectName = resourceObjectNameList[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resource found is " + resourceObjectName);
                }
                ArrayList<String> resourcesToFind = new ArrayList<String>();
                String resourceConfigId = ConfigServiceHelper.getConfigDataId(resourceObjectName).toString();
                resourcesToFind.add(resourceConfigId);
                if (traverseContainedResources != null && traverseContainedResources.booleanValue()) {
                    String resourceType = ResourceInstanceRelations.getInstance().getResourceType(resourceConfigId);
                    if (resourceType != null && !ResourceInstanceRelations.getInstance().isValidResourceType(resourceType)) {
                        throw new InvalidParameterValueException(cmd.getName(), "resourceName", resourceName);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "traverse the parent");
                    }
                    HashMap map = ResourceInstanceRelations.getInstance().getAllParentInstances(session, configService, resourceConfigId, resourceType);
                    for (String parentType : map.keySet()) {
                        List parentIDs = (List)map.get(parentType);
                        for (String parentID : parentIDs) {
                            resourcesToFind.add(parentID);
                        }
                    }
                }
                if ((authzGrps = this.getAuthzGroupObjectName(session, configService, null)) != null) {
                    block7: for (int i = 0; i < authzGrps.length; ++i) {
                        ObjectName authzGroup = authzGrps[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "authzGroup is " + authzGroup);
                        }
                        ArrayList authzGroupResources = (ArrayList)this.getResourcesFromAuthorizationGroup(session, configService, authzGroup);
                        for (int j = 0; j < resourcesToFind.size(); ++j) {
                            if (!authzGroupResources.contains(resourcesToFind.get(j))) continue;
                            String authzGrpName = (String)configService.getAttribute(session, authzGroup, "name", false);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Authorization group:  " + authzGrpName + ".  Contains resource: " + resourcesToFind.get(j));
                            }
                            result.add(authzGrpName);
                            continue block7;
                        }
                    }
                }
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listAuthorizationGroupsOfResource", (String)"361");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationGroupsOfResource", result);
            }
        }
    }

    public HashMap listResourcesForUserID(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResourcesForUserID", new Object[]{cmd});
        }
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String userid = (String)cmd.getParameter("userid");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user id to find is " + userid);
            }
            if (!this.isUserAllowed(userid, false)) {
                throw new Exception("Access Denied for " + cmd.getName());
            }
            HashMap hashMap = this.listAuthzGrpOrResourcesAsSystem(session, configService, true, "users", userid);
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listResourcesForUserID", (String)"390");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listResourcesForUserID");
            }
        }
    }

    public HashMap listResourcesForGroupID(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResourcesForGroupID", new Object[]{cmd});
        }
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String groupid = (String)cmd.getParameter("groupid");
            String type = "groups";
            if (groupid.equals("EVERYONE")) {
                groupid = "EveryoneExt";
                type = "specialSubjects";
            } else if (groupid.equals("ALLAUTHENTICATED")) {
                groupid = "AllAuthenticatedUsersExt";
                type = "specialSubjects";
            } else if (groupid.equals("ALLAUTHENTICATEDINTRUSTEDREALMS")) {
                groupid = "AllAuthenticatedUsersInTrustedRealmsExt";
                type = "specialSubjects";
            }
            if (!this.isUserAllowed(groupid, true)) {
                throw new Exception("Access Denied for " + cmd.getName());
            }
            HashMap hashMap = this.listAuthzGrpOrResourcesAsSystem(session, configService, true, type, groupid);
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listResourcesForGroupID", (String)"454");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listResourcesForGroupID");
            }
        }
    }

    public HashMap listAuthorizationGroupsForUserID(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationGroupsForUserID", new Object[]{cmd});
        }
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String userid = (String)cmd.getParameter("userid");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user id to find is " + userid);
            }
            HashMap hashMap = this.listAuthzGrpOrResources(session, configService, false, "users", userid);
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listResourcesForUser", (String)"390");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationGroupsForUser");
            }
        }
    }

    public HashMap listAuthorizationGroupsForGroupID(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationGroupsForGroupID", new Object[]{cmd});
        }
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String groupid = (String)cmd.getParameter("groupid");
            String type = "groups";
            if (groupid.equals("EVERYONE")) {
                groupid = "EveryoneExt";
                type = "specialSubjects";
            } else if (groupid.equals("ALLAUTHENTICATED")) {
                groupid = "AllAuthenticatedUsersExt";
                type = "specialSubjects";
            } else if (groupid.equals("ALLAUTHENTICATEDINTRUSTEDREALMS")) {
                groupid = "AllAuthenticatedUsersInTrustedRealmsExt";
                type = "specialSubjects";
            }
            HashMap hashMap = this.listAuthzGrpOrResources(session, configService, false, type, groupid);
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listResourcesForUser", (String)"421");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationGroupsForGroup");
            }
        }
    }

    private boolean isRoleNameACustomRole(String roleName) {
        boolean retValue = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRoleNameACustomRole", retValue);
        }
        List monitorParents = RoleRelations.getInstance().getAllParentRoles("monitor");
        if (!(roleName.equals("auditor") || roleName.equals("iscadmins") || roleName.equals("nobody") || roleName.equals("monitor") || monitorParents.contains(roleName))) {
            retValue = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRoleNameACustomRole", retValue);
        }
        return retValue;
    }

    public ArrayList listAuthorizationRoles(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationRoles", new Object[]{cmd});
        }
        ArrayList<Object> resourceRoleList = null;
        try {
            ObjectName[] auditAuthzTables;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String roleType = (String)cmd.getParameter("roleType");
            ObjectName authzGrpObjName = this.getCellObjectName(session, configService);
            ObjectName[] authzTables = this.getAdminAuthzTables(session, configService, authzGrpObjName);
            ObjectName authzTable = null;
            ObjectName auditAuthzTable = null;
            if (authzTables != null && authzTables.length == 0) {
                ArrayList arrayList = null;
                return arrayList;
            }
            ArrayList<String> customRolesList = new ArrayList<String>();
            ArrayList<String> builtInRolesList = new ArrayList<String>();
            for (int i = 0; i < authzTables.length; ++i) {
                String authzFileName = ConfigServiceHelper.getDisplayName(authzTables[i]);
                if (!authzFileName.equals("admin-authz.xml")) continue;
                authzTable = authzTables[i];
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found authzFileName: " + authzFileName);
                break;
            }
            ArrayList authorizationsList = (ArrayList)configService.getAttribute(session, authzTable, "authorizations", false);
            resourceRoleList = new ArrayList<Object>();
            for (int i = 0; i < authorizationsList.size(); ++i) {
                ObjectName authz = (ObjectName)authorizationsList.get(i);
                ObjectName authzRoleID = (ObjectName)configService.getAttribute(session, authz, "role", false);
                String roleName = this.resolveRoleIDToRoleName(session, configService, authzTable, authzRoleID);
                if (this.isRoleNameACustomRole(roleName)) {
                    customRolesList.add(roleName);
                    continue;
                }
                builtInRolesList.add(roleName);
            }
            AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
            if ((!SecurityContext.isSecurityEnabled() || aa == null || aa.isCallerInRole("auditor")) && (auditAuthzTables = AuditAuthzCommandProvider.getAuditAuthzTablesPub(session, configService, authzGrpObjName)) != null && auditAuthzTables.length > 0) {
                for (int i = 0; i < auditAuthzTables.length; ++i) {
                    String auditAuthzFileName = ConfigServiceHelper.getDisplayName(auditAuthzTables[i]);
                    if (!auditAuthzFileName.equals("audit-authz.xml")) continue;
                    auditAuthzTable = auditAuthzTables[i];
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Found auditAuthzFileName: " + auditAuthzFileName);
                    break;
                }
                ArrayList auditAuthorizationList = (ArrayList)configService.getAttribute(session, auditAuthzTable, "authorizations", false);
                for (int i = 0; i < auditAuthorizationList.size(); ++i) {
                    ObjectName auditAuthz = (ObjectName)auditAuthorizationList.get(i);
                    ObjectName authzRoleID = (ObjectName)configService.getAttribute(session, auditAuthz, "role", false);
                    String roleName = this.resolveRoleIDToRoleName(session, configService, auditAuthzTable, authzRoleID);
                    Tr.debug(tc, "roleName=" + roleName);
                    if (!roleName.equals("auditor")) continue;
                    builtInRolesList.add(roleName);
                    break;
                }
            }
            if (!(customRolesList.size() <= 0 || null != roleType && roleType.equalsIgnoreCase("Builtin"))) {
                Object[] customRolesArray = customRolesList.toArray();
                Arrays.sort(customRolesArray);
                for (int i = 0; i < customRolesArray.length; ++i) {
                    Tr.debug(tc, " Custom customRolesArray[" + i + "]=" + customRolesArray[i]);
                    resourceRoleList.add(customRolesArray[i]);
                }
            }
            if (!(builtInRolesList.size() <= 0 || null != roleType && roleType.equalsIgnoreCase("Custom"))) {
                Object[] adminRolesArray = builtInRolesList.toArray();
                Arrays.sort(adminRolesArray);
                for (int i = 0; i < adminRolesArray.length; ++i) {
                    Tr.debug(tc, " Builtin adminRolesArray[" + i + "]=" + adminRolesArray[i]);
                    resourceRoleList.add(adminRolesArray[i]);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "admin-authz.xml name is " + authzTable.getCanonicalName());
            }
            ArrayList<Object> arrayList = resourceRoleList;
            return arrayList;
        }
        catch (Exception cse) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught in AuthzGroupCommandsProvider.listAuthorizationRoles", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationRoles inside AuthzGroupCommandsProvider aaaaaa", resourceRoleList);
            }
        }
    }

    public HashMap listGroupIDsOfAuthorizationGroup(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listGroupIDsOfAuthorizationGroup", new Object[]{cmd});
        }
        HashMap resourceRoleMap = null;
        try {
            HashMap hashMap = resourceRoleMap = this.listIDsOfAuthozGroup(cmd, "groups");
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listGroupIDsOfAuthorizationGroup", (String)"568");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listGroupIDsOfAuthorizationGroup", resourceRoleMap);
            }
        }
    }

    public HashMap listUserIDsOfAuthorizationGroup(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listUserIDsOfAuthorizationGroup", new Object[]{cmd});
        }
        HashMap resourceRoleMap = null;
        try {
            HashMap hashMap = resourceRoleMap = this.listIDsOfAuthozGroup(cmd, "users");
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listUserIDsOfAuthorizationGroup", (String)"568");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listUserIDsOfAuthorizationGroup inside AuthzGroupCommandsProvider bbbbb", resourceRoleMap);
            }
        }
    }

    private HashMap listIDsOfAuthozGroup(AbstractAdminCommand cmd, String type) throws Exception {
        HashMap hashMap;
        ObjectName authzTable;
        ObjectName[] authzTables;
        Session session;
        ConfigService configService;
        HashMap resourceRoleMap;
        block22: {
            ObjectName authzGrpObjName;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listUserIDsForAuthorizationGroup", new Object[]{cmd});
            }
            resourceRoleMap = null;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            configService = helper.getConfigService();
            session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            if (authzGrpName == null || authzGrpName.equals("CellAuthorizationGroup")) {
                authzGrpObjName = this.getCellObjectName(session, configService);
            } else {
                ObjectName[] authzGroup = this.getAuthzGroupObjectName(session, configService, authzGrpName);
                if (authzGroup == null || authzGroup.length <= 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Authorization Group: " + authzGrpName + " does not exist");
                    }
                    throw new InvalidParameterValueException(cmd.getName(), "authorizationGroupName", authzGrpName);
                }
                authzGrpObjName = authzGroup[0];
            }
            authzTables = this.getAdminAuthzTables(session, configService, authzGrpObjName);
            authzTable = null;
            if (authzTables == null || authzTables.length != 0) break block22;
            HashMap hashMap2 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listUserIDsOfAuthorizationGroup", resourceRoleMap);
            }
            return hashMap2;
        }
        try {
            for (int i = 0; i < authzTables.length; ++i) {
                String authzFileName = ConfigServiceHelper.getDisplayName(authzTables[i]);
                if (!authzFileName.equals("admin-authz.xml")) continue;
                authzTable = authzTables[i];
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found : " + authzFileName);
                break;
            }
            resourceRoleMap = this.createResourceRoleMap();
            ArrayList authorizationsList = (ArrayList)configService.getAttribute(session, authzTable, "authorizations", false);
            for (int k = 0; k < authorizationsList.size(); ++k) {
                ObjectName authz = (ObjectName)authorizationsList.get(k);
                ObjectName authzRoleID = (ObjectName)configService.getAttribute(session, authz, "role", false);
                String roleName = this.resolveRoleIDToRoleName(session, configService, authzTable, authzRoleID);
                ArrayList ids = (ArrayList)configService.getAttribute(session, authz, type, false);
                ArrayList<String> resourcesList = (ArrayList<String>)resourceRoleMap.get(roleName);
                if (resourcesList == null) {
                    resourcesList = new ArrayList<String>();
                }
                resourceRoleMap.put(roleName, resourcesList);
                for (int l = 0; l < ids.size(); ++l) {
                    ObjectName id = (ObjectName)ids.get(l);
                    String IDName = (String)configService.getAttribute(session, id, "name", false);
                    resourcesList.add(IDName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Authorization role:  " + roleName + ".  Name:  " + IDName);
                }
                if (type == null || !type.equals("groups")) continue;
                ArrayList specialSubjectsids = (ArrayList)configService.getAttribute(session, authz, "specialSubjects", false);
                for (int m = 0; m < specialSubjectsids.size(); ++m) {
                    ObjectName specialSubject = (ObjectName)specialSubjectsids.get(m);
                    String specialSubjectType = ConfigServiceHelper.getConfigDataType(specialSubject);
                    if (specialSubjectType.equals("EveryoneExt")) {
                        resourcesList.add("EVERYONE");
                        continue;
                    }
                    if (specialSubjectType.equals("AllAuthenticatedUsersExt")) {
                        resourcesList.add("ALLAUTHENTICATED");
                        continue;
                    }
                    if (!specialSubjectType.equals("AllAuthenticatedUsersInTrustedRealmsExt")) continue;
                    resourcesList.add("ALLAUTHENTICATEDINTRUSTEDREALMS");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "admin-authz.xml name is " + authzTable.getCanonicalName());
            }
            hashMap = resourceRoleMap;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listUserIDsOfAuthorizationGroup", (String)"568");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "listUserIDsOfAuthorizationGroup", resourceRoleMap);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listUserIDsOfAuthorizationGroup", resourceRoleMap);
        }
        return hashMap;
    }

    private ObjectName[] getAuthzGroupObjectName(Session session, ConfigService configService, String authzGrpName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGroupObjectName", authzGrpName);
        }
        ObjectName[] result = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "AuthorizationGroup");
        ObjectName[] authzGroups2 = configService.queryConfigObjects(session, null, pattern, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzGroups ObjectNames are " + authzGroups2);
        }
        if (authzGrpName == null || authzGrpName.equals("")) {
            result = authzGroups2;
        } else if (authzGroups2 != null) {
            for (int i = 0; i < authzGroups2.length; ++i) {
                ObjectName authzGrp = authzGroups2[i];
                String name = (String)configService.getAttribute(session, authzGrp, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authorization group name to check:  " + name);
                }
                if (!name.equals(authzGrpName)) continue;
                result = new ObjectName[]{authzGrp};
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthzGroupObjectName", result);
        }
        return result;
    }

    private ObjectName findAuthzGroupsWithGivenResource(Session session, ConfigService configService, ObjectName[] authzGroups2, ObjectName resource) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGroup", new Object[]{authzGroups2, resource});
        }
        String resourceID = ConfigServiceHelper.getConfigDataId(resource).toString();
        ObjectName result = null;
        boolean found = false;
        for (int i = 0; i < authzGroups2.length; ++i) {
            ObjectName authzGroup = authzGroups2[i];
            ArrayList members = (ArrayList)configService.getAttribute(session, authzGroup, "members", false);
            for (int j = 0; j < members.size(); ++j) {
                ObjectName member = (ObjectName)members.get(j);
                String memberName = (String)configService.getAttribute(session, member, "resourceName");
                if (!memberName.equals(resourceID)) continue;
                result = authzGroup;
                found = true;
                break;
            }
            if (found) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findResourceInAuthzGroups", result);
        }
        return result;
    }

    private ObjectName resolveRoleNameToRoleID(Session session, ConfigService configService, ObjectName authzTable, String roleName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveRoleNameToRoleID", roleName);
        }
        ObjectName result = null;
        ArrayList roleList = (ArrayList)configService.getAttribute(session, authzTable, "roles", false);
        for (int i = 0; i < roleList.size(); ++i) {
            ObjectName roles = (ObjectName)roleList.get(i);
            String roleRoleName = (String)configService.getAttribute(session, roles, "roleName", false);
            if (!roleRoleName.equalsIgnoreCase(roleName)) continue;
            result = roles;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveRoleNameToRoleID", result);
        }
        return result;
    }

    private String resolveRoleIDToRoleName(Session session, ConfigService configService, ObjectName authzTable, ObjectName roleID) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveRoleIDToRoleName", roleID);
        }
        String result = null;
        ArrayList roleList = (ArrayList)configService.getAttribute(session, authzTable, "roles", false);
        for (int i = 0; i < roleList.size(); ++i) {
            ObjectName roles = (ObjectName)roleList.get(i);
            if (!roles.equals(roleID)) continue;
            result = (String)configService.getAttribute(session, roles, "roleName", false);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveRoleIDToRoleName", result);
        }
        return result;
    }

    private List addRemoveRoleOrGroupID(Session session, ConfigService configService, String cmdName, String authzGrpName, String roleName, String[] ids, String[] specialSubjects, String[] aIds) throws ConfigServiceException, ConnectorException, InvalidParameterValueException {
        ObjectName authorizationRole;
        ObjectName authorization;
        int i;
        ObjectName predefinedRoleObjectName;
        ObjectName authzGroup;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRoleOrGroupID", new Object[]{cmdName, authzGrpName, roleName, ids});
        }
        ArrayList<String> failedList = new ArrayList<String>();
        if (authzGrpName == null || authzGrpName.equals("CellAuthorizationGroup")) {
            authzGroup = this.getCellObjectName(session, configService);
        } else {
            ObjectName[] authzGrps = this.getAuthzGroupObjectName(session, configService, authzGrpName);
            if (authzGrps == null || authzGrps.length != 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authorization Group: " + authzGrpName + " does not exist");
                }
                throw new InvalidParameterValueException(cmdName, "authorizationGroupName", authzGrpName);
            }
            authzGroup = authzGrps[0];
        }
        ObjectName[] authzTables = this.getAdminAuthzTables(session, configService, authzGroup);
        ObjectName authzTable = null;
        if (authzTables != null && authzTables.length == 0) {
            authzTable = this.createAuthzTableDocument(session, configService, authzGroup);
        } else {
            for (int i2 = 0; i2 < authzTables.length; ++i2) {
                String authzFileName = ConfigServiceHelper.getDisplayName(authzTables[i2]);
                if (!authzFileName.equals("admin-authz.xml")) continue;
                authzTable = authzTables[i2];
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found : " + authzFileName);
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "admin-authz.xml name is " + authzTable.getCanonicalName());
        }
        if ((predefinedRoleObjectName = this.resolveRoleNameToRoleID(session, configService, authzTable, roleName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Role " + roleName + " does not exist");
            }
            throw new InvalidParameterValueException(cmdName, "roleName", roleName);
        }
        ArrayList authorizationsList = (ArrayList)configService.getAttribute(session, authzTable, "authorizations", false);
        boolean found = false;
        for (i = 0; i < authorizationsList.size(); ++i) {
            authorization = (ObjectName)authorizationsList.get(i);
            authorizationRole = (ObjectName)configService.getAttribute(session, authorization, "role", false);
            if (!authorizationRole.equals(predefinedRoleObjectName)) continue;
            found = true;
            break;
        }
        if (!found) {
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("role", predefinedRoleObjectName));
            configService.createConfigDataByTemplate(session, authzTable, "authorizations", attrList, null);
            authorizationsList = (ArrayList)configService.getAttribute(session, authzTable, "authorizations", false);
        }
        for (i = 0; i < authorizationsList.size(); ++i) {
            authorization = (ObjectName)authorizationsList.get(i);
            authorizationRole = (ObjectName)configService.getAttribute(session, authorization, "role", false);
            if (!authorizationRole.equals(predefinedRoleObjectName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorizationRole found" + authorizationRole.getCanonicalName());
            }
            if (ids != null) {
                for (int j = 0; j < ids.length; ++j) {
                    ObjectName roleToDelete;
                    String id = ids[j];
                    String aId = aIds != null ? aIds[j] : null;
                    AttributeList roleAttrList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(roleAttrList, "name", id);
                    if (aId != null) {
                        ConfigServiceHelper.setAttributeValue(roleAttrList, "accessId", aId);
                    }
                    if (cmdName.equals("mapUsersToAdminRole")) {
                        if (this.findRoleIDInAuthorization(session, configService, authorization, "users", id) == null) {
                            configService.createConfigData(session, authorization, "users", "UserExt", roleAttrList);
                            continue;
                        }
                        failedList.add(id);
                        continue;
                    }
                    if (cmdName.equals("removeUsersFromAdminRole")) {
                        roleToDelete = this.findRoleIDInAuthorization(session, configService, authorization, "users", id);
                        if (roleToDelete != null) {
                            configService.deleteConfigData(session, roleToDelete);
                            continue;
                        }
                        failedList.add(id);
                        continue;
                    }
                    if (cmdName.equals("mapGroupsToAdminRole")) {
                        if (this.findRoleIDInAuthorization(session, configService, authorization, "groups", id) == null) {
                            configService.createConfigData(session, authorization, "groups", "GroupExt", roleAttrList);
                            continue;
                        }
                        failedList.add(id);
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromAdminRole")) continue;
                    roleToDelete = this.findRoleIDInAuthorization(session, configService, authorization, "groups", id);
                    if (roleToDelete != null) {
                        configService.deleteConfigData(session, roleToDelete);
                        continue;
                    }
                    failedList.add(id);
                }
            }
            if (specialSubjects == null || specialSubjects.length <= 0) continue;
            for (int k = 0; k < specialSubjects.length; ++k) {
                String specSubj = specialSubjects[k];
                if (specSubj.equals("ALLAUTHENTICATED")) {
                    ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "AllAuthenticatedUsersExt");
                    if (cmdName.equals("mapGroupsToAdminRole")) {
                        if (checkRole == null) {
                            configService.createConfigData(session, authorization, "specialSubjects", "AllAuthenticatedUsersExt", new AttributeList());
                            continue;
                        }
                        failedList.add("ALLAUTHENTICATED");
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromAdminRole")) continue;
                    if (checkRole != null) {
                        configService.deleteConfigData(session, checkRole);
                        continue;
                    }
                    failedList.add("ALLAUTHENTICATED");
                    continue;
                }
                if (specSubj.equals("EVERYONE")) {
                    ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "EveryoneExt");
                    if (cmdName.equals("mapGroupsToAdminRole")) {
                        if (checkRole == null) {
                            configService.createConfigData(session, authorization, "specialSubjects", "EveryoneExt", new AttributeList());
                            continue;
                        }
                        failedList.add("EVERYONE");
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromAdminRole")) continue;
                    if (checkRole != null) {
                        configService.deleteConfigData(session, checkRole);
                        continue;
                    }
                    failedList.add("EVERYONE");
                    continue;
                }
                if (!specSubj.equals("ALLAUTHENTICATEDINTRUSTEDREALMS")) continue;
                ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "AllAuthenticatedUsersInTrustedRealmsExt");
                if (cmdName.equals("mapGroupsToAdminRole")) {
                    if (checkRole == null) {
                        configService.createConfigData(session, authorization, "specialSubjects", "AllAuthenticatedUsersInTrustedRealmsExt", new AttributeList());
                        continue;
                    }
                    failedList.add("ALLAUTHENTICATEDINTRUSTEDREALMS");
                    continue;
                }
                if (!cmdName.equals("removeGroupsFromAdminRole")) continue;
                if (checkRole != null) {
                    configService.deleteConfigData(session, checkRole);
                    continue;
                }
                failedList.add("ALLAUTHENTICATEDINTRUSTEDREALMS");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRoleOrGroupID");
        }
        return failedList;
    }

    private ObjectName createAuthzTableDocument(Session session, ConfigService configService, ObjectName authzGroup) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthzTableDocument", authzGroup);
        }
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, "fileName", "admin-authz.xml");
        ObjectName authzTblTemplate = null;
        ObjectName[] authzTblTemplates = configService.queryTemplates(session, "AuthorizationTableExt");
        for (int i = 0; authzTblTemplates != null && i < authzTblTemplates.length; ++i) {
            ObjectName on = authzTblTemplates[i];
            String cId = ConfigServiceHelper.getConfigDataId(on).toString();
            int inx = cId.lastIndexOf("|");
            int einx = cId.lastIndexOf("#");
            String name = cId.substring(inx + 1, einx);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name = " + name);
            }
            if (!name.equals("admin-authz.xml")) continue;
            authzTblTemplate = on;
        }
        ObjectName authzDoc = configService.createConfigDataByTemplate(session, authzGroup, "AuthorizationTableExt", attrList, authzTblTemplate);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuthzTableDocument", authzDoc);
        }
        return authzDoc;
    }

    private ObjectName createAuditAuthzTableDocument(Session session, ConfigService configService, ObjectName authzGroup) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuditAuthzTableDocument", authzGroup);
        }
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, "fileName", "audit-authz.xml");
        ObjectName authzTblTemplate = null;
        ObjectName[] authzTblTemplates = configService.queryTemplates(session, "AuthorizationTableExt");
        for (int i = 0; authzTblTemplates != null && i < authzTblTemplates.length; ++i) {
            ObjectName on = authzTblTemplates[i];
            String cId = ConfigServiceHelper.getConfigDataId(on).toString();
            int inx = cId.lastIndexOf("|");
            int einx = cId.lastIndexOf("#");
            String name = cId.substring(inx + 1, einx);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name = " + name);
            }
            if (!name.equals("audit-authz.xml")) continue;
            authzTblTemplate = on;
        }
        ObjectName authzDoc = configService.createConfigDataByTemplate(session, authzGroup, "AuthorizationTableExt", attrList, authzTblTemplate);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuditAuthzTableDocument", authzDoc);
        }
        return authzDoc;
    }

    private List getResourcesFromAuthorizationGroup(Session session, ConfigService configService, ObjectName authzGrpObjName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourcesFromAuthorizationGroup", authzGrpObjName);
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList membersList = (ArrayList)configService.getAttribute(session, authzGrpObjName, "members", false);
        for (int i = 0; i < membersList.size(); ++i) {
            ObjectName member = (ObjectName)membersList.get(i);
            String memberID = (String)configService.getAttribute(session, member, "resourceName", false);
            result.add(memberID);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourcesFromAuthorizationGroup", result);
        }
        return result;
    }

    private ObjectName findRoleIDInAuthorization(Session session, ConfigService configService, ObjectName authzGrp, String type, String id) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findRoleIDInAuthorization", new Object[]{authzGrp, type, id});
        }
        ObjectName result = null;
        ArrayList users = (ArrayList)configService.getAttribute(session, authzGrp, type, false);
        for (int i = 0; i < users.size(); ++i) {
            ObjectName role = (ObjectName)users.get(i);
            String roleName = !type.equals("specialSubjects") ? (String)configService.getAttribute(session, role, "name", false) : ConfigServiceHelper.getConfigDataType(role);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Role name to check is " + roleName);
            }
            if (!roleName.equals(id)) continue;
            result = role;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findRoleIDInAuthorization", result);
        }
        return result;
    }

    private HashMap createResourceRoleMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceRoleMap");
        }
        HashMap resourceRoleMap = new HashMap(5);
        ArrayList adminList = new ArrayList();
        ArrayList operatorList = new ArrayList();
        ArrayList configuratorList = new ArrayList();
        ArrayList monitorList = new ArrayList();
        ArrayList deployerList = new ArrayList();
        ArrayList asmList = new ArrayList();
        resourceRoleMap.put("administrator", adminList);
        resourceRoleMap.put("operator", operatorList);
        resourceRoleMap.put("configurator", configuratorList);
        resourceRoleMap.put("monitor", monitorList);
        resourceRoleMap.put("deployer", deployerList);
        resourceRoleMap.put("adminsecuritymanager", asmList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceRoleMap", resourceRoleMap);
        }
        return resourceRoleMap;
    }

    private HashMap listAuthzGrpOrResources(Session session, ConfigService configService, boolean isResources, String type, String id) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthzGrpOrResources", new Object[]{type, id});
        }
        HashMap resourceRoleMap = this.createResourceRoleMap();
        ObjectName[] cellGrp = new ObjectName[]{this.getCellObjectName(session, configService)};
        this.getIdOrResourcesFromAuthzGrp(session, configService, cellGrp, resourceRoleMap, isResources, true, type, id);
        ObjectName[] authzGrps = this.getAuthzGroupObjectName(session, configService, null);
        this.getIdOrResourcesFromAuthzGrp(session, configService, authzGrps, resourceRoleMap, isResources, false, type, id);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAuthzGrpOrResources", resourceRoleMap);
        }
        return resourceRoleMap;
    }

    private HashMap getIdOrResourcesFromAuthzGrp(Session session, ConfigService configService, ObjectName[] authzGrps, HashMap resourceRoleMap, boolean isResources, boolean isCell, String type, String id) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGrpOrResources", new Object[]{authzGrps, type, id});
        }
        if (authzGrps != null) {
            block0: for (int i = 0; i < authzGrps.length; ++i) {
                ObjectName authzGroup = authzGrps[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authzGroup is " + authzGroup);
                }
                ObjectName[] authzTables = this.getAdminAuthzTables(session, configService, authzGroup);
                for (int j = 0; j < authzTables.length; ++j) {
                    ObjectName authzTable = authzTables[j];
                    ArrayList authorizationsList = (ArrayList)configService.getAttribute(session, authzTable, "authorizations", false);
                    for (int k = 0; k < authorizationsList.size(); ++k) {
                        ObjectName authz = (ObjectName)authorizationsList.get(k);
                        ObjectName user = this.findRoleIDInAuthorization(session, configService, authz, type, id);
                        if (user == null) continue;
                        ObjectName authzRoleID = (ObjectName)configService.getAttribute(session, authz, "role", false);
                        String roleName = this.resolveRoleIDToRoleName(session, configService, authzTable, authzRoleID);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found matching userid:  " + id + "  Authorization role:  " + roleName);
                        }
                        ArrayList resourcesList = (ArrayList)resourceRoleMap.get(roleName);
                        if (isResources) {
                            if (isCell) {
                                resourcesList.add("Cell");
                                continue;
                            }
                            resourcesList.addAll(this.getResourcesFromAuthorizationGroup(session, configService, authzGroup));
                            continue;
                        }
                        if (isCell) {
                            resourcesList.add("CellAuthorizationGroup");
                            continue;
                        }
                        resourcesList.add((String)configService.getAttribute(session, authzGroup, "name", false));
                    }
                    if (isCell) continue block0;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthzGrpOrResources", resourceRoleMap);
        }
        return resourceRoleMap;
    }

    private ObjectName getCellObjectName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellObjectName", new Object[]{session, configService, this});
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + cell + ". Cell Name is " + ConfigServiceHelper.getDisplayName(cell));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellObjectName", cell);
        }
        return cell;
    }

    private boolean checkAccess(ObjectName obj) {
        AdminAuthorizer aa;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess ", obj);
        }
        if (obj == null) {
            return true;
        }
        String res = ConfigServiceHelper.getConfigDataId(obj).toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ResourceName = ", res);
        }
        if ((aa = AdminAuthorizerFactory.getAdminAuthorizer()) != null) {
            return aa.checkAccess(res, "adminsecuritymanager");
        }
        return true;
    }

    private void checkClusterMembers(ObjectName clusterObject, Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkClusterMembers", clusterObject);
        }
        List members = (List)configService.getAttribute(session, clusterObject, "members");
        for (AttributeList member : members) {
            String memberName = (String)ConfigServiceHelper.getAttributeValue(member, "memberName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberName", memberName);
            }
            String nodeName = (String)ConfigServiceHelper.getAttributeValue(member, "nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", nodeName);
            }
            if (this.isNodeValid(nodeName, session)) continue;
            throw new CommandValidationException("Cluster has one or more members that is not version 6.1 or greater. One of the members is " + memberName + " in node " + nodeName + " that is not version 6.1 or greater ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClusterMembers");
        }
    }

    private void checkApplicationTargets(ObjectName appObj, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkApplicationTargets", appObj);
        }
        EObject eobj = MOFUtil.convertToEObject(session, appObj);
        Deployment appDep = null;
        if (eobj instanceof Deployment) {
            appDep = (Deployment)eobj;
            TreeIterator iter = appDep.eAllContents();
            while (iter.hasNext()) {
                ServerTarget svrTarget;
                String nodeName;
                Object obj = iter.next();
                if (!(obj instanceof ServerTarget) || this.isNodeValid(nodeName = (svrTarget = (ServerTarget)obj).getNodeName(), session)) continue;
                throw new CommandValidationException("Application has one or more targets that is not version 6.1 or greater. One of the targets is " + nodeName + " that is not version 6.1 or greater ");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkApplicationTargets");
        }
    }

    private boolean isNodeValid(String nodeName, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeValid", nodeName);
        }
        boolean result = true;
        Properties props = new Properties();
        props.setProperty("CONFIG_SESSION", session.toString());
        ManagedObjectMetadataAccessor metadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(props);
        ManagedObjectMetadataHelper metadataHelper = new ManagedObjectMetadataHelper(metadataAccessor);
        if (nodeName != null) {
            String productVersion = metadataHelper.getNodeBaseProductVersion(nodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node product version is " + productVersion);
            }
            String nodeMajorVersion = metadataHelper.getNodeMajorVersion(nodeName);
            String nodeMinorVersion = metadataHelper.getNodeMinorVersion(nodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeMajorVersion is " + nodeMajorVersion + " nodeMinorVersion is " + nodeMinorVersion);
            }
            int nodeMajorVersionInt = Integer.parseInt(nodeMajorVersion);
            int nodeMinorVersionInt = Integer.parseInt(nodeMinorVersion);
            if (nodeMajorVersionInt < 7 && (nodeMajorVersionInt != 6 || nodeMinorVersionInt < 1)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resource is not a version 6.1 or above resource.  Version is " + productVersion);
                }
                result = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeValid", new Boolean(result));
        }
        return result;
    }

    private HashMap listAuthzGrpOrResourcesAsSystem(Session session, ConfigService configService, boolean isResources, String type, String id) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthzGrpOrResourcesAsSystem", new Object[]{new Boolean(isResources), type, id});
        }
        final Session sessionFinal = session;
        final ConfigService configServiceFinal = configService;
        final boolean isresourcesFinal = isResources;
        final String typeFinal = type;
        final String idFinal = id;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            HashMap obj = (HashMap)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthzGroupCommandsProvider.this.listAuthzGrpOrResources(sessionFinal, configServiceFinal, isresourcesFinal, typeFinal, idFinal);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthzGrpOrResourcesAsSystem", obj);
            }
            return obj;
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
    }

    private boolean isUserAllowed(String id, boolean isGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUserAllowed", new Object[]{id, new Boolean(isGroup)});
        }
        boolean res = false;
        AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
        if (aa == null) {
            return true;
        }
        if (aa.checkAccess("cell.xml", "adminsecuritymanager")) {
            res = true;
        } else if (isGroup) {
            try {
                Subject sub = SecurityHelper.retrieveSubject();
                WSCredential cred = SubjectHelper.getWSCredentialFromSubject((Subject)sub);
                String realm = cred.getRealmName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "realm", realm);
                }
                UserRegistry ur = ContextManagerFactory.getInstance().getRegistry(realm);
                String accessId = ur.getUniqueGroupId(id);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "accessId", accessId);
                }
                String securityName = cred.getSecurityName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "logged in user securityName", securityName);
                }
                List groups = ur.getGroupsForUser(securityName);
                Object[] grps = groups.toArray();
                for (int i = 0; i < grps.length; ++i) {
                    String grp = (String)grps[i];
                    String uniqueId = ur.getUniqueGroupId(grp);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "logged in user group uniqueId", uniqueId);
                    }
                    if (accessId == null || uniqueId == null) {
                        res = false;
                        continue;
                    }
                    if (!uniqueId.equalsIgnoreCase(accessId)) continue;
                    res = true;
                }
            }
            catch (Exception e) {
                res = false;
            }
        } else {
            try {
                Subject sub = SecurityHelper.retrieveSubject();
                WSCredential cred = SubjectHelper.getWSCredentialFromSubject((Subject)sub);
                String realm = cred.getRealmName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "realm", realm);
                }
                UserRegistry ur = ContextManagerFactory.getInstance().getRegistry(realm);
                String accessId = ur.getUniqueUserId(id);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "accessId", accessId);
                }
                String securityName = cred.getSecurityName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "logged in user securityName", securityName);
                }
                String uniqueId = ur.getUniqueUserId(securityName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "logged in user uniqueId", uniqueId);
                }
                if (accessId == null || uniqueId == null) {
                    res = false;
                } else if (uniqueId.equalsIgnoreCase(accessId)) {
                    res = true;
                }
            }
            catch (Exception e) {
                res = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserAllowed", new Boolean(res));
        }
        return res;
    }

    private ObjectName[] getAdminAuthzTables(Session session, ConfigService cs, ObjectName authzGroup) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminAuthzTables", new Object[]{session, authzGroup});
        }
        ArrayList<ObjectName> ons = new ArrayList<ObjectName>();
        ObjectName[] authzTbls = cs.getRelationship(session, authzGroup, "AuthorizationTableExt");
        for (int i = 0; authzTbls != null && i < authzTbls.length; ++i) {
            ObjectName on = authzTbls[i];
            String cId = ConfigServiceHelper.getConfigDataId(on).toString();
            int inx = cId.lastIndexOf("|");
            int einx = cId.lastIndexOf("#");
            String name = cId.substring(inx + 1, einx);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name = " + name);
            }
            if (!name.equals("admin-authz.xml")) continue;
            ons.add(on);
        }
        ObjectName[] aTables = ons.toArray(new ObjectName[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminAuthzTables", aTables);
        }
        return aTables;
    }

    private static boolean isResourceNameAnAssetsBlasOrCus(String resourceName) {
        String resourceType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isResourceNameAssetsBlasCus resourceName=", resourceName);
        }
        boolean retValue = false;
        if (AuthzGroupCommandsProvider.isScopeId(resourceName)) {
            StringTokenizer st = new StringTokenizer(resourceName, "=:");
            while (st.hasMoreTokens()) {
                String type = st.nextToken();
                if (type.equalsIgnoreCase("blas") || type.equalsIgnoreCase("cus") || type.equalsIgnoreCase("assets")) {
                    retValue = true;
                    break;
                }
                if (!st.hasMoreTokens()) continue;
                st.nextToken();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isResourceNameAssetsBlasCus retValue=" + retValue);
            }
            return retValue;
        }
        if (!retValue && null != resourceName && (resourceType = ResourceInstanceRelations.getInstance().getResourceType(resourceName)) != null && (resourceType.equals("BLA") || resourceType.equals("ASSET") || resourceType.equals("CUS"))) {
            retValue = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isResourceNameAssetsBlasCus retValue=" + retValue);
        }
        return retValue;
    }

    private static boolean isScopeId(String cfgId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isScopeId", new Object[]{cfgId});
        }
        boolean result = false;
        if (cfgId != null && cfgId.indexOf(61) > 0) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isScopeId", new Boolean(result));
        }
        return result;
    }

    public class AddResourceToAuthorizationGroupCmd
    extends AbstractAdminCommand {
        public AddResourceToAuthorizationGroupCmd(CommandMetadata inMetadata) throws CommandNotFoundException {
            super(inMetadata);
        }

        public AddResourceToAuthorizationGroupCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block20: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "execute");
                }
                CommandResultImpl result = new CommandResultImpl();
                result.reset();
                this.setCommandResult(result);
                try {
                    ObjectName[] authzGrps;
                    CommandProviderHelper helper = AuthzGroupCommandsProvider.this.getCommandProviderHelper();
                    ConfigService configService = helper.getConfigService();
                    Session session = this.getConfigSession();
                    String authzGrpName = (String)this.getParameter("authorizationGroupName");
                    String resourceName = (String)this.getParameter("resourceName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "authzGrpName=" + authzGrpName);
                        Tr.debug(tc, "resourceName=" + resourceName);
                    }
                    ObjectName resourceObjectName = null;
                    if (AuthzGroupCommandsProvider.isResourceNameAnAssetsBlasOrCus(resourceName)) {
                        Tr.debug(tc, "resourceName is an assets, blas, or cus");
                        resourceObjectName = AdminCommandHelper.getResourceForAssetsBlasOrCus((ConfigService)configService, (Session)session, (String)resourceName)[0];
                    } else {
                        resourceObjectName = resourceName.contains("=") ? AdminCommandHelper.getResources((Session)session, (ConfigService)configService, (String)resourceName)[0] : ConfigServiceHelper.createObjectName(new ConfigDataId(resourceName));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resourceObjectName " + resourceObjectName);
                    }
                    this.validate(session, configService, null, resourceObjectName);
                    String resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName).toString();
                    String resourceType = ResourceInstanceRelations.getInstance().getResourceType(resConfigID);
                    if (resourceType != null && resourceType.equals("AuthorizationGroup")) {
                        throw new InvalidParameterValueException(this.getName(), "resourceName", resourceName);
                    }
                    if (resourceType != null && !ResourceInstanceRelations.getInstance().isValidResourceType(resourceType)) {
                        throw new InvalidParameterValueException(this.getName(), "resourceName", resourceName);
                    }
                    AttributeList resAttrList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(resAttrList, "resourceName", resConfigID);
                    ConfigServiceHelper.setAttributeValue(resAttrList, "resourceType", resourceType);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resources attributes to be set are " + resAttrList);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "authzGroups name is " + authzGrpName);
                    }
                    if ((authzGrps = AuthzGroupCommandsProvider.this.getAuthzGroupObjectName(session, configService, authzGrpName)) != null && authzGrps.length > 0) {
                        ObjectName authzGrpObjName = authzGrps[0];
                        ObjectName createdMember = configService.createConfigData(session, authzGrpObjName, "members", "AuthorizationGroupMember", resAttrList);
                        HashMap map = ResourceInstanceRelations.getInstance().getAllParentInstances(session, configService, resConfigID, resourceType);
                        for (String parentType : map.keySet()) {
                            List parentIDs = (List)map.get(parentType);
                            for (String parentID : parentIDs) {
                                resAttrList.clear();
                                ConfigServiceHelper.setAttributeValue(resAttrList, "name", parentType);
                                ConfigServiceHelper.setAttributeValue(resAttrList, "value", parentID);
                                configService.createConfigData(session, createdMember, "memberProperties", "Property", resAttrList);
                            }
                        }
                        break block20;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No authorization group: " + authzGrpName + " found");
                    }
                    throw new InvalidParameterValueException(this.getName(), "authorizationGroupName", authzGrpName);
                }
                catch (Exception cse) {
                    FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.createAuthorizationGroup", (String)"88");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exception caught", cse);
                    }
                    result.setException(cse);
                }
                finally {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "execute");
                    }
                }
            }
        }

        public void validate(Session session, ConfigService configService, ObjectName[] authzGroups2, ObjectName resourceObjectName) throws CommandValidationException, ConfigServiceException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate", new Object[]{authzGroups2, resourceObjectName});
            }
            super.validate();
            try {
                String resourceType = ConfigServiceHelper.getConfigDataType(resourceObjectName);
                if (resourceType == null) {
                    String resString = ConfigServiceHelper.getConfigDataId(resourceObjectName).toString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resString=" + resString);
                    }
                    resourceType = ResourceInstanceRelations.getInstance().getResourceType(resString);
                }
                if (resourceType != null && !ResourceInstanceRelations.getInstance().isValidResourceType(resourceType)) {
                    throw new CommandValidationException("Invalid Type.  " + resourceType);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resourceType=" + resourceType);
                }
                if (authzGroups2 == null) {
                    authzGroups2 = AuthzGroupCommandsProvider.this.getAuthzGroupObjectName(session, configService, null);
                }
                if (AuthzGroupCommandsProvider.this.findAuthzGroupsWithGivenResource(session, configService, authzGroups2, resourceObjectName) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resource already existed. " + resourceObjectName);
                    }
                    throw new CommandValidationException("Resource already existed. " + resourceObjectName);
                }
                Properties resourceProps = ConfigServiceHelper.getObjectLocation(resourceObjectName);
                String nodeName = resourceProps.getProperty("node");
                if (nodeName != null) {
                    if (!AuthzGroupCommandsProvider.this.isNodeValid(nodeName, session)) {
                        throw new CommandValidationException("resource " + resourceObjectName + " cannot be part of any authorization group becuase, its product version is not 6.1 or greater. Check the corresponding node's product version. ");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resource type = ", resourceType);
                    }
                    if (resourceType.equals("Application") || resourceType.equals("Deployment")) {
                        AuthzGroupCommandsProvider.this.checkApplicationTargets(resourceObjectName, session);
                    }
                    if (resourceType.equals("ServerCluster") || resourceType.equals("Cluster")) {
                        AuthzGroupCommandsProvider.this.checkClusterMembers(resourceObjectName, session, configService);
                    }
                }
            }
            catch (ConfigServiceException cse) {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.AddResourceToAuthorizationGroupCmd", (String)"264");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.commands.authzgroup.AddResourceToAuthorizationGroupCmd", (String)"267");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", e);
                }
                throw new CommandValidationException(e, "Validation failed");
            }
            finally {
                Tr.exit(tc, "validate");
            }
        }
    }
}

