/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class LangUtils {
    private static TraceComponent tc = Tr.register(LangUtils.class, "LangUtils", "com.ibm.ws.management.commands");
    private static LangUtils langUtils = null;

    public static String formDisplayString(Object object, String lang) {
        if (langUtils == null) {
            langUtils = new LangUtils();
        }
        return langUtils.makeString(object, lang);
    }

    private LangUtils() {
    }

    private String makeString(Object object, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeString", new Object[]{object, lang});
        }
        String ret = new String();
        if (object != null && lang != null) {
            if (object instanceof Properties) {
                ret = this.propertiesToString((Properties)object, lang);
            } else if (object instanceof ObjectName) {
                try {
                    ret = this.objectNameToString((ObjectName)object);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, e.getMessage());
                    }
                }
            } else {
                ret = object.getClass().isArray() ? this.arrayToString((Object[])object, lang) : (object instanceof AttributeList ? this.AttributeListToString((AttributeList)object, lang) : (object instanceof Collection ? this.collectionToString((Collection)object, lang) : object.toString()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeString", new Object[]{ret});
        }
        return ret;
    }

    private String getOpenOptionSyntax(String lang) {
        String openOptionSyntax = "";
        if (lang.equalsIgnoreCase("jacl")) {
            openOptionSyntax = "{";
        } else if (lang.equalsIgnoreCase("jython")) {
            openOptionSyntax = "[";
        }
        return openOptionSyntax;
    }

    private String getCloseOptionSyntax(String lang) {
        String closeOptionSyntax = "";
        if (lang.equalsIgnoreCase("jacl")) {
            closeOptionSyntax = "}";
        } else if (lang.equalsIgnoreCase("jython")) {
            closeOptionSyntax = "]";
        }
        return closeOptionSyntax;
    }

    private String objectNameToString(ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectNameToString", new Object[]{objectName});
        }
        String ret = new String();
        String id = objectName.getKeyProperty("_Websphere_Config_Data_Id");
        if (id != null) {
            Class<?> objectNameHelperCls = Class.forName("com.ibm.ws.scripting.ObjectNameHelper");
            Method getListingNameMethod = objectNameHelperCls.getMethod("getListingName", ObjectName.class);
            Object result = getListingNameMethod.invoke(objectNameHelperCls, objectName);
            ret = result.toString();
        } else {
            ret = objectName.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectNameToString", new Object[]{ret});
        }
        return ret;
    }

    private String propertiesToString(Properties props, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesToString", new Object[]{props, lang});
        }
        StringBuffer strBuffer = new StringBuffer(1024);
        strBuffer.append(this.getOpenOptionSyntax(lang));
        Enumeration<?> vEnum = props.propertyNames();
        while (vEnum.hasMoreElements()) {
            String key = (String)vEnum.nextElement();
            String val = props.getProperty(key);
            if (val == null) {
                val = "null";
            }
            if ((val = val.trim()).length() > 0) {
                if (val.startsWith("\"\"") && val.endsWith("\"\"") && val.length() > 2) {
                    val = val.substring(1, val.length() - 1);
                }
                if (val.indexOf(32) != -1) {
                    if (!val.startsWith("\"") && !val.startsWith(this.getOpenOptionSyntax(lang))) {
                        val = "\"" + val;
                    }
                    if (!val.endsWith("\"") && !val.endsWith(this.getCloseOptionSyntax(lang))) {
                        val = val + "\"";
                    }
                }
            }
            if (strBuffer.length() > 1) {
                strBuffer.append(" ");
            }
            strBuffer.append(this.getOpenOptionSyntax(lang));
            strBuffer.append(key);
            strBuffer.append(" ");
            strBuffer.append(val);
            strBuffer.append(this.getCloseOptionSyntax(lang));
        }
        strBuffer.append(this.getCloseOptionSyntax(lang));
        String ret = strBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesToString", new Object[]{ret});
        }
        return ret;
    }

    private String arrayToString(Object[] objArray, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayToString", new Object[]{objArray, lang});
        }
        StringBuffer strBuffer = new StringBuffer(1024);
        strBuffer.append(this.getOpenOptionSyntax(lang));
        for (int i = 0; i < objArray.length; ++i) {
            Object elementObj = objArray[i];
            if (elementObj == null) continue;
            String str = this.makeString(elementObj, lang);
            if ((str = str.trim()).length() == 0) continue;
            if (str.indexOf(32) != -1) {
                if (!str.startsWith("\"") && !str.startsWith(this.getOpenOptionSyntax(lang))) {
                    str = "\"" + str;
                }
                if (!str.endsWith("\"") && !str.endsWith(this.getCloseOptionSyntax(lang))) {
                    str = str + "\"";
                }
            }
            if (i > 0) {
                strBuffer.append(" ");
            }
            strBuffer.append(str);
        }
        strBuffer.append(this.getCloseOptionSyntax(lang));
        String ret = strBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayToString", new Object[]{ret});
        }
        return ret;
    }

    private String AttributeListToString(AttributeList attrList, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AttributeListToString", new Object[]{attrList, lang});
        }
        Properties props = new Properties();
        for (int i = 0; i < attrList.size(); ++i) {
            String name = ((Attribute)attrList.get(i)).getName();
            Object value = ((Attribute)attrList.get(i)).getValue();
            if (value != null) {
                props.setProperty(name, this.makeString(value, lang));
                continue;
            }
            props.setProperty(name, "null");
        }
        String ret = this.propertiesToString(props, lang);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AttributeListToString", new Object[]{ret});
        }
        return ret;
    }

    private String collectionToString(Collection collection, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectionToString", new Object[]{collection, lang});
        }
        String ret = this.arrayToString(collection.toArray(), lang);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectionToString", new Object[]{ret});
        }
        return ret;
    }
}

