/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.SimpleAdminCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import java.util.HashMap;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConfigServiceCommandProvider
extends CommandProvider {
    public AbstractAdminCommand createCommand(CommandMetadata commandmetadata) throws CommandNotFoundException {
        return new ConfigServiceCommand(commandmetadata);
    }

    public AbstractAdminCommand loadCommand(CommandData commanddata) throws CommandNotFoundException, CommandLoadException {
        return new ConfigServiceCommand(commanddata);
    }

    private class ConfigServiceCommand
    extends SimpleAdminCommand {
        public ConfigServiceCommand(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public ConfigServiceCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            CommandMetadata metadata2 = this.getCommandMetadata();
            String name = metadata2.getName();
            CommandProviderHelper helper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            Session session = this.getConfigSession();
            ConfigService configService = helper.getConfigService();
            CommandResultImpl commandResult = new CommandResultImpl();
            Object result = null;
            try {
                this.validate();
                if (name.equals("configservice_save")) {
                    Object overwriteOnConflict = this.getParameter("overwriteOnConflict");
                    configService.save(session, (Boolean)overwriteOnConflict);
                } else if (name.equals("configservice_discard")) {
                    configService.discard(session);
                } else if (name.equals("configservice_getUnsavedChanges")) {
                    result = configService.getUnsavedChanges(session);
                } else if (name.equals("configservice_getConflictDocuments")) {
                    result = configService.getConflictDocuments(session);
                } else if (name.equals("configservice_getSupportedConfigObjectTypes")) {
                    result = configService.getSupportedConfigObjectTypes();
                } else if (name.equals("configservice_getRelationshipsMetaInfo")) {
                    String configObjectType = (String)this.getParameter("configObjectType");
                    result = configService.getRelationshipsMetaInfo(configObjectType);
                } else if (name.equals("configservice_getAttributesMetaInfo")) {
                    String configObjectType = (String)this.getParameter("configObjectType");
                    result = configService.getAttributesMetaInfo(configObjectType);
                } else if (name.equals("configservice_queryConfigObjects")) {
                    ObjectName scope = (ObjectName)this.getParameter("scope");
                    ObjectName pattern = (ObjectName)this.getParameter("pattern");
                    result = configService.queryConfigObjects(session, scope, pattern, null);
                } else if (name.equals("configservice_queryTemplates")) {
                    String type = (String)this.getParameter("type");
                    result = configService.queryTemplates(session, type);
                } else if (name.equals("configservice_resolve")) {
                    String containmentPath = (String)this.getParameter("containmentPath");
                    result = configService.resolve(session, containmentPath);
                } else if (name.equals("configservice_setProperties")) {
                    HashMap props = (HashMap)this.getParameter("props");
                    configService.setProperties(session, props);
                } else if (name.equals("configservice_validate")) {
                    ObjectName scope = (ObjectName)this.getParameter("scope");
                    configService.validate(session, scope);
                } else if (name.equals("configservice_createConfigData")) {
                    ObjectName parent = (ObjectName)this.getParameter("parent");
                    String attributeName = (String)this.getParameter("attributeName");
                    String type = (String)this.getParameter("type");
                    AttributeList attrList = (AttributeList)this.getParameter("attrList");
                    result = configService.createConfigData(session, parent, attributeName, type, attrList);
                } else if (name.equals("configservice_createConfigDataByTemplate")) {
                    ObjectName parent = (ObjectName)this.getParameter("parent");
                    String attributeName = (String)this.getParameter("attributeName");
                    AttributeList attrList = (AttributeList)this.getParameter("attrList");
                    ObjectName template = (ObjectName)this.getParameter("template");
                    result = configService.createConfigDataByTemplate(session, parent, attributeName, attrList, template);
                } else if (name.equals("configservice_setAttributes")) {
                    ObjectName configData = (ObjectName)this.getTargetObject();
                    AttributeList attrList = (AttributeList)this.getParameter("attrList");
                    configService.setAttributes(session, configData, attrList);
                } else if (name.equals("configservice_addElement")) {
                    ObjectName configData = (ObjectName)this.getTargetObject();
                    String attribute = (String)this.getParameter("attribute");
                    Object element = this.getParameter("element");
                    Integer index = (Integer)this.getParameter("index");
                    configService.addElement(session, configData, attribute, element, index == null ? -1 : index);
                } else if (name.equals("configservice_removeElement")) {
                    ObjectName configData = (ObjectName)this.getTargetObject();
                    String attribute = (String)this.getParameter("attribute");
                    Object element = this.getParameter("element");
                    configService.removeElement(session, configData, attribute, element);
                } else if (name.equals("configservice_unsetAttributes")) {
                    ObjectName configData = (ObjectName)this.getTargetObject();
                    String[] attributes = (String[])this.getParameter("attributes");
                    configService.unsetAttributes(session, configData, attributes);
                } else if (name.equals("configservice_resetAttributes")) {
                    ObjectName configData = (ObjectName)this.getTargetObject();
                    AttributeList attrList = (AttributeList)this.getParameter("attrList");
                    configService.resetAttributes(session, configData, attrList);
                } else if (name.equals("configservice_getAttributes")) {
                    ObjectName configData = (ObjectName)this.getTargetObject();
                    String[] attributes = (String[])this.getParameter("attributes");
                    Boolean recursive = (Boolean)this.getParameter("recursive");
                    result = configService.getAttributes(session, configData, attributes, recursive == null ? false : recursive);
                } else if (name.equals("configservice_getAttribute")) {
                    ObjectName configData = (ObjectName)this.getTargetObject();
                    String attribute = (String)this.getParameter("attribute");
                    result = configService.getAttribute(session, configData, attribute);
                } else if (name.equals("configservice_deleteConfigData")) {
                    ObjectName configData = (ObjectName)this.getTargetObject();
                    configService.deleteConfigData(session, configData);
                } else if (name.equals("configservice_getRelationship")) {
                    ObjectName configData = (ObjectName)this.getTargetObject();
                    String relationship = (String)this.getParameter("relationship");
                    result = configService.getRelationship(session, configData, relationship);
                } else if (name.equals("configservice_getRelationships")) {
                    ObjectName configData = (ObjectName)this.getTargetObject();
                    String[] relationships = (String[])this.getParameter("relationships");
                    result = configService.getRelationships(session, configData, relationships);
                }
                commandResult.setResult(result);
                this.setCommandResult(commandResult);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
        }
    }
}

