/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.SimpleAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.ws.management.commands.LangUtils;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class AdminServiceCommands
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(AdminServiceCommands.class, "AdminServiceCommands", "com.ibm.ws.management.commands");
    private AdminService adminService = null;

    public AdminServiceCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminServiceCommands");
        }
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        CommandProviderHelper helper = cmdMgr.getCommandProviderHelper();
        this.adminService = helper.getAdminService();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminServiceCommands");
        }
    }

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        String cmdName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand");
        }
        if ((cmdName = metadata2.getName()).equals("adminservice_queryNames")) {
            return new QueryNamesCmd(metadata2);
        }
        if (cmdName.equals("adminservice_invoke")) {
            return new InvokeCmd(metadata2);
        }
        if (cmdName.equals("adminservice_getAttribute")) {
            return new GetAttributeCmd(metadata2);
        }
        if (cmdName.equals("adminservice_getAttributes")) {
            return new GetAttributesCmd(metadata2);
        }
        if (cmdName.equals("adminservice_setAttribute")) {
            return new SetAttributeCmd(metadata2);
        }
        if (cmdName.equals("adminservice_setAttributes")) {
            return new SetAttributesCmd(metadata2);
        }
        if (cmdName.equals("adminservice_getLocalServer")) {
            return new GetLocalServerCmd(metadata2);
        }
        if (cmdName.equals("adminservice_getCellName")) {
            return new GetCellNameCmd(metadata2);
        }
        if (cmdName.equals("adminservice_getNodeName")) {
            return new GetNodeNameCmd(metadata2);
        }
        if (cmdName.equals("adminservice_getProcessName")) {
            return new GetProcessNameCmd(metadata2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cannot find command " + cmdName + " to create.");
        }
        return super.createCommand(metadata2);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        String cmdName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCommand");
        }
        if ((cmdName = cmdData.getName()).equals("adminservice_queryNames")) {
            return new QueryNamesCmd(cmdData);
        }
        if (cmdName.equals("adminservice_invoke")) {
            return new InvokeCmd(cmdData);
        }
        if (cmdName.equals("adminservice_getAttribute")) {
            return new GetAttributeCmd(cmdData);
        }
        if (cmdName.equals("adminservice_getAttributes")) {
            return new GetAttributesCmd(cmdData);
        }
        if (cmdName.equals("adminservice_setAttribute")) {
            return new SetAttributeCmd(cmdData);
        }
        if (cmdName.equals("adminservice_setAttributes")) {
            return new SetAttributesCmd(cmdData);
        }
        if (cmdName.equals("adminservice_getLocalServer")) {
            return new GetLocalServerCmd(cmdData);
        }
        if (cmdName.equals("adminservice_getCellName")) {
            return new GetCellNameCmd(cmdData);
        }
        if (cmdName.equals("adminservice_getNodeName")) {
            return new GetNodeNameCmd(cmdData);
        }
        if (cmdName.equals("adminservice_getProcessName")) {
            return new GetProcessNameCmd(cmdData);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cannot find command " + cmdName + " to load.");
        }
        return super.loadCommand(cmdData);
    }

    class GetProcessNameCmd
    extends SimpleAdminCommand {
        public GetProcessNameCmd(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public GetProcessNameCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResult = new CommandResultImpl();
            String result = null;
            try {
                this.validate();
                result = AdminServiceCommands.this.adminService.getProcessName();
                commandResult.setResult(result);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
            this.setCommandResult(commandResult);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", result);
            }
        }

        public String generateScript(String lang) {
            return "";
        }
    }

    class GetNodeNameCmd
    extends SimpleAdminCommand {
        public GetNodeNameCmd(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public GetNodeNameCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResult = new CommandResultImpl();
            String result = null;
            try {
                this.validate();
                result = AdminServiceCommands.this.adminService.getNodeName();
                commandResult.setResult(result);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
            this.setCommandResult(commandResult);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", result);
            }
        }

        public String generateScript(String lang) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateScript", new Object[]{lang});
            }
            String wsadminCmd = "";
            if (lang.equalsIgnoreCase("jacl")) {
                wsadminCmd = "$AdminControl getNode";
            } else if (lang.equalsIgnoreCase("jython")) {
                wsadminCmd = "AdminControl.getNode()";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{wsadminCmd});
            }
            return wsadminCmd;
        }
    }

    class GetCellNameCmd
    extends SimpleAdminCommand {
        public GetCellNameCmd(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public GetCellNameCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResult = new CommandResultImpl();
            String result = null;
            try {
                this.validate();
                result = AdminServiceCommands.this.adminService.getCellName();
                commandResult.setResult(result);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
            this.setCommandResult(commandResult);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", result);
            }
        }

        public String generateScript(String lang) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateScript", new Object[]{lang});
            }
            String wsadminCmd = "";
            if (lang.equalsIgnoreCase("jacl")) {
                wsadminCmd = "$AdminControl getCell";
            } else if (lang.equalsIgnoreCase("jython")) {
                wsadminCmd = "AdminControl.getCell()";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{wsadminCmd});
            }
            return wsadminCmd;
        }
    }

    class GetLocalServerCmd
    extends SimpleAdminCommand {
        public GetLocalServerCmd(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public GetLocalServerCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResult = new CommandResultImpl();
            ObjectName result = null;
            try {
                this.validate();
                result = AdminServiceCommands.this.adminService.getLocalServer();
                commandResult.setResult(result);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
            this.setCommandResult(commandResult);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", result);
            }
        }

        public String generateScript(String lang) {
            return "";
        }
    }

    class SetAttributesCmd
    extends SimpleAdminCommand {
        public SetAttributesCmd(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public SetAttributesCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResult = new CommandResultImpl();
            AttributeList result = null;
            try {
                this.validate();
                ObjectName name = (ObjectName)this.getTargetObject();
                AttributeList attributeList = (AttributeList)this.getParameter("attributeList");
                result = AdminServiceCommands.this.adminService.setAttributes(name, attributeList);
                commandResult.setResult(result);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
            this.setCommandResult(commandResult);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", result);
            }
        }

        public String generateScript(String lang) {
            String wsadminCmd;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{lang});
                }
                wsadminCmd = "";
                try {
                    ObjectName targetObj = (ObjectName)this.getTargetObject();
                    String targetObjStr = LangUtils.formDisplayString(targetObj, lang);
                    AttributeList attributeList = (AttributeList)this.getParameter("attributeList");
                    String attributeListStr = LangUtils.formDisplayString(attributeList, lang);
                    if (lang.equalsIgnoreCase("jacl")) {
                        wsadminCmd = "$AdminControl setAttributes " + targetObjStr + " " + attributeListStr;
                    } else if (lang.equalsIgnoreCase("jython")) {
                        wsadminCmd = "AdminControl.setAttributes('" + targetObjStr + "', '" + attributeListStr + "')";
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + lang + ") for setAttributes command. " + e.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{wsadminCmd});
            }
            return wsadminCmd;
        }
    }

    class SetAttributeCmd
    extends SimpleAdminCommand {
        public SetAttributeCmd(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public SetAttributeCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResult = new CommandResultImpl();
            try {
                this.validate();
                ObjectName name = (ObjectName)this.getTargetObject();
                Attribute attribute = (Attribute)this.getParameter("attribute");
                AdminServiceCommands.this.adminService.setAttribute(name, attribute);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
            this.setCommandResult(commandResult);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute");
            }
        }

        public String generateScript(String lang) {
            String wsadminCmd;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{lang});
                }
                wsadminCmd = "";
                try {
                    ObjectName targetObj = (ObjectName)this.getTargetObject();
                    String targetObjStr = LangUtils.formDisplayString(targetObj, lang);
                    Attribute attribute = (Attribute)this.getParameter("attribute");
                    String attributeName = attribute.getName();
                    Object attributeValue = attribute.getValue();
                    String attributeValueStr = LangUtils.formDisplayString(attributeValue, lang);
                    if (lang.equalsIgnoreCase("jacl")) {
                        wsadminCmd = "$AdminControl setAttribute " + targetObjStr + " " + attributeName + " " + attributeValue;
                    } else if (lang.equalsIgnoreCase("jython")) {
                        wsadminCmd = "AdminControl.setAttribute('" + targetObjStr + "', '" + attributeName + "', '" + attributeValue + "')";
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + lang + ") for setAttribute command. " + e.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{wsadminCmd});
            }
            return wsadminCmd;
        }
    }

    class GetAttributesCmd
    extends SimpleAdminCommand {
        public GetAttributesCmd(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public GetAttributesCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResult = new CommandResultImpl();
            AttributeList result = null;
            try {
                this.validate();
                ObjectName name = (ObjectName)this.getTargetObject();
                String[] attributes = (String[])this.getParameter("attributes");
                result = AdminServiceCommands.this.adminService.getAttributes(name, attributes);
                commandResult.setResult(result);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
            this.setCommandResult(commandResult);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", result);
            }
        }

        public String generateScript(String lang) {
            String wsadminCmd;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{lang});
                }
                wsadminCmd = "";
                try {
                    ObjectName targetObj = (ObjectName)this.getTargetObject();
                    String targetObjStr = LangUtils.formDisplayString(targetObj, lang);
                    String[] attributes = (String[])this.getParameter("attributes");
                    String attributesStr = LangUtils.formDisplayString(attributes, lang);
                    if (lang.equalsIgnoreCase("jacl")) {
                        wsadminCmd = "$AdminControl getAttributes " + targetObjStr + " " + attributesStr;
                    } else if (lang.equalsIgnoreCase("jython")) {
                        wsadminCmd = "AdminControl.getAttributes('" + targetObjStr + "', '" + attributesStr + "')";
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + lang + ") for getAttributes command. " + e.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{wsadminCmd});
            }
            return wsadminCmd;
        }
    }

    class GetAttributeCmd
    extends SimpleAdminCommand {
        public GetAttributeCmd(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public GetAttributeCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResult = new CommandResultImpl();
            Object result = null;
            try {
                this.validate();
                ObjectName name = (ObjectName)this.getTargetObject();
                String attribute = (String)this.getParameter("attribute");
                result = AdminServiceCommands.this.adminService.getAttribute(name, attribute);
                commandResult.setResult(result);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
            this.setCommandResult(commandResult);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", result);
            }
        }

        public String generateScript(String lang) {
            String wsadminCmd;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{lang});
                }
                wsadminCmd = "";
                try {
                    ObjectName targetObj = (ObjectName)this.getTargetObject();
                    String targetObjStr = LangUtils.formDisplayString(targetObj, lang);
                    String attribute = (String)this.getParameter("attribute");
                    if (lang.equalsIgnoreCase("jacl")) {
                        wsadminCmd = "$AdminControl getAttribute " + targetObjStr + " " + attribute;
                    } else if (lang.equalsIgnoreCase("jython")) {
                        wsadminCmd = "AdminControl.getAttribute('" + targetObjStr + "', '" + attribute + "')";
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + lang + ") for getAttribute command. " + e.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{wsadminCmd});
            }
            return wsadminCmd;
        }
    }

    class InvokeCmd
    extends SimpleAdminCommand {
        public InvokeCmd(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public InvokeCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResult = new CommandResultImpl();
            Object result = null;
            try {
                this.validate();
                ObjectName name = (ObjectName)this.getTargetObject();
                String operation = (String)this.getParameter("operation");
                Object[] params = (Object[])this.getParameter("params");
                String[] signature = (String[])this.getParameter("signature");
                result = AdminServiceCommands.this.adminService.invoke(name, operation, params, signature);
                commandResult.setResult(result);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
            this.setCommandResult(commandResult);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", result);
            }
        }

        public String generateScript(String lang) {
            String wsadminCmd;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{lang});
                }
                wsadminCmd = "";
                try {
                    ObjectName targetObj = (ObjectName)this.getTargetObject();
                    String targetObjStr = LangUtils.formDisplayString(targetObj, lang);
                    String operation = (String)this.getParameter("operation");
                    Object[] params = (Object[])this.getParameter("params");
                    String paramsStr = LangUtils.formDisplayString(params, lang);
                    String[] signature = (String[])this.getParameter("signature");
                    String signatureStr = LangUtils.formDisplayString(signature, lang);
                    if (lang.equalsIgnoreCase("jacl")) {
                        wsadminCmd = "$AdminControl invoke " + targetObjStr + " " + operation + (paramsStr.length() == 0 ? "" : (signatureStr.length() == 0 ? " " + paramsStr : " " + paramsStr + " " + signatureStr));
                    } else if (lang.equalsIgnoreCase("jython")) {
                        wsadminCmd = "AdminControl.invoke('" + targetObjStr + "', '" + operation + (paramsStr.length() == 0 ? "" : (signatureStr.length() == 0 ? "', '" + paramsStr : "', '" + paramsStr + "', '" + signatureStr)) + "')";
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + lang + ") for invoke command. " + e.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{wsadminCmd});
            }
            return wsadminCmd;
        }
    }

    class QueryNamesCmd
    extends SimpleAdminCommand {
        public QueryNamesCmd(CommandMetadata metadata2) throws CommandNotFoundException {
            super(metadata2);
        }

        public QueryNamesCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResult = new CommandResultImpl();
            Set result = null;
            try {
                this.validate();
                ObjectName objName = (ObjectName)this.getParameter("objname");
                QueryExp query = (QueryExp)this.getParameter("query");
                result = AdminServiceCommands.this.adminService.queryNames(objName, query);
                commandResult.setResult(result);
            }
            catch (Throwable th) {
                commandResult.setException(th);
            }
            this.setCommandResult(commandResult);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", result);
            }
        }

        public String generateScript(String lang) {
            String wsadminCmd;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{lang});
                }
                wsadminCmd = "";
                try {
                    ObjectName objName = (ObjectName)this.getParameter("objname");
                    QueryExp query = (QueryExp)this.getParameter("query");
                    String objNameStr = LangUtils.formDisplayString(objName, lang);
                    String queryStr = LangUtils.formDisplayString(query, lang);
                    if (lang.equalsIgnoreCase("jacl")) {
                        wsadminCmd = "$AdminControl queryNames " + objNameStr + (queryStr.length() == 0 ? "" : " " + queryStr);
                    } else if (lang.equalsIgnoreCase("jython")) {
                        wsadminCmd = "AdminControl.queryNames('" + objNameStr + (queryStr.length() == 0 ? "" : "', '" + queryStr) + "')";
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + lang + ") for queryNames command. " + e.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{wsadminCmd});
            }
            return wsadminCmd;
        }
    }
}

