/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.management.commands.AdminAppCommands;
import com.ibm.ws.management.commands.CommandGenerator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class AdminAppEditCmd
extends AdminAppCommands
implements CommandGenerator {
    private static TraceComponent tc = Tr.register(AdminAppEditCmd.class, "AdminAppEditCmd", "com.ibm.ws.management.commands");
    public static final String SESSION_KEY = "ADMINAPP_EDIT_CMD";
    public static final String EDIT_CMD = "edit";
    public static final String MESSAGE_KEY = "ADMINAPP_HELP_EDIT";
    protected String appName = null;

    public String getName() {
        return EDIT_CMD;
    }

    public String generateScript(String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateScript");
        }
        String cmdScript = this.getEditCmdScript(lang);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateScript", new Object[]{cmdScript});
        }
        return cmdScript;
    }

    public String getDescription(Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescription");
        }
        String desc = TraceNLS.getStringFromBundle("com.ibm.ws.scripting.resources.wscpMessage", MESSAGE_KEY, locale);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescription", new Object[]{desc});
        }
        return desc;
    }

    public String toString() {
        return super.toString();
    }

    public String getEditCmdScript(String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEditCmdScript");
        }
        String script = this.appName == null ? "AppName not found" : this.getEditCmdScript(this.appName, this.getDiffHash(), lang);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEditCmdScript", new Object[]{script});
        }
        return script;
    }

    public String getEditCmdScript(String appName, Hashtable taskHash, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEditCmdScript");
        }
        String cmdScript = "";
        if (lang.equals("jacl")) {
            cmdScript = "AdminApp edit " + appName + " " + this.makeParamsString(taskHash, lang);
        } else if (lang.equals("jython")) {
            cmdScript = "AdminApp.edit('" + appName + "', " + "'" + this.makeParamsString(taskHash, lang) + "' )";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEditCmdScript", new Object[]{cmdScript});
        }
        return cmdScript;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    private String makeParamsString(Hashtable taskHash, String lang) {
        String CB;
        String OB;
        String SP;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeParamsString");
        }
        String ret = "";
        if (lang.equals("jacl")) {
            SP = " ";
            OB = "{";
            CB = "}";
        } else if (lang.equals("jython")) {
            SP = " ";
            OB = "[";
            CB = "]";
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "makeParamsString");
            }
            return null;
        }
        ret = ret + OB + SP;
        Enumeration keys = taskHash.keys();
        while (keys.hasMoreElements()) {
            String currKey = (String)keys.nextElement();
            String[][] taskTable = (String[][])taskHash.get(currKey);
            ret = ret + SP + "-" + currKey + SP;
            ret = ret + OB;
            int numRows = taskTable.length;
            int numCols = taskTable[0].length;
            for (int row = 1; row < numRows; ++row) {
                ret = ret + OB + SP;
                for (int col = 0; col < numCols; ++col) {
                    String cellString = this.quoteStr(taskTable[row][col]);
                    ret = ret + cellString + SP;
                }
                ret = ret + CB;
            }
            ret = ret + CB;
        }
        ret = ret + CB;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeParamsString", new Object[]{ret});
        }
        return ret;
    }
}

