/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.commands.CommandGenerator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public abstract class AdminAppCommands
implements CommandGenerator {
    private static TraceComponent tc = Tr.register(AdminAppCommands.class, "AdminAppCommands", "com.ibm.ws.management.commands");
    public static final String ADMIN_APP = "AdminApp";
    public static final String JACL = "jacl";
    public static final String JYTHON = "jython";
    protected Hashtable defaultTaskData = null;
    protected Hashtable userTaskData = null;

    public abstract String getName();

    public abstract String generateScript(String var1);

    public abstract String getDescription(Locale var1);

    public String toString() {
        return "AdminApp " + this.getName();
    }

    public AdminAppCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminAppCommands");
        }
        this.defaultTaskData = new Hashtable();
        this.userTaskData = new Hashtable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminAppCommands");
        }
    }

    public void setDefaultTaskData(String taskName, String[][] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultTaskData");
        }
        this.copyTaskDataNoReplace(this.defaultTaskData, taskName, taskData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultTaskData");
        }
    }

    public void setUserTaskData(String taskName, String[][] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUserTaskData");
        }
        this.copyTaskData(this.userTaskData, taskName, taskData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUserTaskData");
        }
    }

    protected Hashtable getDiffHash() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDiffHash");
        }
        Hashtable<String, String[][]> diffHash = new Hashtable<String, String[][]>();
        Enumeration keys = this.defaultTaskData.keys();
        while (keys.hasMoreElements()) {
            String currKey = (String)keys.nextElement();
            String[][] diffTable = this.getDiffTable(currKey);
            if (diffTable == null) continue;
            diffHash.put(currKey, diffTable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDiffHash", new Object[]{diffHash});
        }
        return diffHash;
    }

    protected String[][] getDiffTable(String taskName) {
        int col;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDiffTable");
        }
        String[][] defaultTable = (String[][])this.defaultTaskData.get(taskName);
        String[][] userTable = (String[][])this.userTaskData.get(taskName);
        Vector<Integer> changedRows = new Vector<Integer>(0);
        int numRows = userTable.length;
        int numCols = userTable[0].length;
        block0: for (int row = 1; row < numRows; ++row) {
            if (defaultTable.length < row) {
                changedRows.add(new Integer(row));
                continue;
            }
            for (col = 0; col < numCols; ++col) {
                if (defaultTable[row][col] == null) {
                    defaultTable[row][col] = "";
                }
                if (userTable[row][col] == null) {
                    userTable[row][col] = "";
                }
                if (defaultTable[row][col].equals(userTable[row][col])) continue;
                changedRows.add(new Integer(row));
                continue block0;
            }
        }
        if (changedRows.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDiffTable");
            }
            return null;
        }
        String[][] diffTable = new String[changedRows.size() + 1][numCols];
        for (col = 0; col < numCols; ++col) {
            diffTable[0][col] = userTable[0][col];
        }
        for (int row = 1; row < changedRows.size() + 1; ++row) {
            int userRow = (Integer)changedRows.get(row - 1);
            for (int col2 = 0; col2 < numCols; ++col2) {
                diffTable[row][col2] = userTable[userRow][col2];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDiffTable", new Object[]{diffTable});
        }
        return diffTable;
    }

    protected void copyTaskDataNoReplace(Hashtable copyToHash, String taskName, String[][] copyFrom) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyTaskDataNoReplace");
        }
        if (!copyToHash.containsKey(taskName)) {
            this.copyTaskData(copyToHash, taskName, copyFrom);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyTaskDataNoReplace");
        }
    }

    protected void copyTaskData(Hashtable copyToHash, String taskName, String[][] copyFrom) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyTaskData");
        }
        int numRows = copyFrom.length;
        int numCols = copyFrom[0].length;
        String[][] copyTo = new String[numRows][numCols];
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                copyTo[row][col] = copyFrom[row][col];
            }
        }
        copyToHash.put(taskName, copyTo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyTaskData");
        }
    }

    protected String quoteStr(String ret) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quoteStr");
        }
        if (ret != null) {
            if (ret.equals("")) {
                ret = "\"" + ret + "\"";
            } else if (ret.length() > 0 && ret.indexOf(" ") != -1) {
                ret = "\"" + ret + "\"";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quoteStr", new Object[]{ret});
        }
        return ret;
    }
}

