/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.authorizer.GroupsParser;
import com.ibm.ws.management.authorizer.ResourceInstanceIdentifier;
import com.ibm.ws.management.authorizer.ResourceRelationHandler;
import com.ibm.ws.management.authorizer.ResourceRelations;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ResourceInstanceRelations {
    private static TraceComponent tc = Tr.register(ResourceInstanceRelations.class, "ResourceInstanceRelations", "com.ibm.ws.management.authorizer");
    private static ResourceInstanceRelations instance = new ResourceInstanceRelations();
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private Set bundlesProvidingConfig;
    private boolean initialized = false;

    private ResourceInstanceRelations() {
        try {
            this.bundlesProvidingConfig = new HashSet();
            IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".admin-authz-def";
            IExtensionPoint point = registry.getExtensionPoint(epid);
            IExtension[] extensions = point.getExtensions();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension point " + epid);
                Tr.debug(tc, "There are " + extensions.length + " extensions");
            }
            for (int i = 0; i < extensions.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extension found " + extensions[i]);
                }
                this.bundlesProvidingConfig.add(Platform.getBundle((String)extensions[i].getNamespace()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ResourceInstanceRelations getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)adminPermission);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getParentInstances(String resourceNameIn, String resourceTypeIn) {
        ConfigService configService;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentInstances", resourceNameIn + " type = " + resourceTypeIn);
        }
        if ((configService = ConfigServiceFactory.getConfigService()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configservice not found using dmgr configserice proxy ");
            }
            try {
                Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                configService = (ConfigService)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ResourceInstanceRelations.this.getDmgrConfigService();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                pae.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configservice is ", configService);
        }
        final String resourceName = resourceNameIn;
        final String resourceType = resourceTypeIn;
        final ConfigService cs = configService;
        final Session session = new Session();
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            List lst = (List)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HashMap lst = ResourceInstanceRelations.this.getAllParentInstances(session, cs, resourceName, resourceType);
                    return ResourceInstanceRelations.this.convertCfgId(lst);
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parent list = ");
                Iterator ditr = lst.iterator();
                while (ditr.hasNext()) {
                    Tr.debug(tc, (String)ditr.next());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getParentInstances");
            }
            List list = lst;
            return list;
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae.getException(), (String)"com.ibm.ws.management.authorizer.ResourceInstanceRelations.getParentInstances", (String)"100", (Object)this);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.ResourceInstanceRelations.getParentInstances", (String)"102", (Object)this);
        }
        finally {
            try {
                if (session != null && cs != null) {
                    cs.discard(session);
                }
            }
            catch (Exception e) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentInstances");
        }
        return null;
    }

    public List getParentInstances(String resourceName, String parentResourceType, Session session, ConfigService cs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentInstances", resourceName + " type = " + parentResourceType);
        }
        try {
            String className = ResourceRelations.getInstance().getClassName(parentResourceType);
            if (className == null) {
                className = "com.ibm.ws.management.authorizer.ResoruceInstanceIdentifier";
            }
            String methodName = "getParentInstances";
            Class implClass = this.getResourceClass(className);
            Constructor ct = implClass.getConstructor(new Class[0]);
            Object obj = ct.newInstance(new Object[0]);
            Method method = implClass.getMethod(methodName, String.class, String.class, Session.class, ConfigService.class);
            List parentInstances = (List)method.invoke(obj, resourceName, parentResourceType, session, cs);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parent list = ");
                Iterator ditr = parentInstances.iterator();
                while (ditr.hasNext()) {
                    Tr.debug(tc, (String)ditr.next());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getParentInstances");
            }
            return parentInstances;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.ResourceInstanceIdentifier.getParentInstances", (String)"147", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getParentInstances");
            }
            return null;
        }
    }

    public HashMap getAllParentInstances(Session session, ConfigService cs, String resourceName, String resourceType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllParentInstances", resourceName + " type = " + resourceType);
        }
        this.initialize();
        HashMap<String, List> parentInstances = new HashMap<String, List>(5);
        List lst = ResourceRelations.getInstance().getAllParentResources(resourceType);
        if (lst == null) {
            return null;
        }
        for (String parentType : lst) {
            List parents = this.getParentInstances(resourceName, parentType, session, cs);
            parentInstances.put(parentType, parents);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllParentInstances", parentInstances);
        }
        return parentInstances;
    }

    public List convertCfgId(HashMap resList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertCfgId", resList);
        }
        ArrayList<String> lst = new ArrayList<String>();
        if (resList == null) {
            return lst;
        }
        Set keys = resList.keySet();
        for (String resType : keys) {
            List resources = (List)resList.get(resType);
            if (resources == null) continue;
            for (String resource : resources) {
                lst.add(this.convertCfgId(resource, resType));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cgfids list = ");
            Iterator ditr = lst.iterator();
            while (ditr.hasNext()) {
                Tr.debug(tc, (String)ditr.next());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertCfgId");
        }
        return lst;
    }

    public String convertCfgId(String resource, String resourceType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertCfgId", resource + " type = " + resourceType);
        }
        try {
            String className = ResourceRelations.getInstance().getClassName(resourceType);
            if (className == null) {
                className = "com.ibm.ws.management.authorizer.ResourceInstanceIdentifier";
            }
            String methodName = "getResourceName";
            Class implClass = this.getResourceClass(className);
            Constructor ct = implClass.getConstructor(new Class[0]);
            Object obj = ct.newInstance(new Object[0]);
            Method method = implClass.getMethod(methodName, String.class, String.class);
            String resourceName = (String)method.invoke(obj, resource, resourceType);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertCfgId", resourceName);
            }
            return resourceName;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.ResourceInstanceIdentifier.convertCfgId", (String)"245", (Object)this);
            return null;
        }
    }

    public String convertMbeanName(ObjectName mbeanName, String resourceType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertMbeanName", mbeanName + "  type = " + resourceType);
        }
        try {
            String className = ResourceRelations.getInstance().getClassName(resourceType);
            if (className == null) {
                className = "com.ibm.ws.management.authorizer.ResoruceInstanceIdentifier";
            }
            String methodName = "getResourceName";
            Class implClass = this.getResourceClass(className);
            Constructor ct = implClass.getConstructor(new Class[0]);
            Object obj = ct.newInstance(new Object[0]);
            Method method = implClass.getMethod(methodName, ObjectName.class, String.class);
            String resourceName = (String)method.invoke(obj, mbeanName, resourceType);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertMbeanName", resourceName);
            }
            return resourceName;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.ResourceInstanceRelations.convertMbeanName", (String)"273", (Object)this);
            return null;
        }
    }

    public String getResourceType(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceType", resourceName);
        }
        String resourceType = null;
        List classes = ResourceRelations.getInstance().getClassNames();
        try {
            String className;
            Class implClass;
            Constructor ct;
            Object obj;
            ResourceInstanceIdentifier rii;
            Iterator itr = classes.iterator();
            while (itr.hasNext() && (resourceType = (rii = (ResourceInstanceIdentifier)(obj = (ct = (implClass = this.getResourceClass(className = (String)itr.next())).getConstructor(new Class[0])).newInstance(new Object[0]))).getResourceType(resourceName)) == null) {
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceType", resourceType);
        }
        return resourceType;
    }

    public boolean isValidResource(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidResource", resourceName);
        }
        List classes = ResourceRelations.getInstance().getClassNames();
        boolean isValid = false;
        try {
            String className;
            Class implClass;
            Constructor ct;
            Object obj;
            ResourceInstanceIdentifier rii;
            Iterator itr = classes.iterator();
            while (itr.hasNext() && !(isValid = (rii = (ResourceInstanceIdentifier)(obj = (ct = (implClass = this.getResourceClass(className = (String)itr.next())).getConstructor(new Class[0])).newInstance(new Object[0]))).isValidResource(resourceName))) {
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidResource", new Boolean(isValid));
        }
        return isValid;
    }

    public boolean isValidResourceType(String resourceType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidResourceType", resourceType);
        }
        List classes = ResourceRelations.getInstance().getClassNames();
        boolean isValid = false;
        try {
            String className;
            Class implClass;
            Constructor ct;
            Object obj;
            ResourceInstanceIdentifier rii;
            Iterator itr = classes.iterator();
            while (itr.hasNext() && !(isValid = (rii = (ResourceInstanceIdentifier)(obj = (ct = (implClass = this.getResourceClass(className = (String)itr.next())).getConstructor(new Class[0])).newInstance(new Object[0]))).isValidResourceType(resourceType))) {
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidResourceType", new Boolean(isValid));
        }
        return isValid;
    }

    public String getUniversalResourceType(String resourceType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniversalResourceType", resourceType);
        }
        List classes = ResourceRelations.getInstance().getClassNames();
        String type = null;
        try {
            String className;
            Class implClass;
            Constructor ct;
            Object obj;
            ResourceInstanceIdentifier rii;
            Iterator itr = classes.iterator();
            while (itr.hasNext() && (type = (rii = (ResourceInstanceIdentifier)(obj = (ct = (implClass = this.getResourceClass(className = (String)itr.next())).getConstructor(new Class[0])).newInstance(new Object[0]))).getUniversalResourceType(resourceType)) == null) {
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniversalResourceType", type);
        }
        return type;
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        if (ResourceRelations.getInstance().isInitialized()) {
            this.initialized = true;
            return;
        }
        this.initialized = true;
        GroupsParser groupsParser = new GroupsParser(new ResourceRelationHandler());
        groupsParser.loadConfigFile("com/ibm/ws/management/authorizer/xml/resourceTypeRelation.xml");
    }

    public ConfigService getDmgrConfigService() throws Exception {
        AdminClient dmgrClient = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
        return new ConfigServiceProxy(dmgrClient);
    }

    private Class getResourceClass(final String className) throws ClassNotFoundException {
        Class clazz;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getResourceClass", className);
            }
            clazz = null;
            Iterator it = this.bundlesProvidingConfig.iterator();
            while (it.hasNext() && clazz == null) {
                final Bundle bundle = (Bundle)it.next();
                if (bundle == null) {
                    return Class.forName(className);
                }
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(className);
                        }
                    });
                }
                catch (Exception e) {
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unable to load class " + className + " from bundle " + bundle.getSymbolicName());
                }
            }
            if (clazz == null) {
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return Class.forName(className, true, ExtClassLoader.getInstance());
                        }
                    });
                }
                catch (Exception e) {
                    if (!tc.isEventEnabled()) break block13;
                    Tr.event(tc, "unable to load class " + className + "using Extension " + "classloader");
                }
            }
        }
        if (clazz == null) {
            ClassNotFoundException cnfe = new ClassNotFoundException(className);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unable to load class " + className);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to load class " + className);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getResourceClass", cnfe);
            }
            throw cnfe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceClass", clazz);
        }
        return clazz;
    }
}

