/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.StringTokenizer;

public class GroupsUtil {
    private static TraceComponent tc = Tr.register(GroupsUtil.class, "GroupsUtil", "com.ibm.ws.management.authorizer");
    private static GroupsUtil groupsUtil = new GroupsUtil();
    public static final String CELLPREFIX = "cell=";
    public static final String NODEPREFIX = "node=";
    public static final String SERVERPREFIX = "process=";
    public static final String AUTHZGROUPPREFIX = "authorization=";
    public static final String BLAPREFIX = "bla=";
    public static final String CUSPREFIX = "cus=";
    public static final String ASSETPREFIX = "asset=";
    public static final String APPPREFIX = "Application=";
    public static final String CLUSTER_PREFIX = "name=";
    public static final String DELIM = ",";
    public static final String NODEGROUPPREFIX = "nodegroup=";
    public static final String DELIM_CFGID = "/:|";

    private GroupsUtil() {
    }

    public static GroupsUtil getInstance() {
        return groupsUtil;
    }

    private String getValueMbean(String prefix, String delim, String resourceName) {
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValueMbean", "prefix = " + prefix + " delim = " + delim);
        }
        if ((index = resourceName.indexOf(prefix)) < 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(resourceName.substring(index + prefix.length()), delim);
        String ret = st.nextToken();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValueMbean", ret);
        }
        return ret;
    }

    public boolean contains(String resName, String cfgType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains", resName + " " + cfgType);
        }
        String resourceName = new String(resName);
        boolean ret = false;
        String prefix = cfgType;
        String delim = DELIM_CFGID;
        int index = resourceName.indexOf("cells/");
        if (index < 0) {
            return ret;
        }
        StringTokenizer st = new StringTokenizer(resourceName.substring(index + "cells".length() + 1), delim);
        if (prefix.equals("cells")) {
            if (st.hasMoreTokens()) {
                ret = true;
            }
        } else {
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (!st.hasMoreTokens() || !(tok = st.nextToken()).equals(prefix) || !st.hasMoreTokens()) continue;
                ret = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contains", new Boolean(ret));
        }
        return ret;
    }

    private String getValue(String prefix, String delim, String resName) {
        String resourceName;
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValue", prefix + " " + resName);
        }
        if ((index = (resourceName = new String(resName)).indexOf("cells/")) < 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(resourceName.substring(index + "cells".length() + 1), delim);
        String ret = null;
        if (prefix.equals("cells")) {
            if (st.hasMoreTokens()) {
                ret = st.nextToken();
            }
        } else {
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (!st.hasMoreTokens() || !(tok = st.nextToken()).equals(prefix) || !st.hasMoreTokens()) continue;
                ret = st.nextToken();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValue", ret);
        }
        return ret;
    }

    public String getCellName(String resourceName, boolean mbean) {
        String delim = null;
        String prefix = null;
        String cellName = null;
        if (mbean) {
            delim = DELIM;
            prefix = CELLPREFIX;
            cellName = this.getValueMbean(prefix, delim, resourceName);
        } else {
            delim = DELIM_CFGID;
            prefix = "cells";
            cellName = this.getValue(prefix, delim, resourceName);
        }
        return cellName;
    }

    public String getNodeGroupName(String resourceName, boolean mbean) {
        String delim = null;
        String prefix = null;
        String nodeGroupName = null;
        if (mbean) {
            delim = DELIM;
            prefix = NODEGROUPPREFIX;
            nodeGroupName = this.getValueMbean(prefix, delim, resourceName);
        } else {
            delim = DELIM_CFGID;
            prefix = "nodegroups";
            nodeGroupName = this.getValue(prefix, delim, resourceName);
        }
        return nodeGroupName;
    }

    public String getNodeName(String resourceName, boolean mbean) {
        String delim = null;
        String prefix = null;
        String nodeName = null;
        if (mbean) {
            delim = DELIM;
            prefix = NODEPREFIX;
            nodeName = this.getValueMbean(prefix, delim, resourceName);
        } else {
            delim = DELIM_CFGID;
            prefix = "nodes";
            nodeName = this.getValue(prefix, delim, resourceName);
        }
        return nodeName;
    }

    public String getServerName(String resourceName, boolean mbean) {
        String delim = null;
        String prefix = null;
        String serverName = null;
        if (mbean) {
            delim = DELIM;
            prefix = SERVERPREFIX;
            serverName = this.getValueMbean(prefix, delim, resourceName);
        } else {
            delim = DELIM_CFGID;
            prefix = "servers";
            serverName = this.getValue(prefix, delim, resourceName);
        }
        return serverName;
    }

    public String getAuthzGroupName(String resourceName, boolean mbean) {
        String delim = null;
        String prefix = null;
        String serverName = null;
        if (mbean) {
            delim = DELIM;
            prefix = AUTHZGROUPPREFIX;
            serverName = this.getValueMbean(prefix, delim, resourceName);
        } else {
            delim = DELIM_CFGID;
            prefix = "authorizationgroups";
            serverName = this.getValue(prefix, delim, resourceName);
        }
        return serverName;
    }

    public String getBlaName(String resourceName, boolean mbean) {
        String delim = null;
        String prefix = null;
        String blaName = null;
        if (mbean) {
            delim = DELIM;
            prefix = BLAPREFIX;
            blaName = this.getValueMbean(prefix, delim, resourceName);
        } else {
            delim = DELIM_CFGID;
            prefix = "blas";
            blaName = this.getValue(prefix, delim, resourceName);
        }
        return blaName;
    }

    public String getCusName(String resourceName, boolean mbean) {
        String delim = null;
        String prefix = null;
        String cusName = null;
        if (mbean) {
            delim = DELIM;
            prefix = CUSPREFIX;
            cusName = this.getValueMbean(prefix, delim, resourceName);
        } else {
            delim = DELIM_CFGID;
            prefix = "cus";
            cusName = this.getValue(prefix, delim, resourceName);
        }
        return cusName;
    }

    public String getAssetName(String resourceName, boolean mbean) {
        String delim = null;
        String prefix = null;
        String assetName = null;
        if (mbean) {
            delim = DELIM;
            prefix = ASSETPREFIX;
            assetName = this.getValueMbean(prefix, delim, resourceName);
        } else {
            delim = DELIM_CFGID;
            prefix = "assets";
            assetName = this.getValue(prefix, delim, resourceName);
        }
        return assetName;
    }

    public String getClusterName(String resourceName, boolean mbean) {
        String delim = null;
        String prefix = null;
        String clusterName = null;
        if (mbean) {
            delim = DELIM;
            prefix = CLUSTER_PREFIX;
            clusterName = this.getValueMbean(prefix, delim, resourceName);
        } else {
            delim = DELIM_CFGID;
            prefix = "clusters";
            clusterName = this.getValue(prefix, delim, resourceName);
        }
        return clusterName;
    }

    public String getAppName(String resourceName, String methodName, boolean mbean) {
        String delim = null;
        String prefix = null;
        String appName = null;
        if (mbean) {
            delim = DELIM;
            prefix = APPPREFIX;
            appName = this.getValueMbean(prefix, delim, resourceName);
        } else {
            delim = DELIM_CFGID;
            prefix = "deployments";
            appName = this.getValue(prefix, delim, resourceName);
        }
        if (!(appName != null && appName.length() != 0 || mbean)) {
            delim = DELIM_CFGID;
            prefix = "applications";
            appName = this.getValue(prefix, delim, resourceName);
        }
        return appName;
    }
}

