/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class GroupsParser {
    private static TraceComponent tc = Tr.register(GroupsParser.class, "GroupsParser", "com.ibm.ws.management.authorizer");
    private SAXParser parser;
    DefaultHandler handler;

    GroupsParser(DefaultHandler handler) {
        this.handler = handler;
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parse(String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", fileName);
        }
        try {
            this.parser.parse(fileName, this.handler);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.GroupsParser.parse", (String)"82", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    public void parse(InputSource in) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", in);
        }
        try {
            this.parser.parse(in, this.handler);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.GroupsParser.parse", (String)"96", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    public void loadConfigFile(String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfigFile", fileName);
        }
        try {
            HashSet<Bundle> bundlesProvidingConfig = new HashSet<Bundle>();
            IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".admin-authz-def";
            IExtensionPoint point = registry.getExtensionPoint(epid);
            IExtension[] extensions = point.getExtensions();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension point " + epid);
                Tr.debug(tc, "There are " + extensions.length + " extensions");
            }
            for (int i = 0; i < extensions.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extension found " + extensions[i]);
                }
                bundlesProvidingConfig.add(Platform.getBundle((String)extensions[i].getNamespace()));
            }
            for (final Bundle bundle : bundlesProvidingConfig) {
                final String fileNameFinal = fileName;
                Enumeration e = (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        try {
                            return bundle.getResources(fileNameFinal);
                        }
                        catch (IOException ioe) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "io exception caught loading resources " + fileNameFinal);
                            }
                            return null;
                        }
                    }
                });
                while (e != null && e.hasMoreElements()) {
                    try {
                        URL url = (URL)e.nextElement();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "loading " + url);
                        }
                        InputStream in = url.openStream();
                        InputSource inSource = new InputSource(in);
                        inSource.setSystemId(fileName);
                        this.parse(inSource);
                    }
                    catch (Exception ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "caught exception while loading ");
                        }
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.authorizer.GroupsParser.loadConfigFile", (String)"151", (Object)this);
                    }
                }
            }
        }
        catch (Throwable e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught exception while loading " + fileName);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.GroupsParser.loadConfigFile", (String)"156", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfigFile");
        }
    }
}

