/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class AuthzCache {
    public static final int USER = 1;
    public static final int CONFIG = 2;
    public static final int MBEAN = 3;
    public static final int GROUP = 4;
    private static final int MAX_ENTRIES_USER = 1000;
    private static final int MAX_ENTRIES_CONFIG = 5000;
    private static final int MAX_ENTRIES_MBEAN = 2000;
    private static final int MAX_ENTRIES_GROUP = 1000;
    private Map userCache = Collections.synchronizedMap(new LinkedHashMap(1001, 0.75f, true){

        public boolean removeEldestEntry() {
            return this.size() > 1000;
        }
    });
    private Map configCache;
    private Map mbeanCache = Collections.synchronizedMap(new LinkedHashMap(2001, 0.75f, true){

        public boolean removeEldestEntry() {
            return this.size() > 2000;
        }
    });
    private Map groupCache;

    AuthzCache() {
        this.configCache = Collections.synchronizedMap(new LinkedHashMap(5001, 0.75f, true){

            public boolean removeEldestEntry() {
                return this.size() > 5000;
            }
        });
        this.groupCache = Collections.synchronizedMap(new LinkedHashMap(1001, 0.75f, true){

            public boolean removeEldestEntry() {
                return this.size() > 1000;
            }
        });
    }

    public void addEntry(int type, String key, Object val) {
        if (type == 1) {
            this.userCache.put(key, val);
        } else if (type == 2) {
            this.configCache.put(key, val);
        } else if (type == 3) {
            this.mbeanCache.put(key, val);
        } else if (type == 4) {
            this.groupCache.put(key, val);
        }
    }

    public Object getEntry(int type, String key) {
        if (type == 1) {
            return this.userCache.get(key);
        }
        if (type == 2) {
            return this.configCache.get(key);
        }
        if (type == 3) {
            return this.mbeanCache.get(key);
        }
        if (type == 4) {
            return this.groupCache.get(key);
        }
        return null;
    }

    public void clear(int type) {
        if (type == 1) {
            this.userCache.clear();
        } else if (type == 2) {
            this.configCache.clear();
        } else if (type == 3) {
            this.mbeanCache.clear();
        } else if (type == 4) {
            this.groupCache.clear();
        }
    }

    public void clear() {
        this.userCache.clear();
        this.configCache.clear();
        this.mbeanCache.clear();
        this.groupCache.clear();
    }
}

