/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.authorizer.AuthorizationGroup;
import com.ibm.ws.management.authorizer.AuthorizationGroups;
import com.ibm.ws.management.authorizer.AuthzCache;
import com.ibm.ws.management.authorizer.ExcludeList;
import com.ibm.ws.management.authorizer.ResourceInstanceRelations;
import com.ibm.ws.management.authorizer.ResourceRelations;
import com.ibm.ws.management.authorizer.RoleRelations;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AdminAuthorizerImpl
implements AdminAuthorizer {
    private static TraceComponent tc = Tr.register(AdminAuthorizerImpl.class, "AdminAuthorizerImpl", "com.ibm.ws.management.authorizer");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private RoleBasedConfigurator rbc = null;
    private AuthzCache authzCache = null;
    private boolean globalCanCache = false;
    private static AdminAuthorizerImpl authorizer = null;
    private static String scope = "scope";
    private Session session = null;
    private ConfigService configService = null;
    private static ExcludeList excludeList = new ExcludeList();
    private String cell = null;
    private String node = null;
    private String server = null;
    private String CELLXML = null;
    private String JDBCPROVIDERTEMPLATE = null;
    private String uuid = AdminContext.peek();

    public static AdminAuthorizerImpl create() {
        String curUUID = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create:" + curUUID);
        }
        AdminAuthorizerImpl ret = null;
        if (curUUID == null) {
            if (authorizer == null) {
                ret = authorizer = new AdminAuthorizerImpl();
            }
        } else {
            ret = (AdminAuthorizerImpl)AdminSubsystemServiceRegistry.getService((String)AdminAuthorizer.class.getName());
            if (ret == null) {
                ret = new AdminAuthorizerImpl();
                AdminSubsystemServiceRegistry.addService((String)AdminAuthorizer.class.getName(), (Object)ret);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create", ret);
        }
        return ret;
    }

    public static AdminAuthorizer getInstance() {
        String currentUUID = AdminContext.peek();
        if (currentUUID == null) {
            return authorizer;
        }
        return (AdminAuthorizer)AdminSubsystemServiceRegistry.getService((String)AdminAuthorizer.class.getName());
    }

    private AdminAuthorizerImpl() {
    }

    public boolean isFineGrainedAdminSecurity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFineGrainedAdminSecurity");
        }
        Collection groups = null;
        groups = AuthorizationGroups.getInstance().getGroups();
        if (groups != null && !groups.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFineGrainedAdminSecurity", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFineGrainedAdminSecurity", new Boolean(false));
        }
        return false;
    }

    public boolean checkAccess(String resNameIn, String role) {
        String resName = new String(resNameIn);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", resName + " : " + role);
        }
        String cacheKey = null;
        try {
            String resourceName = null;
            if (this.runningAsSystem()) {
                return true;
            }
            if ((resName.endsWith("serverindex.xml") || resName.endsWith("node-metadata.properties")) && role == "monitor") {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                return true;
            }
            String resType = null;
            if (resName.indexOf("(templates/clusters/") > 0 || resName.startsWith("templates/clusters/")) {
                String clusterName = null;
                String pattern = "templates/clusters/";
                int binx = resName.indexOf(pattern);
                int einx = resName.indexOf("/", binx += pattern.length());
                clusterName = einx > 0 ? resName.substring(binx, einx) : resName.substring(binx);
                resName = "cells/" + this.cell + "/clusters/" + clusterName;
            }
            if (resName.indexOf("cells/") < 0) {
                resourceName = resName.startsWith("/") ? "cells/" + this.cell + resName : "cells/" + this.cell + "/" + resName;
                resType = ResourceInstanceRelations.getInstance().getResourceType(resName);
            } else {
                resType = ResourceInstanceRelations.getInstance().getResourceType(resName);
                resourceName = resType != null && !resType.equals("BLA") && !resType.equals("CUS") && !resType.equals("ASSET") ? ResourceInstanceRelations.getInstance().convertCfgId(resName, resType) : resName;
            }
            if (this.canCache()) {
                cacheKey = this.createConfigCacheKey(resourceName, resType, role);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cacheKey", cacheKey);
                }
                Boolean resCache = this.checkAccessFromCache(2, cacheKey);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "result from cache ", resCache);
                }
                if (resCache != null) {
                    return resCache;
                }
            }
            String[] roles = null;
            List parentRoles = RoleRelations.getInstance().getAllParentRoles(role);
            parentRoles.add(role);
            if (resourceName == null) {
                resourceName = "cells/" + this.cell;
            }
            resType = ResourceInstanceRelations.getInstance().getResourceType(resourceName);
            if (role.equals("configurator") && resType != null && (resType.equals("Application") || resType.equals("BLA") || resType.equals("CUS") || resType.equals("ASSET"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding deployer for " + resName);
                }
                parentRoles.add("deployer");
            }
            Collections.sort(parentRoles);
            roles = parentRoles.toArray(new String[0]);
            if (resName.equals(this.CELLXML) && role.equals("monitor")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                this.updateAuthzCache(2, cacheKey, new Boolean(true));
                return true;
            }
            if (resName.equals(this.JDBCPROVIDERTEMPLATE) && role.equals("monitor")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                this.updateAuthzCache(2, cacheKey, new Boolean(true));
                return true;
            }
            if (this.checkAccess(roles, "admin-authz")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                this.updateAuthzCache(2, cacheKey, new Boolean(true));
                return true;
            }
            if (resName.endsWith("serverindex.xml") && role.equals("configurator")) {
                String[] deployerRole = new String[]{"deployer"};
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking for celllevel deployer for serverindex.xml file ");
                }
                if (this.checkAccess(deployerRole, "admin-authz")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkAccess", new Boolean(true));
                    }
                    this.updateAuthzCache(2, cacheKey, new Boolean(true));
                    return true;
                }
            }
            if ((resName.endsWith("admin-authz.xml") || resName.endsWith("authorizationgroup.xml")) && role.equals("configurator")) {
                String[] adminSecRole = new String[]{"adminsecuritymanager"};
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking for celllevel adminsecuritymanager for admin resources ");
                }
                if (this.checkAccess(adminSecRole, "admin-authz")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkAccess", new Boolean(true));
                    }
                    this.updateAuthzCache(2, cacheKey, new Boolean(true));
                    return true;
                }
            }
            if (!this.isFineGrainedAdminSecurity()) {
                this.updateAuthzCache(2, cacheKey, new Boolean(false));
                return false;
            }
            List groupNames = null;
            if (resType != null) {
                groupNames = AuthorizationGroups.getInstance().getAllResourceGroupNames(resourceName, resType);
            }
            if (groupNames != null) {
                String gCacheKey;
                String groupName;
                int i;
                boolean needFurtherCheck = false;
                ArrayList<String> gCacheKeys = new ArrayList<String>(groupNames.size());
                for (i = 0; i < groupNames.size(); ++i) {
                    groupName = (String)groupNames.get(i);
                    gCacheKey = this.createGroupCacheKey(groupName, roles);
                    gCacheKeys.add(i, gCacheKey);
                    if (this.canCache()) {
                        Boolean resCache = this.checkAccessFromCache(4, gCacheKey);
                        if (resCache != null) {
                            if (!resCache.booleanValue()) continue;
                            this.updateAuthzCache(2, cacheKey, new Boolean(true));
                            return true;
                        }
                        needFurtherCheck = true;
                        continue;
                    }
                    needFurtherCheck = true;
                }
                if (!needFurtherCheck) {
                    this.updateAuthzCache(2, cacheKey, new Boolean(false));
                    return false;
                }
                for (i = 0; i < groupNames.size(); ++i) {
                    groupName = (String)groupNames.get(i);
                    gCacheKey = (String)gCacheKeys.get(i);
                    if (!this.checkAccess(roles, groupName)) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkAccess", new Boolean(true));
                    }
                    this.updateAuthzCache(4, gCacheKey, new Boolean(true));
                    this.updateAuthzCache(2, cacheKey, new Boolean(true));
                    return true;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.checkAccess", (String)"198", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(false));
        }
        this.updateAuthzCache(2, cacheKey, new Boolean(false));
        return false;
    }

    public boolean checkAccess(String moduleName, String resourceName, String methodName) {
        String[] resourceNames = new String[2];
        String[] resourceTypes = new String[2];
        resourceNames[0] = this.node;
        resourceNames[1] = this.server;
        resourceTypes[0] = "Node";
        resourceTypes[1] = "Server";
        return this.checkAccess(moduleName, null, resourceNames, resourceTypes, methodName);
    }

    public boolean checkAccess(ObjectName name, String[] resourceNames, String[] resourceTypes, String methodName) {
        return this.checkAccess(null, name, resourceNames, resourceTypes, methodName);
    }

    public boolean checkAccess(String modName, ObjectName name, String[] resourceNames, String[] resourceTypes, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", name + " " + resourceNames[0] + " " + resourceTypes[0] + " " + methodName);
        }
        String cacheKey = null;
        try {
            Boolean resCache;
            int j;
            Boolean resCache2;
            if (this.runningAsSystem()) {
                return true;
            }
            String moduleName = null;
            moduleName = modName != null ? modName : ObjectNameHelper.getMBeanType(name);
            String resAndMethod = moduleName + ":" + methodName;
            if (resAndMethod.equals("Server:getProcessType")) {
                return this.isGrantedRoleInAnyGroup("monitor");
            }
            if (excludeList.isExcluded(moduleName, moduleName, methodName)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                return true;
            }
            if (this.canCache() && (resCache2 = this.checkAccessFromCache(3, cacheKey = this.createMbeanCacheKey(resAndMethod))) != null) {
                return resCache2;
            }
            if (this.checkAccess("admin-authz", moduleName, moduleName, methodName)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                this.updateAuthzCache(3, cacheKey, new Boolean(true));
                return true;
            }
            if (!this.isFineGrainedAdminSecurity()) {
                this.updateAuthzCache(3, cacheKey, new Boolean(false));
                return false;
            }
            String resName = new String();
            String resourceName = null;
            for (j = 0; resourceTypes != null && j < resourceTypes.length; ++j) {
                if (!resourceTypes[j].equals("Cluster")) continue;
                resourceTypes[j] = "ServerCluster";
            }
            for (j = 0; j < resourceNames.length; ++j) {
                if (j > 0) {
                    resName = resName + "/";
                }
                resName = resName + this.getResType(resourceTypes[j]) + "/" + resourceNames[j];
            }
            String resType = resourceTypes[j - 1];
            if (resourceTypes.length == 1 && resourceTypes[0].equals("Server")) {
                resName = "nodes/" + this.node + "/" + resName;
            }
            if (resName.indexOf("cells/") < 0) {
                resourceName = resName.startsWith("/") ? "cells/" + this.cell + resName : "cells/" + this.cell + "/" + resName;
            }
            if (resourceTypes != null && resourceTypes.length > 0 && resourceTypes[0].equals("ResourceURI")) {
                resType = ResourceInstanceRelations.getInstance().getResourceType(resourceNames[0]);
                resourceName = resType != null ? ResourceInstanceRelations.getInstance().convertCfgId(resourceNames[0], resType) : resName;
            }
            if (this.canCache() && (resCache = this.checkAccessFromCache(3, cacheKey = this.createMbeanCacheKey(resourceName, resType, resAndMethod))) != null) {
                return resCache;
            }
            List groupNames = AuthorizationGroups.getInstance().getAllResourceGroupNames(resourceName, resType);
            if (groupNames != null) {
                String gCacheKey;
                String groupName;
                int i;
                boolean needFurtherCheck = false;
                ArrayList<String> gCacheKeys = new ArrayList<String>(groupNames.size());
                for (i = 0; i < groupNames.size(); ++i) {
                    groupName = (String)groupNames.get(i);
                    gCacheKey = this.createGroupCacheKey(groupName, moduleName, methodName);
                    gCacheKeys.add(i, gCacheKey);
                    if (this.canCache()) {
                        Boolean resCache3 = this.checkAccessFromCache(4, gCacheKey);
                        if (resCache3 != null) {
                            if (!resCache3.booleanValue()) continue;
                            this.updateAuthzCache(3, cacheKey, new Boolean(true));
                            return true;
                        }
                        needFurtherCheck = true;
                        continue;
                    }
                    needFurtherCheck = true;
                }
                if (!needFurtherCheck) {
                    this.updateAuthzCache(3, cacheKey, new Boolean(false));
                    return false;
                }
                for (i = 0; i < groupNames.size(); ++i) {
                    groupName = (String)groupNames.get(i);
                    gCacheKey = (String)gCacheKeys.get(i);
                    if (!this.checkAccess(groupName, moduleName, moduleName, methodName)) continue;
                    this.updateAuthzCache(4, gCacheKey, new Boolean(true));
                    this.updateAuthzCache(3, cacheKey, new Boolean(true));
                    return true;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.checkAccess", (String)"300", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(false));
        }
        this.updateAuthzCache(3, cacheKey, new Boolean(false));
        return false;
    }

    public boolean isCallerInRole(String groupName, String role) {
        Boolean resCache;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerInRole", groupName + " " + role);
        }
        if (this.runningAsSystem()) {
            return true;
        }
        String cacheKey = null;
        RoleBasedAuthorizer ra = null;
        boolean res = false;
        if (groupName == null) {
            return false;
        }
        if (this.canCache() && (resCache = this.checkAccessFromCache(1, cacheKey = this.createUserCacheKey(groupName, role))) != null) {
            return resCache;
        }
        ContextManager ctxManager = ContextManagerFactory.getInstance();
        String authzTableName = ctxManager.getProperty("com.ibm.websphere.security.authorizationTable", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "groupName ", groupName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzTableName ", authzTableName);
        }
        boolean externalProvider = false;
        if (groupName.equals("admin-authz-merge") && authzTableName != null && authzTableName.length() != 0) {
            externalProvider = true;
        }
        if (externalProvider) {
            res = this.checkAllGroups(role);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCallerInRole ", new Boolean(res));
            }
            this.updateAuthzCache(1, cacheKey, new Boolean(res));
            return res;
        }
        try {
            String ctxt = groupName;
            if (!groupName.startsWith("admin-authz")) {
                ctxt = "admin-authz-" + groupName;
            }
            if (ctxt.equals("admin-authz-merge") && !this.isFineGrainedAdminSecurity()) {
                ctxt = "admin-authz";
            }
            ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isCallerInRole", (String)"327", (Object)this);
        }
        if (ra != null) {
            List allRoles = this.getAllParentRoles(role);
            allRoles.add(role);
            String[] roles = allRoles.toArray(new String[0]);
            res = ra.isGrantedAnyRole(roles);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerInRole", new Boolean(res));
        }
        this.updateAuthzCache(1, cacheKey, new Boolean(res));
        return res;
    }

    public boolean isCallerInRole(String roleName) {
        Boolean resCache;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerInRole", roleName);
        }
        String cacheKey = null;
        if (this.runningAsSystem()) {
            return true;
        }
        String resType = null;
        String role = roleName;
        boolean res = false;
        if (this.canCache() && (resCache = this.checkAccessFromCache(1, cacheKey = this.createUserCacheKey(roleName))) != null) {
            return resCache;
        }
        int i = roleName.indexOf(58);
        if (i > 0) {
            resType = roleName.substring(0, i);
            role = roleName.substring(i + 1);
            res = this.checkAccess(resType, role);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCallerInRole", new Boolean(res));
            }
            this.updateAuthzCache(1, cacheKey, new Boolean(res));
            return res;
        }
        i = roleName.indexOf("-");
        if (i > 0) {
            resType = roleName.substring(0, i);
            role = roleName.substring(i + 1);
        }
        if (resType == null || resType.equals("Any")) {
            ContextManager ctxManager = ContextManagerFactory.getInstance();
            String authzTableName = ctxManager.getProperty("com.ibm.websphere.security.authorizationTable", null);
            if (authzTableName != null && authzTableName.length() > 0) {
                res = this.checkAllGroups(role);
                this.updateAuthzCache(1, cacheKey, new Boolean(res));
                return res;
            }
            String ctxt = "admin-authz-merge";
            if (!this.isFineGrainedAdminSecurity()) {
                ctxt = "admin-authz";
            }
            res = this.isCallerInRole(ctxt, role);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCallerInRole", new Boolean(res));
            }
            this.updateAuthzCache(1, cacheKey, new Boolean(res));
            return res;
        }
        if (this.isCallerInRole("admin-authz", role)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCallerInRole", new Boolean(true));
            }
            this.updateAuthzCache(1, cacheKey, new Boolean(true));
            return true;
        }
        Collection ags = AuthorizationGroups.getInstance().getGroups();
        Iterator itr = ags.iterator();
        List allResourceTypes = ResourceRelations.getInstance().getAllParentResources(resType);
        allResourceTypes.add(resType);
        while (itr.hasNext()) {
            AuthorizationGroup ag = (AuthorizationGroup)itr.next();
            if (!this.groupContainsResourceTypes(allResourceTypes, ag) || !this.isCallerInRole(ag.getGroupName(), role)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCallerInRole", new Boolean(true));
            }
            this.updateAuthzCache(1, cacheKey, new Boolean(true));
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerInRole", new Boolean(res));
        }
        this.updateAuthzCache(1, cacheKey, new Boolean(res));
        return res;
    }

    private boolean groupContainsResourceTypes(List resTypes, AuthorizationGroup ag) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "groupContainsResourceTypes", new Object[]{resTypes, ag});
        }
        boolean result = false;
        for (int i = 0; resTypes != null && i < resTypes.size(); ++i) {
            String resType = (String)resTypes.get(i);
            if (!ag.hasResourceType(resType)) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "groupContainsResourceTypes", new Boolean(result));
        }
        return result;
    }

    public List getAllParentRoles(String roleName) {
        ArrayList parentRoles;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllParentRoles", roleName);
        }
        if ((parentRoles = RoleRelations.getInstance().getAllParentRoles(roleName)) == null) {
            parentRoles = new ArrayList();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parent roles are");
            for (String parentRole : parentRoles) {
                Tr.debug(tc, "role=", parentRole);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllParentRoles");
        }
        return parentRoles;
    }

    public List getParentRoles(String roleName) {
        ArrayList parentRoles;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentRoles", roleName);
        }
        if ((parentRoles = RoleRelations.getInstance().getParentRoles(roleName)) == null) {
            parentRoles = new ArrayList();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parent roles are");
            for (String parentRole : parentRoles) {
                Tr.debug(tc, "role=", parentRole);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentRoles");
        }
        return parentRoles;
    }

    public void setRoleBasedConfigurator(RoleBasedConfigurator roleBasedConfigurator) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)adminPermission);
        }
        this.rbc = roleBasedConfigurator;
    }

    public RoleBasedConfigurator getRoleBasedConfigurator() {
        return this.rbc;
    }

    private boolean checkAccess(String groupName, String moduleName, String resourceName, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", "Group = " + groupName + " resource = " + resourceName);
        }
        RoleBasedAuthorizer ra = null;
        boolean res = false;
        if (groupName == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAccess", new Boolean(res));
            }
            return res;
        }
        try {
            String ctxt = groupName;
            if (!groupName.startsWith("admin-authz")) {
                ctxt = "admin-authz-" + groupName;
            }
            ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.checkAccess", (String)"467", (Object)this);
        }
        if (ra != null) {
            res = ra.checkAccess(moduleName, resourceName, methodName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(res));
        }
        return res;
    }

    private boolean checkAccess(String[] roles, String groupName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", groupName + " " + this.arrToStr(roles));
        }
        RoleBasedAuthorizer ra = null;
        boolean res = false;
        if (groupName == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAccess", new Boolean(res));
            }
            return res;
        }
        try {
            String ctxt = groupName;
            if (!groupName.startsWith("admin-authz")) {
                ctxt = "admin-authz-" + groupName;
            }
            ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.checkAccess", (String)"496", (Object)this);
        }
        String[] newRoles = this.getValidRoles(roles, groupName);
        if (ra != null) {
            res = ra.isGrantedAnyRole(newRoles);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(res));
        }
        return res;
    }

    public void setCellName(String cellName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)adminPermission);
        }
        this.cell = cellName;
        this.CELLXML = "cells/" + this.cell + "/cell.xml";
        this.JDBCPROVIDERTEMPLATE = "templates/system/jdbc-resource-provider-templates.xml";
    }

    public void setNodeName(String nodeName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)adminPermission);
        }
        this.node = nodeName;
    }

    public void setServerName(String serverName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)adminPermission);
        }
        this.server = serverName;
    }

    public void setCacheEnabled() {
        this.globalCanCache = true;
    }

    public void setCacheDisabled() {
        this.globalCanCache = false;
    }

    private boolean runningAsSystem() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runningAsSystem");
        }
        try {
            Subject invocationSubject = ContextManagerFactory.getInstance().getInvocationSubject();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InvocationSubject = ", invocationSubject);
            }
            if (invocationSubject != null && ContextManagerFactory.getInstance().isServerSubject(invocationSubject)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "runningAsSystem", new Boolean(true));
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runningAsSystem", new Boolean(false));
        }
        return false;
    }

    public boolean isGrantedRoleInAnyGroup(String role) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedRoleInAnyGroup", role);
        }
        RoleBasedAuthorizer ra = null;
        boolean res = false;
        String[] roles = null;
        List parentRoles = RoleRelations.getInstance().getAllParentRoles(role);
        parentRoles.add(role);
        roles = parentRoles.toArray(new String[0]);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checking for roles ", "admin-authz");
            for (int i = 0; i < roles.length; ++i) {
                Tr.debug(tc, "role=", roles[i]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking group ", "admin-authz");
        }
        try {
            String ctxt = "admin-authz";
            ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedRoleInAnyGroup", (String)"617", (Object)this);
        }
        if (ra != null) {
            res = ra.isGrantedAnyRole(roles);
        }
        if (res) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedRoleInAnyGroup", new Boolean(res));
            }
            return res;
        }
        String[] newRoles = this.getValidRoles(roles, null);
        List groupNames = AuthorizationGroups.getInstance().getGroupNames();
        for (String groupName : groupNames) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking group ", groupName);
            }
            try {
                String ctxt = "admin-authz-" + groupName;
                ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedRoleInAnyGroup", (String)"636", (Object)this);
            }
            if (ra != null) {
                res = ra.isGrantedAnyRole(newRoles);
            }
            if (!res) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedRoleInAnyGroup", new Boolean(res));
            }
            return res;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRoleInAnyGroup", new Boolean(res));
        }
        return res;
    }

    private String getResType(String cfgType) {
        return ResourceInstanceRelations.getInstance().getUniversalResourceType(cfgType);
    }

    private String[] getValidRoles(String[] roles, String groupName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValidRoles", new Object[]{this.arrToStr(roles), groupName});
        }
        if (groupName != null && groupName.startsWith("admin-authz")) {
            return roles;
        }
        ArrayList<String> reqRoles = new ArrayList<String>();
        List customRoles = RoleRelations.getInstance().getCustomRoles();
        for (int i = 0; i < roles.length; ++i) {
            boolean found = false;
            for (String cRole : customRoles) {
                if (!cRole.equals(roles[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            reqRoles.add(roles[i]);
        }
        String[] newRoles = reqRoles.toArray(new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValidRoles", this.arrToStr(newRoles));
        }
        return newRoles;
    }

    private String arrToStr(String[] arr) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i == 0) {
                sbuf.append(arr[i]);
                continue;
            }
            sbuf.append(":");
            sbuf.append(arr[i]);
        }
        return sbuf.toString();
    }

    private boolean checkAllGroups(String role) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAllGroups", role);
        }
        boolean res = false;
        if (this.isCallerInRole("admin-authz", role)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAllGroups", new Boolean(true));
            }
            return true;
        }
        Collection ags = AuthorizationGroups.getInstance().getGroups();
        for (AuthorizationGroup ag : ags) {
            if (!this.isCallerInRole(ag.getGroupName(), role)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAllGroups", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAllGroups", new Boolean(res));
        }
        return res;
    }

    public void setAuthzCache(AuthzCache aCache) {
        this.authzCache = aCache;
    }

    private String getCallerId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerId");
        }
        String id = null;
        try {
            Subject invocationSubject = ContextManagerFactory.getInstance().getInvocationSubject();
            if (invocationSubject != null) {
                WSCredential cred = SubjectHelper.getWSCredentialFromSubject((Subject)invocationSubject);
                if (cred != null) {
                    id = cred.getAccessId();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCallerId", id);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerId", id);
        }
        return id;
    }

    public boolean isGrantedMinimumRolesForMBean(String moduleName, String resourceName, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedMinimumRolesForMBean", new Object[]{moduleName, resourceName, methodName});
        }
        boolean permissionGranted = false;
        ContextManager ctxManager = ContextManagerFactory.getInstance();
        String authzTableName = ctxManager.getProperty("com.ibm.websphere.security.authorizationTable", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzTableName ", authzTableName);
        }
        boolean externalProvider = false;
        if (authzTableName != null && authzTableName.length() != 0) {
            externalProvider = true;
        }
        if (!externalProvider) {
            String ctxt = "admin-authz-merge";
            if (!this.isFineGrainedAdminSecurity()) {
                ctxt = "admin-authz";
            }
            try {
                RoleBasedAuthorizer ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
                permissionGranted = ra.checkAccess(moduleName, resourceName, methodName);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedMinimumRolesForMBean", (String)"617", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedMinimumRolesForMBean", new Boolean(permissionGranted));
            }
            return permissionGranted;
        }
        try {
            String ctxt = "admin-authz";
            RoleBasedAuthorizer ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
            permissionGranted = ra.checkAccess(moduleName, resourceName, methodName);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedMinimumRolesForMBean", (String)"617", (Object)this);
        }
        if (permissionGranted) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedMinimumRolesForMBean", new Boolean(permissionGranted));
            }
            return permissionGranted;
        }
        Collection ags = AuthorizationGroups.getInstance().getGroups();
        for (AuthorizationGroup ag : ags) {
            String ctxt = "admin-authz-" + ag.getGroupName();
            try {
                RoleBasedAuthorizer ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
                permissionGranted = ra.checkAccess(moduleName, resourceName, methodName);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedMinimumRolesForMBean", (String)"617", (Object)this);
            }
            if (!permissionGranted) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedMinimumRolesForMBean", new Boolean(permissionGranted));
            }
            return permissionGranted;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedMinimumRolesForMBean", new Boolean(permissionGranted));
        }
        return permissionGranted;
    }

    public boolean isGrantedRole(String[] roleNames, Subject subject) {
        ContextManager ctxManager;
        String authzTableName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedRole", new Object[]{roleNames, subject});
        }
        if ((authzTableName = (ctxManager = ContextManagerFactory.getInstance()).getProperty("com.ibm.websphere.security.authorizationTable", null)) != null && authzTableName.length() > 0) {
            return this.checkAllGroups(roleNames, subject);
        }
        RoleBasedAuthorizer ra = null;
        try {
            String ctxt = "admin-authz-merge";
            if (!this.isFineGrainedAdminSecurity()) {
                ctxt = "admin-authz";
            }
            ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedRole", (String)"327", (Object)this);
            return false;
        }
        if (ra.isGrantedRole(roleNames, subject)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAllGroups", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRole", new Boolean(false));
        }
        return false;
    }

    private boolean checkAllGroups(String[] roles, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAllGroups", roles);
        }
        boolean res = false;
        RoleBasedAuthorizer ra = null;
        try {
            String ctxt = "admin-authz";
            ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.checkAllGroups", (String)"327", (Object)this);
            return false;
        }
        if (ra.isGrantedRole(roles, subject)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAllGroups", new Boolean(true));
            }
            return true;
        }
        Collection ags = AuthorizationGroups.getInstance().getGroups();
        for (AuthorizationGroup ag : ags) {
            try {
                String ctxt = "admin-authz-" + ag.getGroupName();
                ra = this.rbc.getRoleBasedAuthorizer(ctxt, scope);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.authorizer.AdminAuthorizerImpl.checkAllGroups", (String)"327", (Object)this);
                return false;
            }
            if (!ra.isGrantedRole(roles, subject)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAllGroups", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAllGroups", new Boolean(res));
        }
        return res;
    }

    private boolean canCache() {
        return this.globalCanCache;
    }

    private void updateAuthzCache(int type, String cacheKey, Boolean value) {
        if (this.canCache()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caching ", new Object[]{cacheKey, value});
            }
            this.authzCache.addEntry(type, cacheKey, value);
        }
    }

    private Boolean checkAccessFromCache(int type, String cacheKey) {
        if (this.canCache()) {
            Boolean res = (Boolean)this.authzCache.getEntry(type, cacheKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "result from cache ", new Object[]{cacheKey, res});
            }
            return res;
        }
        return null;
    }

    private String createConfigCacheKey(String res, String resType, String role) {
        String callerId = this.getCallerId();
        return this.createConfigCacheKey(res, resType, role, callerId);
    }

    private String createConfigCacheKey(String res, String resType, String role, String user) {
        StringBuffer sb = null;
        sb = resType != null ? new StringBuffer(resType) : new StringBuffer("Cell");
        sb.append(":").append(res).append(":").append(role).append(":").append(user);
        return sb.toString();
    }

    private String createMbeanCacheKey(String mbeanMethod) {
        String callerId = this.getCallerId();
        StringBuffer sb = new StringBuffer(mbeanMethod);
        sb.append(":").append(callerId);
        return sb.toString();
    }

    private String createUserCacheKey(String role) {
        String callerId = this.getCallerId();
        StringBuffer sb = new StringBuffer(role);
        sb.append(":").append(callerId);
        return sb.toString();
    }

    private String createUserCacheKey(String groupName, String role) {
        String callerId = this.getCallerId();
        StringBuffer sb = new StringBuffer(groupName);
        sb.append(":").append(role).append(":").append(callerId);
        return sb.toString();
    }

    private String createGroupCacheKey(String groupName, String[] roles) {
        String callerId = this.getCallerId();
        StringBuffer sb = new StringBuffer(groupName);
        for (int i = 0; i < roles.length; ++i) {
            sb.append(":");
            sb.append(roles[i]);
        }
        sb.append(":").append(callerId);
        return sb.toString();
    }

    private String createGroupCacheKey(String groupName, String moduleName, String methodName) {
        String callerId = this.getCallerId();
        StringBuffer sb = new StringBuffer(groupName);
        sb.append(":").append(callerId).append(":").append(moduleName).append(":").append(methodName);
        return sb.toString();
    }

    private String createMbeanCacheKey(String res, String resType, String mbeanMethod) {
        String callerId = this.getCallerId();
        StringBuffer sb = new StringBuffer(resType);
        sb.append(":").append(res).append(":").append(mbeanMethod).append(":").append(callerId);
        return sb.toString();
    }
}

