/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import com.ibm.wsspi.runtime.config.ConfigService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public final class RoutingTable
implements NotificationListener {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(RoutingTable.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static RoutingTable _instance;
    private String endpointUUID;
    private Map _rt;
    private Map _rtStateMachine;
    private Map _disabled_rt;
    private Map _disabled_rtStateMachine;
    private List _routingListeners;
    private RoutingListener[] listenerArray;
    private Accessor parent;
    private StateMachine parentStateMachine;
    private StateMachineCallback parentStateMachineCallback;
    private StateMachineCallback childStateMachineCallback;
    private int numMonitorThreads = 0;
    private boolean nodeAgentListenerAdded = false;
    private ServerInfo ownInfo;
    private Map agentPingThreads = new HashMap();
    HashMap myXCFGroupMembers = new HashMap();
    boolean xcfMonitor_Enabled = false;
    String myXCFHostCellNode = null;
    boolean isCellRegistered = false;
    public static final String[] eventNames;
    public static final String[] stateNames;

    private RoutingTable() {
        this.endpointUUID = AdminContext.peek();
        this._rt = Collections.synchronizedMap(new HashMap());
        this._rtStateMachine = Collections.synchronizedMap(new HashMap());
        this._disabled_rt = Collections.synchronizedMap(new HashMap());
        this._disabled_rtStateMachine = Collections.synchronizedMap(new HashMap());
        this.parentStateMachine = new StateMachine();
        this.parentStateMachineCallback = new ParentStateMachineCallback();
        this.childStateMachineCallback = new ChildStateMachineCallback();
        this._routingListeners = new ArrayList();
        this.listenerArray = new RoutingListener[0];
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String cellName = AdminServiceFactory.getAdminService().getCellName();
            String nodeName = AdminServiceFactory.getAdminService().getNodeName();
            this.myXCFHostCellNode = "MyHost" + cellName + nodeName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "myXCFHostCellNode: " + this.myXCFHostCellNode);
            }
            String xcfmonitor = System.getProperty("was.xcfmonitor.enabled");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "xcfmonitor: " + xcfmonitor);
            }
            this.xcfMonitor_Enabled = xcfmonitor == null ? true : xcfmonitor.equalsIgnoreCase("true");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "xcfMonitor_Enabled: " + this.xcfMonitor_Enabled);
            }
        }
    }

    public static synchronized RoutingTable getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance with UUID: " + AdminContext.peek());
        }
        String profileKey = AdminContext.peek();
        RoutingTable rt = null;
        if (profileKey == null) {
            if (_instance == null) {
                _instance = new RoutingTable();
            }
            rt = _instance;
        } else {
            rt = (RoutingTable)AdminSubsystemServiceRegistry.getService((String)RoutingTable.class.getName());
            if (rt == null) {
                rt = new RoutingTable();
                AdminSubsystemServiceRegistry.addService((String)RoutingTable.class.getName(), (Object)rt);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return rt;
    }

    public synchronized void shutdown() {
        this.checkAdminContext();
        this.parentStateMachineCallback.stopMonitor(this.parent);
        this.childStateMachineCallback.stopMonitor(this.parent);
    }

    public synchronized void addRoutingListener(RoutingListener l) {
        this.checkAdminContext();
        if (l != null && l instanceof NodeSync) {
            this._routingListeners.add(0, l);
        } else {
            this._routingListeners.add(l);
        }
        this.listenerArray = this._routingListeners.toArray(new RoutingListener[0]);
    }

    public synchronized void removeRoutingListener(RoutingListener l) {
        this.checkAdminContext();
        this._routingListeners.remove(l);
        this.listenerArray = this._routingListeners.toArray(new RoutingListener[0]);
    }

    public String getProductVersion(String name) {
        this.checkAdminContext();
        Accessor accessor = (Accessor)this._rt.get(name);
        if (accessor != null) {
            return accessor.getServerInfo().getVersion();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminClient getParent() throws ConnectorException {
        boolean tryGetParent = false;
        this.checkAdminContext();
        RoutingTable routingTable = this;
        synchronized (routingTable) {
            if (this.parent != null && this.parentStateMachine.getState() == 1) {
                tryGetParent = true;
            }
        }
        if (tryGetParent) {
            return this.parent.getConnector();
        }
        throw new ConnectorNotAvailableException();
    }

    public boolean connectedToParent(long timeout) {
        this.checkAdminContext();
        while (this.parent == null && timeout > 0L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeout -= 500L;
        }
        return this.parent != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String name) {
        this.checkAdminContext();
        Accessor accessor = (Accessor)this._rt.get(name);
        if (accessor != null) {
            return accessor.getSession();
        }
        RoutingTable routingTable = this;
        synchronized (routingTable) {
            if (this.parent != null && this.parent.getName().equals(name)) {
                return this.parent.getSession();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPid(String name) {
        this.checkAdminContext();
        Accessor accessor = (Accessor)this._rt.get(name);
        if (accessor != null) {
            return accessor.getPid();
        }
        RoutingTable routingTable = this;
        synchronized (routingTable) {
            if (this.parent != null && this.parent.getName().equals(name)) {
                return this.parent.getPid();
            }
            return "";
        }
    }

    public void setOwnInfo(ServerInfo self) {
        this.checkAdminContext();
        this.ownInfo = self;
    }

    public ServerInfo getOwnInfo() {
        this.checkAdminContext();
        return this.ownInfo;
    }

    public boolean isRoutable(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRoutable", name);
        }
        this.checkAdminContext();
        Accessor accessor = (Accessor)this._rt.get(name);
        if (accessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRoutable - false");
            }
            return false;
        }
        boolean routable = accessor.isRoutable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRoutable: " + routable);
        }
        return routable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminClient[] getAdminClients() {
        Accessor[] accessors;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClients");
        }
        this.checkAdminContext();
        RoutingTable routingTable = this;
        synchronized (routingTable) {
            accessors = new Accessor[this._rt.size()];
            accessors = this._rt.values().toArray(accessors);
        }
        AdminClient[] clients = new AdminClient[accessors.length];
        for (int i = 0; i < clients.length; ++i) {
            try {
                clients[i] = accessors[i].getConnector();
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RoutingTable.getAdminClients", (String)"177", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "failed to get one AdminClient", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClients " + clients.length);
        }
        return clients;
    }

    public AdminClient getAdminClient(String name) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient", name);
        }
        this.checkAdminContext();
        Accessor accessor = (Accessor)this._rt.get(name);
        if (accessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdminClient - fail");
            }
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return accessor.getConnector();
    }

    public AdminClient getAdminClient(String name, String connectorType) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient", new Object[]{name, connectorType});
        }
        this.checkAdminContext();
        Accessor accessor = (Accessor)this._rt.get(name);
        if (accessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdminClient - fail");
            }
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return accessor.getConnector(connectorType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChild", serverInfo);
        }
        this.checkAdminContext();
        Subject savedSubject = null;
        try {
            Accessor tmpAccessor;
            Session tmpSession;
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                savedSubject = this.pushServerSubject();
            }
            if ((tmpSession = (tmpAccessor = new Accessor(serverInfo)).resetSession()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "can't get session");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addChild", serverInfo);
                }
                return;
            }
            if (this.xcfMonitor_Enabled) {
                if (AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NOT adding Nodeagent to XCF group list.");
                    }
                } else {
                    String memberName = this.myXCFHostCellNode + serverInfo.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "memberName: " + memberName);
                    }
                    Long context = new Long(0L);
                    if (!this.isXCFGroupMember(memberName)) {
                        this.addXCFGroupMember(memberName, context);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "addChild: Member " + memberName + " is ALREADY a member of group. Context: " + context);
                        Tr.debug(tc, "Context from GroupMember: " + this.getXCFGroupMember(memberName));
                    }
                }
            }
            String name = serverInfo.getRole().equals("NodeAgent") ? serverInfo.getNode() : serverInfo.getName();
            RoutingTable routingTable = this;
            synchronized (routingTable) {
                StateMachine stateMachine = (StateMachine)this._rtStateMachine.get(name);
                if (stateMachine == null) {
                    stateMachine = new StateMachine();
                    this._rtStateMachine.put(name, stateMachine);
                }
                stateMachine.transition(0, tmpSession, tmpAccessor, this.childStateMachineCallback);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.RoutingTable.addChild", (String)"247", (Object)this);
        }
        finally {
            if (savedSubject != null) {
                SecurityHelper.popInvocationSubject(savedSubject);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChild:", serverInfo);
        }
    }

    private void childRouteAdded(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childRouteAdded", accessor);
        }
        try {
            ServerInfo serverInfo = accessor.getServerInfo();
            String name = serverInfo.getName();
            if (serverInfo.getRole().equals("NodeAgent")) {
                name = serverInfo.getNode();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding to RoutingTable " + name);
            }
            this._rt.put(name, accessor);
            new AddChildThread(serverInfo).start();
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.RoutingTable.addChild", (String)"203", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChild");
        }
    }

    private void childRouteRemoved(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childRouteRemoved", accessor);
        }
        try {
            ServerInfo serverInfo = accessor.getServerInfo();
            String name = serverInfo.getName();
            if (serverInfo.getRole().equals("NodeAgent")) {
                name = serverInfo.getNode();
            }
            this._rt.remove(name);
            new RemoveChildThread(serverInfo).start();
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.RoutingTable.childRouteRemoved", (String)"314", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childRouteRemoved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeAgentListener() {
        RoutingTable routingTable = this;
        synchronized (routingTable) {
            if (this.nodeAgentListenerAdded) {
                return;
            }
            this.nodeAgentListenerAdded = true;
        }
        try {
            ObjectName nodeAgentServers = new ObjectName("WebSphere:*,type=Server,processType=NodeAgent");
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("j2ee.state.stopping");
            AdminServiceFactory.getAdminService().addNotificationListenerExtended(nodeAgentServers, this, filter, null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    public boolean isChildDisabled(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isChildDisabled", name);
        }
        this.checkAdminContext();
        boolean retVal = this._disabled_rt.containsKey(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isChildDisabled", new Boolean(retVal));
        }
        return retVal;
    }

    public AdminClient getDisabledAdminClient(String name) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient", name);
        }
        this.checkAdminContext();
        Accessor accessor = (Accessor)this._disabled_rt.get(name);
        if (accessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdminClient - fail");
            }
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return accessor.getConnector();
    }

    public synchronized void disableChild(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableChild", name);
        }
        this.checkAdminContext();
        Accessor accessor = (Accessor)this._rt.get(name);
        StateMachine stateMachine = (StateMachine)this._rtStateMachine.get(name);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Accessor, StateMachine", new Object[]{accessor, stateMachine});
        }
        if (accessor != null) {
            this._disabled_rt.put(name, accessor);
            this._rt.remove(name);
        }
        if (stateMachine != null) {
            this._disabled_rtStateMachine.put(name, stateMachine);
            this._rtStateMachine.remove(name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableChild");
        }
    }

    public synchronized void enableChild(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enableChild", name);
        }
        this.checkAdminContext();
        Accessor accessor = (Accessor)this._disabled_rt.get(name);
        StateMachine stateMachine = (StateMachine)this._disabled_rtStateMachine.get(name);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Accessor, StateMachine", new Object[]{accessor, stateMachine});
        }
        if (accessor != null) {
            this._rt.put(name, accessor);
            this._disabled_rt.remove(name);
        }
        if (stateMachine != null) {
            this._rtStateMachine.put(name, stateMachine);
            this._disabled_rtStateMachine.remove(name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enableChild");
        }
    }

    public synchronized void removeChild(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeChild", name);
        }
        this.checkAdminContext();
        boolean removed = false;
        Accessor accessor = (Accessor)this._rt.get(name);
        StateMachine stateMachine = (StateMachine)this._rtStateMachine.get(name);
        if (stateMachine != null) {
            stateMachine.transition(3, null, accessor, this.childStateMachineCallback);
            this._rtStateMachine.remove(name);
        }
        if (accessor == null && tc.isEntryEnabled()) {
            Tr.exit(tc, "remove - not in cache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeChild");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParent(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addParent");
        }
        this.checkAdminContext();
        Subject savedSubject = null;
        try {
            Accessor tmpAccessor;
            Session tmpSession;
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                savedSubject = this.pushServerSubject();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parent's name is: " + serverInfo.getName());
            }
            if ((tmpSession = (tmpAccessor = new Accessor(serverInfo)).resetSession()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "null tmpSession");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addParent");
                }
                return;
            }
            if (this.xcfMonitor_Enabled) {
                if (AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NOT adding Dmgr to XCF group list.");
                    }
                } else {
                    String memberName = this.myXCFHostCellNode + serverInfo.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "memberName: " + memberName);
                    }
                    Long context = new Long(0L);
                    if (!this.isXCFGroupMember(memberName)) {
                        this.addXCFGroupMember(memberName, context);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "addParent: Member " + memberName + " is ALREADY a member of group. Context: " + context);
                        Tr.debug(tc, "Context from GroupMember: " + this.getXCFGroupMember(memberName));
                    }
                }
            }
            RoutingTable routingTable = this;
            synchronized (routingTable) {
                this.parentStateMachine.transition(0, tmpSession, tmpAccessor, this.parentStateMachineCallback);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.RoutingTable.addParent", (String)"399", (Object)this);
        }
        finally {
            if (savedSubject != null) {
                SecurityHelper.popInvocationSubject(savedSubject);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addParent");
        }
    }

    public synchronized void removeParent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeParent");
        }
        this.checkAdminContext();
        Accessor accessor = this.parent;
        if (this.parentStateMachine != null) {
            this.parentStateMachine.transition(3, null, accessor, this.parentStateMachineCallback);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeParent");
        }
    }

    private void notifyParentAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyParentAdded");
        }
        for (int i = 0; i < this.listenerArray.length; ++i) {
            try {
                new notifyParentAddedThread(serverInfo, this.listenerArray[i]).start();
                continue;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.RoutingTable.notifyParentAdded", (String)"449", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyParentAdded");
        }
    }

    private void parentRouteAdded(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentRouteAdded");
        }
        this.parent = accessor;
        try {
            new AddParentThread(accessor.getServerInfo()).start();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.RoutingTable.parentRouteAdded", (String)"469", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentRouteAdded");
        }
    }

    private void parentRouteRemoved(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentRouteRemoved");
        }
        if (this.parent == null) {
            return;
        }
        this.parent = null;
        ServerInfo serverInfo = accessor.getServerInfo();
        for (int i = 0; i < this.listenerArray.length; ++i) {
            try {
                this.listenerArray[i].parentRemoved(serverInfo);
                continue;
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.RoutingTable.removeParent", (String)"392", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "exception thrown from the routing listener: parentRouteRemoved", th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeParent");
        }
    }

    private Subject pushServerSubject() {
        Subject savedSubject = null;
        Subject secSubject = null;
        try {
            secSubject = SecurityHelper.getOwnedSubject();
            if (secSubject != null) {
                savedSubject = SecurityHelper.pushInvocationSubject(secSubject);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RoutingTable.pushServerSubject", (String)"612", (Object)this);
        }
        return savedSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification ntfyObj, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", ntfyObj);
        }
        this.checkAdminContext();
        String nodeName = ((ObjectName)ntfyObj.getSource()).getKeyProperty("node");
        Map map = this.agentPingThreads;
        synchronized (map) {
            List threads = (List)this.agentPingThreads.get(nodeName);
            if (threads != null) {
                Iterator it = threads.iterator();
                while (it.hasNext()) {
                    ((Thread)it.next()).interrupt();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXCFGroupMember(String memberName) {
        HashMap hashMap = this.myXCFGroupMembers;
        synchronized (hashMap) {
            boolean isMember = this.myXCFGroupMembers.containsKey(memberName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isXCFGroupMember: " + isMember + " for member " + memberName);
            }
            return isMember;
        }
    }

    public HashMap getXCFGroupMembers() {
        return this.myXCFGroupMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getXCFGroupMember(String memberName) {
        HashMap hashMap = this.myXCFGroupMembers;
        synchronized (hashMap) {
            if (this.myXCFGroupMembers.containsKey(memberName)) {
                return (Long)this.myXCFGroupMembers.get(memberName);
            }
            return new Long(0L);
        }
    }

    public String getmyXCFHostCellNode() {
        return this.myXCFHostCellNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXCFGroupMember(String memberName, Long context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addXCFGroupMember", memberName);
        }
        HashMap hashMap = this.myXCFGroupMembers;
        synchronized (hashMap) {
            this.myXCFGroupMembers.put(memberName, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addXCFGroupMember");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXCFGroupMember(String memberName) {
        Accessor accessor;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeXCFGroupMember", memberName);
        }
        HashMap hashMap = this.myXCFGroupMembers;
        synchronized (hashMap) {
            this.myXCFGroupMembers.remove(memberName);
        }
        String name = memberName.substring(this.myXCFHostCellNode.length());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "member name: " + name);
        }
        if ((accessor = (Accessor)this._rt.get(name)) != null) {
            this.removeChild(name);
        } else if (name.equals("adminagent") || name.equals("nodeagent")) {
            this.removeParent();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "memberName is NOT in routing table(children) and NOT a parent.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeXCFGroupMember");
        }
    }

    public boolean isXCFMonitorEnabled() {
        return this.xcfMonitor_Enabled;
    }

    private synchronized void incrMonitorThreads() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "incrMonitorThreads");
        }
        ++this.numMonitorThreads;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "numMonitorThread: " + this.numMonitorThreads);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "incrMonitorThreads");
        }
    }

    private synchronized void decrMonitorThreads() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrMonitorThreads");
        }
        --this.numMonitorThreads;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "numMonitorThread: " + this.numMonitorThreads);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrMonitorThreads");
        }
    }

    public void checkAdminContext() {
        String contextUUID = AdminContext.peek();
        if (this.endpointUUID == contextUUID || this.endpointUUID != null && this.endpointUUID.equals(contextUUID) || contextUUID != null && contextUUID.equals(this.endpointUUID)) {
            return;
        }
        IllegalStateException ex = new IllegalStateException("RoutingTable was created for admin subsystem " + this.endpointUUID + " but top of AdminContext stack  contains: " + contextUUID);
        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RoutingTable.checkAdminContext", (String)"1909");
        throw ex;
    }

    static {
        eventNames = new String[]{"DISCOVERY_EVENT", "REACHABLE_EVENT", "NOT_REACHABLE_EVENT", "RESET_EVENT"};
        stateNames = new String[]{"INIT_STATE", "MONITOR_STATE", "RECOVERY_STATE"};
    }

    public class StateMachine {
        public static final int INIT_STATE = 0;
        public static final int MONITOR_STATE = 1;
        public static final int RECOVERY_STATE = 2;
        public static final int DISCOVERY_EVENT = 0;
        public static final int REACHABLE_EVENT = 1;
        public static final int NOT_REACHABLE_EVENT = 2;
        public static final int RESET_EVENT = 3;
        private int nodeState = 0;
        private Accessor nodeAccessor = null;

        public void transition(int event2, Session eventSession, Accessor accessor, StateMachineCallback callback) {
            boolean stopMonitor = false;
            try {
                String sessionStr;
                String string = sessionStr = eventSession == null ? "null" : eventSession.toString();
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "transition", new Object[]{eventNames[event2], sessionStr});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "currentState: " + stateNames[this.nodeState]);
                }
                boolean startMonitor = false;
                if (event2 == 3) {
                    switch (this.nodeState) {
                        case 0: {
                            stopMonitor = true;
                            break;
                        }
                        case 1: {
                            stopMonitor = true;
                            callback.routeRemoved(this.nodeAccessor);
                            this.nodeState = 0;
                            break;
                        }
                        case 2: {
                            stopMonitor = true;
                            this.nodeState = 0;
                        }
                    }
                    this.nodeAccessor = null;
                } else {
                    boolean sameSession = false;
                    Session nodeSession = null;
                    if (this.nodeAccessor != null) {
                        nodeSession = this.nodeAccessor.getSession();
                    }
                    if (eventSession != null && eventSession.equals(nodeSession)) {
                        sameSession = true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sameSession:" + sameSession);
                    }
                    if (event2 == 0) {
                        switch (this.nodeState) {
                            case 0: {
                                this.nodeAccessor = accessor;
                                callback.routeAdded(accessor);
                                this.nodeState = 1;
                                startMonitor = true;
                                break;
                            }
                            case 1: {
                                if (sameSession) break;
                                callback.routeRemoved(this.nodeAccessor);
                                this.nodeAccessor = accessor;
                                callback.routeAdded(this.nodeAccessor);
                                startMonitor = true;
                                break;
                            }
                            case 2: {
                                this.nodeAccessor = accessor;
                                callback.routeAdded(this.nodeAccessor);
                                this.nodeState = 1;
                                if (sameSession) break;
                                startMonitor = true;
                            }
                        }
                    } else if (event2 == 1) {
                        switch (this.nodeState) {
                            case 0: {
                                stopMonitor = true;
                                break;
                            }
                            case 1: {
                                if (sameSession) break;
                                stopMonitor = true;
                                break;
                            }
                            case 2: {
                                if (sameSession) {
                                    callback.routeAdded(this.nodeAccessor);
                                    this.nodeState = 1;
                                    break;
                                }
                                stopMonitor = true;
                            }
                        }
                    } else if (event2 == 2) {
                        switch (this.nodeState) {
                            case 0: {
                                stopMonitor = true;
                                break;
                            }
                            case 1: {
                                if (sameSession) {
                                    callback.routeRemoved(this.nodeAccessor);
                                    this.nodeState = 2;
                                    break;
                                }
                                stopMonitor = true;
                                break;
                            }
                            case 2: {
                                if (sameSession) break;
                                stopMonitor = true;
                            }
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unknown event: " + event2);
                    }
                }
                if (startMonitor) {
                    callback.startMonitor(this.nodeAccessor);
                }
                if (stopMonitor) {
                    callback.stopMonitor(accessor);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.RoutingTable.StateMachine", (String)"602", (Object)this);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nextState: " + stateNames[this.nodeState]);
                Tr.debug(tc, "stopMonitor:" + stopMonitor);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transition");
            }
        }

        public int getState() {
            return this.nodeState;
        }
    }

    public class ParentStateMachineCallback
    implements StateMachineCallback {
        private UpstreamPing p = null;

        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "routeAdded");
            }
            RoutingTable.this.parentRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "routeRemoved");
            }
            RoutingTable.this.parentRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startMonitor");
            }
            try {
                String name = accessor.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name: " + name);
                }
                String adminType = AdminServiceFactory.getAdminService().getProcessType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adminType is: " + adminType);
                }
                Properties configProps = AdminInitializer.getInstance().getProperties();
                RoutingTable.this.isCellRegistered = new Boolean(configProps.getProperty("cellRegisteredConfigProperty"));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isCellRegistered: " + RoutingTable.this.isCellRegistered);
                }
                if (RoutingTable.this.xcfMonitor_Enabled && (adminType.equals("UnManagedProcess") && RoutingTable.this.isCellRegistered || adminType.equals("ManagedProcess"))) {
                    if (RoutingTable.this.isXCFGroupMember(RoutingTable.this.myXCFHostCellNode + name)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "server already started.");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "server NOT started.");
                    }
                } else {
                    this.p = new UpstreamPing(name, accessor, RoutingTable.this.parentStateMachine);
                    this.p.setName("UpstreamPing");
                    this.p.setDaemon(true);
                    this.p.start();
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.RoutingTable.AddChildStateMachineCallback", (String)"996", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "startMonitor");
            }
        }

        public void stopMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopMonitor");
            }
            if (this.p != null) {
                this.p.stopMonitor(accessor);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stopMonitor");
            }
        }
    }

    public class ChildStateMachineCallback
    implements StateMachineCallback {
        NodeAgentPing p = null;

        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "routeAdded");
            }
            RoutingTable.this.childRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "routeRemoved");
            }
            RoutingTable.this.childRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startMonitor");
            }
            try {
                String adminType;
                ServerInfo serverInfo = accessor.getServerInfo();
                String name = serverInfo.getName();
                if (serverInfo.getRole().equals("NodeAgent")) {
                    name = serverInfo.getNode();
                }
                if ((adminType = AdminServiceFactory.getAdminService().getProcessType()).equals("DeploymentManager")) {
                    RoutingTable.this.addNodeAgentListener();
                    StateMachine stateMachine = (StateMachine)RoutingTable.this._rtStateMachine.get(name);
                    this.p = new NodeAgentPing(name, accessor, stateMachine);
                    this.p.setName("NodeAgentPing");
                    this.p.setDaemon(true);
                    this.p.start();
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.RoutingTable.AddChildStateMachineCallback", (String)"996", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "startMonitor");
            }
        }

        public void stopMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopMonitor");
            }
            if (this.p != null) {
                this.p.stopMonitor(accessor);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stopMonitor");
            }
        }
    }

    public static interface StateMachineCallback {
        public void routeAdded(Accessor var1);

        public void routeRemoved(Accessor var1);

        public void startMonitor(Accessor var1);

        public void stopMonitor(Accessor var1);
    }

    private class RemoveChildThread
    extends Thread {
        ServerInfo serverInfo;

        RemoveChildThread(ServerInfo si) {
            this.serverInfo = si;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RemoveChildThread.run");
            }
            boolean pushed = false;
            try {
                pushed = AdminContext.push((String)RoutingTable.this.endpointUUID);
                Subject savedSubject = null;
                if (SecurityHelper.getHelper().isSecurityEnabled()) {
                    savedSubject = RoutingTable.this.pushServerSubject();
                }
                try {
                    for (int i = 0; i < RoutingTable.this.listenerArray.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "RoutingListner.parentRemoved: " + RoutingTable.this.listenerArray[i].getClass().getName());
                        }
                        try {
                            RoutingTable.this.listenerArray[i].childRemoved(this.serverInfo);
                            continue;
                        }
                        catch (Throwable th) {
                            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.RoutingTable.remove", (String)"246", (Object)this);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "exception thrown from the routing listener: parentRemoved", th);
                        }
                    }
                }
                finally {
                    if (SecurityHelper.getHelper().isSecurityEnabled()) {
                        SecurityHelper.pushInvocationSubject(savedSubject);
                    }
                }
            }
            finally {
                if (pushed) {
                    AdminContext.pop();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "RemoveChildThread.run");
            }
        }
    }

    private class AddParentThread
    extends Thread {
        ServerInfo serverInfo;

        AddParentThread(ServerInfo si) {
            this.serverInfo = si;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "AddParentThread.run");
            }
            boolean pushed = false;
            try {
                pushed = AdminContext.push((String)RoutingTable.this.endpointUUID);
                RoutingTable.this.notifyParentAdded(this.serverInfo);
            }
            finally {
                if (pushed) {
                    AdminContext.pop();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "AddParentThread.run");
            }
        }
    }

    private class AddChildThread
    extends Thread {
        ServerInfo serverInfo;

        AddChildThread(ServerInfo si) {
            this.serverInfo = si;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "AddChildThread.run");
            }
            boolean pushed = false;
            try {
                pushed = AdminContext.push((String)RoutingTable.this.endpointUUID);
                Subject savedSubject = null;
                if (SecurityHelper.getHelper().isSecurityEnabled()) {
                    savedSubject = RoutingTable.this.pushServerSubject();
                }
                try {
                    for (int i = 0; i < RoutingTable.this.listenerArray.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "RoutingListner.childAdded: " + RoutingTable.this.listenerArray[i].getClass().getName());
                        }
                        try {
                            RoutingTable.this.listenerArray[i].childAdded(this.serverInfo);
                            continue;
                        }
                        catch (Throwable th) {
                            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.RoutingTable.addChild", (String)"194", (Object)this);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "failed to execute RoutingListener.childAdded");
                        }
                    }
                }
                finally {
                    if (SecurityHelper.getHelper().isSecurityEnabled()) {
                        SecurityHelper.pushInvocationSubject(savedSubject);
                    }
                }
            }
            finally {
                if (pushed) {
                    AdminContext.pop();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "AddChildThread.run");
            }
        }
    }

    private class NodeAgentPing
    extends PingThread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        NodeAgentPing(String name, Accessor accessor, StateMachine stateMachine) {
            super(name, accessor, stateMachine);
            Map map = RoutingTable.this.agentPingThreads;
            synchronized (map) {
                ArrayList<NodeAgentPing> pingThreadsForThisNode = (ArrayList<NodeAgentPing>)RoutingTable.this.agentPingThreads.get(name);
                if (pingThreadsForThisNode == null) {
                    pingThreadsForThisNode = new ArrayList<NodeAgentPing>();
                    RoutingTable.this.agentPingThreads.put(name, pingThreadsForThisNode);
                }
                pingThreadsForThisNode.add(this);
            }
        }

        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "NodeAgentPing.routeAdded");
            }
            RoutingTable.this.childRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "NodeAgentPing.routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "NodeAgentPing.routeRemoved");
            }
            RoutingTable.this.childRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "NodeAgentPing.routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "NodeAgentPing.startMonitor");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "NodeAgentPing.startMonitor");
            }
        }
    }

    private class UpstreamPing
    extends PingThread {
        UpstreamPing(String name, Accessor accessor, StateMachine stateMachine) {
            super(name, accessor, stateMachine);
        }

        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "UpstreamPing.routeAdded");
            }
            RoutingTable.this.parentRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "UpstreamPing.routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "UpstreamPing.routeRemoved");
            }
            RoutingTable.this.parentRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "UpstreamPing.routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "UpstreamPing.startMonitor");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "UpstreamPing.startMonitor");
            }
        }
    }

    private abstract class PingThread
    extends Thread
    implements StateMachineCallback {
        protected String name;
        protected Accessor accessor;
        protected StateMachine stateMachine;
        protected boolean stopMonitor = false;

        PingThread(String name, Accessor accessor, StateMachine stateMachine) {
            this.name = name;
            this.accessor = accessor;
            this.stateMachine = stateMachine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "PingThread.run", this.name);
            }
            boolean pushed = false;
            try {
                pushed = AdminContext.push((String)RoutingTable.this.endpointUUID);
                Subject savedSubject = null;
                if (SecurityHelper.getHelper().isSecurityEnabled()) {
                    savedSubject = RoutingTable.this.pushServerSubject();
                }
                RoutingTable.this.incrMonitorThreads();
                try {
                    String s = System.getProperty("com.ibm.websphere.management.monitoring.pingInterval", "60");
                    int pingInterval = new Integer(s);
                    s = System.getProperty("com.ibm.websphere.management.monitoring.pingMaximumAttempts", "1");
                    int pingMaximumAttempts = new Integer(s);
                    int shortPingCurAttempts = 0;
                    s = System.getProperty("com.ibm.websphere.management.monitoring.shortPingInterval", "5");
                    int shortPingInterval = new Integer(s);
                    s = System.getProperty("com.ibm.websphere.management.monitoring.shortPingMaximumAttempts", "10");
                    int shortPingMaximumAttempts = new Integer(s);
                    boolean attempts = false;
                    AdminClient client = this.accessor.getConnector();
                    Session session = this.accessor.getSession();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pingInterval is: " + pingInterval);
                        Tr.debug(tc, "pingMaxiumAttempts is: " + pingMaximumAttempts);
                        Tr.debug(tc, "session is: " + session);
                    }
                    int curAttempts = 0;
                    while (!this.stopMonitor) {
                        try {
                            RoutingTable routingTable;
                            boolean reachable;
                            block45: {
                                reachable = false;
                                Session curSession = null;
                                try {
                                    curSession = client.isAlive();
                                    if (curSession == null) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "got null session");
                                        }
                                        break block45;
                                    }
                                    if (!curSession.equals(session)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "got new session:" + curSession);
                                        }
                                        break;
                                    }
                                    reachable = true;
                                }
                                catch (Throwable t) {
                                    if (!tc.isDebugEnabled()) break block45;
                                    Tr.debug(tc, "unable to reach parent. Got exception " + t);
                                }
                            }
                            if (reachable) {
                                curAttempts = 0;
                                routingTable = RoutingTable.this;
                                synchronized (routingTable) {
                                    this.stateMachine.transition(1, session, this.accessor, this);
                                }
                            } else if (++curAttempts == pingMaximumAttempts) {
                                curAttempts = 0;
                                routingTable = RoutingTable.this;
                                synchronized (routingTable) {
                                    this.stateMachine.transition(2, session, this.accessor, this);
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "node not reachable, curAttempts : " + curAttempts);
                            }
                            if (this.stopMonitor) continue;
                            if (shortPingCurAttempts > 0) {
                                if (++shortPingCurAttempts >= shortPingMaximumAttempts) {
                                    shortPingCurAttempts = 0;
                                }
                                Thread.sleep(shortPingInterval * 1000);
                                continue;
                            }
                            if (reachable) {
                                Thread.sleep(pingInterval * 1000);
                                continue;
                            }
                            Thread.sleep(pingInterval * 2000);
                        }
                        catch (InterruptedException ex) {
                            shortPingCurAttempts = 1;
                            try {
                                Thread.sleep(shortPingInterval * 1000);
                            }
                            catch (InterruptedException e) {
                            }
                            catch (Throwable t) {
                                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.RoutingTable.PingThread.run", (String)"1080", (Object)this);
                            }
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.RoutingTable.PingThread.run", (String)"1082", (Object)this);
                        }
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.RoutingTable.PingThread.run", (String)"1137", (Object)this);
                }
                finally {
                    if (SecurityHelper.getHelper().isSecurityEnabled()) {
                        SecurityHelper.pushInvocationSubject(savedSubject);
                    }
                }
                Map map = RoutingTable.this.agentPingThreads;
                synchronized (map) {
                    List threads = (List)RoutingTable.this.agentPingThreads.get(this.name);
                    if (threads != null) {
                        threads.remove(this);
                    }
                }
                RoutingTable.this.decrMonitorThreads();
            }
            finally {
                if (pushed) {
                    AdminContext.pop();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "PingThread.run", this.name);
            }
        }

        public abstract void routeAdded(Accessor var1);

        public abstract void routeRemoved(Accessor var1);

        public abstract void startMonitor(Accessor var1);

        public void stopMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "PingThread.stopMonitor");
            }
            this.stopMonitor = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "PingThread.stopMonitor");
            }
        }
    }

    public class Accessor {
        String name;
        String pid;
        String defaultType;
        String localType;
        String remoteType;
        String serverHostName = null;
        String configuredSystemName = null;
        ServerInfo serverInfo;
        Map connectorCfgs = new HashMap();
        Session session;
        ConfigService configService = null;

        Accessor(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            this.setConnectors(serverInfo.getConnectors());
        }

        public Accessor(Session session) {
            this.session = session;
        }

        String getName() {
            return this.serverInfo.getName();
        }

        String getPid() {
            return this.serverInfo.getPid();
        }

        public String toString() {
            return this.serverInfo.toString();
        }

        void setServerInfo(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            this.setConnectors(serverInfo.getConnectors());
        }

        ServerInfo getServerInfo() {
            return this.serverInfo;
        }

        private void setConnectors(List connectors) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setConnectors");
            }
            this.localType = "SOAP";
            this.remoteType = "RMI";
            String nodeVersion = this.serverInfo.getVersion();
            if (nodeVersion != null && nodeVersion.startsWith("5.")) {
                this.remoteType = "SOAP";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using SOAP for remoteType since we have a v5 node");
                }
            }
            String type = null;
            this.connectorCfgs.clear();
            for (Properties props : connectors) {
                String tmpConfiguredSystemName;
                String tmp;
                type = props.getProperty("type");
                if (props.getProperty("localAdminProtocol") != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "localAdminProtocol " + type);
                    }
                    this.localType = type;
                }
                if (this.serverHostName == null && type != null && !"IPC".equals(type) && (tmp = props.getProperty("host")) != null) {
                    this.serverHostName = tmp;
                }
                if (props.getProperty("remoteAdminProtocol") != null) {
                    this.remoteType = type;
                }
                if (props.getProperty("preferred") != null) {
                    this.defaultType = type;
                }
                if ((tmpConfiguredSystemName = props.getProperty("was.ConfiguredSystemName")) != null) {
                    this.configuredSystemName = tmpConfiguredSystemName;
                }
                this.connectorCfgs.put(type, props);
            }
            if (this.defaultType == null) {
                this.defaultType = type;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setConnectors");
            }
        }

        void clear() {
            this.connectorCfgs.clear();
        }

        boolean isRoutable() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isRoutable: " + !this.connectorCfgs.isEmpty());
            }
            return !this.connectorCfgs.isEmpty();
        }

        boolean isReachAble() {
            boolean yes;
            block2: {
                yes = false;
                try {
                    yes = this.getConnector().isAlive() != null;
                    yes = true;
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block2;
                    Tr.debug(tc, "can not reach: ", this.getName());
                }
            }
            return yes;
        }

        AdminClient getConnector(String type) throws ConnectorException {
            AdminClient client;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getConnector(type)", type);
                }
                client = null;
                Properties cfg = (Properties)this.connectorCfgs.get(type);
                if (cfg == null) {
                    throw new ConnectorNotAvailableException();
                }
                try {
                    client = AdminClientFactory.createAdminClient(cfg);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RoutingTable.Accessor.getConnector", (String)"583", (Object)this);
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "unable to create connector with properties:", cfg);
                }
            }
            if (client == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConnector(type) - failed");
                }
                throw new ConnectorNotAvailableException();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnector(type)");
            }
            return client;
        }

        AdminClient getConnector() throws ConnectorException {
            String ownConfiguredSystemName;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getConnector");
            }
            AdminClient client = null;
            boolean tryLocalProtocolFirst = false;
            String ownNodeName = RoutingTable.this.getOwnInfo().getNode();
            String serverNodeName = this.getServerInfo().getNode();
            String ownAdminType = AdminServiceFactory.getAdminService().getProcessType();
            String serverAdminType = this.getServerInfo().getRole();
            String ownHostName = RoutingTable.this.getOwnInfo().getHostName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NodeName " + ownNodeName + ":" + serverNodeName);
                Tr.debug(tc, "AdminType " + ownAdminType + ":" + serverAdminType);
                Tr.debug(tc, "HostName " + ownHostName + ":" + this.serverHostName);
            }
            if (ownNodeName.equals(serverNodeName)) {
                tryLocalProtocolFirst = true;
            }
            if (AdminHelper.getPlatformHelper().isZOS() && (ownConfiguredSystemName = AdminHelper.getInstance().getWasConfiguredSystemName()) != null && ownConfiguredSystemName.equals(this.configuredSystemName)) {
                tryLocalProtocolFirst = true;
            }
            if (!tryLocalProtocolFirst && (ownAdminType.equals("AdminAgent") && serverAdminType.equals("UnManagedProcess") || ownAdminType.equals("UnManagedProcess") && serverAdminType.equals("AdminAgent"))) {
                tryLocalProtocolFirst = true;
            }
            if (!tryLocalProtocolFirst && ownHostName != null && ownHostName.equals(this.serverHostName)) {
                tryLocalProtocolFirst = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "localType " + this.localType);
                Tr.debug(tc, "tryLocalProtocolFirst " + tryLocalProtocolFirst);
            }
            ArrayList<String> alreadyTried = new ArrayList<String>(3);
            if (this.localType != null && tryLocalProtocolFirst) {
                try {
                    alreadyTried.add(this.localType);
                    client = this.getConnector(this.localType);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RoutingTable.Accessor.getConnector", (String)"610", (Object)this);
                }
            }
            if (client == null && this.remoteType != null && !alreadyTried.contains(this.remoteType)) {
                try {
                    alreadyTried.add(this.remoteType);
                    client = this.getConnector(this.remoteType);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RoutingTable.Accessor.getConnector", (String)"965", (Object)this);
                }
            }
            if (client == null && this.defaultType != null && !alreadyTried.contains(this.defaultType)) {
                try {
                    alreadyTried.add(this.defaultType);
                    client = this.getConnector(this.defaultType);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RoutingTable.Accessor.getConnector", (String)"965", (Object)this);
                }
            }
            if (client == null) {
                Iterator it = this.connectorCfgs.keySet().iterator();
                while (client == null && it.hasNext()) {
                    String type = (String)it.next();
                    if (alreadyTried.contains(type)) continue;
                    try {
                        client = this.getConnector(type);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RoutingTable.Accessor.getConnector", (String)"998", (Object)this);
                    }
                }
            }
            if (client == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConnector - failed");
                }
                throw new ConnectorNotAvailableException();
            }
            return client;
        }

        Session resetSession() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resetSession");
            }
            try {
                AdminClient client = this.getConnector();
                this.session = client.isAlive();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RoutingTable.getAllAdminClients", (String)"492", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resetSession");
            }
            return this.session;
        }

        Session getSession() {
            return this.session;
        }
    }

    private class notifyParentAddedThread
    extends Thread {
        ServerInfo serverInfo;
        RoutingListener routingListener;

        notifyParentAddedThread(ServerInfo si, RoutingListener listener) {
            this.serverInfo = si;
            this.routingListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "notifyParentAddedThread.run");
                }
                boolean pushed = false;
                try {
                    pushed = AdminContext.push((String)RoutingTable.this.endpointUUID);
                    Subject savedSubject = null;
                    if (SecurityHelper.getHelper().isSecurityEnabled()) {
                        savedSubject = RoutingTable.this.pushServerSubject();
                    }
                    try {
                        this.routingListener.parentAdded(this.serverInfo);
                        if (!SecurityHelper.getHelper().isSecurityEnabled()) break block13;
                    }
                    catch (Throwable th) {
                        try {
                            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.RoutingTable.notifyParentAddedThread", (String)"594", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "error in thread notifying that parent was added", th);
                            }
                            break block13;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                                SecurityHelper.pushInvocationSubject(savedSubject);
                            }
                        }
                    }
                    SecurityHelper.pushInvocationSubject(savedSubject);
                }
                finally {
                    if (pushed) {
                        AdminContext.pop();
                    }
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "notifyParentAddedThread.run");
        }
    }
}

