/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.JMXManageableSupport;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceFactoryInitializer;
import com.ibm.ws.management.ControlAdminService;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws.management.MBeanStateConsumer;
import com.ibm.ws.management.PlatformMBeanServer;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.descriptor.MBeanDescriptorManager;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.proxy.ModelMBeanBinder;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanFactoryImpl
implements MBeanFactory {
    private static String resourceBundleName = "com.ibm.ws.management.resources.adminservice";
    private TraceNLS nls = TraceNLS.getTraceNLS(resourceBundleName);
    private static TraceComponent tc = Tr.register(MBeanFactoryImpl.class, "MBeanFactory", resourceBundleName);
    private MBeanServer mBeanServer = null;
    private MBeanServer defaultMBeanServer = null;
    private MBeanDescriptorManager descriptorMan = MBeanDescriptorManager.getInstance();
    private String serverName = null;
    private String nodeName = null;
    private String processName = null;
    private String cellName = null;
    private String repositoryDir = null;
    private TypeList mbeanTypes = new TypeList();
    private ControlAdminService controlAdmin = null;
    private HashSet savedMMInfo = new HashSet();
    private String adminAppName = "admin-authz";
    private String adminContext = "domain";
    private HashSet loadedSecureMBeanTypes = new HashSet();
    private LinkedList MBeanActivateList = new LinkedList();

    public MBeanFactoryImpl(String serverName) {
        this.serverName = serverName;
    }

    public MBeanFactoryImpl(String serverName, MBeanServer mbeanServer) {
        this(serverName);
        this.defaultMBeanServer = mbeanServer;
    }

    @Override
    public MBeanServer getMBeanServer() {
        if (this.mBeanServer == null) {
            this.createMBeanServer();
        }
        return this.mBeanServer;
    }

    private synchronized void createMBeanServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMBeanServer");
        }
        if (this.mBeanServer != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createMBeanServer", "not created");
            }
            return;
        }
        this.mBeanServer = MBeanServerFactory.createMBeanServer(this.serverName);
        this.defaultMBeanServer = this.mBeanServer instanceof PlatformMBeanServer ? ((PlatformMBeanServer)this.mBeanServer).getDefaultMBeanServer() : this.mBeanServer;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMBeanServer", "created");
        }
    }

    public void setCellName(String name) {
        this.cellName = name;
    }

    public void setNodeName(String name) {
        this.nodeName = name;
    }

    public void setProcessName(String name) {
        this.processName = name;
    }

    public void setRepositoryDir(String dir) {
        this.repositoryDir = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMBeanTypes() {
        List lst = null;
        TypeList typeList = this.mbeanTypes;
        synchronized (typeList) {
            if (tc.isDebugEnabled()) {
                Iterator it = this.mbeanTypes.iterator();
                while (it.hasNext()) {
                    Tr.debug(tc, "mbean type registered:", it.next());
                }
            }
            lst = Collections.unmodifiableList(this.mbeanTypes);
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMBeanType(String type) {
        TypeList typeList = this.mbeanTypes;
        synchronized (typeList) {
            this.mbeanTypes.add(type);
        }
    }

    @Override
    public String getConfigId(Object target) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigId", target);
        }
        String id = null;
        try {
            if (target == null) {
                id = "null";
            } else if (target instanceof EObject) {
                EObject o = (EObject)target;
                Resource res = o.eResource();
                if (res != null) {
                    int idx;
                    URI uri = res.getURI();
                    id = res.getURIFragment(o);
                    uri = uri.appendFragment(id);
                    String fullpath = uri.toString();
                    fullpath = fullpath.replace('\\', '/');
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "(String)fullpath: ", fullpath);
                    }
                    int length = fullpath.length();
                    String newString = "";
                    for (int x = 0; x < length; ++x) {
                        int i = fullpath.indexOf("%20");
                        if (i != -1) {
                            String subString = fullpath.substring(0, i);
                            newString = newString + subString + " ";
                            fullpath = fullpath.substring(i + 3);
                            continue;
                        }
                        x = length;
                        newString = newString + fullpath;
                    }
                    fullpath = newString.trim();
                    URI repUri = URI.createFileURI(this.repositoryDir);
                    String repPath = repUri.path();
                    repPath = repPath.replace('\\', '/');
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "repPath: ", repPath);
                    }
                    id = (idx = fullpath.indexOf(repPath)) >= 0 ? fullpath.substring(idx + repPath.length() + 1) : fullpath.substring(fullpath.lastIndexOf(":") + 1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "id: ", id);
                    }
                } else {
                    id = o.getClass().getName();
                }
            } else if (target instanceof Resource) {
                Resource res = (Resource)target;
                String fullpath = res.getURI().path();
                URI repUri = URI.createFileURI(this.repositoryDir);
                String repPath = repUri.path();
                id = fullpath.substring(repPath.length() + 1);
            } else if (target instanceof ObjectName) {
                ObjectName name = (ObjectName)target;
                id = name.getKeyProperty("mbeanIdentifier");
                if (id == null) {
                    id = name.getCanonicalName();
                }
            } else if (target instanceof String) {
                id = (String)target;
            } else if (target instanceof ConfigObject) {
                String repositoryPath;
                ConfigObject o = (ConfigObject)target;
                id = new File(o.getDocumentPath()).getAbsolutePath().replace('\\', '/');
                id = id.startsWith(repositoryPath = new File(this.repositoryDir).getAbsolutePath().replace('\\', '/')) ? id.substring(repositoryPath.length() + 1) : id.substring(id.lastIndexOf(58) + 1);
                id = id + '#' + o.getID();
            } else {
                id = target.getClass().getName();
            }
        }
        catch (Throwable t) {
            throw new AdminException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigId", id);
        }
        return id;
    }

    @Override
    public ObjectName activateMBean(String type, RuntimeCollaborator collaborator, String configId, String descriptor) throws AdminException {
        return this.activateMBean(type, collaborator, configId, descriptor, null);
    }

    @Override
    public ObjectName activateMBean(String type, RuntimeCollaborator collaborator, String configId) throws AdminException {
        return this.activateMBean(type, collaborator, configId, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName activateMBean(String type, RuntimeCollaborator collaborator, String configId, String descriptor, Properties props) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateMBean", configId);
        }
        String profileKey = AdminContext.peek();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Under context of: " + profileKey);
        }
        ObjectName name = null;
        configId = this.convertConfigIdToKeyProperty(configId);
        try {
            Object runtimeObj;
            ModelMBeanInfo info = this.descriptorMan.getDescriptor(type, descriptor);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mbeandescriptor:", info.getMBeanDescriptor());
            }
            if (AdminHelper.getPlatformHelper().isZOS()) {
                String processType = AdminServiceFactory.getAdminService().getProcessType();
                if (AdminHelper.getPlatformHelper().isControlJvm() && !processType.equalsIgnoreCase("NodeAgent")) {
                    String platform = null;
                    String collaboratorClass = null;
                    String adminAgentProxyInterface = null;
                    String dynamicProxyRegistration = null;
                    try {
                        Descriptor desc = info.getMBeanDescriptor();
                        if (desc != null) {
                            platform = (String)desc.getFieldValue("platform");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "platform", platform);
                            }
                            collaboratorClass = (String)desc.getFieldValue("collaboratorClass");
                            adminAgentProxyInterface = (String)desc.getFieldValue("adminAgentProxyInterface");
                            dynamicProxyRegistration = (String)desc.getFieldValue("allowDynamicProxyStaticRegistrationInControlRegion");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "xml collaboratorClass (proxy class):" + collaboratorClass + ", dynamicProxyRegistration: " + dynamicProxyRegistration + ", adminAgentProxyInterface " + adminAgentProxyInterface);
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "error obtaining platform and collaboratorClass values:", t);
                        }
                        throw new AdminException(t);
                    }
                    String runtimeCollaboratorClass = collaborator.getClass().getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "runtimeCollaboratorClass", runtimeCollaboratorClass);
                    }
                    if (platform != null && collaboratorClass != null && platform.equals("proxy") && !collaborator.getClass().getName().equals(collaboratorClass) && adminAgentProxyInterface == null) {
                        if (configId == null) {
                            configId = "null";
                        }
                        name = this.createMBeanName(info, configId, props, type);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "activateMBean", name + " was not registered");
                        }
                        return name;
                    }
                    if ((platform == null || platform.equals("dynamicproxy")) && adminAgentProxyInterface == null) {
                        boolean foundServerTypeMatch = false;
                        if (dynamicProxyRegistration != null) {
                            String serverType = AdminServiceFactory.getAdminService().getServerType();
                            StringTokenizer tokens = new StringTokenizer(dynamicProxyRegistration, ",");
                            while (tokens.hasMoreTokens() && !foundServerTypeMatch) {
                                String token = tokens.nextToken();
                                foundServerTypeMatch = serverType.equalsIgnoreCase(token);
                            }
                        }
                        if (!foundServerTypeMatch) {
                            if (configId == null) {
                                configId = "null";
                            }
                            name = this.createMBeanName(info, configId, props, type);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "activateMBean", name + " was not registered");
                            }
                            return name;
                        }
                    }
                }
            }
            RequiredModelMBean mBean = new RequiredModelMBean(info);
            collaborator.bindMBean(info, mBean);
            info = (ModelMBeanInfo)((Object)mBean.getMBeanInfo());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "after binding info:", MBeanFactoryImpl.printModelMBeanInfo(info));
            }
            if (configId == null) {
                configId = "null";
            }
            name = this.createMBeanName(info, configId, props, type);
            collaborator.setObjectName(name);
            if (AdminHelper.getPlatformHelper().isZOS() && collaborator instanceof DefaultRuntimeCollaborator && (runtimeObj = ((DefaultRuntimeCollaborator)collaborator).getRuntimeObject()) instanceof JMXManageableSupport) {
                ((JMXManageableSupport)runtimeObj).setModelMBean(mBean);
            }
            this.defaultMBeanServer.registerMBean(mBean, name);
            collaborator.mbeanActivated();
            runtimeObj = this.mbeanTypes;
            synchronized (runtimeObj) {
                this.mbeanTypes.add(type);
            }
            this.applySecurityPolicy(info, descriptor);
            if (AdminHelper.getPlatformHelper().isServantJvm()) {
                String stoken = AdminHelper.getPlatformHelper().getServantToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "props", props);
                }
                Properties proxyProps = null;
                proxyProps = props == null ? new Properties() : (props.containsKey(name) ? props : (Properties)props.clone());
                if (!proxyProps.containsKey(name)) {
                    String nameValue = name.getKeyProperty("name");
                    proxyProps.put("name", nameValue);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "proxyProps", proxyProps);
                }
                if (this.controlAdmin != null) {
                    InputSource inSource = this.descriptorMan.loadMBeanDescriptorFile(type, descriptor);
                    InputStream inStream = inSource.getByteStream();
                    byte[] buf = new byte[100];
                    int bytesRead = 0;
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    boolean done = false;
                    while (!done) {
                        int availBytes = inStream.available();
                        if (availBytes > buf.length) {
                            buf = new byte[availBytes];
                        }
                        if ((bytesRead = inStream.read(buf, 0, buf.length)) == -1) {
                            done = true;
                            continue;
                        }
                        outStream.write(buf, 0, bytesRead);
                    }
                    byte[] descriptorBytes = outStream.toByteArray();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "descriptorBytes", descriptorBytes);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Activation of MBean " + configId + " real time", new Object[]{type, configId, descriptor, proxyProps, stoken, name});
                    }
                    Serializable state = this.controlAdmin.activateProxyMBean(type, configId, descriptor, proxyProps, stoken, name, descriptorBytes);
                    if (collaborator instanceof MBeanStateConsumer) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Invoking setMBeanState", state);
                        }
                        ((MBeanStateConsumer)collaborator).setMBeanState(state);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Activation of MBean " + configId + " will be deferred until after ORB initialization.");
                    }
                    MBeanActivationInfo mbai = new MBeanActivationInfo(type, configId, descriptor, proxyProps, stoken, name, collaborator);
                    this.MBeanActivateList.add(mbai);
                }
            } else if (AdminHelper.getPlatformHelper().isControlJvm()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Control Region ProxyMBeanSupport check", collaborator);
                }
                if (collaborator != null && collaborator instanceof ProxyMBeanSupport) {
                    if (this.controlAdmin != null) {
                        ControlAdminServiceImpl.getInstance().addListener(name, mBean);
                    } else {
                        MBeanActivationInfo mbai = new MBeanActivationInfo(null, null, null, null, null, name, collaborator);
                        this.MBeanActivateList.add(mbai);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Instance Already Exist ", name);
            }
            throw new AdminException(ex, this.nls.getFormattedMessage("ADMN0005E", new Object[]{type, collaborator, configId, descriptor}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activateMBean", name);
        }
        return name;
    }

    public ObjectName activateMBean(String type, Proxy proxy, String configId, String descriptor, ModelMBeanInfo info) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateMBean[dynamicproxy]", configId);
        }
        ObjectName name = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mbeandescriptor:", info.getMBeanDescriptor());
            }
            RequiredModelMBean mBean = new RequiredModelMBean(info);
            Proxy.getInvocationHandler(proxy).invoke(proxy, ModelMBeanBinder.class.getMethod("bindMBean", ModelMBeanInfo.class, ModelMBean.class), new Object[]{info, mBean});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "after binding info:", MBeanFactoryImpl.printModelMBeanInfo(info));
            }
            Method pMethod = proxy.getClass().getMethod("getObjectName", null);
            name = (ObjectName)pMethod.invoke((Object)proxy, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dynamicproxy MBean ObjectName:", name);
            }
            this.defaultMBeanServer.registerMBean(mBean, name);
            this.mbeanTypes.add(type);
            this.applySecurityPolicy(info, descriptor);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.MBeanFactoryImpl.activateMBean", (String)"190", (Object)this);
            throw new AdminException(ex, this.nls.getFormattedMessage("ADMN0005E", new Object[]{type, proxy, configId, descriptor}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activateMBean[dynamicproxy]", name);
        }
        return name;
    }

    public ObjectName activateMBean(Proxy proxy, ModelMBeanInfo info) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateMBean[dynamicproxy]");
        }
        ObjectName name = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mbeandescriptor:", info.getMBeanDescriptor());
            }
            RequiredModelMBean mBean = new RequiredModelMBean(info);
            Proxy.getInvocationHandler(proxy).invoke(proxy, ModelMBeanBinder.class.getMethod("bindMBean", ModelMBeanInfo.class, ModelMBean.class), new Object[]{info, mBean});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "after binding info:", MBeanFactoryImpl.printModelMBeanInfo(info));
            }
            Method pMethod = proxy.getClass().getMethod("getObjectName", null);
            name = (ObjectName)pMethod.invoke((Object)proxy, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dynamicproxy MBean ObjectName:", name);
            }
            this.defaultMBeanServer.registerMBean(mBean, name);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.MBeanFactoryImpl.activateMBean", (String)"190", (Object)this);
            throw new AdminException(ex, this.nls.getFormattedMessage("ADMN0005E", new Object[]{proxy}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activateMBean[dynamicproxy]", name);
        }
        return name;
    }

    @Override
    public void completeActivateMBeans() {
        block31: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "completeActivateMBeans");
            }
            if (AdminServiceFactoryInitializer.getPlatformHelper().isServantJvm()) {
                try {
                    ORB _orb = AdminServiceFactoryInitializer.getPlatformHelper().getGlobalORB();
                    String serviceName = "ControlAdminService";
                    String profileKey = AdminContext.peek();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Activating MBeans for profileKey: " + profileKey);
                    }
                    if (profileKey != null) {
                        serviceName = serviceName + "_" + profileKey;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resolving initial reference for: " + serviceName);
                    }
                    this.controlAdmin = (ControlAdminService)_orb.resolve_initial_references(serviceName);
                    if (this.controlAdmin != null) {
                        if (this.mBeanServer instanceof PlatformMBeanServer) {
                            ((PlatformMBeanServer)this.mBeanServer).initControlAdmin();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Starting activation of deferred MBeans.");
                        }
                        while (!this.MBeanActivateList.isEmpty()) {
                            MBeanActivationInfo mbai;
                            block30: {
                                mbai = (MBeanActivationInfo)this.MBeanActivateList.removeFirst();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Deferred activation of MBean " + mbai.configId + " started.", new Object[]{mbai.type, mbai.configId, mbai.descriptor, mbai.props, mbai.stoken, mbai.name});
                                }
                                try {
                                    InputSource inSource = this.descriptorMan.loadMBeanDescriptorFile(mbai.type, mbai.descriptor);
                                    InputStream inStream = inSource.getByteStream();
                                    byte[] buf = new byte[100];
                                    int bytesRead = 0;
                                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                                    boolean done = false;
                                    while (!done) {
                                        int availBytes = inStream.available();
                                        if (availBytes > buf.length) {
                                            buf = new byte[availBytes];
                                        }
                                        if ((bytesRead = inStream.read(buf, 0, buf.length)) == -1) {
                                            done = true;
                                            continue;
                                        }
                                        outStream.write(buf, 0, bytesRead);
                                    }
                                    byte[] descriptorBytes = outStream.toByteArray();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "descriptorBytes", descriptorBytes);
                                    }
                                    Serializable state = this.controlAdmin.activateProxyMBean(mbai.type, mbai.configId, mbai.descriptor, mbai.props, mbai.stoken, mbai.name, descriptorBytes);
                                    if (mbai.collaborator instanceof MBeanStateConsumer) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Invoking setMBeanState", state);
                                        }
                                        ((MBeanStateConsumer)mbai.collaborator).setMBeanState(state);
                                    }
                                }
                                catch (Exception e) {
                                    if (!tc.isDebugEnabled()) break block30;
                                    Tr.debug(tc, "Deferred activation failed for MBean " + mbai.configId, e);
                                }
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Deferred activation of MBean " + mbai.configId + " complete.");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Completed activation of deferred MBeans.");
                        }
                        break block31;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ControlAdmin still null - can't activate deferred MBeans.");
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during activation of deferred MBeans.");
                    }
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.MBeanFactoryImpl.completeActivateMBeans", (String)"947", (Object)this);
                }
            } else if (AdminServiceFactoryInitializer.getPlatformHelper().isControlJvm()) {
                MBeanActivationInfo mbai = null;
                try {
                    while (!this.MBeanActivateList.isEmpty()) {
                        mbai = (MBeanActivationInfo)this.MBeanActivateList.removeFirst();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Control Region Deferred listener add of MBean " + mbai.configId + " started.", new Object[]{mbai.collaborator, mbai.name});
                        }
                        ControlAdminServiceImpl.getInstance().addListener(mbai.name, mbai.collaborator);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block31;
                    Tr.debug(tc, "Deferred CR activation failed for MBean " + (mbai == null ? null : mbai.name), e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeActivateMBeans");
        }
    }

    @Override
    public ObjectName createObjectName(String type, String configId, String descriptor, Properties props) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectName", new Object[]{type, configId, descriptor, props});
        }
        ObjectName name = null;
        configId = this.convertConfigIdToKeyProperty(configId);
        try {
            ModelMBeanInfo info = this.descriptorMan.getDescriptor(type, descriptor);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mbeandescriptor:", info.getMBeanDescriptor());
            }
            name = this.createMBeanName(info, configId, props, type);
        }
        catch (Exception ex) {
            throw new AdminException(ex, this.nls.getFormattedMessage("ADMN0017E", new Object[]{type, configId, descriptor}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createObjectName", name);
        }
        return name;
    }

    private String convertConfigIdToKeyProperty(String configId) {
        if (configId == null) {
            configId = "null";
        } else if (configId.indexOf(42) != -1 || configId.indexOf(44) != -1) {
            String oldId = configId;
            configId = configId.replace('*', '_');
            configId = configId.replace(',', '_');
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ADMN0012A", new Object[]{oldId, configId});
            }
        }
        return configId;
    }

    @Override
    public void deactivateMBean(String configId) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deactivateMBean", configId);
        }
        ObjectName name = null;
        try {
            name = this.findMBean(configId);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found object name: " + name);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.MBeanFactoryImpl.deactivateMBean", (String)"197", (Object)this);
            throw new AdminException(ex);
        }
        if (name != null) {
            this.deactivateMBean(name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deactivateMBean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateMBean(ObjectName mbean) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deactivateMBean", mbean);
        }
        try {
            String type = mbean.getKeyProperty("type");
            this.defaultMBeanServer.unregisterMBean(mbean);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unregistered the mbean, type=" + type);
            }
            TypeList typeList = this.mbeanTypes;
            synchronized (typeList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing the mbean type " + type);
                }
                this.mbeanTypes.remove(ObjectNameHelper.getMBeanType(mbean));
            }
            this.descriptorMan.removeDescriptor(type);
            if (AdminHelper.getPlatformHelper().isServantJvm()) {
                String stoken = AdminHelper.getPlatformHelper().getServantToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deactivating the proxy mbean for profileKey: " + AdminContext.peek());
                }
                this.controlAdmin.deactivateProxyMBean(mbean, stoken);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.MBeanFactoryImpl.deactivateMBean", (String)"197", (Object)this);
            throw new AdminException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deactivateMBean");
        }
    }

    @Override
    public ObjectName findMBean(String configId) throws InstanceNotFoundException {
        ObjectName partialName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findMBean", configId);
        }
        if (configId.indexOf(42) != -1 || configId.indexOf(44) != -1) {
            String oldId = configId;
            configId = configId.replace('*', '_');
            configId = configId.replace(',', '_');
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ADMN0012A", new Object[]{oldId, configId});
            }
        }
        try {
            partialName = new ObjectName(this.getMBeanServer().getDefaultDomain() + ":mbeanIdentifier=" + configId + ",*");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "partialName: " + partialName);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.MBeanFactoryImpl.findMBean", (String)"213", (Object)this);
            throw new InstanceNotFoundException(configId);
        }
        Set result = null;
        result = this.getMBeanServer().queryNames(partialName, null);
        ObjectName found = null;
        if (result.size() == 0) {
            throw new InstanceNotFoundException();
        }
        found = (ObjectName)result.iterator().next();
        if (result.size() > 1) {
            Tr.warning(tc, "ADMN0006W", configId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findMBean", found);
        }
        return found;
    }

    public MBeanDescriptorManager getDescriptorManager() {
        return this.descriptorMan;
    }

    private ObjectName createMBeanName(ModelMBeanInfo info, String configId, Properties props, String activationType) throws MBeanException, MalformedObjectNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMBeanName", configId);
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (info != null) {
            String spec;
            String version;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "info:", info);
            }
            Descriptor mBeanDescriptor = info.getMBeanDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mBeanDescriptor", mBeanDescriptor);
            }
            String name = (String)mBeanDescriptor.getFieldValue("name");
            String displayName = (String)mBeanDescriptor.getFieldValue("displayName");
            String type = (String)mBeanDescriptor.getFieldValue("type");
            String platform = (String)mBeanDescriptor.getFieldValue("platform");
            String j2eeType = (String)mBeanDescriptor.getFieldValue("j2eeType");
            if (name == null) {
                name = configId;
            }
            if (displayName == null) {
                displayName = name;
            }
            if (name.equals("Dummy_Name")) {
                displayName = configId;
                name = configId;
            }
            table.put("name", displayName);
            if (props != null) {
                Enumeration<Object> keys = props.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    table.put(key, props.getProperty(key));
                }
            }
            if ((version = Utils.getProductVersion()) != null) {
                table.put("version", version);
            }
            if ((spec = (String)mBeanDescriptor.getFieldValue("spec")) != null) {
                table.put("spec", spec);
            }
            if (type != null && type.equals("ConfigRepository")) {
                table.put("version", "5.0");
            }
            if (this.cellName != null) {
                table.put("cell", this.cellName);
            }
            if (this.nodeName != null) {
                table.put("node", this.nodeName);
            }
            if (this.processName != null) {
                table.put("process", this.processName);
            }
            if (type != null) {
                table.put("type", type);
            }
            if (platform != null) {
                table.put("platform", platform);
            }
            if (j2eeType != null) {
                table.put("j2eeType", j2eeType);
                this.addParentJ2eeTypeKeyProperties(table);
            }
            if (activationType != null && !activationType.equals(type)) {
                Tr.warning(tc, "ADMN1218W", new Object[]{activationType, type == null ? "<null>" : type});
            }
        }
        table.put("mbeanIdentifier", configId);
        ObjectName name = new ObjectName(this.getMBeanServer().getDefaultDomain(), table);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMBeanName", name);
        }
        return name;
    }

    private void addParentJ2eeTypeKeyProperties(Hashtable<String, String> table) {
        String j2eeType = table.get("j2eeType");
        if (!j2eeType.equals("J2EEDomain") && !j2eeType.equals("J2EEServer")) {
            this.addJ2EEServerParentJ2EEType(table);
        }
        if (j2eeType.endsWith("Module") || j2eeType.endsWith("Bean") || j2eeType.equals("Servlet") || j2eeType.equals("ResourceAdapter")) {
            this.addJ2EEApplicationParentJ2EEType(table);
        }
    }

    private void addJ2EEServerParentJ2EEType(Hashtable<String, String> table) {
        String j2eeServer = table.get("J2EEServer");
        if (j2eeServer == null) {
            j2eeServer = table.get("process");
            if (j2eeServer == null && (j2eeServer = table.get("Server")) == null) {
                throw new RuntimeException("J2EEServer, process or Server key property required");
            }
            table.put("J2EEServer", j2eeServer);
        }
    }

    private void addJ2EEApplicationParentJ2EEType(Hashtable<String, String> table) {
        String j2eeApplication = table.get("J2EEApplication");
        if (j2eeApplication == null) {
            j2eeApplication = table.get("Application");
            if (j2eeApplication != null) {
                table.put("J2EEApplication", j2eeApplication);
            } else {
                throw new RuntimeException("Application or J2EEApplication key property required");
            }
        }
    }

    private String convertToSecurityDescriptor(String descriptorUri) {
        String secDesc = null;
        int index = descriptorUri.lastIndexOf(".xml");
        secDesc = index == -1 ? descriptorUri + "Security" : descriptorUri.substring(0, index) + "Security.xml";
        return secDesc;
    }

    private void loadSecurityPolicy(ModelMBeanInfo info, String descriptor) {
        try {
            InputSource inputSource;
            String type = (String)info.getMBeanDescriptor().getFieldValue("type");
            if (this.loadedSecureMBeanTypes.contains(type)) {
                return;
            }
            this.loadedSecureMBeanTypes.add(type);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "apply security for mbean with type", type);
            }
            String securityDescriptor = null;
            if (descriptor != null) {
                securityDescriptor = this.convertToSecurityDescriptor(descriptor);
            }
            if ((inputSource = this.getDescriptorManager().loadSecurityDescriptorFile(type, securityDescriptor)).getByteStream() == null) {
                inputSource = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "secDesc : null");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "secDesc", inputSource.getSystemId());
            }
            SecurityHelper.getHelper().getConfigurator().loadSecurityPolicy(this.adminAppName, info, inputSource, this.adminContext);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to load policy for ModelMBean", info);
            }
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.MBeanFactoryImpl", (String)"464", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeApplySecurityPolicy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeApplySecurityPolicy");
        }
        HashSet hashSet = this.savedMMInfo;
        synchronized (hashSet) {
            if (!this.savedMMInfo.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Applying security policy for saved MBeans");
                }
                for (MBeanSecurityPolicyInfo saved : this.savedMMInfo) {
                    this.loadSecurityPolicy(saved.getInfo(), saved.getDescriptor());
                }
                this.savedMMInfo.clear();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No MBeans to apply security policy for in saved list");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeApplySecurityPolicy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applySecurityPolicy(ModelMBeanInfo info, String descriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "applySecurityPolicy");
        }
        HashSet hashSet = this.savedMMInfo;
        synchronized (hashSet) {
            if (!SecurityHelper.getHelper().isSecurityServiceStarted()) {
                MBeanSecurityPolicyInfo saveit = new MBeanSecurityPolicyInfo(info, descriptor);
                this.savedMMInfo.add(saveit);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security policy will be applied later " + this.savedMMInfo.size());
                }
            } else if (!this.savedMMInfo.isEmpty()) {
                for (MBeanSecurityPolicyInfo saved : this.savedMMInfo) {
                    this.loadSecurityPolicy(saved.getInfo(), saved.getDescriptor());
                }
                this.savedMMInfo.clear();
                this.loadSecurityPolicy(info, descriptor);
            } else {
                this.loadSecurityPolicy(info, descriptor);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "applySecurityPolicy");
        }
    }

    public static String printModelMBeanInfo(ModelMBeanInfo info) {
        StringBuffer retStr = new StringBuffer();
        retStr.append("\nMBeanInfo for ModelMBean is:");
        retStr.append("\nCLASSNAME: \t" + info.getClassName());
        retStr.append("\nDESCRIPTION: \t" + info.getDescription());
        try {
            retStr.append("\nMBEAN DESCRIPTOR: \t" + info.getMBeanDescriptor());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.MBeanFactoryImpl.printModelMBeanInfo", (String)"313");
            retStr.append("\nMBEAN DESCRIPTOR: \t is invalid");
        }
        retStr.append("\n\nATTRIBUTES");
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        if (attrInfo != null && attrInfo.length > 0) {
            for (int i = 0; i < attrInfo.length; ++i) {
                retStr.append("\n    ** NAME: \t" + attrInfo[i].getName());
                retStr.append("    DESCR: \t" + attrInfo[i].getDescription());
                retStr.append("    TYPE: \t" + attrInfo[i].getType());
                retStr.append("\tREAD: " + attrInfo[i].isReadable());
                retStr.append("\tWRITE: " + attrInfo[i].isWritable());
                retStr.append("    DESCRIPTOR: " + ((ModelMBeanAttributeInfo)attrInfo[i]).getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No attributes **");
        }
        retStr.append("\n\nCONSTRUCTORS");
        MBeanConstructorInfo[] constrInfo = info.getConstructors();
        if (constrInfo != null && constrInfo.length > 0) {
            for (int i = 0; i < constrInfo.length; ++i) {
                retStr.append("\n    ** NAME: \t" + constrInfo[i].getName());
                retStr.append("    DESCR: \t" + constrInfo[i].getDescription());
                retStr.append("    PARAM: \t" + constrInfo[i].getSignature().length + " parameter(s)");
                retStr.append("    DESCRIPTOR: " + ((ModelMBeanConstructorInfo)constrInfo[i]).getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No Constructors **");
        }
        retStr.append("\n\nOPERATIONS");
        MBeanOperationInfo[] opInfo = info.getOperations();
        if (opInfo != null && opInfo.length > 0) {
            for (int i = 0; i < opInfo.length; ++i) {
                retStr.append("\n    ** NAME: \t" + opInfo[i].getName());
                retStr.append("    DESCR: \t" + opInfo[i].getDescription());
                retStr.append("    PARAM: \t" + opInfo[i].getSignature().length + " parameter(s)");
                retStr.append("    DESCRIPTOR: " + ((ModelMBeanOperationInfo)opInfo[i]).getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No operations ** ");
        }
        retStr.append("\n\nNOTIFICATIONS");
        MBeanNotificationInfo[] notifInfo = info.getNotifications();
        if (notifInfo != null && notifInfo.length > 0) {
            for (int i = 0; i < notifInfo.length; ++i) {
                retStr.append("\n    ** NAME: \t" + notifInfo[i].getName());
                retStr.append("    DESCR: \t" + notifInfo[i].getDescription());
                retStr.append("    DESCRIPTOR: " + ((ModelMBeanNotificationInfo)notifInfo[i]).getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No notifications **");
        }
        retStr.append(" ** ModelMBean: End of MBeanInfo ** ");
        return retStr.toString();
    }

    private class MBeanSecurityPolicyInfo {
        private ModelMBeanInfo info;
        private String descriptor;

        public MBeanSecurityPolicyInfo(ModelMBeanInfo i, String s) {
            this.info = i;
            this.descriptor = s;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public void setDescriptor(String descriptor) {
            this.descriptor = descriptor;
        }

        public ModelMBeanInfo getInfo() {
            return this.info;
        }

        public void setInfo(ModelMBeanInfo info) {
            this.info = info;
        }
    }

    private class TypeList
    extends ArrayList {
        private static final long serialVersionUID = 969784407160850457L;
        HashMap types = new HashMap();

        TypeList() {
        }

        public boolean add(Object o) {
            Integer count = (Integer)this.types.get(o);
            if (count == null) {
                count = new Integer(1);
                this.types.put(o, count);
                return super.add(o);
            }
            count = new Integer(count + 1);
            this.types.put(o, count);
            return false;
        }

        public boolean remove(Object o) {
            Integer count = (Integer)this.types.get(o);
            if (count == null) {
                return false;
            }
            int val = count;
            if (val > 1) {
                count = new Integer(--val);
                this.types.put(o, count);
                return false;
            }
            this.types.remove(o);
            return super.remove(o);
        }
    }

    class MBeanActivationInfo {
        String type;
        String configId;
        String descriptor;
        Properties props;
        String stoken;
        ObjectName name;
        RuntimeCollaborator collaborator;

        MBeanActivationInfo(String type, String configId, String descriptor, Properties props, String stoken, ObjectName name, RuntimeCollaborator collaborator) {
            this.type = type;
            this.configId = configId;
            this.descriptor = descriptor;
            this.props = props;
            this.stoken = stoken;
            this.name = name;
            this.collaborator = collaborator;
        }
    }
}

