/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import java.util.LinkedList;
import java.util.logging.Logger;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class MBeanConverter {
    private static Logger logger = Logger.getLogger(MBeanConverter.class.getName());

    public static ModelMBeanInfo convert(Object mBean) throws NotCompliantMBeanException {
        DynamicMBean dynamicMBean;
        logger.entering(MBeanConverter.class.getName(), "convert", mBean);
        logger.finest("Checking if mbean is standard and if so, creating  a new StandardMBean object.");
        Object[] standardMBeanInfo = MBeanConverter.isStandardMBean(mBean);
        Boolean isStandardMBean = (Boolean)standardMBeanInfo[0];
        Class interfaceClass = (Class)standardMBeanInfo[1];
        if (isStandardMBean.booleanValue()) {
            dynamicMBean = new StandardMBean(mBean, interfaceClass);
        } else {
            logger.finest("MBean was not standard.");
            dynamicMBean = (DynamicMBean)mBean;
        }
        logger.finest("Getting mbean info from dynamic mbean.");
        MBeanInfo mBeanInfo = dynamicMBean.getMBeanInfo();
        String mBeanDescription = mBeanInfo.getDescription();
        MBeanAttributeInfo[] mBeanAttributeInfo = mBeanInfo.getAttributes();
        MBeanConstructorInfo[] mBeanConstructorInfo = mBeanInfo.getConstructors();
        MBeanOperationInfo[] mBeanOperationInfo = mBeanInfo.getOperations();
        MBeanNotificationInfo[] mBeanNotificationInfo = mBeanInfo.getNotifications();
        logger.finest("Creating model mbean info objects from dynamic mbean.");
        Object[] modelMBeanAttributeInfoArrayAndAttributeOperations = MBeanConverter.getModelMBeanAttributeInfo(mBeanAttributeInfo, isStandardMBean);
        MBeanAttributeInfo[] modelMBeanAttributeInfo = (ModelMBeanAttributeInfo[])modelMBeanAttributeInfoArrayAndAttributeOperations[0];
        LinkedList attributeOperationsLinkedList = (LinkedList)modelMBeanAttributeInfoArrayAndAttributeOperations[1];
        MBeanConstructorInfo[] modelMBeanConstructorInfo = MBeanConverter.getModelMBeanConstructorInfo(mBeanConstructorInfo);
        MBeanOperationInfo[] modelMBeanOperationInfo = MBeanConverter.getModelMBeanOperationInfo(mBeanOperationInfo, isStandardMBean, attributeOperationsLinkedList);
        MBeanNotificationInfo[] modelMBeanNotificationInfo = MBeanConverter.getModelMBeanNotificationInfo(mBeanNotificationInfo);
        logger.finest("Creating the ModelMBeanInfo object.");
        ModelMBeanInfoSupport modelMBeanInfo = new ModelMBeanInfoSupport(mBean.getClass().getName(), mBeanDescription, (ModelMBeanAttributeInfo[])modelMBeanAttributeInfo, (ModelMBeanConstructorInfo[])modelMBeanConstructorInfo, (ModelMBeanOperationInfo[])modelMBeanOperationInfo, (ModelMBeanNotificationInfo[])modelMBeanNotificationInfo);
        logger.finest("Now printing the newly created ModelMBeanInfo objects...");
        MBeanConverter.logMBeanAttributeInfo(modelMBeanAttributeInfo);
        MBeanConverter.logMBeanConstructorInfo(modelMBeanConstructorInfo);
        MBeanConverter.logMBeanOperationInfo(modelMBeanOperationInfo);
        MBeanConverter.logMBeanNotificationInfo(modelMBeanNotificationInfo);
        logger.finest("Now done printing ModelMBeanInfo objects for mbean " + mBean + "...");
        MBeanConverter.logMBeanAttributeDescriptorInfo((ModelMBeanAttributeInfo[])modelMBeanAttributeInfo);
        logger.exiting(MBeanConverter.class.getName(), "convert");
        return modelMBeanInfo;
    }

    private static Object[] getModelMBeanAttributeInfo(MBeanAttributeInfo[] mBeanAttributeInfo, Boolean isStandardMBean) {
        logger.entering(MBeanConverter.class.getName(), "getModelMBeanAttributeInfo", new Object[]{mBeanAttributeInfo, isStandardMBean});
        LinkedList<ModelMBeanOperationInfo> attributeOperationsLinkedList = new LinkedList<ModelMBeanOperationInfo>();
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfo = new ModelMBeanAttributeInfo[mBeanAttributeInfo.length];
        for (int i = 0; i < mBeanAttributeInfo.length; ++i) {
            ModelMBeanOperationInfo newAttributeGetterOperation;
            DescriptorSupport newAttributeOperationDescriptor;
            logger.finest("Setting descriptors for attribute " + mBeanAttributeInfo[i].getName() + ".");
            DescriptorSupport descriptor = new DescriptorSupport();
            descriptor.setField("name", mBeanAttributeInfo[i].getName());
            descriptor.setField("descriptorType", "attribute");
            logger.finest("Creating ModelMBeanAttributeInfo object for attribute " + mBeanAttributeInfo[i].getName() + ".");
            modelMBeanAttributeInfo[i] = new ModelMBeanAttributeInfo(mBeanAttributeInfo[i].getName(), mBeanAttributeInfo[i].getType(), mBeanAttributeInfo[i].getDescription(), mBeanAttributeInfo[i].isReadable(), mBeanAttributeInfo[i].isWritable(), mBeanAttributeInfo[i].isIs(), descriptor);
            if (mBeanAttributeInfo[i].isReadable()) {
                logger.finest("Attribute " + mBeanAttributeInfo[i].getName() + " isReadable.");
                descriptor.setField("getMethod", "get" + mBeanAttributeInfo[i].getName());
                if (isStandardMBean.booleanValue()) {
                    logger.finest("Creating descriptor for newly created getter for attribute " + mBeanAttributeInfo[i].getName() + ".");
                    newAttributeOperationDescriptor = new DescriptorSupport();
                    newAttributeOperationDescriptor.setField("name", "get" + mBeanAttributeInfo[i].getName());
                    newAttributeOperationDescriptor.setField("descriptorType", "operation");
                    newAttributeOperationDescriptor.setField("role", "getter");
                    logger.finest("Creating ModelMBeanOperationInfo object for newly created getter for attribute " + mBeanAttributeInfo[i].getName());
                    newAttributeGetterOperation = new ModelMBeanOperationInfo("get" + mBeanAttributeInfo[i].getName(), "Getter for attribute: " + mBeanAttributeInfo[i].getName(), null, mBeanAttributeInfo[i].getType(), 0, newAttributeOperationDescriptor);
                    attributeOperationsLinkedList.add(newAttributeGetterOperation);
                }
            } else if (mBeanAttributeInfo[i].isIs()) {
                logger.finest("Attribute: " + mBeanAttributeInfo[i].getName() + " isIs.");
                descriptor.setField("getMethod", "is" + mBeanAttributeInfo[i].getName());
                if (isStandardMBean.booleanValue()) {
                    logger.finest("Creating descriptors for newly created boolean getter operation for attribute " + mBeanAttributeInfo[i].getName() + ".");
                    newAttributeOperationDescriptor = new DescriptorSupport();
                    newAttributeOperationDescriptor.setField("name", "is" + mBeanAttributeInfo[i].getName());
                    newAttributeOperationDescriptor.setField("descriptorType", "operation");
                    newAttributeOperationDescriptor.setField("role", "getter");
                    logger.finest("Creating ModelMBeanOperationInfo object for newly created boolean getter operation for attribute " + mBeanAttributeInfo[i].getName() + ".");
                    newAttributeGetterOperation = new ModelMBeanOperationInfo("get" + mBeanAttributeInfo[i].getName(), "Getter for attribute: " + mBeanAttributeInfo[i].getName(), null, mBeanAttributeInfo[i].getType(), 0, newAttributeOperationDescriptor);
                    attributeOperationsLinkedList.add(newAttributeGetterOperation);
                }
            }
            if (mBeanAttributeInfo[i].isWritable()) {
                logger.finest("Attribute: " + mBeanAttributeInfo[i].getName() + " isWritable.");
                descriptor.setField("setMethod", "set" + mBeanAttributeInfo[i].getName());
                if (isStandardMBean.booleanValue()) {
                    logger.finest("Creating descriptors for newly created setter operation attribute " + mBeanAttributeInfo[i].getName() + ".");
                    DescriptorSupport newAttributeOperationsDiscriptor = new DescriptorSupport();
                    newAttributeOperationsDiscriptor.setField("name", "set" + mBeanAttributeInfo[i].getName());
                    newAttributeOperationsDiscriptor.setField("descriptorType", "operation");
                    newAttributeOperationsDiscriptor.setField("role", "setter");
                    logger.finest("Creating ModelMBeanOperationInfo object for newly created setter operation for attribute " + mBeanAttributeInfo[i].getName() + ".");
                    ModelMBeanOperationInfo newAttributeSetterOperation = new ModelMBeanOperationInfo("set" + mBeanAttributeInfo[i].getName(), "Setter for attribute: " + mBeanAttributeInfo[i].getName(), new MBeanParameterInfo[]{new MBeanParameterInfo(mBeanAttributeInfo[i].getType(), mBeanAttributeInfo[i].getType(), null)}, Void.TYPE.getName(), 1, newAttributeOperationsDiscriptor);
                    attributeOperationsLinkedList.add(newAttributeSetterOperation);
                }
            }
            modelMBeanAttributeInfo[i] = new ModelMBeanAttributeInfo(mBeanAttributeInfo[i].getName(), mBeanAttributeInfo[i].getType(), mBeanAttributeInfo[i].getDescription(), mBeanAttributeInfo[i].isReadable(), mBeanAttributeInfo[i].isWritable(), mBeanAttributeInfo[i].isIs(), descriptor);
        }
        Object[] modelMBeanAttributeInfoAndAttributeOperationsLinkedList = new Object[]{modelMBeanAttributeInfo, attributeOperationsLinkedList};
        logger.exiting(MBeanConverter.class.getName(), "getModelMBeanAttributeInfo", modelMBeanAttributeInfoAndAttributeOperationsLinkedList);
        return modelMBeanAttributeInfoAndAttributeOperationsLinkedList;
    }

    private static ModelMBeanConstructorInfo[] getModelMBeanConstructorInfo(MBeanConstructorInfo[] mBeanConstructorInfo) {
        logger.entering(MBeanConverter.class.getName(), "getModelMBeanConstructorInfo", mBeanConstructorInfo);
        ModelMBeanConstructorInfo[] modelMBeanConstructorInfo = new ModelMBeanConstructorInfo[mBeanConstructorInfo.length];
        for (int i = 0; i < mBeanConstructorInfo.length; ++i) {
            logger.finest("Creating ModelMBeanConstructorInfo object for constructor " + mBeanConstructorInfo[i].getName() + ".");
            modelMBeanConstructorInfo[i] = new ModelMBeanConstructorInfo(mBeanConstructorInfo[i].getName(), mBeanConstructorInfo[i].getDescription(), mBeanConstructorInfo[i].getSignature());
        }
        logger.exiting(MBeanConverter.class.getName(), "getModelMBeanConstructorInfo", modelMBeanConstructorInfo);
        return modelMBeanConstructorInfo;
    }

    private static ModelMBeanOperationInfo[] getModelMBeanOperationInfo(MBeanOperationInfo[] mBeanOperationInfo, Boolean isStandardMBean, LinkedList attributeOperationsLinkedList) {
        logger.entering(MBeanConverter.class.getName(), "getModelMBeanOperationInfo", new Object[]{mBeanOperationInfo, isStandardMBean, attributeOperationsLinkedList});
        ModelMBeanOperationInfo[] modelMBeanOperationInfo = new ModelMBeanOperationInfo[mBeanOperationInfo.length];
        for (int i = 0; i < mBeanOperationInfo.length; ++i) {
            logger.finest("Creating ModelMBeanOperationInfo object for operation " + mBeanOperationInfo[i].getName() + ".");
            modelMBeanOperationInfo[i] = new ModelMBeanOperationInfo(mBeanOperationInfo[i].getName(), mBeanOperationInfo[i].getDescription(), mBeanOperationInfo[i].getSignature(), mBeanOperationInfo[i].getReturnType(), 3);
        }
        if (isStandardMBean.booleanValue()) {
            Object[] attributeOperationsArray = attributeOperationsLinkedList.toArray();
            ModelMBeanOperationInfo[] aggregateModelMBeanOperationInfo = new ModelMBeanOperationInfo[modelMBeanOperationInfo.length + attributeOperationsArray.length];
            logger.finest("Copying operations obtained from mbean conversion.");
            for (int i = 0; i < modelMBeanOperationInfo.length; ++i) {
                aggregateModelMBeanOperationInfo[i] = modelMBeanOperationInfo[i];
            }
            logger.finest("Copying newly created mbean operations.");
            for (int j = 0; j < attributeOperationsArray.length; ++j) {
                aggregateModelMBeanOperationInfo[j + modelMBeanOperationInfo.length] = (ModelMBeanOperationInfo)attributeOperationsArray[j];
            }
            modelMBeanOperationInfo = aggregateModelMBeanOperationInfo;
        }
        String modelMBeanOperationInfoString = "";
        for (int k = 0; k < modelMBeanOperationInfo.length; ++k) {
            modelMBeanOperationInfoString = modelMBeanOperationInfoString + modelMBeanOperationInfo[k].getName() + modelMBeanOperationInfo[k].getDescription() + modelMBeanOperationInfo[k].getImpact() + modelMBeanOperationInfo[k].getClass() + " ; ";
        }
        logger.finest("ModelMBeanOperations that are being returned are: " + modelMBeanOperationInfoString);
        logger.exiting(MBeanConverter.class.getName(), "getModelMBeanOperationInfo", modelMBeanOperationInfo);
        return modelMBeanOperationInfo;
    }

    private static ModelMBeanNotificationInfo[] getModelMBeanNotificationInfo(MBeanNotificationInfo[] mBeanNotificationInfo) {
        logger.entering(MBeanConverter.class.getName(), "getModelMBeanNotificationInfo", mBeanNotificationInfo);
        ModelMBeanNotificationInfo[] modelMBeanNotificationInfo = new ModelMBeanNotificationInfo[mBeanNotificationInfo.length];
        for (int i = 0; i < mBeanNotificationInfo.length; ++i) {
            logger.finest("Creating descriptors for notification " + mBeanNotificationInfo[i].getName() + ".");
            DescriptorSupport descriptor = new DescriptorSupport();
            descriptor.setField("name", mBeanNotificationInfo[i].getName());
            descriptor.setField("descriptorType", "notification");
            logger.finest("Creating ModelMBeanNotificationInfo object for notification " + mBeanNotificationInfo[i].getName() + ".");
            modelMBeanNotificationInfo[i] = new ModelMBeanNotificationInfo(mBeanNotificationInfo[i].getNotifTypes(), mBeanNotificationInfo[i].getName(), mBeanNotificationInfo[i].getDescription(), descriptor);
        }
        logger.exiting(MBeanConverter.class.getName(), "getModelMBeanNotificationInfo", modelMBeanNotificationInfo);
        return modelMBeanNotificationInfo;
    }

    private static Object[] isStandardMBean(Object mBeanObject) throws NotCompliantMBeanException {
        Class<?> interfaceClass;
        logger.entering(MBeanConverter.class.getName(), "isStandardMBean", mBeanObject);
        Class<?>[] interfaceArray = mBeanObject.getClass().getInterfaces();
        for (int i = 0; i < interfaceArray.length; ++i) {
            interfaceClass = interfaceArray[i];
            if (interfaceArray[i].getName().equals("javax.management.DynamicMBean")) {
                logger.exiting(MBeanConverter.class.getName(), "isStandardMBean", new Boolean(false));
                return new Object[]{new Boolean(false), null};
            }
            if (!interfaceArray[i].getName().equals(mBeanObject.getClass().getName() + "MBean")) continue;
            logger.exiting(MBeanConverter.class.getName(), "isStandardMBean", new Boolean(true));
            return new Object[]{new Boolean(true), interfaceClass};
        }
        for (Class<?> superClass = mBeanObject.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            interfaceArray = superClass.getInterfaces();
            for (int j = 0; j < interfaceArray.length; ++j) {
                interfaceClass = interfaceArray[j];
                if (interfaceArray[j].getName().equals("javax.management.DynamicMBean")) {
                    logger.exiting(MBeanConverter.class.getName(), "isStandardMBean", new Boolean(false));
                    return new Object[]{new Boolean(false), null};
                }
                if (!interfaceArray[j].getName().equals(superClass.getName() + "MBean")) continue;
                logger.exiting(MBeanConverter.class.getName(), "isStandardMBean", new Boolean(true));
                return new Object[]{new Boolean(true), interfaceClass};
            }
        }
        throw new NotCompliantMBeanException();
    }

    private static void logMBeanAttributeInfo(MBeanAttributeInfo[] mBeanAttributeInfoArray) {
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            String attributeName = mBeanAttributeInfoArray[i].getName();
            logger.finest(attributeName + " attribute Name: " + attributeName);
            logger.finest(attributeName + " attribute Type: " + mBeanAttributeInfoArray[i].getType());
            logger.finest(attributeName + " attribute Description: " + mBeanAttributeInfoArray[i].getDescription());
            logger.finest(attributeName + " attribute isReadable: " + mBeanAttributeInfoArray[i].isReadable());
            logger.finest(attributeName + " attribute isWritable: " + mBeanAttributeInfoArray[i].isWritable());
            logger.finest(attributeName + " attribute isIs: " + mBeanAttributeInfoArray[i].isIs());
        }
    }

    private static void logMBeanConstructorInfo(MBeanConstructorInfo[] mBeanConstructorInfoArray) {
        String constructorName = null;
        String parameterName = null;
        MBeanParameterInfo[] parameterArray = null;
        for (int i = 0; i < mBeanConstructorInfoArray.length; ++i) {
            constructorName = mBeanConstructorInfoArray[i].getName();
            logger.finest(constructorName + " constructor Name: " + constructorName);
            logger.finest(constructorName + " constructor Description: " + mBeanConstructorInfoArray[i].getDescription());
            logger.finest(constructorName + " constructor Class: " + mBeanConstructorInfoArray[i].getClass());
            parameterArray = mBeanConstructorInfoArray[i].getSignature();
            if (parameterArray.length == 0 || parameterArray == null) {
                logger.finest(constructorName + " constructor has a null signature. " + "Not printing parameter info.");
                continue;
            }
            for (int j = 0; j < parameterArray.length; ++j) {
                parameterName = parameterArray[j].getName();
                logger.finest(parameterName + " parameter Name: " + parameterArray[j].getName());
                logger.finest(parameterName + " parameter Description: " + parameterArray[j].getDescription());
                logger.finest(parameterName + " parameter Type: " + parameterArray[j].getType());
                logger.finest(parameterName + " parameter Class: " + parameterArray[j].getClass());
            }
        }
    }

    private static void logMBeanOperationInfo(MBeanOperationInfo[] mBeanOperationInfoArray) {
        String operationName = null;
        String parameterName = null;
        MBeanParameterInfo[] parameterArray = null;
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            operationName = mBeanOperationInfoArray[i].getName();
            logger.finest(operationName + " operation Name: " + operationName);
            logger.finest(operationName + " operation Description: " + mBeanOperationInfoArray[i].getDescription());
            logger.finest(operationName + " operation Class: " + mBeanOperationInfoArray[i].getClass());
            logger.finest(operationName + " operation Return Type: " + mBeanOperationInfoArray[i].getReturnType());
            logger.finest(operationName + " operation Impact: " + mBeanOperationInfoArray[i].getImpact());
            parameterArray = mBeanOperationInfoArray[i].getSignature();
            if (parameterArray.length == 0 || parameterArray == null) {
                logger.finest(operationName + " constructor has a null signature. " + "Not printing parameter info.");
                continue;
            }
            for (int j = 0; j < parameterArray.length; ++j) {
                parameterName = parameterArray[j].getName();
                logger.finest(parameterName + " parameter Name: " + parameterArray[j].getName());
                logger.finest(parameterName + " parameter Description: " + parameterArray[j].getDescription());
                logger.finest(parameterName + " parameter Type: " + parameterArray[j].getType());
                logger.finest(parameterName + " parameter Class: " + parameterArray[j].getClass());
            }
        }
    }

    private static void logMBeanNotificationInfo(MBeanNotificationInfo[] mBeanNotificationInfoArray) {
        for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
            String notificationName = mBeanNotificationInfoArray[i].getName();
            logger.finest(notificationName + " Name: " + notificationName);
            logger.finest(notificationName + " Description: " + mBeanNotificationInfoArray[i].getDescription());
            logger.finest(notificationName + " Class: " + mBeanNotificationInfoArray[i].getClass());
            String[] notifTypes = mBeanNotificationInfoArray[i].getNotifTypes();
            for (int j = 0; j < notifTypes.length; ++j) {
                logger.finest(notificationName + " notification type: " + notifTypes[j]);
            }
        }
    }

    private static void logMBeanAttributeDescriptorInfo(ModelMBeanAttributeInfo[] mBeanAttributeInfoArray) {
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            String attributeName = mBeanAttributeInfoArray[i].getName();
            Descriptor descriptor = mBeanAttributeInfoArray[i].getDescriptor();
            String[] descriptorFieldsArray = descriptor.getFields();
            String descriptorString = "";
            for (int j = 0; j < descriptorFieldsArray.length; ++j) {
                descriptorString = descriptorString + descriptorFieldsArray[j] + " ; ";
            }
            logger.finest("Descriptor information for attribute, " + attributeName + ": " + descriptorString);
        }
    }
}

