/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.authorizer.SecurityAuditingHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceFactoryInitializer;
import com.ibm.ws.management.ControllerAdminService;
import com.ibm.ws.management.MBeanFactoryImpl;
import com.ibm.ws.management.MBeanRouter;
import com.ibm.ws.management.PlatformMBeanServer;
import com.ibm.ws.management.RemoteAdminService;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.discovery.Utils;
import com.ibm.ws.management.event.ClientNotificationService;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.FilterChangeListener;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.ZControlFilterChangeListener;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.nodeagent.NodeAgent;
import com.ibm.ws.management.util.DefaultPlatformUtils;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.security.auth.Subject;

public class AdminServiceImpl
extends DefaultRuntimeCollaborator
implements AdminService,
RemoteAdminService {
    private static String resBundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS(resBundleName);
    private static ManagedObjectMetadataHelper nodeCapabilitiesHelper;
    private static TraceComponent tc;
    private NotificationService notificationService;
    private ClientNotificationService localNotificationService;
    private final String WAS_DOMAIN = "WebSphere";
    private String domainName = null;
    private String cellName = null;
    private String nodeName = null;
    private String processName = null;
    private String cellType = null;
    private boolean cellRegistered = false;
    private final Session session = new Session();
    private String adminType = "ManagedProcess";
    private ObjectName serverMBean = null;
    private String serverType = null;
    private String profileKey = null;
    private final boolean jmxQuery = Boolean.getBoolean("com.ibm.ws.management.AdminServiceImpl.jmxQuery");
    private MBeanFactoryImpl mbeanFactory;
    private MBeanServer _mbServer;
    private ControllerAdminService controllerAdmin = null;
    private static PlatformUtils platformUtils;

    public AdminServiceImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminServiceImpl constructor");
        }
        this.profileKey = AdminContext.peek();
        this.mbeanFactory = new MBeanFactoryImpl(this.getDomainName());
        this._mbServer = this.mbeanFactory.getMBeanServer();
        if (this._mbServer instanceof PlatformMBeanServer) {
            this._mbServer = ((PlatformMBeanServer)this._mbServer).getDefaultMBeanServer();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AdminServiceImpl constructor: ");
            Tr.debug(tc, "    AdminServiceImpl: " + this);
            Tr.debug(tc, "     profileKey: " + this.profileKey);
            Tr.debug(tc, "     mbeanFactory: " + this.mbeanFactory);
        }
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            this.notificationService = new NotificationService(this._mbServer);
        }
    }

    public MBeanFactory getMBeanFactory() {
        this.checkAdminContext();
        return this.mbeanFactory;
    }

    protected void setCellName(String name) {
        this.checkAdminContext();
        this.cellName = name;
    }

    public String getCellName() {
        this.checkAdminContext();
        return this.cellName;
    }

    protected void setNodeName(String name) {
        this.checkAdminContext();
        this.nodeName = name;
    }

    public String getNodeName() {
        this.checkAdminContext();
        return this.nodeName;
    }

    protected void setProcessName(String name) {
        this.checkAdminContext();
        this.processName = name;
    }

    public String getProcessName() {
        this.checkAdminContext();
        return this.processName;
    }

    protected void setServerType(String type) {
        this.checkAdminContext();
        this.serverType = type;
    }

    public String getServerType() {
        this.checkAdminContext();
        return this.serverType;
    }

    protected void setCellType(String type) {
        this.checkAdminContext();
        this.cellType = type;
    }

    public String getCellType() {
        this.checkAdminContext();
        return this.cellType;
    }

    protected void setCellRegistered(boolean isRegistered) {
        this.checkAdminContext();
        this.cellRegistered = isRegistered;
    }

    public boolean isCellRegistered() {
        this.checkAdminContext();
        return this.cellRegistered;
    }

    public Session isAlive() {
        this.checkAdminContext();
        return this.session;
    }

    public Session isAlive(int timeout) {
        this.checkAdminContext();
        return this.session;
    }

    public String getJvmType() {
        this.checkAdminContext();
        String jvmtype = null;
        jvmtype = AdminHelper.getPlatformHelper().isControlJvm() ? "Control" : (AdminHelper.getPlatformHelper().isServantJvm() ? "Servant" : (AdminHelper.getPlatformHelper().isCRAJvm() ? "CRA" : "Single"));
        return jvmtype;
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instantiate", className);
        }
        this.checkAdminContext();
        Object retVal = this._mbServer.instantiate(className);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instantiate", retVal);
        }
        return retVal;
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instantiate", new Object[]{className, loaderName});
        }
        this.checkAdminContext();
        Object retVal = this._mbServer.instantiate(className, loaderName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instantiate", retVal);
        }
        return retVal;
    }

    public Object instantiate(String className, Object[] args, String[] parameters) throws ReflectionException, MBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instantiate", new Object[]{className, args, parameters});
        }
        this.checkAdminContext();
        Object retVal = this._mbServer.instantiate(className, args, parameters);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instantiate", retVal);
        }
        return retVal;
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instantiate", new Object[]{className, loaderName, args, parameters});
        }
        this.checkAdminContext();
        Object retVal = this._mbServer.instantiate(className, loaderName, args, parameters);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instantiate", retVal);
        }
        return retVal;
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMBean");
        }
        this.checkAdminContext();
        ObjectInstance retVal = this._mbServer.createMBean(className, name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMBean");
        }
        return retVal;
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMBean");
        }
        this.checkAdminContext();
        ObjectInstance retVal = this._mbServer.createMBean(className, name, loaderName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMBean");
        }
        return retVal;
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMBean");
        }
        this.checkAdminContext();
        ObjectInstance retVal = this._mbServer.createMBean(className, name, params, signature);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMBean");
        }
        return retVal;
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMBean");
        }
        this.checkAdminContext();
        ObjectInstance retVal = this._mbServer.createMBean(className, name, loaderName, params, signature);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMBean");
        }
        return retVal;
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerMBean", name);
        }
        this.checkAdminContext();
        ObjectInstance retVal = this._mbServer.registerMBean(object, name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerMBean");
        }
        return retVal;
    }

    public String getDomainName() {
        this.checkAdminContext();
        if (this.domainName == null) {
            this.domainName = "WebSphere";
        }
        return this.domainName;
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterMBean");
        }
        this.checkAdminContext();
        this._mbServer.unregisterMBean(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterMBean");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set queryMBeans(ObjectName name, QueryExp query) {
        Set retVal;
        block27: {
            AdminClient[] clients;
            block31: {
                block28: {
                    boolean includeSelf;
                    String rkey;
                    block30: {
                        block26: {
                            block29: {
                                if (tc.isEntryEnabled()) {
                                    Tr.entry(tc, "queryMBeans", name);
                                }
                                this.checkAdminContext();
                                retVal = new HashSet();
                                rkey = null;
                                RoutingGuide rg = null;
                                includeSelf = false;
                                if (this.controllerAdmin != null) break block28;
                                if (name == null) {
                                    rkey = "*";
                                    includeSelf = true;
                                } else {
                                    rg = new RoutingGuide(name, true);
                                    if (rg.eligible()) {
                                        rkey = rg.getRoutingKey();
                                        includeSelf = rg.includeSelf();
                                    } else {
                                        rkey = null;
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "routing key is: ", rkey);
                                }
                                if (rkey != null) break block29;
                                retVal = this._mbServer.queryMBeans(name, query);
                                break block27;
                            }
                            if (!rkey.equals("*")) break block30;
                            if (includeSelf) {
                                retVal = this._mbServer.queryMBeans(name, query);
                            }
                            clients = null;
                            try {
                                clients = RoutingTable.getInstance().getAdminClients();
                            }
                            catch (Throwable t) {
                                if (!tc.isDebugEnabled()) break block26;
                                Tr.debug(tc, "getAdminClients returned exception:", t);
                            }
                        }
                        if (clients == null) break block27;
                        break block31;
                    }
                    if (includeSelf) {
                        retVal = this._mbServer.queryMBeans(name, query);
                    }
                    if (!RoutingTable.getInstance().isRoutable(rkey)) break block27;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "remote queryNames: " + rkey);
                        }
                        AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                        Set _set = client.queryMBeans(name, query);
                        if (retVal == null || retVal.isEmpty()) {
                            retVal = _set;
                            break block27;
                        } else if (_set != null && !_set.isEmpty()) {
                            retVal.addAll(_set);
                        }
                        break block27;
                    }
                    catch (Throwable ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.queryMBeans", (String)"284", (Object)name);
                        if (!tc.isDebugEnabled()) break block27;
                        Tr.debug(tc, "error while doing remote queryNames", ex);
                    }
                    break block27;
                }
                try {
                    retVal = this.controllerAdmin.queryMBeans(name, query);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.queryMBeans", (String)"341", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error while doing controller queryMBeans", ex);
                    }
                    if (!AdminHelper.getPlatformHelper().isServerShuttingDown()) {
                        throw new UndeclaredThrowableException(ex);
                    }
                    retVal = Collections.EMPTY_SET;
                    if (!tc.isDebugEnabled()) break block27;
                    Tr.debug(tc, "Server is shutting down, returning empty set", retVal);
                }
                break block27;
            }
            for (int i = 0; i < clients.length; ++i) {
                if (clients[i] == null) continue;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remote queryNames");
                    }
                    Set _set = clients[i].queryMBeans(name, query);
                    if (retVal == null || retVal.isEmpty()) {
                        retVal = _set;
                        continue;
                    }
                    if (_set == null || _set.isEmpty()) continue;
                    retVal.addAll(_set);
                    continue;
                }
                catch (Throwable ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.queryMBeans", (String)"261", (Object)name);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "error while doing remote queryNames", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryMBeans", retVal);
        }
        return retVal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set queryNames(ObjectName name, QueryExp query) {
        Set retVal;
        block34: {
            AdminClient[] clients;
            block38: {
                block35: {
                    boolean includeSelf;
                    String rkey;
                    block37: {
                        block33: {
                            block36: {
                                if (tc.isEntryEnabled()) {
                                    Tr.entry(tc, "queryNames", name);
                                }
                                this.checkAdminContext();
                                if (this.jmxQuery) {
                                    boolean safeQuery = false;
                                    if (name != null) {
                                        String node = name.getKeyProperty("node");
                                        String process = name.getKeyProperty("process");
                                        if (node != null && node.trim().length() > 0) {
                                            safeQuery = true;
                                        }
                                        if (process != null && process.trim().length() > 0) {
                                            safeQuery = true;
                                        }
                                    }
                                    if (this.adminType.equalsIgnoreCase("DeploymentManager") && !safeQuery) {
                                        Tr.service(tc, "ADMN1202W", new Object[]{name == null ? "*" : name.toString()});
                                        new Exception("Query Details: " + name.toString()).printStackTrace(System.err);
                                    }
                                }
                                retVal = new HashSet();
                                rkey = null;
                                RoutingGuide rg = null;
                                includeSelf = false;
                                if (this.controllerAdmin != null) break block35;
                                if (name == null) {
                                    rkey = "*";
                                    includeSelf = true;
                                } else {
                                    rg = new RoutingGuide(name, true);
                                    if (rg.eligible()) {
                                        rkey = rg.getRoutingKey();
                                        includeSelf = rg.includeSelf();
                                    } else {
                                        rkey = null;
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "routing key is: ", rkey);
                                }
                                if (rkey != null) break block36;
                                retVal = this._mbServer.queryNames(name, query);
                                break block34;
                            }
                            if (!rkey.equals("*")) break block37;
                            if (includeSelf) {
                                retVal = this._mbServer.queryNames(name, query);
                            }
                            clients = null;
                            try {
                                clients = RoutingTable.getInstance().getAdminClients();
                            }
                            catch (Throwable t) {
                                if (!tc.isDebugEnabled()) break block33;
                                Tr.debug(tc, "getAdminClients got exception", t);
                            }
                        }
                        if (clients == null) break block34;
                        break block38;
                    }
                    if (includeSelf) {
                        retVal = this._mbServer.queryNames(name, query);
                    }
                    if (!RoutingTable.getInstance().isRoutable(rkey)) break block34;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "remote queryNames: " + rkey);
                        }
                        AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                        Set _set = client.queryNames(name, query);
                        if (retVal == null || retVal.isEmpty()) {
                            retVal = _set;
                            break block34;
                        } else if (_set != null && !_set.isEmpty()) {
                            retVal.addAll(_set);
                        }
                        break block34;
                    }
                    catch (Throwable ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.queryNames", (String)"284", (Object)name);
                        if (!tc.isDebugEnabled()) break block34;
                        Tr.debug(tc, "error while doing remote queryNames", ex);
                    }
                    break block34;
                }
                try {
                    retVal = this.controllerAdmin.queryNames(name, query);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.queryNames", (String)"341", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error while doing controller queryNames", ex);
                    }
                    if (!AdminHelper.getPlatformHelper().isServerShuttingDown()) {
                        throw new UndeclaredThrowableException(ex);
                    }
                    retVal = Collections.EMPTY_SET;
                    if (!tc.isDebugEnabled()) break block34;
                    Tr.debug(tc, "Server is shutting down, returning empty set", retVal);
                }
                break block34;
            }
            for (int i = 0; i < clients.length; ++i) {
                if (clients[i] == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "skipping clients: " + i);
                    continue;
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remote queryNames");
                    }
                    Set _set = clients[i].queryNames(name, query);
                    if (retVal == null || retVal.isEmpty()) {
                        retVal = _set;
                        continue;
                    }
                    if (_set == null || _set.isEmpty()) continue;
                    retVal.addAll(_set);
                    continue;
                }
                catch (Throwable ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.queryNames", (String)"261", (Object)name);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "error while doing remote queryNames", ex);
                }
            }
        }
        if ("AdminAgent".equals(this.adminType)) {
            retVal = this.reorderQueryResult(retVal);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryNames", retVal);
        }
        return retVal;
    }

    public boolean isRegistered(ObjectName name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistered", name);
        }
        this.checkAdminContext();
        boolean retVal = false;
        if (name == null) {
            return false;
        }
        if (this.controllerAdmin == null) {
            RoutingGuide rg = new RoutingGuide(name, false);
            String rkey = rg.eligible() ? rg.getRoutingKey() : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "routing key is: ", rkey);
            }
            if (rkey == null) {
                retVal = this._mbServer.isRegistered(name);
            } else if (RoutingTable.getInstance().isRoutable(rkey)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remote isRegistered: " + rkey);
                    }
                    AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                    retVal = client.isRegistered(name);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.isRegistered", (String)"321", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "connector problem occurs", ex);
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                }
                retVal = this._mbServer.isRegistered(name);
            }
        } else {
            try {
                retVal = this.controllerAdmin.isRegistered(name);
            }
            catch (ConnectorException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.isRegistered", (String)"409", (Object)name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error while doing controller isRegistered", ex);
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistered", new Boolean(retVal));
        }
        return retVal;
    }

    public Integer getMBeanCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanCount");
        }
        this.checkAdminContext();
        Integer retVal = null;
        if (this.controllerAdmin == null) {
            retVal = this._mbServer.getMBeanCount();
        } else {
            try {
                retVal = this.controllerAdmin.getMBeanCount();
            }
            catch (ConnectorException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getMBeanCount", (String)"440");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error while doing controller getMBeanCount", ex);
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanCount");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        Object retVal;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAttribute", name);
            }
            retVal = null;
            String resName = (name == null ? "null" : name.toString()) + "|" + attribute;
            SecurityConfigResource res = new SecurityConfigResource(resName, "admin");
            boolean secPushed = false;
            try {
                this.checkAdminContext();
                secPushed = SecurityObjectLocator.getThreadLocal().pushResource(res);
                name = MBeanRouter.transformObjectName(name);
                if (this.controllerAdmin == null) {
                    try {
                        RoutingGuide rg = new RoutingGuide(name, false);
                        String rkey = rg.eligible() ? rg.getRoutingKey() : null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "routing key is: ", rkey);
                        }
                        if (rkey == null) {
                            this.preInvoke(name, attribute, true);
                            retVal = this._mbServer.getAttribute(name, attribute);
                            break block22;
                        }
                        if (RoutingTable.getInstance().isRoutable(rkey)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "remote getAttribute: " + rkey);
                            }
                            try {
                                AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                                retVal = client.getAttribute(name, attribute);
                                break block22;
                            }
                            catch (ConnectorException exc) {
                                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.AdminServiceImpl.getAttribute", (String)"379", (Object)name);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "connector problem occurs", exc);
                                }
                                throw new JMRuntimeException(this.connectorMsg(this.processName, rkey, exc));
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                        }
                        this.preInvoke(name, attribute, true);
                        retVal = this._mbServer.getAttribute(name, attribute);
                        break block22;
                    }
                    catch (MBeanException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"408", (Object)this, (Object[])new Object[]{name});
                        Tr.service(tc, "ADMN0007I", new AdminException(ex));
                        throw ex;
                    }
                    catch (ReflectionException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"415", (Object)this, (Object[])new Object[]{name});
                        Tr.service(tc, "ADMN0007I", new AdminException(ex));
                        throw ex;
                    }
                    catch (RuntimeException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"422", (Object)this, (Object[])new Object[]{name});
                        Tr.service(tc, "ADMN0007I", new AdminException(ex));
                        throw ex;
                    }
                }
                try {
                    retVal = this.controllerAdmin.getAttribute(name, attribute);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getAttribute", (String)"534");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error while doing controller getAttribute", ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
            finally {
                if (secPushed) {
                    SecurityObjectLocator.getThreadLocal().popResource();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", retVal);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList retVal;
        block23: {
            String resName;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAttributes", name);
            }
            retVal = null;
            String string = resName = name == null ? "null" : name.toString();
            if (attributes != null) {
                for (int i = 0; i < attributes.length; ++i) {
                    resName = resName + "|" + attributes[i];
                }
            }
            SecurityConfigResource res = new SecurityConfigResource(resName, "admin");
            boolean secPushed = false;
            try {
                this.checkAdminContext();
                secPushed = SecurityObjectLocator.getThreadLocal().pushResource(res);
                name = MBeanRouter.transformObjectName(name);
                if (this.controllerAdmin == null) {
                    try {
                        RoutingGuide rg = new RoutingGuide(name, false);
                        String rkey = rg.eligible() ? rg.getRoutingKey() : null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "routing key is: ", rkey);
                        }
                        if (rkey == null) {
                            this.preInvoke(name, attributes, true);
                            retVal = this._mbServer.getAttributes(name, attributes);
                            break block23;
                        }
                        if (RoutingTable.getInstance().isRoutable(rkey)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "remote getAttributes: " + rkey);
                            }
                            try {
                                AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                                retVal = client.getAttributes(name, attributes);
                                break block23;
                            }
                            catch (ConnectorException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getAttributes", (String)"437", (Object)name);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "connector problem occurs", ex);
                                }
                                throw new JMRuntimeException(this.connectorMsg(this.processName, rkey, ex));
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                        }
                        this.preInvoke(name, attributes, true);
                        retVal = this._mbServer.getAttributes(name, attributes);
                        break block23;
                    }
                    catch (ReflectionException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"476", (Object)this, (Object[])new Object[]{name});
                        Tr.service(tc, "ADMN0008I", new AdminException(ex));
                        throw ex;
                    }
                    catch (RuntimeException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"483", (Object)this, (Object[])new Object[]{name});
                        Tr.service(tc, "ADMN0008I", new AdminException(ex));
                        throw ex;
                    }
                }
                try {
                    retVal = this.controllerAdmin.getAttributes(name, attributes);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getAttributes", (String)"617");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error while doing controller getAttributes", ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
            finally {
                if (secPushed) {
                    SecurityObjectLocator.getThreadLocal().popResource();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setAttribute", name);
            }
            String resName = (name == null ? "null" : name.toString()) + "|" + (attribute == null ? "null" : attribute.getName());
            SecurityConfigResource res = new SecurityConfigResource(resName, "admin");
            boolean secPushed = false;
            try {
                this.checkAdminContext();
                secPushed = SecurityObjectLocator.getThreadLocal().pushResource(res);
                name = MBeanRouter.transformObjectName(name);
                if (this.controllerAdmin == null) {
                    try {
                        RoutingGuide rg = new RoutingGuide(name, false);
                        String rkey = rg.eligible() ? rg.getRoutingKey() : null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "routing key is: ", rkey);
                        }
                        if (rkey == null) {
                            this.preInvoke(name, attribute, false);
                            this._mbServer.setAttribute(name, attribute);
                            break block21;
                        }
                        if (RoutingTable.getInstance().isRoutable(rkey)) {
                            try {
                                AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                                client.setAttribute(name, attribute);
                                break block21;
                            }
                            catch (ConnectorException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.setAttribute", (String)"488", (Object)name);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "connector problem occurs", ex);
                                }
                                throw new MBeanException(ex, "connector malfunction");
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                        }
                        this.preInvoke(name, attribute, false);
                        this._mbServer.setAttribute(name, attribute);
                        break block21;
                    }
                    catch (MBeanException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"537", (Object)this, (Object[])new Object[]{name});
                        Tr.service(tc, "ADMN0009I", new AdminException(ex));
                        throw ex;
                    }
                    catch (ReflectionException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"544", (Object)this, (Object[])new Object[]{name});
                        Tr.service(tc, "ADMN0009I", new AdminException(ex));
                        throw ex;
                    }
                    catch (RuntimeException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"551", (Object)this, (Object[])new Object[]{name});
                        Tr.service(tc, "ADMN0009I", new AdminException(ex));
                        throw ex;
                    }
                }
                try {
                    this.controllerAdmin.setAttribute(name, attribute);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.setAttribute", (String)"706");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error while doing controller setAttribute", ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
            finally {
                if (secPushed) {
                    SecurityObjectLocator.getThreadLocal().popResource();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList retVal;
        block22: {
            String resName;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setAttributes", name);
            }
            retVal = null;
            String string = resName = name == null ? "null" : name.toString();
            if (attributes != null) {
                for (Attribute attr : attributes) {
                    resName = resName + "|" + (attr == null ? "null" : attr.getName());
                }
            }
            SecurityConfigResource res = new SecurityConfigResource(resName, "admin");
            boolean secPushed = false;
            try {
                this.checkAdminContext();
                secPushed = SecurityObjectLocator.getThreadLocal().pushResource(res);
                name = MBeanRouter.transformObjectName(name);
                if (this.controllerAdmin == null) {
                    try {
                        RoutingGuide rg = new RoutingGuide(name, false);
                        String rkey = rg.eligible() ? rg.getRoutingKey() : null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "routing key is: ", rkey);
                        }
                        if (rkey == null) {
                            this.preInvoke(name, attributes, false);
                            retVal = this._mbServer.setAttributes(name, attributes);
                            break block22;
                        }
                        if (RoutingTable.getInstance().isRoutable(rkey)) {
                            try {
                                AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                                retVal = client.setAttributes(name, attributes);
                                break block22;
                            }
                            catch (ConnectorException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.setAttributes", (String)"544", (Object)name);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "connector problem occurs", ex);
                                }
                                throw new JMRuntimeException(this.connectorMsg(this.processName, rkey, ex));
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                        }
                        this.preInvoke(name, attributes, false);
                        retVal = this._mbServer.setAttributes(name, attributes);
                        break block22;
                    }
                    catch (ReflectionException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"605", (Object)this, (Object[])new Object[]{name});
                        Tr.service(tc, "ADMN0010I", new AdminException(ex));
                        throw ex;
                    }
                    catch (RuntimeException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"612", (Object)this, (Object[])new Object[]{name});
                        Tr.service(tc, "ADMN0010I", new AdminException(ex));
                        throw ex;
                    }
                }
                try {
                    retVal = this.controllerAdmin.setAttributes(name, attributes);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.setAttributes", (String)"788");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error while doing controller setAttributes", ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
            finally {
                if (secPushed) {
                    SecurityObjectLocator.getThreadLocal().popResource();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes", retVal);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(final ObjectName origName, final String operationName, final Object[] params, final String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", new Object[]{origName, operationName, new Integer(params == null ? 0 : params.length)});
        }
        Object retVal1 = null;
        String resName = (origName == null ? "null" : origName.toString()) + "|" + operationName;
        SecurityConfigResource res = new SecurityConfigResource(resName, "admin");
        boolean secPushed = false;
        try {
            this.checkAdminContext();
            secPushed = SecurityObjectLocator.getThreadLocal().pushResource(res);
            try {
                retVal1 = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws InstanceNotFoundException, MBeanException, ReflectionException {
                        ObjectName name = MBeanRouter.transformObjectName(origName);
                        Object retVal = null;
                        if (AdminServiceImpl.this.controllerAdmin == null) {
                            block43: {
                                try {
                                    if (operationName.equals("testConnection") && params != null && params.length == 1 && !name.isPattern() && name.getKeyProperty("type").equals("DataSourceCfgHelper") && AdminServiceImpl.this.adminType.equalsIgnoreCase("DeploymentManager")) {
                                        String nodeName = name.getKeyProperty("node");
                                        if (nodeName != null) {
                                            if (nodeCapabilitiesHelper == null) {
                                                nodeCapabilitiesHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(new Properties()));
                                            }
                                            String majorVersion = nodeCapabilitiesHelper.getNodeMajorVersion(nodeName);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "majorVersion for node " + nodeName + " is: " + majorVersion);
                                            }
                                            String oldConfigId = (String)params[0];
                                            params[0] = majorVersion.equals("5") ? AdminServiceImpl.this.transformConfigId(oldConfigId) : AdminServiceImpl.this.reverseTransformConfigId(oldConfigId);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "transforming config Id from " + oldConfigId + " to " + params[0] + " for operation " + operationName + " on MBean " + name.toString());
                                            }
                                        }
                                    } else if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "name.isPattern: " + name.isPattern() + "; name's type property: " + name.getKeyProperty("type") + "; adminType: " + AdminServiceImpl.this.adminType);
                                    }
                                }
                                catch (Throwable ex) {
                                    if (!tc.isDebugEnabled()) break block43;
                                    Tr.debug(tc, "did not transform config due to exception: " + ex);
                                }
                            }
                            try {
                                String runas;
                                RoutingGuide rg = new RoutingGuide(name, false);
                                String rkey = rg.eligible() ? rg.getRoutingKey() : null;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "routing key is: ", rkey);
                                }
                                if (rkey == null) {
                                    runas = AdminServiceImpl.this.preInvoke(name, operationName, params, signature, null, true);
                                    if (runas != null && runas.equals("System")) {
                                        final ObjectName nameFinal = name;
                                        final String operationNameFinal = operationName;
                                        final Object[] paramsFinal = params;
                                        final String[] signatureFinal = signature;
                                        try {
                                            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                                            retVal = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                                                public Object run() throws Exception {
                                                    Object obj = AdminServiceImpl.this._mbServer.invoke(nameFinal, operationNameFinal, paramsFinal, signatureFinal);
                                                    return obj;
                                                }
                                            });
                                        }
                                        catch (PrivilegedActionException pae) {
                                            retVal = null;
                                        }
                                        catch (Exception e) {
                                            retVal = null;
                                        }
                                    }
                                    retVal = AdminServiceImpl.this._mbServer.invoke(name, operationName, params, signature);
                                }
                                if (RoutingTable.getInstance().isRoutable(rkey)) {
                                    try {
                                        AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                                        if (name.getKeyProperty("type").equals("Server") && operationName.equals("stop")) {
                                            NodeAgent na = NodeAgent.getInstance();
                                            if (na != null) {
                                                na.emitTryingToStopProcessNotification(rkey);
                                            } else if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Node agent instance is null: ", rkey);
                                            }
                                        }
                                        retVal = client.invoke(name, operationName, params, signature);
                                    }
                                    catch (ConnectorException ex) {
                                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"591", (Object)name);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "connector problem occurs", ex);
                                        }
                                        throw new JMRuntimeException(AdminServiceImpl.this.connectorMsg(AdminServiceImpl.this.processName, rkey, ex));
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                                }
                                if ((runas = AdminServiceImpl.this.preInvoke(name, operationName, params, signature, null, true)) != null && runas.equals("System")) {
                                    final ObjectName nameFinal = name;
                                    final String operationNameFinal = operationName;
                                    final Object[] paramsFinal = params;
                                    final String[] signatureFinal = signature;
                                    try {
                                        Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                                        retVal = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                                            public Object run() throws Exception {
                                                Object obj = AdminServiceImpl.this._mbServer.invoke(nameFinal, operationNameFinal, paramsFinal, signatureFinal);
                                                return obj;
                                            }
                                        });
                                    }
                                    catch (PrivilegedActionException pae) {
                                        retVal = null;
                                    }
                                    catch (Exception e) {
                                        retVal = null;
                                    }
                                }
                                retVal = AdminServiceImpl.this._mbServer.invoke(name, operationName, params, signature);
                            }
                            catch (InstanceNotFoundException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"672", (Object)this, (Object[])new Object[]{name});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "invoke method throws exception", new AdminException(ex));
                                }
                                throw ex;
                            }
                            catch (MBeanException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"679", (Object)this, (Object[])new Object[]{name});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "invoke method throws exception", new AdminException(ex));
                                }
                                throw ex;
                            }
                            catch (ReflectionException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"686", (Object)this, (Object[])new Object[]{name});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "invoke method throws exception", new AdminException(ex));
                                }
                                throw ex;
                            }
                            catch (RuntimeException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"693", (Object)this, (Object[])new Object[]{name});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "invoke method throws exception", new AdminException(ex));
                                }
                                throw ex;
                            }
                        } else {
                            try {
                                retVal = AdminServiceImpl.this.controllerAdmin.invoke(name, operationName, params, signature);
                            }
                            catch (ConnectorException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"885");
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "error while doing controller invoke", ex);
                                }
                                UndeclaredThrowableException ute = null;
                                Throwable exCause = ex.getCause();
                                ute = exCause != null ? new UndeclaredThrowableException(ex, exCause.getMessage()) : new UndeclaredThrowableException(ex, ex.getMessage());
                                throw ute;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "invoke returning .. do Priv next");
                        }
                        return retVal;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)e;
                }
                if (e instanceof MBeanException) {
                    throw (MBeanException)e;
                }
                if (e instanceof ReflectionException) {
                    throw (ReflectionException)e;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"956");
                throw new MBeanException(e);
            }
        }
        finally {
            if (secPushed) {
                SecurityObjectLocator.getThreadLocal().popResource();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return retVal1;
    }

    public String getDefaultDomain() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDomain");
        }
        this.checkAdminContext();
        String retVal = this._mbServer.getDefaultDomain();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDomain");
        }
        return retVal;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanInfo", name);
        }
        this.checkAdminContext();
        name = MBeanRouter.transformObjectName(name);
        MBeanInfo retVal = null;
        if (this.controllerAdmin == null) {
            RoutingGuide rg = new RoutingGuide(name, false);
            String rkey = rg.eligible() ? rg.getRoutingKey() : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "routing key is: ", rkey);
            }
            if (rkey == null) {
                retVal = this._mbServer.getMBeanInfo(name);
            } else if (RoutingTable.getInstance().isRoutable(rkey)) {
                try {
                    AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                    retVal = client.getMBeanInfo(name);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getMBeanInfo", (String)"674", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "connector problem occurs", ex);
                    }
                    throw new JMRuntimeException(this.connectorMsg(this.processName, rkey, ex));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                }
                retVal = this._mbServer.getMBeanInfo(name);
            }
        } else {
            try {
                retVal = this.controllerAdmin.getMBeanInfo(name);
            }
            catch (ConnectorException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getMBeanInfo", (String)"956");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error while doing controller getMBeanInfo", ex);
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanInfo");
        }
        return retVal;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInstanceOf", name);
        }
        this.checkAdminContext();
        name = MBeanRouter.transformObjectName(name);
        boolean retVal = false;
        if (this.controllerAdmin == null) {
            RoutingGuide rg = new RoutingGuide(name, false);
            String rkey = rg.eligible() ? rg.getRoutingKey() : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "routing key is: ", rkey);
            }
            if (rkey == null) {
                retVal = this._mbServer.isInstanceOf(name, className);
            } else if (RoutingTable.getInstance().isRoutable(rkey)) {
                try {
                    AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                    retVal = client.isInstanceOf(name, className);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.isInstanceOf", (String)"738", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "connector problem occurs", ex);
                    }
                    throw new JMRuntimeException(this.connectorMsg(this.processName, rkey, ex));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                }
                retVal = this._mbServer.isInstanceOf(name, className);
            }
        } else {
            try {
                retVal = this.controllerAdmin.isInstanceOf(name, className);
            }
            catch (ConnectorException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.isInstanceOf", (String)"1019");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error while doing controller isInstanceOf", ex);
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInstanceOf");
        }
        return retVal;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.checkAdminContext();
        if (name == null) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null.");
        }
        if (!this.isRegistered(name)) {
            throw new InstanceNotFoundException("Could not find " + name);
        }
        if (this.localNotificationService == null) {
            this.initLocalEventService();
        }
        try {
            this.localNotificationService.addNotificationListener(name, listener, filter, handback);
        }
        catch (ConnectorException exc) {
            // empty catch block
        }
    }

    public void addNotificationListenerExtended(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        this.checkAdminContext();
        if (name == null) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null.");
        }
        if (this.localNotificationService == null) {
            this.initLocalEventService();
        }
        try {
            this.localNotificationService.addNotificationListenerExtended(name, listener, filter, handback);
        }
        catch (ConnectorException exc) {
            // empty catch block
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkAdminContext();
        if (name == null) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null.");
        }
        if (!this.isRegistered(name)) {
            throw new InstanceNotFoundException("Could not find " + name);
        }
        if (this.localNotificationService == null) {
            throw new ListenerNotFoundException();
        }
        try {
            this.localNotificationService.removeNotificationListener(name, listener);
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
    }

    public void removeNotificationListenerExtended(ObjectName name, NotificationListener listener) throws ListenerNotFoundException {
        this.checkAdminContext();
        if (this.localNotificationService == null) {
            throw new ListenerNotFoundException();
        }
        try {
            this.localNotificationService.removeNotificationListenerExtended(name, listener);
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
    }

    public void removeNotificationListenerExtended(NotificationListener listener) throws ListenerNotFoundException {
        this.checkAdminContext();
        this.removeNotificationListenerExtended(null, listener);
    }

    private synchronized void initLocalEventService() {
        if (this.localNotificationService == null) {
            this.localNotificationService = new ClientNotificationService();
            FilterChangeListener fcListener = null;
            fcListener = AdminHelper.getPlatformHelper().isZOS() ? (AdminHelper.getPlatformHelper().isControlJvm() && !this.adminType.equalsIgnoreCase("NodeAgent") ? new ZControlFilterChangeListener() : this.notificationService.getDownstreamProcessManager()) : this.notificationService.getDownstreamServerManager();
            this.localNotificationService.setFilterChangeListener(fcListener);
            this.notificationService.addListener(this.localNotificationService);
        }
    }

    public void initializeNotificationService() {
        this.checkAdminContext();
        this.notificationService = new NotificationService(this._mbServer);
    }

    public NotificationService getNotificationService() {
        this.checkAdminContext();
        return this.notificationService;
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter filter, PushNotificationListener listener) {
        this.checkAdminContext();
        return this.notificationService.addNotificationListener(filter, listener);
    }

    public void removeNotificationListener(ListenerIdentifier listenerId) throws ReceiverNotFoundException {
        this.checkAdminContext();
        this.notificationService.removeNotificationListener(listenerId);
    }

    public void resetFilter(ListenerIdentifier listenerId, ConsolidatedFilter filter) throws ReceiverNotFoundException {
        this.checkAdminContext();
        this.notificationService.resetFilter(listenerId, filter);
    }

    public Notification[] pullNotifications(ListenerIdentifier id, Integer batchSize) throws ReceiverNotFoundException {
        this.checkAdminContext();
        return this.notificationService.pullNotifications(id, batchSize);
    }

    public String getProcessType() {
        this.checkAdminContext();
        return this.adminType;
    }

    public void setProcessType(String type) {
        this.checkAdminContext();
        this.adminType = type;
    }

    public ObjectName getServerMBean() {
        return this.getLocalServerMBean();
    }

    public ObjectName getLocalServer() {
        return this.getLocalServerMBean();
    }

    public void setLocalServer(ObjectName svrBean) {
        this.checkAdminContext();
        this.serverMBean = svrBean;
    }

    public boolean isLocalServer(String cellname, String nodename, String servername) {
        this.checkAdminContext();
        boolean islocal = false;
        ObjectNameHelper helper = new ObjectNameHelper();
        if (ObjectNameHelper.getCellName(this.serverMBean).equals(cellname)) {
            if (ObjectNameHelper.getNodeName(this.serverMBean).equals(nodename)) {
                if (ObjectNameHelper.getProcessName(this.serverMBean).equals(servername)) {
                    islocal = true;
                }
            }
        }
        return islocal;
    }

    public AdminClient getDeploymentManagerAdminClient() throws AdminException {
        this.checkAdminContext();
        AdminClient ac = null;
        try {
            ac = Utils.getDmgrAdminClient();
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        return ac;
    }

    private void preInvoke(ObjectName name, String attribute, boolean isGetter) throws InstanceNotFoundException, ReflectionException {
        this.preInvoke(name, new Attribute(attribute, null), isGetter);
    }

    private void preInvoke(ObjectName name, String[] attributes, boolean isGetter) throws InstanceNotFoundException, ReflectionException {
        AttributeList lst = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            lst.add(new Attribute(attributes[i], null));
        }
        this.preInvoke(name, lst, isGetter);
    }

    private void preInvoke(ObjectName name, Attribute attribute, boolean isGetter) throws InstanceNotFoundException, ReflectionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "preInvoke", new Object[]{name, attribute, new Boolean(isGetter)});
        }
        if (name == null || attribute == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "null object name or attribute");
            }
            return;
        }
        AttributeList lst = new AttributeList();
        lst.add(attribute);
        this.preInvoke(name, lst, isGetter);
    }

    private void preInvoke(ObjectName name, AttributeList attributes, boolean isGetter) throws InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke", new Object[]{name, attributes, new Boolean(isGetter)});
        }
        if (name == null || attributes == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "null object name or attributes");
            }
            return;
        }
        this.checkForAttrDeprecation(name, attributes);
        if (!SecurityHelper.getHelper().isSecurityEnabled() || !SecurityHelper.getHelper().isSecurityServiceStarted()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "preInvoke - security not enabled");
            }
            return;
        }
        String type = ObjectNameHelper.getMBeanType(name);
        List types = AdminServiceFactory.getMBeanFactory().getMBeanTypes();
        if (!types.contains(type) && !types.contains(name.toString())) {
            return;
        }
        ModelMBeanAttributeInfo attrInfo = null;
        for (int i = 0; i < attributes.size(); ++i) {
            String[] s;
            String attribute = ((Attribute)attributes.get(i)).getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "permission check for attribute: ", attribute);
            }
            try {
                MBeanInfo mbInfo = this.getMBeanInfo(name);
                if (mbInfo instanceof ModelMBeanInfo) {
                    ModelMBeanInfo mmInfo = (ModelMBeanInfo)((Object)mbInfo);
                    attrInfo = mmInfo.getAttribute(attribute);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Constructing ModelMBeanInfo for Standard mbean");
                    }
                    MBeanAttributeInfo[] mbeanAttrInfo = mbInfo.getAttributes();
                    MBeanAttributeInfo attr = null;
                    for (int j = 0; j < mbeanAttrInfo.length; ++j) {
                        attr = mbeanAttrInfo[j];
                        if (!attribute.equals(attr)) continue;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Found the right attribute " + attr.getName());
                        break;
                    }
                    DescriptorSupport descSupport = new DescriptorSupport();
                    descSupport.setField("name", attr.getName());
                    descSupport.setField("descriptorType", "attribute");
                    if (attr.isReadable()) {
                        descSupport.setField("getMethod", "get" + attr.getName());
                    } else if (attr.isIs()) {
                        descSupport.setField("getMethod", "is" + attr.getName());
                    }
                    if (attr.isWritable()) {
                        descSupport.setField("setMethod", "set" + attr.getName());
                    }
                    attrInfo = new ModelMBeanAttributeInfo(attr.getName(), attr.getType(), attr.getDescription(), attr.isReadable(), attr.isWritable(), attr.isIs(), descSupport);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Constructed ModelMBeanAttributeinfo for Standard mbean " + attrInfo);
                    }
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.setAttribute", (String)"1069", (Object)name);
                throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{name}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
            }
            if (attrInfo == null) continue;
            Descriptor desc = attrInfo.getDescriptor();
            String attrType = attrInfo.getType();
            String m = null;
            if (isGetter) {
                m = (String)desc.getFieldValue("getMethod");
                s = new String[]{};
            } else {
                m = (String)desc.getFieldValue("setMethod");
                s = new String[]{attrType};
            }
            if (m == null) continue;
            this.preInvoke(name, m, null, s, desc, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke - granted");
        }
    }

    private void checkForAttrDeprecation(ObjectName name, AttributeList attrs) throws InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForAttrDeprecation");
        }
        MBeanInfo mbInfo = null;
        try {
            mbInfo = this.getMBeanInfo(name);
        }
        catch (IntrospectionException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.checkForAttrDeprecation", (String)"1267", (Object)name);
            throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{name}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
        }
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            String deprecated;
            String attrName = ((Attribute)i.next()).getName();
            ModelMBeanAttributeInfo attrInfo = null;
            try {
                if (mbInfo instanceof ModelMBeanInfo) {
                    attrInfo = ((ModelMBeanInfo)((Object)mbInfo)).getAttribute(attrName);
                }
            }
            catch (MBeanException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.checkForAttrDeprecation", (String)"1285", (Object)name);
                throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{name}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
            }
            if (attrInfo == null || (deprecated = (String)attrInfo.getDescriptor().getFieldValue("deprecated")) == null) continue;
            this.outputWarningAndFFDC("ADMN0036W", new Object[]{name.getKeyProperty("type"), attrName, deprecated}, "com.ibm.ws.management.AdminServiceImpl.checkForAttrDeprecation", "1308");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForAttrDeprecation");
        }
    }

    private void outputWarningAndFFDC(String messageId, Object[] params, String sourceId, String probeId) {
        Tr.warning(tc, messageId, params);
        RuntimeException exc = new RuntimeException(nls.getFormattedMessage(messageId, params, null));
        FFDCFilter.processException((Throwable)exc, (String)sourceId, (String)probeId, (Object)this);
    }

    private String preInvoke(ObjectName name, String operationName, Object[] params, String[] signature, Descriptor attrDesc, boolean doDeprecationCheck) throws InstanceNotFoundException, ReflectionException {
        AdminAuthorizer aa;
        String type;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke", new Object[]{name, operationName, signature, attrDesc});
        }
        String resKey = null;
        String resType = null;
        String[] resource_names = null;
        String[] resource_types = null;
        ModelMBeanInfo modelmbeanInfo = null;
        Descriptor mbeanDesc = null;
        String runAs = null;
        boolean forceFG = false;
        if (doDeprecationCheck) {
            this.checkForOpDeprecation(name, operationName);
        }
        if ((type = ObjectNameHelper.getMBeanType(name)) != null && type.equals("FileBrowser") && operationName.equals("translateLineNumbersToOffsets") && signature != null && signature.length > 1 && signature[1] != null && signature[1].equals("[Llong;")) {
            signature[1] = "[J";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Converting incorrect signature type");
            }
        }
        if (!SecurityHelper.getHelper().isSecurityEnabled() || !SecurityHelper.getHelper().isSecurityServiceStarted()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "preInvoke - security not enabled");
            }
            return null;
        }
        List types = AdminServiceFactory.getMBeanFactory().getMBeanTypes();
        if (!types.contains(type) && !types.contains(name.toString())) {
            return null;
        }
        StringBuffer sb = new StringBuffer(operationName);
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                sb.append(":").append(signature[i]);
            }
        }
        try {
            MBeanInfo mbInfo = this.getMBeanInfo(name);
            if (mbInfo instanceof ModelMBeanInfo) {
                modelmbeanInfo = (ModelMBeanInfo)((Object)mbInfo);
                mbeanDesc = modelmbeanInfo.getMBeanDescriptor();
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.preInvoke(operation)", (String)"1761", (Object)name);
            throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{name}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
        }
        if (mbeanDesc != null) {
            boolean bl = forceFG = mbeanDesc.getFieldValue("forceFineGrain") != null;
        }
        if ((aa = AdminAuthorizerFactory.getAdminAuthorizer()) == null || !forceFG && aa != null && !aa.isFineGrainedAdminSecurity()) {
            String moduleName = ObjectNameHelper.getMBeanType(name);
            if (moduleName == null) {
                moduleName = name.toString();
            }
            try {
                RoleBasedAuthorizer authz = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
                boolean permissionGranted = authz.checkAccess(moduleName, moduleName, sb.toString());
                SecurityAuditingHelper.getInstance().logSecurityAuditForMBean(permissionGranted, name, operationName, (String)null, "preinvoke MBean");
                if (!permissionGranted) {
                    throw new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{operationName, moduleName}, "Access denied for the {0} operation on {1} MBean"));
                }
            }
            catch (RoleBasedAppException ex) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "preInvoke -  denied");
                }
                throw new JMRuntimeException(nls.getFormattedMessage("ADMN0022E", new Object[]{operationName, moduleName}, "Access denied for the {0} operation on {1} MBean"));
            }
            return null;
        }
        if (attrDesc != null) {
            try {
                resKey = (String)attrDesc.getFieldValue("excludeAccessCheck");
                if (resKey != null && resKey.equals("true")) {
                    return null;
                }
                resKey = (String)attrDesc.getFieldValue("minimalAccessCheck");
                if (resKey != null && resKey.equals("true")) {
                    boolean permissionGranted;
                    String moduleName = ObjectNameHelper.getMBeanType(name);
                    if (moduleName == null) {
                        moduleName = name.toString();
                    }
                    if (permissionGranted = this.isGrantedMinimumRole(aa, moduleName, moduleName, sb.toString())) {
                        return null;
                    }
                    throw new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{operationName, moduleName}, "Access denied for the {0} operation on {1} MBean"));
                }
                resKey = (String)attrDesc.getFieldValue("resourceIdentifierKey");
                resType = (String)attrDesc.getFieldValue("resourceType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "From attribute: resKey=" + resKey + ", resType=" + resType);
                }
            }
            catch (Exception ex) {}
        } else {
            try {
                MBeanOperationInfo[] opInfos = modelmbeanInfo.getOperations();
                MBeanOperationInfo opinfo = null;
                boolean match = false;
                for (int i = 0; i < opInfos.length; ++i) {
                    opinfo = opInfos[i];
                    match = true;
                    if (!opinfo.getName().equals(operationName)) {
                        match = false;
                        continue;
                    }
                    MBeanParameterInfo[] plist = opinfo.getSignature();
                    if (signature == null) {
                        if (plist.length > 0) {
                            match = false;
                            continue;
                        }
                    } else if (signature.length != plist.length) {
                        match = false;
                        continue;
                    }
                    for (int j = 0; j < plist.length; ++j) {
                        if (signature[j].equals(plist[j].getType())) continue;
                        match = false;
                    }
                    if (match) break;
                }
                if (match) {
                    String ss;
                    Descriptor odesc = ((ModelMBeanOperationInfo)opinfo).getDescriptor();
                    resKey = (String)odesc.getFieldValue("excludeAccessCheck");
                    if (resKey != null && resKey.equals("true")) {
                        return null;
                    }
                    resKey = (String)odesc.getFieldValue("minimalAccessCheck");
                    if (resKey != null && resKey.equals("true")) {
                        boolean permissionGranted;
                        String moduleName = ObjectNameHelper.getMBeanType(name);
                        if (moduleName == null) {
                            moduleName = name.toString();
                        }
                        if (permissionGranted = this.isGrantedMinimumRole(aa, moduleName, moduleName, sb.toString())) {
                            return null;
                        }
                        throw new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{operationName, moduleName}, "Access denied for the {0} operation on {1} MBean"));
                    }
                    resKey = (String)odesc.getFieldValue("resourceIdentifierKey");
                    resType = (String)odesc.getFieldValue("resourceType");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "From operation: resKey=" + resKey + ", resType=" + resType);
                    }
                    runAs = (String)odesc.getFieldValue("runAs");
                    if (resKey == null && (ss = (String)odesc.getFieldValue("paramResourceTypes")) != null) {
                        StringTokenizer st = new StringTokenizer(ss, ":");
                        int count = st.countTokens();
                        resource_names = new String[count];
                        resource_types = new String[count];
                        int j = 0;
                        while (st.hasMoreTokens()) {
                            String s = st.nextToken();
                            String t1 = s.substring(0, s.indexOf(59));
                            String t2 = s.substring(s.indexOf(59) + 1);
                            int ii = Integer.parseInt(t1);
                            if (!(params[ii] instanceof String)) {
                                Tr.warning(tc, "Operation " + operationName + "'s parameter " + ii + " is not String type, thus cannot be used for resource identifier");
                                resource_names = null;
                                resource_types = null;
                                break;
                            }
                            resource_names[j] = (String)params[ii];
                            resource_types[j] = t2;
                            ++j;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "From parameter(s):", new Object[]{resource_names, resource_types});
                        }
                    }
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.preInvoke(operation)", (String)"1832", (Object)name);
            }
        }
        if (resKey == null && resource_names == null) {
            try {
                resKey = (String)mbeanDesc.getFieldValue("excludeAccessCheck");
                if (resKey != null && resKey.equals("true")) {
                    return null;
                }
                resKey = (String)mbeanDesc.getFieldValue("minimalAccessCheck");
                if (resKey != null && resKey.equals("true")) {
                    boolean permissionGranted;
                    String moduleName = ObjectNameHelper.getMBeanType(name);
                    if (moduleName == null) {
                        moduleName = name.toString();
                    }
                    if (permissionGranted = this.isGrantedMinimumRole(aa, moduleName, moduleName, sb.toString())) {
                        return null;
                    }
                    throw new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{operationName, moduleName}, "Access denied for the {0} operation on {1} MBean"));
                }
                resKey = (String)mbeanDesc.getFieldValue("resourceIdentifierKey");
                resType = (String)mbeanDesc.getFieldValue("resourceType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "From MBean: resKey=" + resKey + ", resType=" + resType);
                }
                if (runAs == null) {
                    runAs = (String)mbeanDesc.getFieldValue("runAs");
                }
            }
            catch (RoleBasedAppException ex) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "preInvoke -  denied");
                }
                throw new JMRuntimeException(nls.getFormattedMessage("ADMN0022E", new Object[]{operationName, ObjectNameHelper.getMBeanType(name)}, "Access denied for the {0} operation on {1} MBean"));
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.preInvoke(operation)", (String)"1801", (Object)name);
                throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{name}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
            }
        }
        if (resKey == null && resource_names == null) {
            resKey = "node:process";
            resType = "Node:Server";
        }
        if (resource_names == null) {
            try {
                StringTokenizer stn = new StringTokenizer(resKey, ":");
                StringTokenizer stt = new StringTokenizer(resType, ":");
                int count = stn.countTokens();
                if (count != stt.countTokens()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Mismatched resource names/types: " + resKey + "/" + resType + ", changed to node:process/Node:Server");
                    }
                    stn = new StringTokenizer("node:process", ":");
                    stt = new StringTokenizer("Node:Server", ":");
                    count = 2;
                }
                resource_names = new String[count];
                resource_types = new String[count];
                int j = 0;
                while (stn.hasMoreTokens()) {
                    String s = stn.nextToken();
                    resource_names[j] = name.getKeyProperty(s);
                    ++j;
                }
                j = 0;
                while (stt.hasMoreTokens()) {
                    String s;
                    resource_types[j] = s = stt.nextToken();
                    ++j;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "For operation " + operationName + " of MBean " + name.getKeyProperty("type"));
            Tr.debug(tc, "Resource units' names:", resource_names);
            Tr.debug(tc, "Resource units' types:", resource_types);
        }
        try {
            boolean permissionGranted = aa.checkAccess(name, resource_names, resource_types, sb.toString());
            SecurityAuditingHelper.getInstance().logSecurityAuditForMBean(permissionGranted, name, operationName, (String)null, "preinvoke MBean", resource_names, resource_types);
            if (!permissionGranted) {
                throw new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{operationName, ObjectNameHelper.getMBeanType(name)}, "Access denied for the {0} operation on {1} MBean"));
            }
        }
        catch (RoleBasedAppException ex) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "preInvoke -  denied");
            }
            throw new JMRuntimeException(nls.getFormattedMessage("ADMN0022E", new Object[]{operationName, ObjectNameHelper.getMBeanType(name)}, "Access denied for the {0} operation on {1} MBean"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke - granted");
        }
        return runAs;
    }

    private void checkForOpDeprecation(ObjectName name, String operationName) throws InstanceNotFoundException, ReflectionException {
        String deprecated;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForOpDeprecation");
        }
        ModelMBeanOperationInfo opInfo = null;
        try {
            MBeanInfo mbInfo = this.getMBeanInfo(name);
            if (mbInfo instanceof ModelMBeanInfo) {
                opInfo = ((ModelMBeanInfo)((Object)mbInfo)).getOperation(operationName);
            }
        }
        catch (IntrospectionException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.checkForOpDeprecation", (String)"1360", (Object)name);
            throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{name}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
        }
        catch (MBeanException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.checkForOpDeprecation", (String)"1380", (Object)name);
            throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{name}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
        }
        if (opInfo != null && (deprecated = (String)opInfo.getDescriptor().getFieldValue("deprecated")) != null) {
            this.outputWarningAndFFDC("ADMN0037W", new Object[]{name.getKeyProperty("type"), operationName, deprecated}, "com.ibm.ws.management.AdminServiceImpl.checkForOpDeprecation", "1410");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForOpDeprecation");
        }
    }

    private ObjectName getLocalServerMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalServerMBean");
        }
        if (this.serverMBean == null) {
            if (this.controllerAdmin == null) {
                ObjectName serverQ = null;
                try {
                    serverQ = new ObjectName("WebSphere:type=Server,process=" + this.processName + ",*");
                }
                catch (MalformedObjectNameException x) {
                    // empty catch block
                }
                Set s = null;
                s = this._mbServer.queryNames(serverQ, null);
                if (!s.isEmpty()) {
                    Iterator i = s.iterator();
                    this.serverMBean = (ObjectName)i.next();
                }
            } else {
                try {
                    this.serverMBean = this.controllerAdmin.getServerMBean();
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getLocalServerMBean", (String)"1584");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error while getting server mbean name", ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalServerMBean", this.serverMBean);
        }
        return this.serverMBean;
    }

    private String connectorMsg(String source, String target, Exception exception) {
        return nls.getFormattedMessage("ADMN0034E", new Object[]{target, source, exception}, "ADMN0034E: Unable to obtain a valid admin client to connect process: \"{0}\" from process \"{1}\" due to exception: {2}");
    }

    public static PlatformUtils getPlatformUtils() {
        return platformUtils;
    }

    public void zOSInitComplete() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "zOSInitComplete");
            }
            this.checkAdminContext();
            if (AdminServiceFactoryInitializer.getPlatformHelper().isServantJvm()) {
                try {
                    this.controllerAdmin = com.ibm.ws.management.util.Utils.getControllerAdminService();
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "unable to connect to ControllerAminService", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zOSInitComplete");
        }
    }

    public boolean isZOSInitComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isZOSInitComplete");
        }
        this.checkAdminContext();
        boolean complete = false;
        if (AdminServiceFactoryInitializer.getPlatformHelper().isServantJvm() && this.controllerAdmin != null) {
            complete = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isZOSInitComplete", new Boolean(complete));
        }
        return complete;
    }

    public String transformConfigId(String old) {
        this.checkAdminContext();
        return old.replace('|', ':');
    }

    public String reverseTransformConfigId(String old) {
        this.checkAdminContext();
        return old.replace(':', '|');
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoaderFor");
        }
        this.checkAdminContext();
        if (name == null) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null.");
        }
        ClassLoader retVal = null;
        if (this.controllerAdmin == null) {
            RoutingGuide rg = new RoutingGuide(name, false);
            String rkey = rg.eligible() ? rg.getRoutingKey() : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "routing key is: ", rkey);
            }
            if (rkey == null) {
                retVal = this._mbServer.getClassLoaderFor(name);
            } else if (RoutingTable.getInstance().isRoutable(rkey)) {
                try {
                    AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                    retVal = client.getClassLoaderFor(name);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getClassLoaderFor", (String)"1968", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "connector problem occurs", ex);
                    }
                    throw new JMRuntimeException(this.connectorMsg(this.processName, rkey, ex));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                }
                retVal = this._mbServer.getClassLoaderFor(name);
            }
        } else {
            try {
                retVal = this.controllerAdmin.getClassLoaderFor(name);
            }
            catch (ConnectorException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getClassLoaderFor", (String)"1987");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error while doing controller getClassLoaderFor", ex);
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoaderFor");
        }
        return retVal;
    }

    public ClassLoader getClassLoader(ObjectName name) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoader");
        }
        this.checkAdminContext();
        if (name == null) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null.");
        }
        ClassLoader retVal = null;
        if (this.controllerAdmin == null) {
            RoutingGuide rg = new RoutingGuide(name, false);
            String rkey = rg.eligible() ? rg.getRoutingKey() : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "routing key is: ", rkey);
            }
            if (rkey == null) {
                retVal = this._mbServer.getClassLoader(name);
            } else if (RoutingTable.getInstance().isRoutable(rkey)) {
                try {
                    AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                    retVal = client.getClassLoader(name);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getClassLoader", (String)"1968", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "connector problem occurs", ex);
                    }
                    throw new JMRuntimeException(this.connectorMsg(this.processName, rkey, ex));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                }
                retVal = this._mbServer.getClassLoaderFor(name);
            }
        } else {
            try {
                retVal = this.controllerAdmin.getClassLoader(name);
            }
            catch (ConnectorException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getClassLoader", (String)"1987");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error while doing controller getClassLoader", ex);
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoader");
        }
        return retVal;
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        this.checkAdminContext();
        return this._mbServer.getClassLoaderRepository();
    }

    public String[] getDomains() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomains");
        }
        this.checkAdminContext();
        String[] retVal = this._mbServer.getDomains();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomains", retVal);
        }
        return retVal;
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance", name);
        }
        this.checkAdminContext();
        if (name == null) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null.");
        }
        ObjectInstance retVal = null;
        if (this.controllerAdmin == null) {
            RoutingGuide rg = new RoutingGuide(name, false);
            String rkey = rg.eligible() ? rg.getRoutingKey() : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "routing key is: ", rkey);
            }
            if (rkey == null) {
                retVal = this._mbServer.getObjectInstance(name);
            } else if (RoutingTable.getInstance().isRoutable(rkey)) {
                try {
                    AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                    retVal = client.getObjectInstance(name);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getObjectInstance", (String)"1999", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "connector problem occurs", ex);
                    }
                    throw new JMRuntimeException(this.connectorMsg(this.processName, rkey, ex));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                }
                retVal = this._mbServer.getObjectInstance(name);
            }
        } else {
            try {
                retVal = this.controllerAdmin.getObjectInstance(name);
            }
            catch (ConnectorException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.getObjectInstance", (String)"2018");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error while doing controller getObjectInstance", ex);
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance");
        }
        return retVal;
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{name, listener, filter, handback});
        }
        this.checkAdminContext();
        if (name == null) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null.");
        }
        if (!this.isRegistered(name)) {
            throw new InstanceNotFoundException("Could not find " + name);
        }
        if (this.controllerAdmin == null) {
            RoutingGuide rg = new RoutingGuide(name, false);
            String rkey = rg.eligible() ? rg.getRoutingKey() : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "routing key is: ", rkey);
            }
            if (rkey == null) {
                this._mbServer.addNotificationListener(name, listener, filter, handback);
            } else if (RoutingTable.getInstance().isRoutable(rkey)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remote isRegistered: " + rkey);
                    }
                    AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                    client.addNotificationListener(name, listener, filter, handback);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.addNotificationListener", (String)"2071", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "connector problem occurs", ex);
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                }
                this._mbServer.addNotificationListener(name, listener, filter, handback);
            }
        } else {
            try {
                this.controllerAdmin.addNotificationListener(name, listener, filter, handback);
            }
            catch (ConnectorException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.addNotificationListener", (String)"2088", (Object)name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error while doing controller addNotificationListener", ex);
                }
                throw new UndeclaredThrowableException(ex);
            }
            catch (InstanceNotFoundException e) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener");
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{name, listener});
        }
        this.checkAdminContext();
        if (!this.isRegistered(name)) {
            throw new InstanceNotFoundException("Could not find " + name);
        }
        if (this.controllerAdmin == null) {
            RoutingGuide rg = new RoutingGuide(name, false);
            String rkey = rg.eligible() ? rg.getRoutingKey() : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "routing key is: ", rkey);
            }
            if (rkey == null) {
                this._mbServer.removeNotificationListener(name, listener);
            } else if (RoutingTable.getInstance().isRoutable(rkey)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remote isRegistered: " + rkey);
                    }
                    AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                    client.removeNotificationListener(name, listener);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.removeNotificationListener", (String)"2127", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "connector problem occurs", ex);
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                }
                this._mbServer.removeNotificationListener(name, listener);
            }
        } else {
            try {
                this.controllerAdmin.removeNotificationListener(name, listener);
            }
            catch (ConnectorException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.removeNotificationListener", (String)"2143", (Object)name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error while doing controller removeNotificationListener", ex);
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{name, listener, filter, handback});
        }
        this.checkAdminContext();
        if (!this.isRegistered(name)) {
            throw new InstanceNotFoundException("Could not find " + name);
        }
        if (this.controllerAdmin == null) {
            RoutingGuide rg = new RoutingGuide(name, false);
            String rkey = rg.eligible() ? rg.getRoutingKey() : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "routing key is: ", rkey);
            }
            if (rkey == null) {
                this._mbServer.removeNotificationListener(name, listener, filter, handback);
            } else if (RoutingTable.getInstance().isRoutable(rkey)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remote isRegistered: " + rkey);
                    }
                    AdminClient client = RoutingTable.getInstance().getAdminClient(rkey);
                    client.removeNotificationListener(name, listener, filter, handback);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.removeNotificationListener", (String)"2184", (Object)name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "connector problem occurs", ex);
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The targeted MBean is not routeable, try the local MBeanServer", name);
                }
                this._mbServer.removeNotificationListener(name, listener, filter, handback);
            }
        } else {
            try {
                this.controllerAdmin.removeNotificationListener(name, listener, filter, handback);
            }
            catch (ConnectorException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.removeNotificationListener", (String)"2200", (Object)name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error while doing controller removeNotificationListener", ex);
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{name, listener, filter, handback});
        }
        this.checkAdminContext();
        if (!this.isRegistered(name)) {
            throw new InstanceNotFoundException("Could not find " + name);
        }
        this.localNotificationService.removeNotificationListener(name, listener, filter, handback);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    boolean isGrantedMinimumRole(AdminAuthorizer aa, String moduleName, String resourceName, String methodName) {
        if (aa == null) {
            return true;
        }
        String allowAuthenticatedUser = System.getProperty("com.ibm.websphere.management.AuthenticatedUserIsMonitor", null);
        if (allowAuthenticatedUser != null && allowAuthenticatedUser.equals("true")) {
            SecurityHelper.getHelper();
            return SecurityHelper.getReceivedSubject() != null;
        }
        return aa.isGrantedMinimumRolesForMBean(moduleName, resourceName, methodName);
    }

    public void checkAdminContext() {
        String contextUUID = AdminContext.peek();
        if (this.profileKey == contextUUID || this.profileKey != null && this.profileKey.equals(contextUUID) || contextUUID != null && contextUUID.equals(this.profileKey)) {
            return;
        }
        IllegalStateException ex = new IllegalStateException("AdminServiceImpl was created for admin subsystem " + this.profileKey + " but top of AdminContext stack  contains: " + contextUUID);
        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.AdminServiceImpl.checkAdminContext", (String)"3042", (Object)this);
        throw ex;
    }

    private Set reorderQueryResult(Set input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reorderQueryResult", input);
        }
        LinkedHashSet<ObjectName> output = null;
        if (input == null) {
            output = null;
        } else {
            output = new LinkedHashSet<ObjectName>();
            LinkedHashSet<ObjectName> otherSet = new LinkedHashSet<ObjectName>();
            for (ObjectName on : input) {
                String onNodeName = on.getKeyProperty("node");
                String onProcessName = on.getKeyProperty("process");
                if (onNodeName != null && onNodeName.equals(this.nodeName) && onProcessName != null && onProcessName.equals(this.processName)) {
                    output.add(on);
                    continue;
                }
                otherSet.add(on);
            }
            Iterator it1 = otherSet.iterator();
            while (it1.hasNext()) {
                output.add((ObjectName)it1.next());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reorderQueryResult", output);
        }
        return output;
    }

    static {
        tc = Tr.register(AdminServiceImpl.class, "Admin", resBundleName);
        platformUtils = null;
        if (PlatformHelperFactory.FORCE_DIST) {
            platformUtils = new DefaultPlatformUtils();
        } else if (AdminHelper.getPlatformHelper().isZOS()) {
            platformUtils = (PlatformUtils)ImplFactory.loadImplFromKey(PlatformUtils.class);
        }
    }

    private class RoutingGuide {
        ObjectName on;
        boolean allowPattern;
        boolean eligible = true;
        boolean includeSelf = false;
        String key = null;

        RoutingGuide(ObjectName on, boolean allowPattern) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RoutingGuide", new Object[]{on, new Boolean(allowPattern)});
            }
            this.on = on;
            this.allowPattern = allowPattern;
            if (on != null && on.getKeyProperty("type") != null && on.getKeyProperty("type").equals("AdminService")) {
                this.eligible = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not eligible for routing");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "RoutingGuide");
                }
                return;
            }
            if (on.isPropertyPattern() && !allowPattern) {
                this.eligible = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not eligible for routing");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "RoutingGuide");
                }
                return;
            }
            this.processRoutingKey();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "RoutingGuide");
            }
        }

        void processRoutingKey() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processRoutingKey");
            }
            String node = this.on.getKeyProperty("node");
            String process = this.on.getKeyProperty("process");
            if (AdminServiceImpl.this.adminType.equalsIgnoreCase("DeploymentManager")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cellmgr routing key handling");
                }
                if (node == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "no node property specified in ObjectName");
                    }
                    if (!this.on.isPropertyPattern()) {
                        this.key = null;
                        this.includeSelf = true;
                    } else {
                        this.key = "*";
                        if (process == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "no process property specified in ObjectName");
                            }
                            this.includeSelf = true;
                        } else if (process.equals(AdminServiceImpl.this.processName)) {
                            this.includeSelf = true;
                            this.key = null;
                        } else {
                            this.includeSelf = false;
                        }
                    }
                } else {
                    this.key = node;
                    if (process == null) {
                        this.includeSelf = false;
                        if (node.equals(AdminServiceImpl.this.nodeName)) {
                            this.includeSelf = true;
                        }
                    } else if (process.equals(AdminServiceImpl.this.processName) && node.equals(AdminServiceImpl.this.nodeName)) {
                        this.includeSelf = true;
                        this.key = null;
                    } else {
                        this.includeSelf = false;
                    }
                }
            } else if (AdminServiceImpl.this.adminType.equalsIgnoreCase("NodeAgent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeagent routing key handling");
                }
                if (process == null) {
                    if (this.on.isPropertyPattern()) {
                        this.key = "*";
                        this.includeSelf = true;
                    } else {
                        this.key = null;
                        this.includeSelf = true;
                    }
                } else {
                    this.key = process;
                    if (process.equals(AdminServiceImpl.this.processName)) {
                        this.includeSelf = true;
                        this.key = null;
                    } else {
                        this.includeSelf = false;
                    }
                }
            } else if (AdminServiceImpl.this.adminType.equalsIgnoreCase("AdminAgent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adminagent routing key handling");
                }
                if (process == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "process is null");
                    }
                    if (this.on.isPropertyPattern()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "is property pattern");
                        }
                        this.key = "*";
                        this.includeSelf = true;
                    } else {
                        this.key = null;
                        this.includeSelf = true;
                    }
                } else {
                    this.key = process;
                    if (process.equals(AdminServiceImpl.this.processName)) {
                        this.includeSelf = true;
                        this.key = null;
                    } else {
                        this.includeSelf = false;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processRoutingKey " + this.key);
            }
        }

        boolean eligible() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "eligible: " + this.eligible);
            }
            return this.eligible;
        }

        boolean includeSelf() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "includeSelf: " + this.includeSelf);
            }
            if (this.eligible()) {
                return this.includeSelf;
            }
            return false;
        }

        String getRoutingKey() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "routing key: " + this.key);
            }
            if (this.eligible()) {
                return this.key;
            }
            return null;
        }
    }
}

