/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.cbe;

import com.ibm.websphere.logging.cbe.WsEventFactoryHomeImpl;
import com.ibm.websphere.logging.cbe.WsTemplateEventFactoryHomeImpl;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;

public class EventFactoryHelper {
    private static final String svDefaultEventFactoryName = "com.ibm.ws.logging.cbe.DefaultEventFactory";
    private static final String svClassName = EventFactoryHelper.class.getName();
    private static EventFactoryHome svEventFactoryHome = null;
    private static EventFactoryHome svDefaultEventFactoryHome = null;
    private static Logger svLogger = null;

    private EventFactoryHelper() {
    }

    public static EventFactory getPlainEventFactory() {
        return EventFactoryImpl.getInstance();
    }

    public static EventFactory getDefaultEventFactory() {
        EventFactory factory = null;
        factory = EventFactoryHelper.getEventFactory(svDefaultEventFactoryHome, svDefaultEventFactoryName);
        return factory;
    }

    public static EventFactory getEventFactory(String eventFactoryName) {
        EventFactory eventFactory = null;
        if (eventFactoryName != null && (eventFactory = EventFactoryHelper.getEventFactory(svEventFactoryHome, eventFactoryName)) != null && eventFactory.getContentHandler() == null) {
            svEventFactoryHome.releaseEventFactory(eventFactoryName);
            eventFactory = null;
        }
        if (eventFactory == null) {
            eventFactory = EventFactoryHelper.getDefaultEventFactory();
        }
        return eventFactory;
    }

    private static EventFactory getEventFactory(final EventFactoryHome factoryHome, final String factoryName) {
        EventFactory eventFactory = null;
        if (factoryHome != null && factoryName != null) {
            try {
                eventFactory = (EventFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return factoryHome.getEventFactory(factoryName);
                    }
                });
            }
            catch (Throwable t) {
                svLogger.throwing(svClassName, "getEventFactory", t);
            }
        }
        return eventFactory;
    }

    static {
        svEventFactoryHome = new WsTemplateEventFactoryHomeImpl();
        svDefaultEventFactoryHome = new WsEventFactoryHomeImpl();
        svLogger = Logger.getLogger("com.ibm.ws.logging.cbe.EventFactoryHelper");
    }
}

