/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.TraceStateChangeListener;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.bootstrap.WsLogManager;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.logging.RecursionCounter;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.hyades.logging.events.cbe.EventFactory;

public class WsLogger
extends Logger
implements TraceStateChangeListener {
    private static Logger svLogger = null;
    private static final String CLASSNAME;
    private static final String RECURSION_COUNTER_NAME;
    private static int RECURSION_COUNTER_MAX;
    private static Vector svAsyncQueue;
    private static final String BUNDLENAME = "com.ibm.ejs.resources.RasMessages";
    private String ivCachedResourceBundleName = null;
    private ResourceBundle ivCachedResourceBundle = null;
    private HashMap ivExtensions = new HashMap();
    private String ivComponent;
    private String ivOrganization;
    private String ivProduct;
    private int ivMinimumLocalizationLevelIntValue = Level.ALL.intValue();
    private Level ivMinimumLocalizationLevel = Level.ALL;
    private boolean ivComputeSourceClassAndMethodNames = false;
    private boolean ibAsync = false;
    private String ivGroupName;
    private TraceComponent ivTC;
    private EventFactory ivEventFactory = null;

    WsLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        if (resourceBundleName != null && !resourceBundleName.equals("")) {
            this.ivCachedResourceBundleName = resourceBundleName;
            this.ivCachedResourceBundle = this.getResourceBundle(resourceBundleName);
        }
        this.registerTraceComponent(name);
        this.ivComputeSourceClassAndMethodNames = "true".equalsIgnoreCase((String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.ws.logging.computeLoggingSource");
            }
        }));
    }

    public void setMinimumLocalizationLevel(Level level) {
        if (level == null) {
            return;
        }
        this.ivMinimumLocalizationLevel = level;
        this.ivMinimumLocalizationLevelIntValue = level.intValue();
    }

    public Level getMinimumLocalizationLevel() {
        return this.ivMinimumLocalizationLevel;
    }

    public void setComputeSourceClassAndMethodNames(boolean computeSource) {
        this.ivComputeSourceClassAndMethodNames = computeSource;
    }

    public boolean getComputeSourceClassAndMethodNames() {
        return this.ivComputeSourceClassAndMethodNames;
    }

    public void log(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        Filter f = this.getFilter();
        if (this.isLoggable(logRecord.getLevel()) && (f == null || f.isLoggable(logRecord))) {
            logRecord.getSourceClassName();
            this.deliverOrBuffer(logRecord);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverOrBuffer(LogRecord logRecord) {
        if (this.ibAsync) {
            WsLogger.queueAsyncEvent(logRecord);
        } else {
            boolean okToLog = RecursionCounter.incrementCount(RECURSION_COUNTER_NAME, RECURSION_COUNTER_MAX);
            try {
                if (okToLog) {
                    super.log(logRecord);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
                throw throwable;
            }
            RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
            this.dispatchAsyncEvents();
        }
    }

    private LogRecord createLogRecord(Level level, String msg, Object[] params, String sourceClassName, String sourceMethodName, String resourceBundleName, Throwable thrown) {
        String loggerName;
        WsLogRecord wsLogRecord;
        ResourceBundle resourceBundle = null;
        if (level.intValue() >= this.ivMinimumLocalizationLevelIntValue) {
            if (resourceBundleName == null) {
                resourceBundleName = this.computeResourceBundleName();
            }
            if (resourceBundleName != null) {
                resourceBundle = resourceBundleName.equals(this.ivCachedResourceBundleName) ? this.ivCachedResourceBundle : this.getResourceBundle(resourceBundleName);
            }
        }
        if ((wsLogRecord = WsLogRecordFactory.createWsLogRecord(this.ivEventFactory, level, msg, params, sourceClassName, sourceMethodName, resourceBundleName, resourceBundle, thrown, this.ivOrganization, this.ivProduct, this.ivComponent, this.ivExtensions, this.ivMinimumLocalizationLevelIntValue, loggerName = this.getName())) == null) {
            return null;
        }
        return wsLogRecord.getImpl();
    }

    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            LogRecord logRecord;
            if (this.ivComputeSourceClassAndMethodNames) {
                StackTraceElement element = this.getCallerFromStack();
                logRecord = this.createLogRecord(level, msg, null, element.getClassName(), element.getMethodName(), null, null);
            } else {
                logRecord = this.createLogRecord(level, msg, null, null, null, null, null);
            }
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void log(Level level, String msg, Object param1) {
        if (this.isLoggable(level)) {
            LogRecord logRecord;
            Object[] params = new Object[]{param1};
            if (this.ivComputeSourceClassAndMethodNames) {
                StackTraceElement element = this.getCallerFromStack();
                logRecord = this.createLogRecord(level, msg, params, element.getClassName(), element.getMethodName(), null, null);
            } else {
                logRecord = this.createLogRecord(level, msg, params, null, null, null, null);
            }
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void log(Level level, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord logRecord;
            if (this.ivComputeSourceClassAndMethodNames) {
                StackTraceElement element = this.getCallerFromStack();
                logRecord = this.createLogRecord(level, msg, params, element.getClassName(), element.getMethodName(), null, null);
            } else {
                logRecord = this.createLogRecord(level, msg, params, null, null, null, null);
            }
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord logRecord;
            if (this.ivComputeSourceClassAndMethodNames) {
                StackTraceElement element = this.getCallerFromStack();
                logRecord = this.createLogRecord(level, msg, null, element.getClassName(), element.getMethodName(), null, thrown);
            } else {
                logRecord = this.createLogRecord(level, msg, null, null, null, null, thrown);
            }
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, null, sourceClass, sourceMethod, null, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (this.isLoggable(level)) {
            Object[] params = new Object[]{param1};
            LogRecord logRecord = this.createLogRecord(level, msg, params, sourceClass, sourceMethod, null, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, params, sourceClass, sourceMethod, null, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, null, sourceClass, sourceMethod, null, thrown);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, null, sourceClass, sourceMethod, bundleName, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (this.isLoggable(level)) {
            Object[] params = new Object[]{param1};
            LogRecord logRecord = this.createLogRecord(level, msg, params, sourceClass, sourceMethod, bundleName, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, params, sourceClass, sourceMethod, bundleName, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, null, sourceClass, sourceMethod, bundleName, thrown);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (this.isLoggable(Level.FINER)) {
            Object[] params = new Object[]{param1};
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", params);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (this.isLoggable(Level.FINER)) {
            String msg = "ENTRY";
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    msg = msg + " {" + i + "}";
                }
            }
            this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (this.isLoggable(Level.FINER)) {
            Object[] params = new Object[]{result};
            this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", params);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.isLoggable(Level.FINER)) {
            LogRecord logRecord = this.createLogRecord(Level.FINER, "THROW", null, sourceClass, sourceMethod, null, thrown);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void severe(String msg) {
        if (this.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, msg);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void warning(String msg) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, msg);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void info(String msg) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, msg);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    private StackTraceElement getCallerFromStack() {
        try {
            StackTraceElement[] elements = Thread.currentThread().getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                if (!CLASSNAME.equals(elements[i].getClassName())) continue;
                ++i;
                while (i < elements.length) {
                    if (!CLASSNAME.equals(elements[i].getClassName())) {
                        return elements[i];
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void config(String msg) {
        if (this.isLoggable(Level.CONFIG)) {
            this.log(Level.CONFIG, msg);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void fine(String msg) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, msg);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void finer(String msg) {
        if (this.isLoggable(Level.FINER)) {
            this.log(Level.FINER, msg);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void finest(String msg) {
        if (this.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, msg);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    private static synchronized void queueAsyncEvent(LogRecord event2) {
        if (svAsyncQueue == null) {
            svAsyncQueue = new Vector();
        }
        if (svAsyncQueue.size() < 50) {
            svAsyncQueue.addElement(event2);
        }
    }

    private synchronized void dispatchAsyncEvents() {
        if (svAsyncQueue == null) {
            return;
        }
        Vector v = svAsyncQueue;
        svAsyncQueue = null;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            LogRecord event2 = (LogRecord)v.elementAt(i);
            super.log(event2);
        }
    }

    private ResourceBundle getResourceBundle(String resourceBundleName) {
        ResourceBundle resourceBundle = null;
        try {
            return TraceNLS.getResourceBundle(resourceBundleName, Locale.getDefault());
        }
        catch (RuntimeException ex) {
            try {
                for (Logger parent = this; null == resourceBundle && null != parent; parent = parent.getParent()) {
                    resourceBundle = parent.getResourceBundle();
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return resourceBundle;
        }
    }

    private String computeResourceBundleName() {
        for (Logger logger = this; logger != null; logger = logger.getParent()) {
            String name = logger.getResourceBundleName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    String getGroupName() {
        return this.ivGroupName;
    }

    private void registerTraceComponent(String name) {
        if (name != null && name.length() > 0) {
            this.ivTC = Tr.register(name);
            this.ivTC.setLoggerForCallback(this);
            if (!WsLogManager.isConfigureByLoggingProperties()) {
                this.traceStateChanged();
            }
        }
    }

    public void traceStateChanged() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WsLogger.this.setLevel(WsLevel.LEVELS[LevelConstants.DISTINCT_LEVELS[WsLogger.this.ivTC.getLevel()]]);
                return null;
            }
        });
    }

    public void addToGroup(String groupName) {
        Tr.register(this.getName(), groupName);
    }

    public EventFactory getEventFactory() {
        return this.ivEventFactory;
    }

    public void setEventFactory(EventFactory eventFactory) {
        this.ivEventFactory = eventFactory;
    }

    public String getExtension(String name) {
        Object o = this.ivExtensions.get(name);
        return o == null ? null : o.toString();
    }

    public Map getExtensions() {
        return this.ivExtensions;
    }

    private boolean isValidExtensionName(String name) {
        return !CBEHelper.getReservedExtenionNames().contains(name);
    }

    public void addExtension(String name, String value) {
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.entering(CLASSNAME, "addExtension", new Object[]{name, value});
        }
        if (!this.isValidExtensionName(name)) {
            String msg = TraceNLS.getFormattedMessage(BUNDLENAME, "EXCEPTION_RESERVED_EXTENSION", new Object[]{name}, "The extension name ''{0}'' is reserved");
            throw new IllegalArgumentException(msg);
        }
        HashMap oldExtensions = this.ivExtensions;
        HashMap<String, String> newExtensions = new HashMap<String, String>(oldExtensions);
        newExtensions.put(name, value);
        this.ivExtensions = newExtensions;
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.exiting(CLASSNAME, "addExtension");
        }
    }

    public void addExtensions(Map extensions) {
        if (extensions == null) {
            return;
        }
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.entering(CLASSNAME, "addExtensions");
        }
        HashMap oldExtensions = this.ivExtensions;
        HashMap<String, String> newExtensions = new HashMap<String, String>(oldExtensions);
        for (Map.Entry entry : extensions.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!this.isValidExtensionName(key)) {
                String msg = TraceNLS.getFormattedMessage(BUNDLENAME, "EXCEPTION_RESERVED_EXTENSION", new Object[]{key}, "The extension name ''{0}'' is reserved");
                throw new IllegalArgumentException(msg);
            }
            newExtensions.put(key, value);
        }
        this.ivExtensions = newExtensions;
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.exiting(CLASSNAME, "addExtensions");
        }
    }

    public void removeExtension(String name) {
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.entering(CLASSNAME, "removeExtension");
        }
        HashMap oldExtensions = this.ivExtensions;
        HashMap newExtensions = new HashMap(oldExtensions);
        newExtensions.remove(name);
        this.ivExtensions = newExtensions;
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.exiting(CLASSNAME, "removeExtension");
        }
    }

    public void clearExtensions() {
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.entering(CLASSNAME, "clearExtensions");
        }
        this.ivExtensions = new HashMap();
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.exiting(CLASSNAME, "clearExtensions");
        }
    }

    public String getComponent() {
        return this.ivComponent;
    }

    public String getOrganization() {
        return this.ivOrganization;
    }

    public String getProduct() {
        return this.ivProduct;
    }

    public void setComponent(String component2) {
        this.ivComponent = component2;
    }

    public void setOrganization(String organization) {
        this.ivOrganization = organization;
    }

    public void setProduct(String product2) {
        this.ivProduct = product2;
    }

    public boolean isAsync() {
        return this.ibAsync;
    }

    public void setAsync(boolean async) {
        this.ibAsync = async;
    }

    static {
        RECURSION_COUNTER_NAME = CLASSNAME = WsLogger.class.getName();
        RECURSION_COUNTER_MAX = 5;
        svAsyncQueue = null;
        try {
            svLogger = Logger.getLogger("com.ibm.ws.logging.WsLogger", BUNDLENAME);
        }
        catch (MissingResourceException e) {
            svLogger = Logger.getLogger("com.ibm.ws.logging.WsLogger");
            svLogger.throwing(CLASSNAME, "static init", e);
            svLogger.warning("Unable to locate com.ibm.ejs.resources.RasMessages resource bundle.  WsLogger messages will not be localized");
        }
        LoggerHelper.setAttributes(svLogger, "IBM", "WebSphere", "RAS", WsLevel.DETAIL);
    }
}

