/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.FormatSet;
import com.ibm.ws.logging.FormattedMessageAndStackTrace;
import com.ibm.ws.logging.cbe.CBEFormatHelper;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class TraceLogFormatter
extends Formatter {
    private static final int svBasicFormatMaxNameLength = 13;
    private static final String svBasicPadding = "                                 ";
    private static final String svAdvancedPadding = "          ";
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String nullParamString = "null";
    private static final String badParamString = "<malformed parameter>";
    private static final String svLineSeparatorPlusBasicPadding = lineSeparator + "                                 ";
    private static final String svLineSeparatorPlusBasicPaddingPlusNullParamString = svLineSeparatorPlusBasicPadding + "null";
    private static final String svLineSeparatorPlusAdvancedPadding = lineSeparator + "          ";
    private static final String svEmptyString = "";
    private static final String svEmptyStringReplacement = "\"\"";
    public static final int UNUSED_PARM_HANDLING_DISCARD = 0;
    public static final int UNUSED_PARM_HANDLING_APPEND_WITH_SPACES = 1;
    public static final int UNUSED_PARM_HANDLING_APPEND_WITH_NEWLINE = 2;
    public static final int UNUSED_PARM_HANDLING_APPEND_WITH_PARM_LABELS = 3;
    public static final int UNUSED_PARM_HANDLING_APPEND_WITH_SEMICOLON_AND_COMMAS = 4;

    public String format(LogRecord record) {
        return null;
    }

    private static void formatTimeAndThread(LogRecord logRecord, StringBuffer buffer) {
        buffer.setLength(0);
        FormatSet fs = FormatSet.getFormatSet();
        buffer.append('[');
        long millis = 0L;
        try {
            final LogRecord tempLogRecord = logRecord;
            millis = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return new Long(tempLogRecord.getMillis());
                }
            });
        }
        catch (PrivilegedActionException e) {
            // empty catch block
        }
        fs.ivDate.setTime(millis);
        FormatSet.svFormatter.format(fs.ivDate, buffer, fs.ivFieldPos);
        FormatSet.returnFormatSet(fs);
        buffer.append("] ");
        buffer.append(RasHelper.getThreadId(logRecord));
        buffer.append(' ');
    }

    private static String mapLevelToType(LogRecord logRecord) {
        Level l = logRecord.getLevel();
        if (l == WsLevel.FATAL) {
            return " F ";
        }
        if (l == Level.SEVERE) {
            return " E ";
        }
        if (l == Level.WARNING) {
            return " W ";
        }
        if (l == WsLevel.AUDIT) {
            return " A ";
        }
        if (l == Level.INFO) {
            return " I ";
        }
        if (l == Level.CONFIG) {
            return " C ";
        }
        if (l == WsLevel.DETAIL) {
            return " D ";
        }
        if (l == Level.FINE) {
            String s = logRecord.getLoggerName();
            if (s != null) {
                if (s.equals("SystemOut")) {
                    return " O ";
                }
                if (s.equals("SystemErr")) {
                    return " R ";
                }
            }
            return " 1 ";
        }
        if (l == Level.FINER) {
            String message = logRecord.getMessage();
            if (message != null) {
                if (message.indexOf("Entry") != -1 || message.indexOf("ENTRY") != -1) {
                    return " > ";
                }
                if (message.indexOf("Exit") != -1 || message.indexOf("RETURN") != -1) {
                    return " < ";
                }
            }
            return " 2 ";
        }
        if (l == Level.FINEST) {
            return " 3 ";
        }
        return " Z ";
    }

    static void formatHeaderBasic(LogRecord logRecord, StringBuffer buffer) {
        int tmpLen;
        int index;
        TraceLogFormatter.formatTimeAndThread(logRecord, buffer);
        String name = logRecord.getLoggerName();
        if (name == null) {
            name = svEmptyString;
        }
        name = (index = name.lastIndexOf(46) + 1) + 13 >= name.length() ? name.substring(index) : name.substring(index, index + 13);
        buffer.append(name);
        for (int i = tmpLen = 13 - name.length(); i > 0; --i) {
            buffer.append(' ');
        }
        buffer.append(TraceLogFormatter.mapLevelToType(logRecord));
        String classname = logRecord.getSourceClassName();
        String methodname = logRecord.getSourceMethodName();
        if (classname != null) {
            buffer.append(classname);
        }
        buffer.append(' ');
        if (methodname != null) {
            buffer.append(methodname);
        }
        buffer.append(' ');
    }

    static void formatHeaderAdvanced(LogRecord logRecord, StringBuffer buffer) {
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
        TraceLogFormatter.formatTimeAndThread(logRecord, buffer);
        buffer.append(TraceLogFormatter.mapLevelToType(logRecord));
        buffer.append("UOW=");
        if (wsLogRecord != null) {
            buffer.append(wsLogRecord.getCorrelationId());
        }
        buffer.append(" source=");
        buffer.append(logRecord.getLoggerName());
        String x = logRecord.getSourceClassName();
        if (x != null) {
            buffer.append(" class=");
            buffer.append(x);
        }
        if ((x = logRecord.getSourceMethodName()) != null) {
            buffer.append(" method=");
            buffer.append(x);
        }
        if (wsLogRecord != null) {
            buffer.append(" org=");
            buffer.append(wsLogRecord.getOrganization());
            buffer.append(" prod=");
            buffer.append(wsLogRecord.getProduct());
            buffer.append(" component=");
            buffer.append(wsLogRecord.getComponent());
            x = wsLogRecord.getReporterOrSourceThreadName();
            if (x != null) {
                buffer.append(" thread=[");
                buffer.append(x);
                buffer.append("]");
            }
        }
    }

    public static String formatMessage(LogRecord logRecord, Locale locale, int unusedParmHandling) {
        return TraceLogFormatter.getFormattedMessage(logRecord, locale, unusedParmHandling);
    }

    public static String formatMessageLR(LogRecord logRecord, Locale locale, int unusedParmHandling) {
        return TraceLogFormatter.formatLocalized(logRecord, null);
    }

    public static String formatMessageWSLR(WsLogRecord wsLogRecord, Locale locale, int unusedParmHandling) {
        String previousMessageLocale;
        if (wsLogRecord.getLocalizable() == 2) {
            String traceString = wsLogRecord.getMessage();
            Object[] parms = wsLogRecord.getParameters();
            return TraceLogFormatter.formatUnlocalized(traceString, parms, unusedParmHandling);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((previousMessageLocale = wsLogRecord.getMessageLocale()) != null) {
            String previousFormattedMessage;
            String currentMessageLocale = locale.toString();
            String previousLanguage = previousMessageLocale.substring(0, 2);
            String currentLanguage = locale.getLanguage();
            if ((previousMessageLocale.equals(currentMessageLocale) || previousLanguage.equals(currentLanguage)) && (previousFormattedMessage = wsLogRecord.getFormattedMessage()) != null) {
                return previousFormattedMessage;
            }
        }
        String formattedMessage = TraceLogFormatter.formatLocalized(wsLogRecord.getImpl(), null);
        if (wsLogRecord != null) {
            wsLogRecord.setMessageLocale(locale.toString());
            wsLogRecord.setFormattedMessage(formattedMessage);
        }
        return formattedMessage;
    }

    public static String formatMessageCBELR(CommonBaseEventLogRecord cbeLogRecord, Locale locale, int unusedParmHandling) {
        CommonBaseEvent cbe = cbeLogRecord.getCommonBaseEvent();
        if (CBEHelper.requiresNoLocalization(cbe)) {
            String traceString = cbe.getMsg();
            if (traceString == null) {
                traceString = cbeLogRecord.getMessage();
            }
            Object[] parms = cbeLogRecord.getParameters();
            return TraceLogFormatter.formatUnlocalized(traceString, parms, unusedParmHandling);
        }
        CBEFormatHelper cbeFormatHelper = new CBEFormatHelper();
        return cbeFormatHelper.getFormattedMessage(cbe, cbeLogRecord.getResourceBundle(), cbeLogRecord.getResourceBundleName(), locale);
    }

    public static String formatBasic(LogRecord logRecord) {
        StringBuffer buffer = new StringBuffer();
        TraceLogFormatter.formatHeaderBasic(logRecord, buffer);
        FormattedMessageAndStackTrace fmst = TraceLogFormatter.getFormattedMessageAndStackTrace(logRecord, null, 2);
        String formattedMessage = fmst.formattedMessage;
        String stackTrace = fmst.stackTrace;
        buffer.append(formattedMessage);
        if (stackTrace != null) {
            buffer.append(svLineSeparatorPlusBasicPadding);
            buffer.append(stackTrace);
        }
        return new String(buffer);
    }

    public static String formatAdvanced(LogRecord logRecord) {
        StringBuffer buffer = new StringBuffer();
        TraceLogFormatter.formatHeaderAdvanced(logRecord, buffer);
        buffer.append(lineSeparator);
        buffer.append(svAdvancedPadding);
        FormattedMessageAndStackTrace fmst = TraceLogFormatter.getFormattedMessageAndStackTrace(logRecord, null, 3);
        String formattedMessage = fmst.formattedMessage;
        String stackTrace = fmst.stackTrace;
        buffer.append(formattedMessage);
        if (stackTrace != null) {
            buffer.append(svLineSeparatorPlusAdvancedPadding);
            buffer.append(stackTrace);
        }
        return new String(buffer);
    }

    public static String formatCBEXML101(CommonBaseEvent cbe, ResourceBundle resourceBundle, String resourceBundleName, Locale locale) {
        if (cbe == null) {
            return null;
        }
        CBEFormatHelper cbeFormatHelper = new CBEFormatHelper();
        cbeFormatHelper.localize(cbe, resourceBundle, resourceBundleName, locale);
        return ((ISerializableAsXml)((Object)cbe)).externalizeCanonicalXmlString();
    }

    public static Object[] convertParameters(Object[] parms) {
        if (parms == null) {
            return null;
        }
        if (parms.length == 0) {
            return parms;
        }
        Object[] newParms = new Object[parms.length];
        for (int i = 0; i < parms.length; ++i) {
            newParms[i] = parms[i] instanceof String && ((String)parms[i]).equals(svEmptyString) ? svEmptyStringReplacement : parms[i];
        }
        return newParms;
    }

    private static String formatUnlocalized(String traceString, Object[] parms, int unusedParmHandling) {
        if (unusedParmHandling == 0) {
            return traceString;
        }
        Object[] newParms = TraceLogFormatter.convertParameters(parms);
        if (newParms == null) {
            return traceString;
        }
        String formattedTrace = traceString.indexOf(123) >= 0 ? TraceNLS.getFormattedMessageFromLocalizedMessage(traceString, newParms, true) : traceString;
        if (formattedTrace.equals(traceString)) {
            return TraceLogFormatter.appendUnusedParms(traceString, newParms, unusedParmHandling);
        }
        return formattedTrace;
    }

    private static String formatLocalized(LogRecord logRecord, Locale locale) {
        Object[] parms;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String localizedMessage = null;
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        String resourceBundleName = logRecord.getResourceBundleName();
        if (resourceBundleName != null) {
            String defaultMessage = logRecord.getMessage();
            String messageKey = defaultMessage.replace(' ', '.');
            localizedMessage = TraceNLS.getStringFromBundle(resourceBundle, resourceBundleName, messageKey, locale, defaultMessage);
        }
        if (localizedMessage == null) {
            localizedMessage = logRecord.getMessage();
        }
        if (localizedMessage == null) {
            localizedMessage = "<Null Message>";
        }
        String formattedMessage = localizedMessage.indexOf(123) >= 0 ? ((parms = TraceLogFormatter.convertParameters(logRecord.getParameters())) == null ? localizedMessage : TraceNLS.getFormattedMessageFromLocalizedMessage(localizedMessage, parms, true)) : localizedMessage;
        return formattedMessage;
    }

    private static String appendUnusedParms(String message, Object[] args, int unusedParmHandling) {
        String returnValue = message;
        switch (unusedParmHandling) {
            case 2: {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) {
                        buffer.append(svLineSeparatorPlusBasicPaddingPlusNullParamString);
                        continue;
                    }
                    buffer.append(svLineSeparatorPlusBasicPadding);
                    buffer.append(args[i].toString());
                }
                returnValue = returnValue.concat(buffer.toString());
                break;
            }
            case 3: {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < args.length; ++i) {
                    buffer.append(" parm");
                    buffer.append(i);
                    buffer.append("=");
                    if (args[i] == null) {
                        buffer.append(nullParamString);
                        continue;
                    }
                    buffer.append(args[i].toString());
                }
                returnValue = returnValue.concat(buffer.toString());
                break;
            }
            case 1: {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < args.length; ++i) {
                    buffer.append(" ").append(args[i].toString());
                }
                returnValue = returnValue.concat(buffer.toString());
                break;
            }
            case 4: {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < args.length; ++i) {
                    if (i == 0) {
                        buffer.append("; ");
                    } else {
                        buffer.append(", ");
                    }
                    if (args[i] == null) {
                        buffer.append(nullParamString);
                        continue;
                    }
                    buffer.append(args[i].toString());
                }
                returnValue = returnValue.concat(buffer.toString());
                break;
            }
        }
        return returnValue;
    }

    private static FormattedMessageAndStackTrace getFormattedMessageAndStackTrace(LogRecord logRecord, Locale locale, int unusedParmHandling) {
        String formattedMessage = TraceLogFormatter.getFormattedMessage(logRecord, locale, unusedParmHandling);
        String stackTrace = TraceLogFormatter.getStackTrace(logRecord);
        return new FormattedMessageAndStackTrace(formattedMessage, stackTrace);
    }

    private static String getFormattedMessage(LogRecord logRecord, Locale locale, int unusedParmHandling) {
        WsLogRecord wsLogRecord;
        CommonBaseEvent cbe;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        CommonBaseEventLogRecord cbeLR = logRecord instanceof CommonBaseEventLogRecord ? (CommonBaseEventLogRecord)logRecord : null;
        CommonBaseEvent commonBaseEvent = cbe = cbeLR != null ? cbeLR.getCommonBaseEvent() : null;
        String formattedMessage = cbe != null ? TraceLogFormatter.formatMessageCBELR(cbeLR, locale, unusedParmHandling) : ((wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord)) != null ? TraceLogFormatter.formatMessageWSLR(wsLogRecord, locale, unusedParmHandling) : TraceLogFormatter.formatMessageLR(logRecord, locale, unusedParmHandling));
        return formattedMessage;
    }

    public static String getStackTrace(CommonBaseEventLogRecord logRecord) {
        String stackTrace;
        CommonBaseEvent cbe;
        CommonBaseEvent commonBaseEvent = cbe = logRecord != null ? logRecord.getCommonBaseEvent() : null;
        if (cbe == null) {
            WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
            stackTrace = TraceLogFormatter.getStackTrace(wsLogRecord);
        } else {
            stackTrace = CBEHelper.getFlatStackTrace(cbe);
            if (stackTrace == null) {
                stackTrace = CBEHelper.getStackTrace(cbe);
            }
        }
        return stackTrace;
    }

    public static String getStackTrace(WsLogRecord logRecord) {
        return logRecord.getStackTrace();
    }

    public static String getStackTrace(LogRecord logRecord) {
        Throwable t = logRecord.getThrown();
        String stackTrace = t == null ? null : RasHelper.throwableToString(t);
        return stackTrace;
    }
}

