/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext.ws;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspWebAppConfig;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.taglib.GlobalTagLibraryCache;
import com.ibm.ws.jsp.taglib.config.GlobalTagLibConfig;
import com.ibm.ws.jsp.webcontainerext.AbstractJSPExtensionFactory;
import com.ibm.ws.jsp.webcontainerext.ws.JSPClassloaderContextImpl;
import com.ibm.ws.jsp.webcontainerext.ws.WASJSPExtensionProcessor;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.service.LibraryMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webcontainer.webapp.WebAppImpl;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.File;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.runtime.JspFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASJSPExtensionFactory
extends AbstractJSPExtensionFactory {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.webcontainerext.ws.WASJSPExtensionFactory";

    @Override
    protected JspXmlExtConfig createConfig(IServletContext webapp) {
        JspWebAppConfig config = new JspWebAppConfig(webapp);
        this.createJspFactory();
        config.getJspOptions().setIsZOS(AdminHelper.getPlatformHelper().isZOS());
        return config;
    }

    private synchronized void createJspFactory() {
        if (JspFactory.getDefaultFactory() == null) {
            String value;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "createJspFactory", "getDefaultFactory() returned null; creating default factory.");
            }
            Properties webContainerProperties = WebContainer.getWebContainerProperties();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "createJspFactory", "webContainerProperties = " + webContainerProperties);
            }
            int bodyContentBufferSize = 512;
            if (webContainerProperties != null && (value = webContainerProperties.getProperty("bodycontentbuffsize")) != null) {
                try {
                    bodyContentBufferSize = Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "createJspFactory", "bodyContentBufferSize = " + bodyContentBufferSize);
            }
            JspFactoryImpl factory = new JspFactoryImpl(bodyContentBufferSize);
            if (System.getSecurityManager() != null) {
                String basePackage = "org.apache.jasper.";
                try {
                    factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                    factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                    factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary");
                    factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary$PrivilegedIntrospectHelper");
                    factory.getClass().getClassLoader().loadClass(basePackage + "runtime.ServletResponseWrapperInclude");
                }
                catch (ClassNotFoundException ex) {
                    System.out.println("Jasper JspRuntimeContext preload of class failed: " + ex.getMessage());
                }
            }
            JspFactory.setDefaultFactory(factory);
        }
    }

    @Override
    protected ExtensionProcessor createProcessor(IServletContext webapp, JspXmlExtConfig webAppConfig, JspClassloaderContext jspClassloaderContext) throws Exception {
        VariableMap vmap = (VariableMap)WsServiceRegistry.getService((Object)this, VariableMap.class);
        LibraryMgr libraryMgr = (LibraryMgr)WsServiceRegistry.getService((Object)this, LibraryMgr.class);
        WebAppImpl webApp = (WebAppImpl)webapp;
        ConfigObject moduleDeployment = webApp.getDeployedModule().getModuleDeploymentConfigObject();
        ConfigObject cl = moduleDeployment.getObject("classloader");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "createProcessor", "moduleDeployment: [" + moduleDeployment + "] classloader: [" + cl + "]");
        }
        ArrayList<String> jarList = new ArrayList<String>();
        if (cl != null) {
            List libraries = cl.getObjectList("libraries");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "createProcessor", "libraries: [" + libraries + "]");
            }
            for (ConfigObject lr : libraries) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "createProcessor", "ConfigObject lr: [" + lr + "]");
                }
                String[] paths = libraryMgr.getClassPaths(lr.getString("libraryName", "__null__"));
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "createProcessor", "paths: [" + paths + "]");
                }
                if (paths == null) continue;
                for (int i = 0; i < paths.length; ++i) {
                    if (paths[i].endsWith(".jar")) {
                        jarList.add(vmap.expand(paths[i]));
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue;
                        logger.logp(Level.FINER, CLASS_NAME, "createProcessor", "adding jar to jar list: " + vmap.expand(paths[i]));
                        continue;
                    }
                    try {
                        File appDir = new File(paths[i]);
                        if (!appDir.isDirectory()) continue;
                        ArrayList<String> dirList = this.getJarsFromDirectory(appDir);
                        jarList.addAll(dirList);
                        continue;
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue;
                        logger.logp(Level.FINER, CLASS_NAME, "createProcessor", "Exception Caught when trying to add jars to library", e);
                    }
                }
            }
        }
        String[] sharedLibraryJars = new String[jarList.size()];
        sharedLibraryJars = jarList.toArray(sharedLibraryJars);
        ExtensionProcessor extensionProcessor = null;
        if (webAppConfig.getJspOptions().getExtensionProcessorClass() != null) {
            if (System.getSecurityManager() != null) {
                final IServletContext finalWebapp = webapp;
                final JspXmlExtConfig finalWebAppConfig = webAppConfig;
                final JspClassloaderContext finalJspClassloaderContext = jspClassloaderContext;
                final String[] finalSharedLibraryJars = sharedLibraryJars;
                try {
                    extensionProcessor = (ExtensionProcessor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws JspCoreException {
                            ExtensionProcessor ep = null;
                            try {
                                Class<?> contextClass = Class.forName(finalWebAppConfig.getJspOptions().getExtensionProcessorClass(), true, finalWebapp.getClassLoader());
                                Constructor<?> constructor = contextClass.getConstructor(IServletContext.class, JspWebAppConfig.class, GlobalTagLibraryCache.class, JspClassloaderContext.class, AbstractJSPExtensionFactory.class, finalSharedLibraryJars.getClass());
                                ep = (ExtensionProcessor)constructor.newInstance(finalWebapp, finalWebAppConfig, WASJSPExtensionFactory.this.globalTagLibraryCache, finalJspClassloaderContext, this, finalSharedLibraryJars);
                            }
                            catch (Exception e) {
                                logger.logp(Level.SEVERE, "JSPExtensionFactory", "createExtensionProcessor", "Failed to load extension processor class: " + finalWebAppConfig.getJspOptions().getExtensionProcessorClass());
                                throw new JspCoreException("jsp.error.failed.load.extension.processor.class", new Object[]{finalWebAppConfig.getJspOptions().getExtensionProcessorClass()}, e);
                            }
                            return ep;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (JspCoreException)pae.getException();
                }
            } else {
                try {
                    Class<?> contextClass = Class.forName(webAppConfig.getJspOptions().getExtensionProcessorClass(), true, webapp.getClassLoader());
                    Constructor<?> constructor = contextClass.getConstructor(IServletContext.class, JspWebAppConfig.class, GlobalTagLibraryCache.class, JspClassloaderContext.class, AbstractJSPExtensionFactory.class, sharedLibraryJars.getClass());
                    extensionProcessor = (ExtensionProcessor)constructor.newInstance(webapp, webAppConfig, this.globalTagLibraryCache, jspClassloaderContext, this, sharedLibraryJars);
                }
                catch (Exception e) {
                    throw new JspCoreException("jsp.error.failed.load.extension.processor.class", new Object[]{webAppConfig.getJspOptions().getExtensionProcessorClass()}, e);
                }
            }
        } else {
            extensionProcessor = new WASJSPExtensionProcessor(webapp, webAppConfig, this.globalTagLibraryCache, jspClassloaderContext, sharedLibraryJars);
        }
        if (webAppConfig.getJspOptions().isUseInMemory()) {
            webAppConfig.getJspOptions().setTranslationContextClass("com.ibm.ws.jsp.inmemory.context.InMemoryJspTranslationContext");
            webAppConfig.getJspOptions().setExtensionProcessorClass("com.ibm.ws.jsp.webcontainerext.ws.WASJSPExtensionProcessor");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "createProcessor", "WASJSPExtensionFactory.createProcessor  webAppConfig.getJspOptions().getTranslationContextClass() [" + webAppConfig.getJspOptions().getTranslationContextClass() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "createProcessor", "WASJSPExtensionFactory.createProcessor  webAppConfig.getJspOptions().getExtensionProcessorClass() [" + webAppConfig.getJspOptions().getExtensionProcessorClass() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "createProcessor", "WASJSPExtensionFactory.createProcessor  extensionProcessor [" + extensionProcessor + "]");
            }
        }
        return extensionProcessor;
    }

    private ArrayList<String> getJarsFromDirectory(File appDir) {
        ArrayList<String> dirList = new ArrayList<String>();
        File[] files = appDir.listFiles();
        if (files != null) {
            int filesLength = files.length;
            for (int j = 0; j < filesLength; ++j) {
                String fileName = files[j].getName().toLowerCase();
                if (!fileName.endsWith(".jar") || dirList.contains(files[j].getPath())) continue;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getJarsFromDirectory", "adding path " + files[j].getPath());
                }
                dirList.add(files[j].getPath());
            }
        }
        return dirList;
    }

    @Override
    protected JspClassloaderContext createJspClassloaderContext(IServletContext webapp, JspXmlExtConfig webAppConfig) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "createJspClassloaderContext", "returning a new JSPClassloaderContextImpl(webapp.getClassLoader(), webAppConfig)");
        }
        return new JSPClassloaderContextImpl(webapp.getClassLoader(), webAppConfig);
    }

    public void addGlobalTagLibConfig(GlobalTagLibConfig globalTagLibConfig) {
        if (this.globalTagLibraryCache == null) {
            this.createGlobalTagLibraryCache();
        }
        this.globalTagLibraryCache.addGlobalTagLibConfig(globalTagLibConfig);
    }
}

