/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext.ws;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.tools.JspModC;
import com.ibm.ws.jsp.webcontainerext.ws.PrepareJspServletRequest;
import com.ibm.ws.jsp.webcontainerext.ws.PrepareJspServletResponse;
import com.ibm.ws.jsp.webcontainerext.ws.WASJSPExtensionProcessor;
import com.ibm.ws.jsp.webcontainerext.ws.WASJSPExtensionServletWrapper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.File;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PrepareJspHelper
implements Runnable {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.webcontainerext.PrepareJspHelper";
    WASJSPExtensionProcessor _jspExtProcessor = null;
    String appName = null;
    int _threads = 1;
    int _counter = 0;
    int _notify = 25;
    int _minLength = 0;
    int _startAt = 0;
    boolean shouldClassload = false;
    boolean onlyCLChanged = false;
    private Stack _files = new Stack();
    private Stack _parents = new Stack();
    WebApp webapp = null;
    JspOptions options = null;

    public PrepareJspHelper(WASJSPExtensionProcessor s, IServletContext webapp, JspOptions options) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "PrepareJspHelper", "enter");
        }
        this._jspExtProcessor = s;
        this.webapp = (WebApp)webapp;
        this.options = options;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "PrepareJspHelper", "exit");
        }
    }

    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "run", "enter");
        }
        String docRoot = null;
        Object threadParam = null;
        docRoot = this.webapp.getRealPath("/");
        this.appName = this.webapp.getWebAppName();
        this._minLength = this.options.getPrepareJSPs() * 1024;
        if (this.options.getPrepareJSPsClassloadChanged() != null) {
            this.onlyCLChanged = true;
            this._startAt = 0;
        } else {
            this._startAt = this.options.getPrepareJSPsClassload();
        }
        this._threads = this.options.getPrepareJSPThreadCount();
        logger.logp(Level.INFO, CLASS_NAME, "run", "PrepareJspHelper executing on application [" + this.appName + "]");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "run", "PrepareJspHelper: Document Root: " + docRoot);
            logger.logp(Level.FINE, CLASS_NAME, "run", "PrepareJspHelper: File size minimum (in bytes): " + this._minLength);
            logger.logp(Level.FINE, CLASS_NAME, "run", "PrepareJspHelper: Number of threads: " + this._threads);
            if (this.onlyCLChanged) {
                logger.logp(Level.FINE, CLASS_NAME, "run", "PrepareJspHelper: Only classloading out-of-date (changed) JSPs.");
            } else {
                logger.logp(Level.FINE, CLASS_NAME, "run", "PrepareJspHelper: Classloading JSPs starting at JSP number " + this._startAt);
            }
        }
        this._parents.push(new File(docRoot));
        try {
            int i;
            Thread[] threads = new Thread[this._threads];
            for (i = 0; i < this._threads; ++i) {
                PrepareJspHelperThread helper = new PrepareJspHelperThread(this, docRoot.length());
                threads[i] = new Thread((Runnable)helper, "PrepareJspHelperThread " + i);
                threads[i].setDaemon(true);
                threads[i].start();
            }
            for (i = 0; i < this._threads; ++i) {
                try {
                    threads[i].join();
                    continue;
                }
                catch (Throwable th) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "run", "Pretouch Thread died during execution.", th);
                }
            }
        }
        catch (Exception ex) {
            logger.logp(Level.WARNING, CLASS_NAME, "run", "Unexpected exception while running pretouch.", ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO)) {
            logger.logp(Level.INFO, CLASS_NAME, "run", "PrepareJspHelper in group [" + this.appName + "]: All " + this._counter + " jsp files have been processed.");
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "run", "< run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File getJsp() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "getJsp", "enter");
        }
        try {
            if (this._counter % this._notify == 0 && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO)) {
                logger.logp(Level.INFO, CLASS_NAME, "getJsp", "PrepareJspHelper in group [" + this.appName + "]: " + this._counter + " jsp files have been processed.");
            }
            if (!this._files.isEmpty()) {
                ++this._counter;
                if (this._counter >= this._startAt) {
                    this.shouldClassload = true;
                }
                File file = (File)this._files.pop();
                return file;
            }
            if (this._parents.isEmpty()) {
                File file = null;
                return file;
            }
            List extList = JspModC.buildJspFileExtensionList(Constants.STANDARD_JSP_EXTENSIONS, this._jspExtProcessor.getPatternList());
            String resourcePath = null;
            while (this._files.isEmpty() && !this._parents.isEmpty()) {
                File[] children = ((File)this._parents.pop()).listFiles();
                if (children == null) continue;
                for (int i = 0; i < children.length; ++i) {
                    resourcePath = children[i].getName().replace('\\', '/');
                    if (resourcePath.startsWith("/META-INF")) continue;
                    if (children[i].isDirectory()) {
                        this._parents.push(children[i]);
                        continue;
                    }
                    if (!children[i].isFile() || !this.isJspFile(children[i].getName(), extList)) continue;
                    this._files.push(children[i]);
                }
            }
            if (!this._files.isEmpty()) {
                ++this._counter;
                if (this._counter >= this._startAt) {
                    this.shouldClassload = true;
                }
                File file = (File)this._files.pop();
                return file;
            }
            File file = null;
            return file;
        }
        catch (Exception ex) {
            logger.logp(Level.WARNING, CLASS_NAME, "getJsp", "Pretouch ERROR: Unexpected exception retrieving jsp names", ex);
            File file = null;
            return file;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getJsp", "exit");
            }
        }
    }

    private boolean isJspFile(String resourcePath, List extensionFilter) {
        String ext = resourcePath.substring(resourcePath.lastIndexOf(".") + 1);
        return extensionFilter.contains(ext);
    }

    protected boolean compileJsp(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "compileJsp", "enter");
        }
        boolean rv = false;
        try {
            this._jspExtProcessor.handleRequest(httpservletrequest, httpservletresponse);
            rv = true;
        }
        catch (Exception _ex) {
            logger.logp(Level.WARNING, CLASS_NAME, "compileJsp", "PrepareJspHelper: Exception while compiling JSP with pretouch. JSP: [" + httpservletrequest.getServletPath() + "]", _ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "compileJsp", "exit: " + rv);
        }
        return rv;
    }

    private class PrepareJspHelperThread
    implements Runnable {
        private static final String CLASS_NAME2 = "com.ibm.ws.jsp.webcontainerext.PrepareJspHelperThread";
        PrepareJspHelper _helper;
        int _rootLength;
        String _id;

        public PrepareJspHelperThread(PrepareJspHelper helper, int rootLength) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "PrepareJspHelperThread", "enter");
            }
            this._helper = helper;
            this._rootLength = rootLength;
            try {
                this._id = Integer.toHexString(Thread.currentThread().hashCode());
            }
            catch (Exception ex) {
                this._id = "        ";
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "PrepareJspHelperThread", "exit");
            }
        }

        public void prepareJspReloadClass(ClassLoader targetClassloader, String config) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "prepareJspReloadClass", "enter, Config: " + config);
            }
            if (targetClassloader != null) {
                try {
                    targetClassloader.loadClass(config);
                }
                catch (Throwable th) {
                    logger.logp(Level.WARNING, CLASS_NAME2, "prepareJspReloadClass", "Error loading jsp class " + config + " during pretouch.", th);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "prepareJspReloadClass", "exit");
            }
        }

        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "run", "enter");
            }
            File _jsp = this._helper.getJsp();
            PrepareJspServletRequest preq = new PrepareJspServletRequest();
            PrepareJspServletResponse pres = new PrepareJspServletResponse();
            String relativePath = null;
            String config = null;
            while (_jsp != null) {
                if (_jsp.length() >= (long)this._helper._minLength) {
                    relativePath = _jsp.getAbsolutePath().substring(this._rootLength, _jsp.getAbsolutePath().length());
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME2, "run", "Processing jsp: " + relativePath);
                    }
                    relativePath = relativePath.replace('\\', '/');
                    preq.setServletPath(relativePath);
                    preq.setRequestURI(relativePath);
                    preq.setQueryString("jsp_precompile");
                    try {
                        IServletWrapper iServletWrapper;
                        if (PrepareJspHelper.this.compileJsp(preq, pres) && (iServletWrapper = this._helper._jspExtProcessor.findWrapper(preq, pres)) instanceof WASJSPExtensionServletWrapper) {
                            WASJSPExtensionServletWrapper jspServletWrapper = (WASJSPExtensionServletWrapper)iServletWrapper;
                            config = jspServletWrapper.getJspResources().getPackageName() + '.' + jspServletWrapper.getJspResources().getClassName();
                            if (this._helper.onlyCLChanged) {
                                if (jspServletWrapper.getJspResources().isOutdated()) {
                                    this.prepareJspReloadClass(jspServletWrapper.getTargetClassLoader(), config);
                                }
                            } else if (PrepareJspHelper.this.shouldClassload) {
                                this.prepareJspReloadClass(jspServletWrapper.getTargetClassLoader(), config);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.logp(Level.WARNING, CLASS_NAME2, "run", "Unexpected exception while processing jsp " + relativePath, e);
                    }
                }
                _jsp = this._helper.getJsp();
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME2, "run", "exit");
            }
        }
    }
}

