/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class JspDependent {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.webcontainerext.JspDependent";
    static Pattern delimeter = Pattern.compile("\\^");
    long lastModified = -1L;
    String dependentFilePath = null;
    JspTranslationContext context = null;
    private final String lineSep = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("line.separator");
        }
    });

    public JspDependent(String dependentFilePath, JspTranslationContext context) {
        this.context = context;
        String[] dependentItems = delimeter.split(dependentFilePath);
        if (dependentItems.length > 1) {
            this.dependentFilePath = dependentItems[0];
            Long ts = new Long(dependentItems[1]);
            this.lastModified = ts;
        }
    }

    public boolean isOutdated() {
        if (this.lastModified == -1L) {
            return true;
        }
        boolean outdated = false;
        File dependentFile = new File(this.context.getRealPath(this.dependentFilePath));
        if (dependentFile.lastModified() != this.lastModified) {
            outdated = true;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "dependentFile ts [" + dependentFile.lastModified() + "] differs from cached ts [" + this.lastModified + "]. Recompile JSP.");
                logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "dependentFile [" + dependentFile + "]");
            }
        }
        return outdated;
    }

    public long getTimestamp() {
        if (this.lastModified == -1L) {
            return 0L;
        }
        File dependentFile = new File(this.context.getRealPath(this.dependentFilePath));
        return dependentFile.lastModified();
    }

    public String getDependentFilePath() {
        return this.dependentFilePath;
    }

    public String toString() {
        return "JspDependent dependentFilePath = " + this.getDependentFilePath() + this.lineSep + "last modified = " + new Date(this.getTimestamp()) + this.lineSep + "is outDated = " + this.isOutdated();
    }
}

