/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext;

import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;

public class JSPExtensionClassLoader
extends URLClassLoader {
    private PermissionCollection permissionCollection = null;
    private CodeSource codeSource = null;
    private String className = null;
    private String packageName = null;
    private ClassLoader parent = null;
    private JspClassloaderContext jspClassloaderContext = null;

    public JSPExtensionClassLoader(URL[] urls, JspClassloaderContext jspClassloaderContext, String className, CodeSource codeSource, PermissionCollection permissionCollection) {
        super(urls, jspClassloaderContext.getClassLoader());
        this.jspClassloaderContext = jspClassloaderContext;
        this.permissionCollection = permissionCollection;
        this.codeSource = codeSource;
        this.className = className;
        this.parent = jspClassloaderContext.getClassLoader();
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (System.getSecurityManager() != null) {
            final String tmpName = name;
            final boolean tmpResolve = resolve;
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return JSPExtensionClassLoader.this._loadClass(tmpName, tmpResolve);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (ClassNotFoundException)pae.getException();
            }
        }
        return this._loadClass(name, resolve);
    }

    private Class _loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        int dot = name.lastIndexOf(46);
        if (System.getSecurityManager() != null && dot >= 0) {
            try {
                System.getSecurityManager().checkPackageAccess(name.substring(0, dot));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                throw new ClassNotFoundException(error);
            }
        }
        if (!(name.startsWith("_ibmjsp") || name.startsWith("com.ibm._jsp") || name.startsWith("org.apache.jsp") || name.startsWith("com.ibm.ws.jsp.tagfile"))) {
            clazz = this.parent.loadClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        String classFile = null;
        classFile = name.startsWith("com.ibm._jsp." + this.className) ? name.substring("com.ibm._jsp".length() + 1) + ".class" : (name.startsWith("org.apache.jsp." + this.className) ? name.substring("org.apache.jsp".length() + 1) + ".class" : name.replace('.', File.separatorChar) + ".class");
        byte[] cdata = this.loadClassDataFromFile(classFile);
        if (cdata != null) {
            if (System.getSecurityManager() != null) {
                ProtectionDomain pd = new ProtectionDomain(this.codeSource, this.permissionCollection);
                clazz = this.defClass(name, cdata, cdata.length, pd);
            } else {
                clazz = this.defClass(name, cdata, cdata.length, null);
            }
        } else if (this.parent != null) {
            clazz = this.parent.loadClass(classFile);
        }
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    private final Class defClass(String className, byte[] classData, int length, ProtectionDomain pd) {
        if (this.jspClassloaderContext.isPredefineClassEnabled()) {
            classData = this.jspClassloaderContext.predefineClass(className, classData);
        }
        if (pd != null) {
            return this.defineClass(className, classData, 0, classData.length, pd);
        }
        return this.defineClass(className, classData, 0, classData.length);
    }

    protected byte[] loadClassDataFromFile(String fileName) {
        byte[] classBytes = null;
        try {
            InputStream in = this.getResourceAsStream(fileName);
            if (in == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                baos.write(buf, 0, i);
            }
            in.close();
            baos.close();
            classBytes = baos.toByteArray();
        }
        catch (Exception ex) {
            return null;
        }
        return classBytes;
    }

    public URL getResource(String name) {
        URL resourceURL = this.findResource(name);
        if (resourceURL != null) {
            return resourceURL;
        }
        return this.parent.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL resourceURL = this.getResource(name);
            if (resourceURL == null) {
                return null;
            }
            return resourceURL.openStream();
        }
        catch (MalformedURLException malURL) {
            return null;
        }
        catch (IOException io) {
            return null;
        }
    }
}

