/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.taglib.GlobalTagLibraryCache;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractJSPExtensionFactory
implements ExtensionFactory {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.webcontainerext.JSPExtensionFactory";
    protected GlobalTagLibraryCache globalTagLibraryCache = null;
    private static final Object lock = new Object();

    public ExtensionProcessor createExtensionProcessor(IServletContext webapp) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, "JSPExtensionFactory", "createExtensionProcessor", "enter createExtensionProcessor()");
        }
        this.createGlobalTagLibraryCache();
        JspXmlExtConfig webAppConfig = this.createConfig(webapp);
        JspClassloaderContext jspClassloaderContext = this.createJspClassloaderContext(webapp, webAppConfig);
        ExtensionProcessor extensionProcessor = this.createProcessor(webapp, webAppConfig, jspClassloaderContext);
        return extensionProcessor;
    }

    public List getPatternList() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, "JSPExtensionFactory", "getPatternList", "enter getPatternList()");
        }
        ArrayList<String> extensionsSupported = new ArrayList<String>();
        for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
            extensionsSupported.add(Constants.STANDARD_JSP_EXTENSIONS[i]);
        }
        return extensionsSupported;
    }

    protected abstract JspXmlExtConfig createConfig(IServletContext var1);

    protected abstract JspClassloaderContext createJspClassloaderContext(IServletContext var1, JspXmlExtConfig var2);

    protected abstract ExtensionProcessor createProcessor(IServletContext var1, JspXmlExtConfig var2, JspClassloaderContext var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createGlobalTagLibraryCache() {
        Object object = lock;
        synchronized (object) {
            if (this.globalTagLibraryCache == null) {
                long start = System.currentTimeMillis();
                this.globalTagLibraryCache = new GlobalTagLibraryCache();
                long end = System.currentTimeMillis();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, "JSPExtensionFactory", "createGlobalTagLibraryCache", "GlobalTagLibraryCache created in " + (end - start) + " ms");
                }
            }
        }
    }
}

