/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.validator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.bean.BeanRepository;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.utils.TagFileId;
import com.ibm.ws.jsp.translator.visitor.JspVisitor;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.validator.ELValidator;
import com.ibm.ws.jsp.translator.visitor.validator.PageDataImpl;
import com.ibm.ws.jsp.translator.visitor.validator.TagCountResult;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.el.lang.ELSupport;
import org.apache.jasper.compiler.ELNode;
import org.apache.jasper.compiler.ELParser;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ValidateVisitor
extends JspVisitor {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.validator.ValidateVisitor";
    public static final String[] ATTR_STANDARD_ACTIONS = new String[]{"useBean", "setProperty", "getProperty", "include", "forward", "param", "plugin", "invoke", "doBody", "element", "output"};
    public static final String[] BODY_STANDARD_ACTIONS = new String[]{"useBean", "setProperty", "getProperty", "include", "forward", "param", "params", "plugin", "element", "output", "fallback"};
    private static final String[] includeAttrNames = new String[]{"page", "flush"};
    private static final String[] forwardAttrNames = new String[]{"page"};
    private static final String[] useBeanAttrNames = new String[]{"id", "scope", "class", "beanName", "type"};
    private static final String[] setPropertyAttrNames = new String[]{"name", "property", "param", "value"};
    private static final String[] getPropertyAttrNames = new String[]{"name", "property"};
    private static final String[] paramAttrNames = new String[]{"name", "value"};
    private static final String[] pluginAttrNames = new String[]{"type", "code", "codebase", "align", "archive", "height", "hspace", "jreversion", "name", "vspace", "title", "width", "nspluginurl", "iepluginurl", "mayscript"};
    private static final String[] attributeAttrNames = new String[]{"name", "trim"};
    private static final String[] elementAttrNames = new String[]{"name"};
    private static final String[] outputAttrNames = new String[]{"omit-xml-declaration", "doctype-root-element", "doctype-system", "doctype-public"};
    private static final String[] includeRuntimeAttrNames = new String[]{"page"};
    private static final String[] forwardRuntimeAttrNames = new String[]{"page"};
    private static final String[] setPropertyRuntimeAttrNames = new String[]{"value"};
    private static final String[] useBeanRuntimeAttrNames = new String[]{"beanName"};
    private static final String[] pluginRuntimeAttrNames = new String[]{"height", "width"};
    private static final String[] paramRuntimeAttrNames = new String[]{"value"};
    private static final String[] includeRequiredAttrs = new String[]{"page"};
    private static final String[] forwardRequiredAttrs = new String[]{"page"};
    private static final String[] useBeanRequiredAttrsClass = new String[]{"class", "id"};
    private static final String[] useBeanRequiredAttrsType = new String[]{"type", "id"};
    private static final String[] setPropertyRequiredAttrs = new String[]{"name", "property"};
    private static final String[] getPropertyRequiredAttrs = new String[]{"name", "property"};
    private static final String[] paramAttrsRequiredAttrs = new String[]{"name", "value"};
    private static final String[] pluginAttrsRequiredAttrs = new String[]{"type", "code", "codebase"};
    private static final String[] attributeRequiredAttrs = new String[]{"name"};
    private static final String[] elementRequiredAttrs = new String[]{"name"};
    protected ValidateResult result = null;
    protected TagLibraryCache tagLibraryCache = null;
    protected Stack tagCountStack = new Stack();
    private Vector dupVector = new Vector();
    private HashMap<String, Integer> scriptVars = new HashMap();
    private HashMap<String, String> prefixToUriMap = new HashMap();
    protected String jspUri = null;
    protected TagCountResult tagCountResult = null;
    protected boolean dupFlag = false;
    protected JspOptions jspOptions = null;
    protected boolean evalQuotedAndEscapedExpression = false;

    protected ValidateVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        super(visitorUsage, jspConfiguration, context, resultMap, inputMap);
        this.tagLibraryCache = (TagLibraryCache)inputMap.get("TagLibraryCache");
        this.jspUri = (String)inputMap.get("JspUri");
        this.tagCountResult = (TagCountResult)resultMap.get("TagCount");
        this.jspOptions = (JspOptions)inputMap.get("JspOptions");
        this.evalQuotedAndEscapedExpression = this.jspOptions.isEvalQuotedAndEscapedExpression();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "ValidateVisitor", "evalQuotedAndEscapedExpression =[" + this.evalQuotedAndEscapedExpression + "]");
        }
    }

    public JspVisitorResult getResult() throws JspCoreException {
        List staticIncludeDependencies = (List)this.inputMap.get("StaticIncludeDependencyList");
        this.result.getDependencyList().addAll(staticIncludeDependencies);
        List tagFileDependencies = (List)this.inputMap.get("TagFileDependencies");
        for (TagFileId tagFileId : tagFileDependencies) {
            TagLibraryInfoImpl tli = this.tagLibraryCache.getTagLibraryInfo(tagFileId.getUri(), tagFileId.getPrefix(), this.jspUri);
            if (!tli.getInputSource().getAbsoluteURL().getProtocol().equals("file")) continue;
            TagFileInfo tfi = tli.getTagFile(tagFileId.getTagName());
            this.result.getDependencyList().add(tfi.getPath());
        }
        this.getBeanRepository();
        return this.result;
    }

    private BeanRepository getBeanRepository() {
        if (this.result.getBeanRepository() == null) {
            this.result.setBeanRepository(new BeanRepository(this.context.getJspClassloaderContext().getClassLoader()));
        }
        return this.result.getBeanRepository();
    }

    protected void visitJspParamsStart(Element jspElement) throws JspCoreException {
        Node parent = jspElement.getParentNode();
        if (parent.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
            if (!parent.getLocalName().equals("plugin") && !parent.getLocalName().equals("body")) {
                throw new JspTranslationException(jspElement, "jsp.params.invalid.parent");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.params.invalid.parent");
        }
    }

    protected void visitJspFallbackStart(Element jspElement) throws JspCoreException {
        Node parent = jspElement.getParentNode();
        if (parent.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
            if (!parent.getLocalName().equals("plugin") && !parent.getLocalName().equals("body")) {
                throw new JspTranslationException(jspElement, "jsp.fallback.invalid.parent");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.fallback.invalid.parent");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void visitJspParamStart(Element jspElement) throws JspCoreException {
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, paramAttrsRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, paramAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, paramRuntimeAttrNames, Object.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
        this.validateEmptyBody(jspElement);
        Node parent = jspElement.getParentNode();
        String parentName = jspElement.getParentNode().getLocalName();
        if (!parent.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) throw new JspTranslationException(jspElement, "jsp.param.invalid.parent");
        if (!parentName.equals("include") && !parentName.equals("forward") && !parentName.equals("params") && !parentName.equals("body")) throw new JspTranslationException(jspElement, "jsp.param.invalid.parent");
        String name = this.getAttributeValue(jspElement, "name");
        if (!name.equals("")) return;
        throw new JspTranslationException(jspElement, "jsp.param.name.empty");
    }

    protected void visitCustomTagStart(Element jspElement) throws JspCoreException {
        ValidationMessage[] validationMessages;
        ValidateVisitor.getAttributeList(jspElement);
        String uri = jspElement.getNamespaceURI();
        String prefix = jspElement.getPrefix();
        String tagName = jspElement.getLocalName();
        boolean isTagFile = false;
        if (uri.startsWith("urn:jsptld:")) {
            uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
        } else if (uri.startsWith("urn:jsptagdir:")) {
            uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
        }
        ValidateTagInfo vti = this.getTagInfo(jspElement, uri, prefix, tagName);
        if (vti == null) {
            return;
        }
        TagInfo ti = vti.getTagInfo();
        isTagFile = vti.isTagFile();
        TagLibraryInfoImpl tli = vti.getTLI();
        ti.setTagLibrary(tli);
        TagAttributeInfo[] attributes = ti.getAttributes();
        this.validateCustomTagAttributes(jspElement, attributes);
        CustomTagInstance cti = this.validateCustomTagAttributeValues(jspElement, attributes, ti.hasDynamicAttributes(), tli);
        Hashtable attribs = cti.getAttributes();
        boolean isScriptless = cti.isScriptless();
        StringBuffer varNameSuffix = new StringBuffer();
        varNameSuffix.append(uri);
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i].isRequired() && !attribs.containsKey(attributes[i].getName())) {
                throw new JspTranslationException(jspElement, "jsp.error.missing.attribute", new Object[]{attributes[i].getName()});
            }
            if (attributes[i].isRequired() || !attribs.containsKey(attributes[i].getName())) continue;
            varNameSuffix.append("_" + attributes[i].getName());
        }
        if (JspTranslatorUtil.hasBody(jspElement) || JspTranslatorUtil.hasJspBody(jspElement)) {
            varNameSuffix.append("_jspxhasbody");
        }
        String tmpValueToBeHashed = varNameSuffix.toString();
        varNameSuffix = new StringBuffer("_" + tmpValueToBeHashed.hashCode());
        Enumeration e = attribs.keys();
        while (e.hasMoreElements()) {
            boolean found = false;
            String attr = (String)e.nextElement();
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getName().equals(attr)) continue;
                found = true;
                break;
            }
            if (found || ti.hasDynamicAttributes()) continue;
            throw new JspTranslationException(jspElement, "jsp.error.bad.attribute", new Object[]{attr});
        }
        TagData tagData = new TagData(attribs);
        if (!ti.isValid(tagData)) {
            throw new JspTranslationException(jspElement, "jsp.error.invalid.attributes");
        }
        TagExtraInfo tei = ti.getTagExtraInfo();
        if (tei != null) {
            tei.setTagInfo(ti);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitCustomTagStart", "tei.getTagInfo().getTagLibrary().getTagLibraryInfos() =[" + tei.getTagInfo().getTagLibrary().getTagLibraryInfos() + "]");
            }
            if (tei.getVariableInfo(tagData) != null && tei.getVariableInfo(tagData).length > 0 && ti.getTagVariableInfos().length > 0) {
                throw new JspTranslationException(jspElement, "jsp.error.non_null_tei_and_var_subelems");
            }
        }
        if ((validationMessages = ti.validate(tagData)) != null && validationMessages.length > 0) {
            StringBuffer errMsg = new StringBuffer();
            for (int i = 0; i < validationMessages.length; ++i) {
                if (validationMessages[i] == null) continue;
                errMsg.append("<p>");
                errMsg.append(validationMessages[i].getId());
                errMsg.append(": ");
                errMsg.append(validationMessages[i].getMessage());
                errMsg.append("</p>");
            }
            throw new JspTranslationException(jspElement, "jsp.error.tei.invalid.attributes", new Object[]{uri, tagName, errMsg.toString()});
        }
        if (isScriptless) {
            isScriptless = this.areChildrenScriptless(jspElement);
        }
        TagVariableInfo[] tagVarInfos = ti.getTagVariableInfos();
        VariableInfo[] varInfos = ti.getVariableInfo(tagData);
        if (varInfos == null) {
            varInfos = new VariableInfo[]{};
        }
        boolean hasScriptingVars = varInfos.length > 0 || tagVarInfos.length > 0;
        Integer tagCount = (Integer)this.tagCountResult.getCountMap().get(jspElement);
        Vector atBeginVars = this.setScriptingVars(tagVarInfos, varInfos, tagData, 1, tagCount);
        Vector nestedVars = this.setScriptingVars(tagVarInfos, varInfos, tagData, 0, tagCount);
        this.result.addCollectTagData(jspElement, isScriptless, hasScriptingVars, atBeginVars, null, nestedVars, tagData, varNameSuffix.toString());
        if (this.tagLibraryCache.getTagClassInfo(ti) == null && !isTagFile) {
            Class<?> tagClass = null;
            try {
                tagClass = this.context.getJspClassloaderContext().getClassLoader().loadClass(ti.getTagClassName());
                this.tagLibraryCache.addTagClassInfo(ti, tagClass);
            }
            catch (Exception ex) {
                throw new JspTranslationException(jspElement, "jsp.error.unable.loadclass", new Object[]{ti.getTagClassName()});
            }
        }
        this.tagCountStack.push(this.tagCountResult.getCountMap().get(jspElement));
    }

    protected void visitCustomTagEnd(Element jspElement) throws JspCoreException {
        ValidateResult.CollectedTagData collectedTagData = this.result.getCollectedTagData(jspElement);
        String uri = jspElement.getNamespaceURI();
        String prefix = jspElement.getPrefix();
        String tagName = jspElement.getLocalName();
        if (uri.startsWith("urn:jsptld:")) {
            uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
        } else if (uri.startsWith("urn:jsptagdir:")) {
            uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
        }
        TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
        if (tli != null) {
            this.tagCountStack.pop();
            TagInfo ti = tli.getTag(tagName);
            if (ti == null) {
                TagFileInfo tfi = tli.getTagFile(tagName);
                ti = tfi.getTagInfo();
            }
            TagVariableInfo[] tagVarInfos = ti.getTagVariableInfos();
            VariableInfo[] varInfos = ti.getVariableInfo(collectedTagData.getTagData());
            if (varInfos == null) {
                varInfos = new VariableInfo[]{};
            }
            Integer tagCount = (Integer)this.tagCountResult.getCountMap().get(jspElement);
            Vector atEndVars = this.setScriptingVars(tagVarInfos, varInfos, collectedTagData.getTagData(), 2, tagCount);
            if (this.dupFlag) {
                Vector dupVector = this.getDuplicateVars();
                collectedTagData.setAtEndDuplicateVars(dupVector);
                this.dupFlag = false;
            }
            collectedTagData.setAtEndScriptingVars(atEndVars);
        }
    }

    protected void visitJspRootStart(Element jspElement) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspRootStart", "enter visitJspRootStart() =[" + jspElement.getNodeValue() + "]");
        }
        if (jspElement.getParentNode().getNodeType() != 9) {
            throw new JspTranslationException(jspElement, "jsp.error.root.must.be.top");
        }
        NamedNodeMap attributes = jspElement.getAttributes();
        if (attributes != null) {
            if (!jspElement.hasAttribute("version")) {
                throw new JspTranslationException(jspElement, "jsp.error.root.invalid.version", new Object[]{"none found"});
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (attribute.getNodeName().startsWith("xmlns:")) {
                    String prefix = attribute.getNodeName();
                    prefix = prefix.substring(prefix.indexOf(":") + 1);
                    String uri = attribute.getNodeValue();
                    if (uri.startsWith("urn:jsptld:")) {
                        uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
                    } else if (uri.startsWith("urn:jsptagdir:")) {
                        uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
                    }
                    if (uri.equals("http://java.sun.com/JSP/Page") || uri.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                    TagLibraryInfoImpl tli = this.tagLibraryCache.getTagLibraryInfo(uri, prefix, this.jspUri);
                    if (tli != null) {
                        if (tli.getTldFilePath() != null && tli.getInputSource().getAbsoluteURL().getProtocol().equals("file") && !this.tagLibraryCache.getImplicitTagLibPrefixMap().containsValue(uri)) {
                            this.result.getDependencyList().add(tli.getTldFilePath());
                        }
                        if (this.result.getTagLibMap().containsKey(uri)) continue;
                        this.result.getTagLibMap().put(uri, tli);
                        tli.setTagLibMap(this.result.getTagLibMap());
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "visitJspRootStart", "getTagLibraryInfos() =[" + tli.getTagLibraryInfos() + "]");
                        }
                        this.prefixToUriMap.put(prefix, uri);
                        this.validateTagLib(jspElement.getOwnerDocument(), uri, prefix, tli);
                        continue;
                    }
                    if (this.jspConfiguration.isXml()) continue;
                    throw new JspTranslationException(jspElement, "jsp.error.tld.not.found", new Object[]{uri, prefix});
                }
                if (!attribute.getNodeName().equals("version") || attribute.getNodeValue().equals("1.2") || attribute.getNodeValue().equals("2.0") || attribute.getNodeValue().equals("2.1")) continue;
                throw new JspTranslationException(jspElement, "jsp.error.root.invalid.version", new Object[]{attribute.getNodeValue()});
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.root.has.no.attributes");
        }
    }

    protected void visitJspUseBeanStart(Element jspElement) throws JspCoreException {
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        try {
            this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, useBeanRequiredAttrsClass);
        }
        catch (JspCoreException jce) {
            this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, useBeanRequiredAttrsType);
        }
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, useBeanAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, useBeanRuntimeAttrNames, String.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
        String nameAttrValue = this.getAttributeValue(jspElement, "id");
        String scopeAttrValue = this.getAttributeValue(jspElement, "scope");
        String classAttrValue = this.getAttributeValue(jspElement, "class");
        String typeAttrValue = this.getAttributeValue(jspElement, "type");
        String beanNameAttrValue = this.getAttributeValue(jspElement, "beanName");
        if (nameAttrValue.equals("")) {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.missing.attribute");
        }
        if (classAttrValue.equals("") && typeAttrValue.equals("")) {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.missing.type");
        }
        if (this.getBeanRepository().checkVariable(nameAttrValue)) {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.duplicate", new Object[]{nameAttrValue});
        }
        if (!classAttrValue.equals("") && !beanNameAttrValue.equals("")) {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.not.both", new Object[]{classAttrValue, beanNameAttrValue});
        }
        if (!classAttrValue.equals("") && !typeAttrValue.equals("")) {
            try {
                Class<?> classAttrClass = Class.forName(classAttrValue, true, this.context.getJspClassloaderContext().getClassLoader());
                Class<?> typeAttrClass = Class.forName(typeAttrValue, true, this.context.getJspClassloaderContext().getClassLoader());
                if (!typeAttrClass.isAssignableFrom(classAttrClass)) {
                    throw new JspTranslationException(jspElement, "jsp.error.usebean.class.must.be.assignable.to.type", new Object[]{classAttrValue, typeAttrValue, jspElement.getTagName()});
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new JspTranslationException(jspElement, "jsp.error.usebean.cannot.locate.class.to.validate.assignable", new Object[]{classAttrValue, typeAttrValue, jspElement.getTagName()}, cnfe);
            }
        }
        String clsname = null;
        clsname = classAttrValue != null && !classAttrValue.equals("") ? classAttrValue : typeAttrValue;
        if (scopeAttrValue.equals("") || scopeAttrValue.equals("page")) {
            this.getBeanRepository().addPageBean(nameAttrValue, clsname);
        } else if (scopeAttrValue.equals("request")) {
            this.getBeanRepository().addRequestBean(nameAttrValue, clsname);
        } else if (scopeAttrValue.equals("session")) {
            this.getBeanRepository().addSessionBean(nameAttrValue, clsname);
        } else if (scopeAttrValue.equals("application")) {
            this.getBeanRepository().addApplicationBean(nameAttrValue, clsname);
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.invalid.scope", new Object[]{scopeAttrValue});
        }
    }

    protected void visitJspExpressionStart(Element jspElement) throws JspCoreException {
        Node n = jspElement.getFirstChild();
        if (n.getNodeType() == 4) {
            if (this.jspConfiguration.scriptingInvalid()) {
                throw new JspTranslationException(jspElement, "jsp.error.expressions.disabled.for.translation.unit");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.expression.contains.no.cdata");
        }
    }

    protected void visitJspScriptletStart(Element jspElement) throws JspCoreException {
        Node n = jspElement.getFirstChild();
        if (n.getNodeType() == 4) {
            if (this.jspConfiguration.scriptingInvalid()) {
                throw new JspTranslationException(jspElement, "jsp.error.scriptlets.disabled.for.translation.unit");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.scriptlet.contains.no.cdata");
        }
    }

    protected void visitJspDeclarationStart(Element jspElement) throws JspCoreException {
        Node n = jspElement.getFirstChild();
        if (n.getNodeType() == 4) {
            if (this.jspConfiguration.scriptingInvalid()) {
                throw new JspTranslationException(jspElement, "jsp.error.declarations.disabled.for.translation.unit");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.declaration.contains.no.cdata");
        }
    }

    protected void visitJspTextStart(Element jspElement) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspTextStart", "jspElement =[" + jspElement + "]");
        }
        for (int i = 0; i < jspElement.getChildNodes().getLength(); ++i) {
            Node n = jspElement.getChildNodes().item(i);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitJspTextStart", "Node n =[" + n + "]");
                logger.logp(Level.FINER, CLASS_NAME, "visitJspTextStart", "Node n TYPE =[" + n.getNodeType() + "]");
            }
            if (n.getNodeType() == 4) {
                CDATASection cdata = (CDATASection)n;
                this.visitJspELTextStart(jspElement, cdata.getData(), String.class);
                continue;
            }
            if (n.getNodeType() == 7) continue;
            throw new JspTranslationException(jspElement, "jsp.error.jsptext.has.child.elements");
        }
    }

    protected void visitJspIncludeStart(Element jspElement) throws JspCoreException {
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, includeRequiredAttrs);
        String flushString = this.getAttributeValue(jspElement, "flush");
        if (!(flushString.equals("") || flushString.equalsIgnoreCase("false") || flushString.equalsIgnoreCase("true"))) {
            throw new JspTranslationException(jspElement, "jsp.error.include.flush.invalid.value", new Object[]{flushString});
        }
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, includeAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, includeRuntimeAttrNames, String.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
    }

    protected void visitJspGetPropertyStart(Element jspElement) throws JspCoreException {
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, getPropertyRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, getPropertyAttrNames);
    }

    protected void visitJspForwardStart(Element jspElement) throws JspCoreException {
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, forwardRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, forwardAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, forwardRuntimeAttrNames, String.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
    }

    protected void visitJspPluginStart(Element jspElement) throws JspCoreException {
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, pluginAttrsRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, pluginAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, pluginRuntimeAttrNames, String.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
        String typeValue = this.getAttributeValue(jspElement, "type");
        if (!typeValue.equals("applet") && !typeValue.equals("bean")) {
            throw new JspTranslationException(jspElement, "jsp.error.plugin.invalid.type", new Object[]{typeValue});
        }
    }

    protected void visitJspSetPropertyStart(Element jspElement) throws JspCoreException {
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, setPropertyRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, setPropertyAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, setPropertyRuntimeAttrNames, Object.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
    }

    protected void visitJspAttributeStart(Element jspElement) throws JspCoreException {
        Node parent = jspElement.getParentNode();
        if (parent.getNodeType() == 1) {
            String uri;
            Element parentElement = (Element)parent;
            String name = jspElement.getAttribute("name");
            String prefix = null;
            if (name.indexOf(58) != -1) {
                prefix = name.substring(0, name.indexOf(58));
                name = name.substring(name.indexOf(58) + 1);
            }
            if ((uri = this.prefixToUriMap.get(parentElement.getPrefix())) == null) {
                String actionName = parentElement.getLocalName();
                boolean validActionFound = false;
                for (int i = 0; i < ATTR_STANDARD_ACTIONS.length; ++i) {
                    if (!actionName.equals(ATTR_STANDARD_ACTIONS[i])) continue;
                    validActionFound = true;
                    break;
                }
                if (!validActionFound) {
                    throw new JspTranslationException(jspElement, "jsp.error.jsp.attribute.invalid.parent");
                }
                if (prefix != null && !parentElement.getLocalName().equals("element") && !parentElement.getPrefix().equals(prefix)) {
                    throw new JspTranslationException(jspElement, "jsp.error.jsp.attribute.prefix.mismatch", new Object[]{parentElement.getPrefix(), prefix});
                }
            } else if (prefix != null) {
                String tagName = parentElement.getLocalName();
                TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
                TagInfo ti = tli.getTag(tagName);
                if (!ti.hasDynamicAttributes() && !parentElement.getPrefix().equals(prefix)) {
                    throw new JspTranslationException(jspElement, "jsp.error.jsp.attribute.prefix.mismatch", new Object[]{parentElement.getPrefix(), prefix});
                }
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.jsp.attribute.invalid.parent");
        }
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, attributeRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, attributeAttrNames);
        NodeList childNodes = jspElement.getChildNodes();
        int numberChilds = childNodes.getLength();
        for (int i = 0; i < numberChilds; ++i) {
            Element childElement;
            Node currentNode = childNodes.item(i);
            if (currentNode.getNodeType() != 1 || (childElement = (Element)currentNode).getNamespaceURI() == null || !childElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !childElement.getLocalName().equals("attribute")) continue;
            throw new JspTranslationException(jspElement, "jsp.error.jsp.attribute.defined.value.jsp.attribute");
        }
    }

    protected void visitJspElementStart(Element jspElement) throws JspCoreException {
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement, true);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, elementRequiredAttrs);
        this.validateAttributes(jspElement, elementAttrNames);
    }

    protected void visitJspOutputStart(Element jspElement) throws JspCoreException {
        if (!this.jspConfiguration.isXml()) {
            throw new JspTranslationException(jspElement, "jsp.error.jspoutput.xml.only");
        }
        this.validateAttributes(jspElement, outputAttrNames);
        if (jspElement.hasChildNodes()) {
            throw new JspTranslationException(jspElement, "jsp.error.output.has.body");
        }
        Attr docTypeDeclElement = jspElement.getAttributeNode("omit-xml-declaration");
        Attr docTypeRootElement = jspElement.getAttributeNode("doctype-root-element");
        Attr docTypePublicElement = jspElement.getAttributeNode("doctype-public");
        Attr docTypeSystemElement = jspElement.getAttributeNode("doctype-system");
        if (docTypeSystemElement == null) {
            if (docTypeRootElement != null) {
                throw new JspTranslationException(jspElement, "jsp.error.no.doctype-system.attr");
            }
            if (docTypePublicElement != null) {
                throw new JspTranslationException(jspElement, "jsp.error.no.doctype-system.attr");
            }
        } else if (docTypeRootElement == null) {
            throw new JspTranslationException(jspElement, "jsp.error.no.doctype-root-element.attr");
        }
        boolean allowJspOutputElementMismatch = JspOptions.ALLOWJSPOUTPUTELEMENTMISMATCH;
        JspOptions jspOptions = (JspOptions)this.inputMap.get("JspOptions");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "jspOptions =[" + jspOptions + "]");
        }
        if (jspOptions != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "jspOptions.isAllowJspOutputElementMismatch():  [" + jspOptions.isAllowJspOutputElementMismatch() + "]");
            }
            allowJspOutputElementMismatch = jspOptions.isAllowJspOutputElementMismatch();
        }
        if (!allowJspOutputElementMismatch) {
            String omitXmlDecl = null;
            if (docTypeDeclElement != null) {
                omitXmlDecl = docTypeDeclElement.getValue();
            }
            String doctypeRoot = null;
            if (docTypeRootElement != null) {
                doctypeRoot = docTypeRootElement.getValue();
            }
            String doctypePublic = null;
            if (docTypePublicElement != null) {
                doctypePublic = docTypePublicElement.getValue();
            }
            String doctypeSystem = null;
            if (docTypeSystemElement != null) {
                doctypeSystem = docTypeSystemElement.getValue();
            }
            String omitXmlDeclOld = this.result.getOmitXmlDecl();
            String doctypeRootOld = this.result.getDoctypeRoot();
            String doctypePublicOld = this.result.getDoctypePublic();
            String doctypeSystemOld = this.result.getDoctypeSystem();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "omitXmlDecl =[" + omitXmlDecl + "] omitXmlDeclOld =[" + omitXmlDeclOld + "]  ");
                logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "doctypeRoot =[" + doctypeRoot + "] doctypeRootOld =[" + doctypeRootOld + "]  ");
                logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "doctypePublic =[" + doctypePublic + "] doctypePublicOld =[" + doctypePublicOld + "]  ");
                logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "doctypeSystem =[" + doctypeSystem + "] doctypeSystemOld =[" + doctypeSystemOld + "]  ");
            }
            if (omitXmlDecl != null && omitXmlDeclOld != null && !omitXmlDecl.equals(omitXmlDeclOld)) {
                throw new JspTranslationException(jspElement, "jsp.error.jspoutput.conflict", new Object[]{"omit-xml-declaration", omitXmlDeclOld, omitXmlDecl});
            }
            if (doctypeRoot != null && doctypeRootOld != null && !doctypeRoot.equals(doctypeRootOld)) {
                throw new JspTranslationException(jspElement, "jsp.error.jspoutput.conflict", new Object[]{"doctype-root-element", doctypeRootOld, doctypeRoot});
            }
            if (doctypePublic != null && doctypePublicOld != null && !doctypePublic.equals(doctypePublicOld)) {
                throw new JspTranslationException(jspElement, "jsp.error.jspoutput.conflict", new Object[]{"doctype-public", doctypePublicOld, doctypePublic});
            }
            if (doctypeSystem != null && doctypeSystemOld != null && !doctypeSystem.equals(doctypeSystemOld)) {
                throw new JspTranslationException(jspElement, "jsp.error.jspoutput.conflict", new Object[]{"doctype-system", doctypeSystemOld, doctypeSystem});
            }
            if (omitXmlDecl != null) {
                this.result.setOmitXmlDecl(omitXmlDecl);
            }
            if (doctypeRoot != null) {
                this.result.setDoctypeRoot(doctypeRoot);
            }
            if (doctypeSystem != null) {
                this.result.setDoctypeSystem(doctypeSystem);
            }
            if (doctypePublic != null) {
                this.result.setDoctypePublic(doctypePublic);
            }
        }
    }

    protected void visitCDataTag(CDATASection cdata) throws JspCoreException {
        this.visitJspELTextStart((Element)cdata.getParentNode(), cdata.getData(), String.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void visitJspBodyStart(Element jspElement) throws JspCoreException {
        Node parent = jspElement.getParentNode();
        if (parent.getNodeType() != 1) throw new JspTranslationException(jspElement, "jsp.error.jsp.body.invalid.parent");
        Element parentElement = (Element)parent;
        String uri = this.prefixToUriMap.get(parentElement.getPrefix());
        if (uri == null) {
            String actionName = parentElement.getLocalName();
            boolean validActionFound = false;
            for (int i = 0; i < BODY_STANDARD_ACTIONS.length; ++i) {
                if (!actionName.equals(BODY_STANDARD_ACTIONS[i])) continue;
                return;
            }
            if (validActionFound) return;
            if (!actionName.equals("root")) throw new JspTranslationException(jspElement, "jsp.error.jsp.body.invalid.parent");
            if (this.jspConfiguration.isXml()) return;
            throw new JspTranslationException(jspElement, "jsp.error.jsp.body.invalid.parent");
        }
        String tagName = parentElement.getLocalName();
        TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
        TagInfo ti = tli.getTag(tagName);
        if (ti == null) return;
        if (!ti.getBodyContent().equalsIgnoreCase("empty")) return;
        throw new JspTranslationException(jspElement, "jsp.error.jsp.body.parent.nobody");
    }

    protected void visitIncludeDirectiveStart(Element jspElement) throws JspCoreException {
    }

    protected void visitTagDirectiveStart(Element jspElement) throws JspCoreException {
    }

    protected void visitAttributeDirectiveStart(Element jspElement) throws JspCoreException {
    }

    protected void visitVariableDirectiveStart(Element jspElement) throws JspCoreException {
    }

    protected void visitUninterpretedTagStart(Element jspElement) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "jspElement =[" + jspElement + "]");
        }
        String uri = jspElement.getNamespaceURI();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "uri =[" + uri + "]");
        }
        if (uri != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "uri =[" + uri + "]");
            }
            if (uri.startsWith("urn:jsptld:")) {
                uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
            } else if (uri.startsWith("urn:jsptagdir:")) {
                uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
            }
            TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
            if (tli == null) {
                tli = this.tagLibraryCache.getTagLibraryInfo(uri, "", this.jspUri);
                if (tli != null) {
                    jspElement.setPrefix("");
                    this.visitCustomTagStart(jspElement);
                }
            } else {
                jspElement.setPrefix("");
                this.visitCustomTagStart(jspElement);
            }
        }
        NamedNodeMap nodeAttrs = jspElement.getAttributes();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "nodeAttrs = [" + nodeAttrs + "]");
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "nodeAttrs.getLength() = [" + nodeAttrs.getLength() + "]");
        }
        for (int i = 0; i < nodeAttrs.getLength(); ++i) {
            Attr attr = (Attr)nodeAttrs.item(i);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "nodeAttrs attr = [" + attr + "]");
            }
            this.visitJspELTextStart(jspElement, attr.getValue(), String.class);
        }
    }

    protected void visitJspParamEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspGetPropertyEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspRootEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspFallbackEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspUseBeanEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspForwardEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspPluginEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspSetPropertyEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitIncludeDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspExpressionEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitPageDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspIncludeEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspScriptletEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspDeclarationEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspTextEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspParamsEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspAttributeEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspElementEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspBodyEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspInvokeEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspDoBodyEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitTagDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitAttributeDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitVariableDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspOutputEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitUninterpretedTagEnd(Element jspElement) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagEnd", "jspElement =[" + jspElement + "]");
        }
        String uri = jspElement.getNamespaceURI();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagEnd", "uri =[" + uri + "]");
        }
        if (uri != null) {
            if (uri.startsWith("urn:jsptld:")) {
                uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
            } else if (uri.startsWith("urn:jsptagdir:")) {
                uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
            }
            TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
            if (tli != null) {
                jspElement.setPrefix("");
                this.visitCustomTagEnd(jspElement);
            }
        }
    }

    private Vector setScriptingVars(TagVariableInfo[] tagVarInfos, VariableInfo[] varInfos, TagData tagData, int scope, int tagCount) throws JspCoreException {
        if (tagVarInfos.length == 0 && varInfos.length == 0) {
            return null;
        }
        Vector<Object> vec = new Vector<Object>();
        Integer ownRange = null;
        ownRange = scope == 1 || scope == 2 ? (this.tagCountStack.size() > 0 ? (Integer)this.tagCountStack.peek() : new Integer(Integer.MAX_VALUE)) : new Integer(tagCount);
        if (varInfos.length > 0) {
            for (int i = 0; i < varInfos.length; ++i) {
                if (varInfos[i].getScope() != scope || !varInfos[i].getDeclare()) continue;
                String varName = varInfos[i].getVarName();
                Integer currentRange = this.scriptVars.get(varName);
                if (currentRange != null) {
                    this.dupFlag = true;
                    this.setDuplicateVars(varInfos[i]);
                }
                if (currentRange != null && ownRange.compareTo(currentRange) <= 0) continue;
                this.scriptVars.put(varName, ownRange);
                vec.add(varInfos[i]);
            }
        } else {
            for (int i = 0; i < tagVarInfos.length; ++i) {
                if (tagVarInfos[i].getScope() != scope || !tagVarInfos[i].getDeclare()) continue;
                String varName = tagVarInfos[i].getNameGiven();
                if (varName == null && (varName = tagData.getAttributeString(tagVarInfos[i].getNameFromAttribute())) == null) {
                    throw new JspTranslationException("jsp.error.scripting.variable.missing_name", new Object[]{tagVarInfos[i].getNameFromAttribute()});
                }
                Integer currentRange = this.scriptVars.get(varName);
                if (currentRange != null && ownRange.compareTo(currentRange) <= 0) continue;
                this.scriptVars.put(varName, ownRange);
                vec.add(tagVarInfos[i]);
            }
        }
        return vec;
    }

    private void setDuplicateVars(VariableInfo varInfo) {
        this.dupVector.addElement(varInfo);
    }

    private Vector getDuplicateVars() {
        return this.dupVector;
    }

    protected void validateTagLib(Document jspDocument, String uri, String prefix, TagLibraryInfoImpl tli) throws JspCoreException {
        TagLibraryValidator tlv = tli.getTagLibraryValidator();
        if (tlv != null) {
            ClassLoader originalClassLoader = ThreadContextHelper.getContextClassLoader();
            ThreadContextHelper.setClassLoader(this.context.getJspClassloaderContext().getClassLoader());
            try {
                ValidationMessage[] validationMessages = tlv.validate(prefix, uri, new PageDataImpl(jspDocument, this.tagLibraryCache));
                ThreadContextHelper.setClassLoader(originalClassLoader);
                if (validationMessages != null && validationMessages.length > 0) {
                    StringBuffer errMsg = new StringBuffer();
                    for (int i = 0; i < validationMessages.length; ++i) {
                        if (validationMessages[i] == null) continue;
                        errMsg.append("<p>");
                        if (validationMessages[i].getId() != null) {
                            JspId jspId = new JspId(validationMessages[i].getId());
                            errMsg.append("File [" + jspId.getFilePath() + "] ");
                            errMsg.append("Line [" + jspId.getStartSourceLineNum() + "] ");
                            errMsg.append("Column [" + jspId.getStartSourceColNum() + "] ");
                        }
                        errMsg.append(validationMessages[i].getMessage());
                        errMsg.append("</p>");
                    }
                    throw new JspTranslationException("jsp.error.tlv.invalid.page", new Object[]{uri, errMsg.toString()});
                }
            }
            catch (Throwable e) {
                throw new JspCoreException(e);
            }
        }
    }

    protected void validateAttributes(List attributeList, Element jspElement, String[] validAttrs) throws JspCoreException {
        for (int i = 0; i < attributeList.size(); ++i) {
            String attr = (String)attributeList.get(i);
            if (attr.equals("jsp:id") || attr.startsWith("xmlns")) continue;
            boolean valid = false;
            for (int j = 0; j < validAttrs.length; ++j) {
                if (!attr.equals(validAttrs[j])) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            throw new JspTranslationException(jspElement, "jsp.error.unknown.attribute", new Object[]{attr, jspElement.getTagName()});
        }
    }

    protected void validateAttributes(Element jspElement, String[] validAttrs) throws JspCoreException {
        NamedNodeMap attrs = jspElement.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String uri = attr.getNamespaceURI();
            String fullName = attr.getNodeName();
            if (uri != null && attr.getLocalName().equals("id") && uri.equals("http://java.sun.com/JSP/Page") || fullName.startsWith("xmlns")) continue;
            boolean valid = false;
            for (int j = 0; j < validAttrs.length; ++j) {
                if (!attr.getNodeName().equals(validAttrs[j])) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            throw new JspTranslationException(jspElement, "jsp.error.unknown.attribute", new Object[]{attr.getNodeName(), jspElement.getTagName()});
        }
    }

    protected void validateEmptyBody(Element jspElement) throws JspCoreException {
        NodeList childNodes = jspElement.getChildNodes();
        if (childNodes != null) {
            CDATASection cdata = null;
            Element childElement = null;
            String value = null;
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node n = childNodes.item(j);
                if (n.getNodeType() == 4) {
                    cdata = (CDATASection)n;
                    value = cdata.getData();
                    if (value.trim().length() <= 0) continue;
                    throw new JspTranslationException(jspElement, "jsp.error.jspbody.emptybody.only", new Object[]{jspElement.getNodeName(), "[" + n.getNodeName() + "] : " + value});
                }
                if (!(n instanceof Element) || (childElement = (Element)n).getNamespaceURI().equals("http://java.sun.com/JSP/Page") && childElement.getLocalName().equals("attribute")) continue;
                throw new JspTranslationException(jspElement, "jsp.error.jspbody.emptybody.only", new Object[]{jspElement.getNodeName(), childElement.getNamespaceURI() + " : " + childElement.getLocalName()});
            }
        }
    }

    protected void visitJspELTextStart(Element jspElement, String cdata, Class expectedType) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "cdata =[" + cdata + "]");
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "cdata.indexOf('${') =[" + cdata.indexOf("${") + "]");
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "cdata.indexOf('#{') =[" + cdata.indexOf("#{") + "]");
        }
        if (cdata.indexOf("${") == -1 && cdata.indexOf("#{") == -1) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "calling ELValidator.getELExpressions");
        }
        String[] expressions = ELValidator.getELExpressions(cdata, this.jspConfiguration, this.evalQuotedAndEscapedExpression);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "expressions returned: [" + expressions + "]");
        }
        if (expressions != null) {
            for (int i = 0; i < expressions.length; ++i) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "about to validate expression: [" + expressions[i] + "]");
                }
                ELValidator.validateELExpression(jspElement, expressions[i], expectedType, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
            }
        }
    }

    protected String getAttributeValue(Element element, String attributeName) {
        String attributeValue = element.getAttribute(attributeName);
        if (attributeValue.equals("")) {
            NodeList nl = element.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Element e;
                Node n = nl.item(i);
                if (n.getNodeType() != 1 || (e = (Element)n).getNamespaceURI() == null || !e.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !e.getLocalName().equals("attribute")) continue;
                String name = e.getAttribute("name");
                if (name.indexOf(58) != -1) {
                    name = name.substring(name.indexOf(58) + 1);
                }
                if (!name.equals(attributeName)) continue;
                Node attrChildNode = e.getFirstChild();
                CDATASection cdata = null;
                if (attrChildNode.getNodeType() == 4) {
                    cdata = (CDATASection)attrChildNode;
                } else if (attrChildNode instanceof Element && attrChildNode.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && attrChildNode.getLocalName().equals("text")) {
                    Element jspElement = (Element)attrChildNode;
                    cdata = (CDATASection)jspElement.getFirstChild();
                }
                attributeValue = cdata.getData();
                if (e.getAttribute("trim").equals("false")) continue;
                attributeValue = attributeValue.trim();
            }
        }
        if (attributeValue == null) {
            attributeValue = "";
        }
        return attributeValue;
    }

    protected static List getAttributeList(Element jspElement) throws JspCoreException {
        return ValidateVisitor.getAttributeList(jspElement, false);
    }

    protected static List getAttributeList(Element jspElement, boolean ignoreDuplicates) throws JspCoreException {
        ArrayList<String> attributeList = new ArrayList<String>(11);
        NamedNodeMap nnmTop = jspElement.getAttributes();
        for (int i = 0; i < nnmTop.getLength(); ++i) {
            Node parentNode = nnmTop.item(i);
            String nodeName = parentNode.getNodeName();
            if (nodeName.equals("jsp:id")) continue;
            if (attributeList.contains(nodeName)) {
                if (ignoreDuplicates) continue;
                throw new JspTranslationException(jspElement, "jsp.error.multiple.attribute.definitions", new Object[]{nodeName, jspElement.getTagName()});
            }
            attributeList.add(nodeName);
        }
        NodeList nl = jspElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || (e = (Element)n).getNamespaceURI() == null || !e.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !e.getLocalName().equals("attribute")) continue;
            NamedNodeMap nnmChild = e.getAttributes();
            String nodeName = e.getAttribute("name");
            if (nodeName.indexOf(58) != -1) {
                nodeName = nodeName.substring(nodeName.indexOf(58) + 1);
            }
            if (attributeList.contains(nodeName)) {
                if (ignoreDuplicates) continue;
                throw new JspTranslationException(jspElement, "jsp.error.multiple.attribute.definitions", new Object[]{nodeName, jspElement.getTagName()});
            }
            attributeList.add(nodeName);
        }
        return attributeList;
    }

    protected CustomTagInstance validateCustomTagAttributeValues(Element jspElement, TagAttributeInfo[] attributes, boolean hasDynamicAttributes, TagLibraryInfoImpl tli) throws JspCoreException {
        boolean checkDeferred;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "Entry");
        }
        Hashtable<String, Object> attributeMap = new Hashtable<String, Object>(11);
        boolean isScriptless = true;
        boolean bl = checkDeferred = !this.jspConfiguration.isDeferredSyntaxAllowedAsLiteral();
        if (tli.getRequiredVersion() != null) {
            checkDeferred = checkDeferred && !tli.getRequiredVersion().equals("2.0") && !tli.getRequiredVersion().equals("1.2");
        }
        NamedNodeMap nnmTop = jspElement.getAttributes();
        for (int i = 0; i < nnmTop.getLength(); ++i) {
            Node parentNode = nnmTop.item(i);
            String nodeName = parentNode.getNodeName();
            String nodeValue = parentNode.getNodeValue();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "nodeName =[" + nodeName + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "nodeValue =[" + nodeValue + "]");
            }
            if (nodeName.equals("jsp:id") || nodeName.startsWith("xmlns")) continue;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "NOT jsp:id and NOT xmlns");
            }
            TagAttributeInfo tai = this.getTagAttributeInfo(attributes, nodeName);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "attributes [" + attributes + "] nodeName [" + nodeName + "]  nodeValue [" + nodeValue + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "tai [" + tai + "]");
            }
            boolean dynamicDeferredMethod = false;
            String dynamicDeferredMethodSignature = null;
            if (tai == null && !hasDynamicAttributes) {
                throw new JspTranslationException(jspElement, "jsp.error.unable.locate.tagname", new Object[]{nodeName});
            }
            isScriptless = this.validateCustomTagAttribute(jspElement, attributeMap, isScriptless, checkDeferred, nodeName, tai, nodeValue, dynamicDeferredMethod, dynamicDeferredMethodSignature);
        }
        NodeList nl = jspElement.getChildNodes();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "nl.getLength() =[" + nl.getLength() + "]");
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "n.getNodeName() =[" + n.getNodeName() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "n.getNodeType() =[" + n.getNodeType() + "]");
            }
            if (n.getNodeType() != 1) continue;
            Element e = (Element)n;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "e.getNamespaceURI() =[" + e.getNamespaceURI() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "e.getLocalName() =[" + e.getLocalName() + "]");
            }
            if (e.getNamespaceURI() == null || !e.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !e.getLocalName().equals("attribute")) continue;
            String nodeName = e.getAttribute("name");
            if (nodeName.indexOf(":") != -1) {
                nodeName = nodeName.substring(nodeName.indexOf(58) + 1);
            }
            boolean trim = true;
            if (!e.getAttribute("trim").equals("")) {
                trim = Boolean.valueOf(e.getAttribute("trim"));
            }
            NodeList childAttributeNodeList = e.getChildNodes();
            TagAttributeInfo tai = this.getTagAttributeInfo(attributes, nodeName);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "attributes [" + attributes + "] nodeName [" + nodeName + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "tai [" + tai + "]");
            }
            boolean isFragment = false;
            boolean dynamicDeferredMethod = false;
            String dynamicDeferredMethodSignature = null;
            if (tai == null) {
                if (!hasDynamicAttributes) {
                    throw new JspTranslationException(jspElement, "jsp.error.unable.locate.tagname", new Object[]{nodeName});
                }
            } else {
                isFragment = tai.isFragment();
            }
            if (e.hasChildNodes()) {
                int numChildren = childAttributeNodeList.getLength();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "numChildren =[" + numChildren + "]");
                }
                if (numChildren == 1) {
                    Node childAttrNode = e.getFirstChild();
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "childAttrNode.getNodeName(): " + childAttrNode.getNodeName());
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "childAttrNode.getNodeType(): " + childAttrNode.getNodeType());
                    }
                    if (childAttrNode.getNodeType() == 4) {
                        CDATASection cdata = (CDATASection)childAttrNode;
                        String nodeValue = cdata.getData();
                        if (trim) {
                            nodeValue = nodeValue.trim();
                        }
                        isScriptless = this.validateCustomTagAttribute(jspElement, attributeMap, isScriptless, checkDeferred, nodeName, tai, nodeValue, dynamicDeferredMethod, dynamicDeferredMethodSignature);
                        continue;
                    }
                    if (childAttrNode.getNodeType() != 1) continue;
                    if (!this.areChildrenScriptless(e)) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "Element children are not scriptless.");
                        }
                        if (tai != null && !tai.canBeRequestTime()) {
                            throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time", new Object[]{nodeName, childAttrNode.getNodeValue()});
                        }
                        isScriptless = false;
                        attributeMap.put(nodeName, TagData.REQUEST_TIME_VALUE);
                        continue;
                    }
                    attributeMap.put(nodeName, TagData.REQUEST_TIME_VALUE);
                    continue;
                }
                int childrenWithValues = 0;
                boolean previousCData = false;
                for (int child = 0; child < numChildren; ++child) {
                    Node currNode = childAttributeNodeList.item(child);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "currNode.getNodeName(): " + currNode.getNodeName());
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "currNode.getNodeType(): " + currNode.getNodeType());
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "currNode.getNodeValue(): " + currNode.getNodeValue());
                    }
                    if (currNode.getNodeType() == 4) {
                        CDATASection cdata = (CDATASection)currNode;
                        String nodeValue = cdata.getData();
                        if (trim) {
                            nodeValue = nodeValue.trim();
                        }
                        if (nodeValue.length() <= 0) continue;
                        if (!previousCData) {
                            ++childrenWithValues;
                        }
                        previousCData = true;
                        continue;
                    }
                    if (currNode.getNodeType() == 1) {
                        Element e1 = (Element)currNode;
                        if (this.areChildrenScriptless(e)) continue;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues 2", "2. Element children are not scriptless.");
                        }
                        if (tai != null && !tai.canBeRequestTime()) {
                            throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time", new Object[]{nodeName, currNode.getNodeValue()});
                        }
                        isScriptless = false;
                        continue;
                    }
                    ++childrenWithValues;
                }
                if (isFragment && childrenWithValues > 1) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "childrenWithValues =[" + childrenWithValues + "]");
                    }
                    throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time.fragment", new Object[]{nodeName});
                }
                attributeMap.put(nodeName, TagData.REQUEST_TIME_VALUE);
                continue;
            }
            attributeMap.put(nodeName, "");
        }
        return new CustomTagInstance(attributeMap, isScriptless);
    }

    private boolean validateCustomTagAttribute(Element jspElement, Hashtable attributeMap, boolean isScriptless, boolean checkDeferred, String nodeName, TagAttributeInfo tai, String nodeValue, boolean dynamicDeferredMethod, String dynamicDeferredMethodSignature) throws JspTranslationException, JspCoreException {
        boolean expression;
        boolean isExpr = JspTranslatorUtil.isExpression(nodeValue);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "about to call JspTranslatorUtil.isELInterpreterInput(nodeValue, jspConfiguration)");
        }
        boolean isElExpr = JspTranslatorUtil.isELInterpreterInput(nodeValue, this.jspConfiguration, checkDeferred);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "isExpr =[" + isExpr + "] isElExpr= [" + isElExpr + "]");
            if (tai != null) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "tai.canBeRequestTime() =[" + tai.canBeRequestTime() + "] tai.isDeferredMethod()= [" + tai.isDeferredMethod() + "] tai.isDeferredValue()= [" + tai.isDeferredValue() + "]");
            } else {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "tai is null, must be a dynamic attribute");
            }
        }
        boolean elExpression = false;
        boolean deferred = false;
        boolean deferredValueIsLiteral = this.jspConfiguration.isDeferredSyntaxAllowedAsLiteral();
        ELNode.Nodes el = null;
        if (!(isExpr || this.jspConfiguration.elIgnored() || this.jspConfiguration.elIgnoredSetTrueInPage() || this.jspConfiguration.elIgnoredSetTrueInPropGrp())) {
            el = ELParser.parse(nodeValue);
            Iterator<ELNode> nodes = el.iterator();
            while (nodes.hasNext()) {
                ELNode node = nodes.next();
                if (!(node instanceof ELNode.Root)) continue;
                if (((ELNode.Root)node).getType() == '$') {
                    elExpression = true;
                    continue;
                }
                if (!checkDeferred || ((ELNode.Root)node).getType() != '#') continue;
                elExpression = true;
                deferred = true;
            }
        }
        boolean bl = expression = isExpr || elExpression;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "nodeValue [" + nodeValue + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "deferred [" + deferred + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "deferredValueIsLiteral [" + deferredValueIsLiteral + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "checkDeferred [" + checkDeferred + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "expression [" + expression + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "isExpr [" + isExpr + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "jspConfiguration.elIgnored() [" + this.jspConfiguration.elIgnored() + "]");
        }
        boolean thisIsADynamicAttribute = false;
        if (tai == null) {
            thisIsADynamicAttribute = true;
        }
        if (thisIsADynamicAttribute || tai.canBeRequestTime() || tai.isDeferredMethod() || tai.isDeferredValue()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "in tai check nodeValue [" + nodeValue + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "in tai check deferred [" + deferred + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "in tai check deferredValueIsLiteral [" + deferredValueIsLiteral + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "in tai check checkDeferred [" + checkDeferred + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "in tai check expression [" + expression + "]");
            }
            String expectedType = null;
            boolean taiIsDeferredMethod = dynamicDeferredMethod;
            boolean taiIsDeferredValue = deferred;
            String taiGetMethodSignature = dynamicDeferredMethodSignature;
            String taiGetExpectedTypeName = "java.lang.Object";
            String taiGetName = nodeName;
            boolean taiCanBeRequestTime = true;
            if (tai != null) {
                taiIsDeferredMethod = tai.isDeferredMethod();
                taiIsDeferredValue = tai.isDeferredValue();
                taiGetMethodSignature = tai.getMethodSignature();
                taiGetExpectedTypeName = tai.getExpectedTypeName();
                taiGetName = tai.getName();
                taiCanBeRequestTime = tai.canBeRequestTime();
            }
            if (!expression) {
                if (taiIsDeferredMethod) {
                    String m = taiGetMethodSignature;
                    if (m != null) {
                        int rti = m.trim().indexOf(32);
                        if (rti > 0) {
                            expectedType = m.substring(0, rti).trim();
                        }
                    } else {
                        expectedType = "java.lang.Object";
                    }
                }
                if (taiIsDeferredValue) {
                    expectedType = taiGetExpectedTypeName;
                }
                if (expectedType != null) {
                    Class expectedClass = String.class;
                    try {
                        expectedClass = JspTranslatorUtil.toClass(expectedType, this.context.getJspClassloaderContext().getClassLoader());
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new JspTranslationException(jspElement, "jsp.error.unknown_attribute_type", new Object[]{taiGetName, expectedType});
                    }
                    try {
                        ELSupport.checkType(nodeValue, expectedClass);
                    }
                    catch (Exception excep) {
                        throw new JspTranslationException(jspElement, "jsp.error.coerce_to_type", new Object[]{taiGetName, expectedType, nodeValue});
                    }
                }
                attributeMap.put(nodeName, nodeValue);
            } else {
                if (isExpr) {
                    isScriptless = false;
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "isScriptless =[" + isScriptless + "]");
                }
                if (deferred && !taiIsDeferredMethod && !taiIsDeferredValue) {
                    throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time", new Object[]{nodeName, nodeValue});
                }
                if (!deferred && !taiCanBeRequestTime) {
                    throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time", new Object[]{nodeName, nodeValue});
                }
                if (elExpression) {
                    expectedType = taiGetExpectedTypeName;
                    if (expectedType == null) {
                        expectedType = "java.lang.Object";
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "about to call validateELExpression, expectedType =[" + expectedType + "]");
                    }
                    ELValidator.validateELExpression(jspElement, nodeValue, expectedType, this.jspConfiguration, this.context, this.result, this.prefixToUriMap);
                }
                attributeMap.put(nodeName, TagData.REQUEST_TIME_VALUE);
            }
        } else {
            if (expression) {
                throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time", new Object[]{nodeName, nodeValue});
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "Adding to attribute map nodeName =[" + nodeName + "] nodeValue =[" + nodeValue + "]");
            }
            attributeMap.put(nodeName, nodeValue);
        }
        return isScriptless;
    }

    protected void validateRequiredAttributes(Element jspElement, List specifiedActionAttrs, String[] requiredAttrs) throws JspCoreException {
        for (int i = 0; i < requiredAttrs.length; ++i) {
            if (specifiedActionAttrs.contains(requiredAttrs[i])) continue;
            throw new JspTranslationException(jspElement, "jsp.error.missing.required.attribute", new Object[]{requiredAttrs[i], jspElement.getTagName()});
        }
    }

    protected void validateCustomTagAttributes(Element jspElement, TagAttributeInfo[] attributes) throws JspCoreException {
        NodeList nl = jspElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || (e = (Element)n).getNamespaceURI() == null || !e.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !e.getLocalName().equals("attribute")) continue;
            NamedNodeMap nnmChild = e.getAttributes();
            String nodeName = e.getAttribute("name");
            if (nodeName.indexOf(":") != -1) {
                nodeName = nodeName.substring(nodeName.indexOf(58) + 1);
            }
            for (int attrIndex = 0; attrIndex < attributes.length; ++attrIndex) {
                TagAttributeInfo tai = attributes[attrIndex];
                String taiName = tai.getName();
                if (taiName == null || !taiName.equals(nodeName) || !tai.isFragment()) continue;
                NodeList attrNodeList = e.getChildNodes();
                for (int attrNodesIndex = 0; attrNodesIndex < attrNodeList.getLength(); ++attrNodesIndex) {
                    Element attrNodeElement;
                    Node attrNode = attrNodeList.item(attrNodesIndex);
                    if (attrNode.getNodeType() != 1 || (attrNodeElement = (Element)attrNode).getNamespaceURI() == null || !attrNodeElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !attrNodeElement.getLocalName().equals("scriptlet") && !attrNodeElement.getLocalName().equals("expression") && !attrNodeElement.getLocalName().equals("declaration")) continue;
                    throw new JspTranslationException(jspElement, "jsp.error.attribute.fragment.cannot.be.scriplet", new Object[]{attrNodeElement.getNodeName()});
                }
            }
        }
    }

    protected TagAttributeInfo getTagAttributeInfo(TagAttributeInfo[] attributes, String nodeName) {
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(nodeName)) continue;
            return attributes[i];
        }
        return null;
    }

    protected boolean areChildrenScriptless(Element jspElement) {
        NodeList nl = jspElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            Element e = (Element)n;
            if (e.getNamespaceURI() != null && e.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                if (e.getLocalName().equals("scriptlet") || e.getLocalName().equals("expression") || e.getLocalName().equals("declaration")) {
                    return false;
                }
                for (int j = 0; j < ATTR_STANDARD_ACTIONS.length; ++j) {
                    if (!e.getLocalName().equals(ATTR_STANDARD_ACTIONS[j])) continue;
                    NamedNodeMap attrs = e.getAttributes();
                    if (attrs != null) {
                        for (int k = 0; k < attrs.getLength(); ++k) {
                            if (!JspTranslatorUtil.isExpression(attrs.item(k).getNodeValue(), true)) continue;
                            return false;
                        }
                    }
                    if (this.areChildrenScriptless(e)) continue;
                    return false;
                }
                continue;
            }
            if (this.areChildrenScriptless(e)) continue;
            return false;
        }
        return true;
    }

    private ValidateTagInfo getTagInfo(Element jspElement, String uri, String prefix, String tagName) throws JspCoreException {
        TagInfo ti;
        TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
        boolean isTagFile = false;
        if (tli == null) {
            tli = this.tagLibraryCache.getTagLibraryInfo(uri, prefix, this.jspUri);
            if (tli != null) {
                if (tli.getTldFilePath() != null && tli.getInputSource().getAbsoluteURL().getProtocol().equals("file") && !this.tagLibraryCache.getImplicitTagLibPrefixMap().containsValue(uri)) {
                    this.result.getDependencyList().add(tli.getTldFilePath());
                }
                this.result.getTagLibMap().put(uri, tli);
                tli.setTagLibMap(this.result.getTagLibMap());
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "visitCustomTagStart", "getTagLibraryInfos() =[" + tli.getTagLibraryInfos() + "]");
                }
                this.prefixToUriMap.put(prefix, uri);
                this.validateTagLib(jspElement.getOwnerDocument(), uri, prefix, tli);
            } else {
                if (!this.jspConfiguration.isXml()) {
                    if (!uri.equalsIgnoreCase("http://java.sun.com/JSP/Page")) {
                        throw new JspTranslationException(jspElement, "jsp.error.tld.not.found", new Object[]{uri, prefix});
                    }
                    return null;
                }
                return null;
            }
        }
        if ((ti = tli.getTag(tagName)) == null) {
            TagFileInfo tfi = tli.getTagFile(tagName);
            if (tfi == null) {
                throw new JspTranslationException(jspElement, "jsp.error.tagfile.not.found", new Object[]{tagName});
            }
            ti = tfi.getTagInfo();
            this.tagLibraryCache.addTagFileClassInfo(tfi);
            isTagFile = true;
        }
        return new ValidateTagInfo(ti, tli, isTagFile);
    }

    protected boolean shouldSkipChildrenForThisVisitor() {
        return true;
    }

    protected boolean isElementTagDependent(Element jspElement) throws JspCoreException {
        String tagName;
        String prefix;
        String uri = jspElement.getNamespaceURI();
        ValidateTagInfo vti = this.getTagInfo(jspElement, uri, prefix = jspElement.getPrefix(), tagName = jspElement.getLocalName());
        if (vti == null) {
            return false;
        }
        String bodyContent = vti.getTagInfo().getBodyContent();
        if (bodyContent == null) {
            return false;
        }
        return bodyContent.equalsIgnoreCase("tagdependent");
    }

    protected class CustomTagInstance {
        private Hashtable attributes;
        private boolean isScriptless = true;

        protected CustomTagInstance(Hashtable attrs, boolean isScriptless) {
            this.attributes = attrs;
            this.isScriptless = isScriptless;
        }

        protected Hashtable getAttributes() {
            return this.attributes;
        }

        protected boolean isScriptless() {
            return this.isScriptless;
        }
    }

    protected class ValidateTagInfo {
        private TagInfo tagInfo;
        private TagLibraryInfoImpl tli;
        private boolean tagFile;

        protected ValidateTagInfo(TagInfo tagInfo, TagLibraryInfoImpl tli, boolean tagFile) {
            this.tagInfo = tagInfo;
            this.tli = tli;
            this.tagFile = tagFile;
        }

        protected TagInfo getTagInfo() {
            return this.tagInfo;
        }

        protected TagLibraryInfoImpl getTLI() {
            return this.tli;
        }

        protected boolean isTagFile() {
            return this.tagFile;
        }
    }
}

