/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.validator;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagFileTagInfo;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateTagFileResult;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateVisitor;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.util.HashMap;
import java.util.List;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ValidateTagFileVisitor
extends ValidateVisitor {
    private static final String[] invokeAttrNames = new String[]{"fragment", "var", "varReader", "scope"};
    private static final String[] doBodyAttrNames = new String[]{"var", "varReader", "scope"};
    private static final String[] tagDirectiveAttrNames = new String[]{"display-name", "body-content", "dynamic-attributes", "small-icon", "large-icon", "description", "example", "language", "import", "pageEncoding", "isELIgnored", "trimDirectiveWhitespaces", "deferredSyntaxAllowedAsLiteral"};
    private static final String[] attributeDirectiveAttrNames = new String[]{"name", "required", "fragment", "rtexprvalue", "type", "description"};
    private static final String[] attributeDirectiveAttrNames21 = new String[]{"name", "required", "fragment", "rtexprvalue", "type", "description", "deferredValue", "deferredValueType", "deferredMethod", "deferredMethodSignature"};
    private static final String[] variableDirectiveAttrNames = new String[]{"name-given", "name-from-attribute", "alias", "variable-class", "declare", "scope", "description"};
    private static final String[] invokeRequiredAttrs = new String[]{"fragment"};
    private static final String[] attributeDirectiveRequiredAttrs = new String[]{"name"};
    private HashMap userDefinedDirectives = new HashMap();

    public ValidateTagFileVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        super(visitorUsage, jspConfiguration, context, resultMap, inputMap);
        this.result = new ValidateTagFileResult(visitorUsage.getJspVisitorDefinition().getId());
    }

    public JspVisitorResult getResult() throws JspCoreException {
        return this.result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void visitTagDirectiveStart(Element jspElement) throws JspCoreException {
        this.validateAttributes(jspElement, tagDirectiveAttrNames);
        ValidateTagFileResult tagFileResult = (ValidateTagFileResult)this.result;
        NamedNodeMap attributes = jspElement.getAttributes();
        if (attributes == null) throw new JspTranslationException(jspElement, "jsp.error.page.directive.contains.no.attributes");
        for (int i = 0; i < attributes.getLength(); ++i) {
            String directiveValue;
            Node attribute = attributes.item(i);
            String directiveName = attribute.getNodeName();
            Object oldDirectiveValue = this.addUserTagDirective(directiveName, directiveValue = attribute.getNodeValue());
            if (!(oldDirectiveValue == null || directiveName.equals("import") || directiveName.equals("jsp:id") || oldDirectiveValue.equals(directiveValue))) {
                throw new JspTranslationException(jspElement, "jsp.error.multiple.occurrences.tag.directive", new Object[]{directiveName, oldDirectiveValue, directiveValue});
            }
            boolean valid = false;
            if (directiveName.equals("language")) {
                valid = true;
                this.result.setLanguage(directiveValue);
            } else if (directiveName.equals("import")) {
                valid = true;
            } else if (directiveName.equals("pageEncoding")) {
                valid = true;
                this.result.setPageEncoding(directiveValue);
            } else if (directiveName.equals("isELIgnored")) {
                valid = true;
                if (directiveValue.equalsIgnoreCase("true")) {
                    this.result.setIsELIgnored(true);
                    this.jspConfiguration.setElIgnored(true);
                    this.jspConfiguration.setElIgnoredSetTrueInPage(true);
                } else {
                    if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.page.invalid.iselignored");
                    this.result.setIsELIgnored(false);
                    this.jspConfiguration.setElIgnored(false);
                }
            } else if (directiveName.equals("display-name")) {
                valid = true;
                tagFileResult.setDisplayName(directiveValue);
            } else if (directiveName.equals("body-content")) {
                if (!directiveValue.equals("scriptless") && !directiveValue.equals("tagdependent") && !directiveValue.equals("empty")) throw new JspTranslationException(jspElement, "jsp.body-content.directive.value.invalid", new Object[]{directiveValue});
                valid = true;
                tagFileResult.setBodyContent(directiveValue);
            } else if (directiveName.equals("dynamic-attributes")) {
                valid = true;
                tagFileResult.setDynamicAttributes(directiveValue);
            } else if (directiveName.equals("small-icon")) {
                valid = true;
                tagFileResult.setSmallIcon(directiveValue);
            } else if (directiveName.equals("large-icon")) {
                valid = true;
                tagFileResult.setLargeIcon(directiveValue);
            } else if (directiveName.equals("description")) {
                valid = true;
                tagFileResult.setDescription(directiveValue);
            } else if (directiveName.equals("example")) {
                valid = true;
                tagFileResult.setExample(directiveValue);
            } else if (directiveName.equals("jsp:id")) {
                valid = true;
            } else if (directiveName.startsWith("xmlns")) {
                valid = true;
            } else if (directiveName.equals("trimDirectiveWhitespaces")) {
                valid = true;
                if (this.jspConfiguration.getTrimDirectiveWhitespaces() == null) {
                    if (directiveValue.equalsIgnoreCase("true")) {
                        this.result.setTrimDirectiveWhitespaces(true);
                        this.jspConfiguration.setTrimDirectiveWhitespaces(true);
                    } else {
                        if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.page.invalid.trimdirectivewhitespaces");
                        this.result.setTrimDirectiveWhitespaces(false);
                        this.jspConfiguration.setTrimDirectiveWhitespaces(false);
                    }
                } else if (!this.jspConfiguration.getTrimDirectiveWhitespaces().equals(directiveValue)) {
                    throw new JspTranslationException(jspElement, "jsp.error.page.conflict.trimdirectivewhitespaces", new Object[]{this.jspConfiguration.getTrimDirectiveWhitespaces(), directiveName});
                }
            } else if (directiveName.equals("deferredSyntaxAllowedAsLiteral")) {
                valid = true;
                if (this.jspConfiguration.getDeferredSyntaxAllowedAsLiteral() == null) {
                    if (directiveValue.equalsIgnoreCase("true")) {
                        this.result.setDeferredSyntaxAllowedAsLiteral(true);
                        this.jspConfiguration.setDeferredSyntaxAllowedAsLiteral(true);
                    } else {
                        if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.page.invalid.deferredsyntaxallowedasliteral");
                        this.result.setDeferredSyntaxAllowedAsLiteral(false);
                        this.jspConfiguration.setDeferredSyntaxAllowedAsLiteral(false);
                    }
                } else if (!this.jspConfiguration.getDeferredSyntaxAllowedAsLiteral().equals(directiveValue)) {
                    throw new JspTranslationException(jspElement, "jsp.error.page.conflict.deferredsyntaxallowedasliteral");
                }
            }
            if (valid) continue;
            throw new JspTranslationException(jspElement, "jsp.error.page.directive.unknown", new Object[]{directiveName});
        }
    }

    protected void visitPageDirectiveStart(Element jspElement) throws JspCoreException {
        throw new JspTranslationException(jspElement, "jsp.error.page.directive.only.in.jsps");
    }

    protected void visitJspInvokeStart(Element jspElement) throws JspCoreException {
        List specifiedStandardActionAttrs = ValidateTagFileVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, invokeRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, invokeAttrNames);
        this.validateEmptyBody(jspElement);
        if (jspElement.hasAttribute("var") && jspElement.hasAttribute("varReader")) {
            throw new JspTranslationException(jspElement, "jsp.error.tagfile.invoke.var_varreader");
        }
        if (jspElement.hasAttribute("scope") && !jspElement.hasAttribute("var") && !jspElement.hasAttribute("varReader")) {
            throw new JspTranslationException(jspElement, "jsp.error.tagfile.invoke.scope_var_varreader");
        }
        Attr scopeAttr = jspElement.getAttributeNode("scope");
        if (scopeAttr != null) {
            boolean valid = false;
            if (scopeAttr.getValue().equals("page")) {
                valid = true;
            } else if (scopeAttr.getValue().equals("request")) {
                valid = true;
            } else if (scopeAttr.getValue().equals("session")) {
                valid = true;
            } else if (scopeAttr.getValue().equals("application")) {
                valid = true;
            }
            if (!valid) {
                throw new JspTranslationException(jspElement, "jsp.error.tagfile.invoke.scope_invalid");
            }
        }
    }

    protected void visitJspDoBodyStart(Element jspElement) throws JspCoreException {
        List specifiedStandardActionAttrs = ValidateTagFileVisitor.getAttributeList(jspElement);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, doBodyAttrNames);
        this.validateEmptyBody(jspElement);
        Attr varAttr = jspElement.getAttributeNode("var");
        Attr varReaderAttr = jspElement.getAttributeNode("varReader");
        if (varAttr != null && varReaderAttr != null) {
            throw new JspTranslationException(jspElement, "jsp.error.tagfile.dobody.var_varreader");
        }
        if (jspElement.hasAttribute("scope") && !jspElement.hasAttribute("var") && !jspElement.hasAttribute("varReader")) {
            throw new JspTranslationException(jspElement, "jsp.error.tagfile.dobody.scope_var_varreader");
        }
        Attr scopeAttr = jspElement.getAttributeNode("scope");
        if (scopeAttr != null) {
            boolean valid = false;
            if (scopeAttr.getValue().equals("page")) {
                valid = true;
            } else if (scopeAttr.getValue().equals("request")) {
                valid = true;
            } else if (scopeAttr.getValue().equals("session")) {
                valid = true;
            } else if (scopeAttr.getValue().equals("application")) {
                valid = true;
            }
            if (!valid) {
                throw new JspTranslationException(jspElement, "jsp.error.tagfile.dobody.scope_invalid");
            }
        }
    }

    protected void visitAttributeDirectiveStart(Element jspElement) throws JspCoreException {
        TagFileTagInfo tfti;
        TagFileInfo tfi;
        TagInfo ti;
        List specifiedStandardActionAttrs = ValidateTagFileVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, attributeDirectiveRequiredAttrs);
        if (Float.valueOf(this.jspConfiguration.getJspVersion()).floatValue() >= JspConfiguration.twoPointOne.floatValue()) {
            this.validateAttributes(specifiedStandardActionAttrs, jspElement, attributeDirectiveAttrNames21);
        } else {
            this.validateAttributes(specifiedStandardActionAttrs, jspElement, attributeDirectiveAttrNames);
        }
        Attr nameAttr = jspElement.getAttributeNode("name");
        if (nameAttr != null && (ti = (tfi = (TagFileInfo)this.inputMap.get("TagFileInfo")).getTagInfo()) instanceof TagFileTagInfo && (tfti = (TagFileTagInfo)ti).getDynamicAttributesMapName() != null && tfti.getDynamicAttributesMapName().equals(nameAttr.getValue())) {
            throw new JspTranslationException(jspElement, "jsp.error.tagfile.tag_dynamic_attrs_equals_attr_name");
        }
    }

    protected void visitVariableDirectiveStart(Element jspElement) throws JspCoreException {
        TagFileTagInfo tfti;
        TagFileInfo tfi;
        TagInfo ti;
        this.validateAttributes(jspElement, variableDirectiveAttrNames);
        Attr nameGivenAttr = jspElement.getAttributeNode("name-given");
        if (nameGivenAttr != null && (ti = (tfi = (TagFileInfo)this.inputMap.get("TagFileInfo")).getTagInfo()) instanceof TagFileTagInfo && (tfti = (TagFileTagInfo)ti).getDynamicAttributesMapName() != null && tfti.getDynamicAttributesMapName().equals(nameGivenAttr.getValue())) {
            throw new JspTranslationException(jspElement, "jsp.error.tagfile.tag_dynamic_attrs_equals_var_name_given");
        }
    }

    protected Object addUserTagDirective(String directiveName, String directiveValue) {
        return this.userDefinedDirectives.put(directiveName, directiveValue);
    }
}

