/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.validator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.visitor.validator.FVVisitor;
import com.ibm.ws.jsp.translator.visitor.validator.MapperELVisitor;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateFunctionMapper;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import org.apache.jasper.compiler.ELNode;
import org.apache.jasper.compiler.ELParser;
import org.apache.jasper.el.ELContextImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ELValidator {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.validator.ELValidator";

    protected static void validateELExpression(Element jspElement, String expression, Class expectedType, JspConfiguration jspConfiguration, ValidateResult result, JspCoreContext context, HashMap prefixToUriMap) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "expression= [" + expression + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "jspConfiguration.elIgnored() =[" + jspConfiguration.elIgnored() + "]");
        }
        if (JspTranslatorUtil.isELInterpreterInput(expression, jspConfiguration)) {
            try {
                int index = expression.indexOf("#{");
                if (index != -1) {
                    String uri = jspElement.getNamespaceURI();
                    if (!jspConfiguration.isDeferredSyntaxAllowedAsLiteral() && uri == null) {
                        throw new JspTranslationException(jspElement, "jsp.error.el.template.deferred", new Object[]{"#{"});
                    }
                    if (!jspConfiguration.isDeferredSyntaxAllowedAsLiteral() && uri != null) {
                        String prefix = jspElement.getPrefix();
                        String tagName = jspElement.getLocalName();
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression ", "uri= [" + uri + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression ", "prefix =[" + prefix + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression ", "tagName =[" + tagName + "]");
                        }
                        if (uri.startsWith("urn:jsptld:")) {
                            uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
                        } else if (uri.startsWith("urn:jsptagdir:")) {
                            uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
                        }
                        TagLibraryInfoImpl tli = result.getTagLibMap().get(uri);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression ", "uri 2= [" + uri + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression ", "tli =[" + tli + "]");
                            if (tli != null) {
                                logger.logp(Level.FINER, CLASS_NAME, "validateELExpression ", "tli.getRequiredVersion() =[" + tli.getRequiredVersion() + "]");
                            }
                        }
                        if (tli == null) {
                            throw new JspTranslationException(jspElement, "jsp.error.el.template.deferred", new Object[]{"#{"});
                        }
                        return;
                    }
                }
                String exprStr = expression;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "exprStr 1= [" + exprStr + "]");
                }
                exprStr = exprStr.replaceAll("&gt;", ">");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "exprStr 2= [" + exprStr + "]");
                }
                exprStr = exprStr.replaceAll("&lt;", "<");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "exprStr 3= [" + exprStr + "]");
                }
                exprStr = exprStr.replaceAll("&amp;", "&");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "exprStr 4= [" + exprStr + "]");
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "jspElement= [" + jspElement + "]");
                }
                ELValidator.validateElFunction(jspElement, exprStr, result, context.getJspClassloaderContext().getClassLoader(), jspConfiguration, prefixToUriMap);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "exprStr 5= [" + exprStr + "]");
                    logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 1", "jspElement= [" + jspElement + "]");
                }
                ELNode.Nodes el = ELParser.parse(exprStr);
                ELValidator.prepareExpression(el, jspElement, exprStr, result, context.getJspClassloaderContext().getClassLoader(), jspConfiguration, prefixToUriMap);
            }
            catch (ELException ele) {
                throw new JspTranslationException(jspElement, "failed.to.parse.el.expression", new Object[]{expression}, ele);
            }
        }
    }

    protected static void validateELExpression(Element jspElement, String expression, String expectedType, JspConfiguration jspConfiguration, JspCoreContext context, ValidateResult result, HashMap prefixToUriMap) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 2", "expression= [" + expression + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 2", "expectedType= [" + expectedType + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateELExpression 2", "jspConfiguration.elIgnored() =[" + jspConfiguration.elIgnored() + "]");
        }
        if (JspTranslatorUtil.isELInterpreterInput(expression, jspConfiguration)) {
            try {
                Class clazz = JspTranslatorUtil.toClass(expectedType, context.getJspClassloaderContext().getClassLoader());
                ELValidator.validateELExpression(jspElement, expression, clazz, jspConfiguration, result, context, prefixToUriMap);
            }
            catch (ClassNotFoundException cnfe) {
                throw new JspTranslationException(jspElement, "failed.to.parse.el.expression", new Object[]{expression}, cnfe);
            }
        }
    }

    protected static String[] getELExpressions(String data, JspConfiguration jspConfiguration, boolean evalQuotedAndEscapedExpression) {
        String[] elExpressions = null;
        ArrayList<String> elList = new ArrayList<String>();
        boolean inElExpression = false;
        char[] chars = data.toCharArray();
        StringBuffer sb = null;
        boolean inQuotes = false;
        boolean usingSingleQuotes = false;
        boolean inEscape = false;
        block7: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\'': {
                    if (inElExpression && evalQuotedAndEscapedExpression) {
                        if (inQuotes && usingSingleQuotes && !inEscape) {
                            inQuotes = false;
                            usingSingleQuotes = false;
                        } else {
                            inQuotes = true;
                            usingSingleQuotes = true;
                        }
                    }
                    if (inElExpression) {
                        sb.append(ch);
                    }
                    inEscape = false;
                    continue block7;
                }
                case '\"': {
                    if (inElExpression) {
                        if (evalQuotedAndEscapedExpression) {
                            inQuotes = !inQuotes || usingSingleQuotes || inEscape;
                            if (inEscape) {
                                sb.append('\\');
                            } else {
                                sb.append(ch);
                            }
                        } else {
                            sb.append(ch);
                        }
                    }
                    inEscape = false;
                    continue block7;
                }
                case '\\': {
                    if (evalQuotedAndEscapedExpression) {
                        int nextChar = 32;
                        if (i + 1 < chars.length) {
                            nextChar = chars[i + 1];
                        }
                        int prevChar = 32;
                        if (i - 1 >= 0) {
                            prevChar = chars[i - 1];
                        }
                        if (inEscape) {
                            inEscape = false;
                        } else if (nextChar == 39 || nextChar == 34 || nextChar == 92 || nextChar == 36) {
                            inEscape = true;
                        }
                        if (!inElExpression || inEscape) continue block7;
                        sb.append('\\');
                        sb.append('\\');
                        continue block7;
                    }
                    if (!inElExpression) continue block7;
                    sb.append('\\');
                    continue block7;
                }
                case '#': 
                case '$': {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "case '$' or '#'");
                        logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "jspConfiguration.elIgnored() =[" + jspConfiguration.elIgnored() + "]");
                    }
                    if (!jspConfiguration.elIgnored()) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "i =[" + i + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "chars[i + 1] == '{' =[" + (chars[i + 1] == '{') + "]");
                        }
                        if (chars[i + 1] == '{') {
                            char prevChar = ' ';
                            if (i > 0) {
                                prevChar = chars[i - 1];
                            }
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "prevChar =[" + prevChar + "]");
                            }
                            if (evalQuotedAndEscapedExpression) {
                                if (!inQuotes && !inEscape) {
                                    if (prevChar != '\\' && sb == null) {
                                        sb = new StringBuffer();
                                        sb.append(ch);
                                        inElExpression = true;
                                    } else if (sb != null) {
                                        sb.append(ch);
                                    }
                                } else if (inElExpression) {
                                    sb.append(ch);
                                }
                            } else if (!evalQuotedAndEscapedExpression && prevChar != '\'' && prevChar != '\\') {
                                sb = new StringBuffer();
                                sb.append(ch);
                                inElExpression = true;
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "1 inElExpression =[" + inElExpression + "]");
                        }
                    }
                    inEscape = false;
                    continue block7;
                }
                case '}': {
                    if (evalQuotedAndEscapedExpression) {
                        if (!inQuotes) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "case '}'");
                                logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "jspConfiguration.elIgnored() =[" + jspConfiguration.elIgnored() + "]");
                            }
                            if (!jspConfiguration.elIgnored()) {
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                                    logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "2 inElExpression =[" + inElExpression + "]");
                                }
                                if (inElExpression) {
                                    sb.append(ch);
                                    elList.add(sb.toString());
                                    inElExpression = false;
                                    sb = null;
                                }
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "3 inElExpression =[" + inElExpression + "]");
                                }
                            }
                        } else {
                            sb.append(ch);
                        }
                    } else if (inElExpression) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "chars[i - 1] =[" + chars[i - 1] + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "chars[i - 2] =[" + chars[i - 2] + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "chars[i - 3] =[" + chars[i - 3] + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "chars[i - 4] =[" + chars[i - 4] + "]");
                        }
                        if (chars[i - 1] == '\'' && chars[i - 2] == '{' && (chars[i - 3] == '$' || chars[i - 3] == '#') && chars[i - 4] == '\'') {
                            sb.append(ch);
                        } else {
                            sb.append(ch);
                            elList.add(sb.toString());
                            inElExpression = false;
                            sb = null;
                        }
                    }
                    inEscape = false;
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue block7;
                    logger.logp(Level.FINER, CLASS_NAME, "getELExpressions", "3 inElExpression =[" + inElExpression + "]");
                    continue block7;
                }
                default: {
                    if (sb != null) {
                        sb.append(ch);
                    }
                    inEscape = false;
                }
            }
        }
        if (elList.size() > 0) {
            elExpressions = new String[elList.size()];
            elExpressions = elList.toArray(elExpressions);
        }
        return elExpressions;
    }

    protected static void validateRuntimeExpressions(Element jspElement, String[] validRuntimeAttrs, Class expectedType, JspConfiguration jspConfiguration, ValidateResult result, JspCoreContext context, HashMap prefixToUriMap) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "Entry");
            logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "jspElement =[" + jspElement + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "validRuntimeAttrs =[" + validRuntimeAttrs + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "expectedType =[" + expectedType + "]");
        }
        NamedNodeMap attrs = jspElement.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (attr.getNodeName().equals("jsp:id")) continue;
            String value = attr.getNodeValue();
            boolean valid = false;
            for (int j = 0; j < validRuntimeAttrs.length; ++j) {
                if (!attr.getNodeName().equals(validRuntimeAttrs[j])) continue;
                ELValidator.validateExpressionForScripts(jspElement, value, jspConfiguration);
                valid = true;
                ELValidator.validateELExpression(jspElement, value, expectedType, jspConfiguration, result, context, prefixToUriMap);
                break;
            }
            if (valid) continue;
            if (JspTranslatorUtil.isExpression(value)) {
                throw new JspTranslationException(jspElement, "rt.expression.not.allowed.for.attribute", new Object[]{jspElement.getTagName(), attr.getNodeName(), value});
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "About to check for isELInterpreterInput 1");
            }
            if (!JspTranslatorUtil.isELInterpreterInput(value, jspConfiguration)) continue;
            throw new JspTranslationException(jspElement, "el.expression.not.allowed.for.attribute", new Object[]{jspElement.getTagName(), attr.getNodeName(), value});
        }
        if (validRuntimeAttrs != null) {
            NodeList children = jspElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element childElement;
                Node child = children.item(i);
                if (!(child instanceof Element) || (childElement = (Element)child).getNamespaceURI() == null || !childElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !childElement.getLocalName().equals("attribute")) continue;
                String name = childElement.getAttribute("name");
                if (name.indexOf(":") != -1) {
                    name = name.substring(name.indexOf(58) + 1);
                }
                if (name.equals("")) continue;
                boolean valid = false;
                String value = childElement.getAttribute("value");
                for (int j = 0; j < validRuntimeAttrs.length; ++j) {
                    if (!name.equals(validRuntimeAttrs[j])) continue;
                    valid = true;
                    ELValidator.validateExpressionForScripts(jspElement, value, jspConfiguration);
                    ELValidator.validateELExpression(jspElement, value, expectedType, jspConfiguration, result, context, prefixToUriMap);
                    break;
                }
                if (valid) continue;
                if (JspTranslatorUtil.isExpression(value)) {
                    throw new JspTranslationException(jspElement, "rt.expression.not.allowed.for.attribute", new Object[]{jspElement.getTagName(), child.getNodeName(), value});
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateRuntimeExpressions", "About to check for isELInterpreterInput 2");
                }
                if (!JspTranslatorUtil.isELInterpreterInput(value, jspConfiguration)) continue;
                throw new JspTranslationException(jspElement, "el.expression.not.allowed.for.attribute", new Object[]{jspElement.getTagName(), child.getNodeName(), value});
            }
        }
    }

    private static void validateElFunction(Element jspElement, String expression, ValidateResult result, ClassLoader loader, JspConfiguration jspConfiguration, HashMap prefixToUriMap) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "jspElement= [" + jspElement + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateElFunction", "expression= [" + expression + "]");
        }
        ELNode.Nodes el = ELParser.parse(expression);
        boolean deferred = false;
        Iterator<ELNode> nodes = el.iterator();
        while (nodes.hasNext()) {
            ELNode node = nodes.next();
            if (!(node instanceof ELNode.Root) || ((ELNode.Root)node).getType() != '#') continue;
            deferred = true;
        }
        if (el.containsEL() && !jspConfiguration.elIgnored() && (!jspConfiguration.isDeferredSyntaxAllowedAsLiteral() && deferred || !deferred)) {
            ELValidator.validateFunctions(el, result, jspElement, prefixToUriMap);
            ELContextImpl ctx = new ELContextImpl();
            ctx.setFunctionMapper(ELValidator.getFunctionMapper(el, loader, result));
            try {
                ELValidator.validateEL(jspConfiguration.getExpressionFactory(), ctx, el, expression);
            }
            catch (ELException e) {
                throw new JspTranslationException(jspElement, "jsp.error.el.function.cannot.parse", new Object[]{expression});
            }
        }
    }

    private static void validateExpressionForScripts(Element jspElement, String value, JspConfiguration jspConfiguration) throws JspCoreException {
        if (jspConfiguration.scriptingInvalid() && JspTranslatorUtil.isExpression(value, true)) {
            throw new JspTranslationException(jspElement, "jsp.error.scripting.disabled.for.translation.unit");
        }
    }

    private static void validateEL(ExpressionFactory ef, ELContext ctx, ELNode.Nodes el, String value) throws ELException {
        if (el != null) {
            ValueExpression ve = ef.createValueExpression(ctx, value, String.class);
        }
    }

    private static void validateFunctions(ELNode.Nodes el, ValidateResult result, Element jspElement, HashMap prefixToUriMap) throws JspTranslationException {
        el.visit(new FVVisitor(jspElement, result, prefixToUriMap));
    }

    private static void prepareExpression(ELNode.Nodes el, Element jspElement, String expr, ValidateResult result, ClassLoader loader, JspConfiguration jspConfiguration, HashMap prefixToUriMap) throws JspTranslationException {
        ELValidator.validateFunctions(el, result, jspElement, prefixToUriMap);
        ELContextImpl ctx = new ELContextImpl();
        ctx.setFunctionMapper(ELValidator.getFunctionMapper(el, loader, result));
        ExpressionFactory ef = jspConfiguration.getExpressionFactory();
        try {
            ef.createValueExpression(ctx, expr, Object.class);
        }
        catch (ELException e) {
            // empty catch block
        }
    }

    private static FunctionMapper getFunctionMapper(ELNode.Nodes el, ClassLoader loader, ValidateResult result) throws JspTranslationException {
        ValidateFunctionMapper fmapper = result.getValidateFunctionMapper();
        el.visit(new MapperELVisitor(fmapper, loader));
        return fmapper;
    }
}

