/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.generator.AttributeGenerator;
import com.ibm.ws.jsp.translator.visitor.generator.CodeGeneratorBase;
import com.ibm.ws.jsp.translator.visitor.generator.FragmentHelperClassWriter;
import com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils;
import com.ibm.ws.jsp.translator.visitor.generator.JavaCodeWriter;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextGenerator
extends CodeGeneratorBase {
    protected static final int MAXSIZE = 32768;
    protected static final String STANDARD_PREFIX = "private final static char[] _jsp_string";
    protected static final String STANDARD_SUFFIX = "\".toCharArray();";
    protected boolean elIgnored = false;
    protected boolean deferredIgnored = false;
    protected boolean generate = true;
    protected boolean trim = false;
    protected String attrName = null;
    protected Integer nextStringNum = null;

    public void init(JspCoreContext ctxt, Element element, ValidateResult validatorResult, JspVisitorInputMap inputMap, ArrayList methodWriterList, FragmentHelperClassWriter fragmentHelperClassWriter, HashMap persistentData, JspConfiguration jspConfiguration, JspOptions jspOptions) throws JspCoreException {
        super.init(ctxt, element, validatorResult, inputMap, methodWriterList, fragmentHelperClassWriter, persistentData, jspConfiguration, jspOptions);
        this.elIgnored = jspConfiguration.elIgnored();
        this.deferredIgnored = jspConfiguration.isDeferredSyntaxAllowedAsLiteral();
    }

    public void startGeneration(int section, JavaCodeWriter writer) throws JspCoreException {
        if ((section == 2 || section == 6) && this.element.getFirstChild() instanceof CDATASection) {
            Node parentParent;
            ArrayList jspAttributeList;
            HashMap jspAttributes;
            Node parent;
            if (section == 2) {
                this.nextStringNum = (Integer)this.persistentData.get("nextStringNum");
                if (this.nextStringNum == null) {
                    this.nextStringNum = new Integer(0);
                }
            }
            if ((parent = this.element.getParentNode()).getNamespaceURI() != null && parent.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                NodeList childNodes = parent.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Element childElement;
                    Node child = childNodes.item(i);
                    if (!(child instanceof Element) || (childElement = (Element)child).getNamespaceURI() == null || !childElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !childElement.getLocalName().equals("attribute")) continue;
                    return;
                }
            }
            if (parent.getNamespaceURI() != null && parent.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && parent.getLocalName().equals("attribute") && (jspAttributes = (HashMap)this.persistentData.get("jspAttributes")) != null && (jspAttributeList = (ArrayList)jspAttributes.get(parentParent = parent.getParentNode())) != null) {
                for (AttributeGenerator.JspAttribute jspAttribute : jspAttributeList) {
                    if (!jspAttribute.getJspAttrElement().equals(parent)) continue;
                    if (jspAttribute.isLiteral()) {
                        this.attrName = jspAttribute.getVarName();
                    }
                    this.trim = jspAttribute.trim();
                }
            }
            CDATASection cdata = (CDATASection)this.element.getFirstChild();
            String data = cdata.getData();
            if (this.trim) {
                data = data.trim();
            }
            char[] chars = data.toCharArray();
            int current = 0;
            int limit = chars.length;
            if (section == 6) {
                this.writeDebugStartBegin(writer);
            }
            int newCurrentStringCount = this.nextStringNum;
            while (current < limit) {
                int from = current;
                int to = Math.min(current + 32768, limit);
                newCurrentStringCount = this.generateChunk(chars, writer, from, to, section, newCurrentStringCount);
                current = to;
            }
            if (section == 2) {
                this.persistentData.put("nextStringNum", new Integer(newCurrentStringCount));
            } else {
                this.writeDebugStartEnd(writer);
            }
        }
    }

    public void endGeneration(int section, JavaCodeWriter writer) throws JspCoreException {
    }

    protected int generateChunk(char[] chars, JavaCodeWriter writer, int from, int to, int section, int currentStringCount) {
        int newCurrentStringCount = currentStringCount;
        StringBuffer sb = new StringBuffer();
        boolean inElExpression = false;
        int arraySize = chars.length;
        boolean inQuotes = false;
        boolean usingSingleQuotes = false;
        boolean inEscape = false;
        block11: for (int i = from; i < to; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\'': {
                    if (inElExpression) {
                        if (inQuotes && usingSingleQuotes && !inEscape) {
                            inQuotes = false;
                            usingSingleQuotes = false;
                        } else {
                            inQuotes = true;
                            usingSingleQuotes = true;
                        }
                    }
                    inEscape = false;
                    sb.append(ch);
                    continue block11;
                }
                case '\"': {
                    if (inElExpression) {
                        inQuotes = !inQuotes || usingSingleQuotes || inEscape;
                    }
                    inEscape = false;
                    if (!this.elIgnored && inElExpression) {
                        sb.append("\"");
                        continue block11;
                    }
                    sb.append("\\\"");
                    continue block11;
                }
                case '\\': {
                    int nextChar = 32;
                    if (i + 1 < arraySize) {
                        nextChar = chars[i + 1];
                    }
                    int prevChar = 32;
                    if (i - 1 >= 0) {
                        prevChar = chars[i - 1];
                    }
                    if (inEscape) {
                        inEscape = false;
                    } else if (nextChar == 39 || nextChar == 34 || nextChar == 92 || nextChar == 36) {
                        inEscape = true;
                    }
                    boolean skip = false;
                    if (prevChar == 37 && nextChar == 62 || prevChar == 60 && nextChar == 37) {
                        skip = true;
                    }
                    if (!(this.elIgnored || nextChar != 36 && nextChar != 35)) {
                        skip = true;
                    }
                    if (skip) continue block11;
                    sb.append("\\\\");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '#': {
                    if (this.deferredIgnored) {
                        sb.append(ch);
                        continue block11;
                    }
                }
                case '$': {
                    if (!this.elIgnored && i + 1 < arraySize && chars[i + 1] == '{') {
                        if (!inQuotes && !inEscape) {
                            if (sb.length() > 0) {
                                int stringId;
                                if (section == 2) {
                                    Integer existingStringNumber = this.lookForExistingString(sb.toString());
                                    if (existingStringNumber == null) {
                                        stringId = ++newCurrentStringCount;
                                        this.addExisitingString(sb.toString(), stringId);
                                        sb.insert(0, STANDARD_PREFIX + stringId + " = \"");
                                        writer.print(sb.toString());
                                        writer.print(STANDARD_SUFFIX);
                                        writer.println();
                                    }
                                } else if (section == 6) {
                                    Integer existingStringNumber = this.lookForExistingString(sb.toString());
                                    stringId = 0;
                                    stringId = existingStringNumber != null ? existingStringNumber : ++newCurrentStringCount;
                                    if (this.attrName != null) {
                                        writer.print("String " + this.attrName + " = String.valueOf(_jsp_string" + stringId + ")");
                                        writer.print(";");
                                        writer.println();
                                    } else {
                                        writer.print("out.write(_jsp_string" + stringId + ");");
                                        writer.println();
                                    }
                                }
                                sb = new StringBuffer();
                            }
                            inElExpression = true;
                        }
                        inEscape = false;
                    }
                    sb.append(ch);
                    continue block11;
                }
                case '}': {
                    if (!this.elIgnored && inElExpression) {
                        if (inQuotes) {
                            sb.append(ch);
                            continue block11;
                        }
                        if (section == 6) {
                            sb.append(ch);
                            writer.print("out.write(");
                            writer.print(GeneratorUtils.interpreterCall(this.isTagFile, sb.toString(), String.class, "_jspx_fnmap", false));
                            writer.print(");");
                            writer.println();
                        }
                        sb = new StringBuffer();
                        inElExpression = false;
                        continue block11;
                    }
                    sb.append(ch);
                    continue block11;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        if (sb.length() > 0) {
            int stringId;
            if (section == 2) {
                Integer existingStringNumber = this.lookForExistingString(sb.toString());
                if (existingStringNumber == null) {
                    stringId = ++newCurrentStringCount;
                    this.addExisitingString(sb.toString(), stringId);
                    sb.insert(0, STANDARD_PREFIX + stringId + " = \"");
                    writer.print(sb.toString());
                    writer.print(STANDARD_SUFFIX);
                    writer.println();
                }
            } else if (section == 6) {
                Integer existingStringNumber = this.lookForExistingString(sb.toString());
                stringId = 0;
                stringId = existingStringNumber != null ? existingStringNumber : ++newCurrentStringCount;
                if (this.attrName != null) {
                    writer.print("String " + this.attrName + " = String.valueOf(_jsp_string" + stringId + ")");
                    writer.print(";");
                    writer.println();
                } else {
                    writer.print("out.write(_jsp_string" + stringId + ");");
                    writer.println();
                }
            }
        }
        return newCurrentStringCount;
    }

    private Integer lookForExistingString(String text) {
        Integer existingStringId = null;
        HashMap existingStringMap = (HashMap)this.persistentData.get("existingStringMap");
        if (existingStringMap == null) {
            existingStringMap = new HashMap();
            this.persistentData.put("existingStringMap", existingStringMap);
        }
        existingStringId = (Integer)existingStringMap.get(text);
        return existingStringId;
    }

    private void addExisitingString(String text, int stringId) {
        HashMap<String, Integer> existingStringMap = (HashMap<String, Integer>)this.persistentData.get("existingStringMap");
        if (existingStringMap == null) {
            existingStringMap = new HashMap<String, Integer>();
            this.persistentData.put("existingStringMap", existingStringMap);
        }
        existingStringMap.put(text, new Integer(stringId));
    }
}

