/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.translator.visitor.generator.CodeGeneratorBase;
import com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils;
import com.ibm.ws.jsp.translator.visitor.generator.JavaCodeWriter;
import java.util.ArrayList;
import org.w3c.dom.CDATASection;

public class ExpressionGenerator
extends CodeGeneratorBase {
    public void startGeneration(int section, JavaCodeWriter writer) throws JspCoreException {
        if (section == 6) {
            CDATASection cdata = (CDATASection)this.element.getFirstChild();
            String data = cdata.getData();
            data = data.replaceAll("&gt;", ">");
            data = data.replaceAll("&lt;", "<");
            data = data.replaceAll("&amp;", "&");
            char[] chars = data.toCharArray();
            this.writeDebugStartBegin(writer);
            String expression = new String(GeneratorUtils.escapeQuotes(chars));
            if (expression.indexOf(43) != -1 && expression.indexOf(34) != -1) {
                int i;
                int parenthesis = 0;
                int numberConstantStrings = 0;
                boolean constantString = false;
                int quoteMode = 0;
                int termStart = 0;
                boolean skipSplit = false;
                ArrayList<String> terms = new ArrayList<String>();
                for (i = 0; i < expression.length(); ++i) {
                    char c = expression.charAt(i);
                    switch (c) {
                        case '(': {
                            if (quoteMode != 0) break;
                            ++parenthesis;
                            constantString = false;
                            break;
                        }
                        case ')': {
                            if (quoteMode != 0) break;
                            --parenthesis;
                            constantString = false;
                            break;
                        }
                        case ':': 
                        case '?': {
                            if (quoteMode != 0) break;
                            skipSplit = true;
                            break;
                        }
                        case '\'': {
                            if (quoteMode == 0) {
                                quoteMode = 1;
                                break;
                            }
                            quoteMode = 0;
                            break;
                        }
                        case '\"': {
                            if (quoteMode == 0) {
                                quoteMode = 2;
                                constantString = true;
                                break;
                            }
                            quoteMode = 0;
                            break;
                        }
                        case '\\': {
                            char c1;
                            if (quoteMode == 0 || i >= expression.length() - 1 || (c1 = expression.charAt(i + 1)) != '\\' && c1 != '\"' && c1 != '\'') break;
                            ++i;
                            break;
                        }
                        case '+': {
                            if (parenthesis != 0 || quoteMode != 0) break;
                            terms.add(expression.substring(termStart, i));
                            termStart = i + 1;
                            if (!constantString) break;
                            ++numberConstantStrings;
                            break;
                        }
                        case ' ': {
                            break;
                        }
                        default: {
                            if (quoteMode != 0) break;
                            constantString = false;
                        }
                    }
                    if (skipSplit) break;
                }
                if (parenthesis == 0 && termStart < expression.length()) {
                    terms.add(expression.substring(termStart, expression.length()));
                    if (constantString) {
                        ++numberConstantStrings;
                    }
                }
                if (!skipSplit && terms.size() > 1 && numberConstantStrings > 0) {
                    for (i = 0; i < terms.size(); ++i) {
                        int j;
                        String el = (String)terms.get(i);
                        constantString = true;
                        for (j = 0; j < el.length() && el.charAt(j) != '\"'; ++j) {
                            if (el.charAt(j) == ' ') continue;
                            constantString = false;
                            break;
                        }
                        for (j = el.length() - 1; j >= 0 && el.charAt(j) != '\"'; --j) {
                            if (el.charAt(j) == ' ') continue;
                            constantString = false;
                            break;
                        }
                        if (constantString) {
                            writer.println("out.write(" + el + ");");
                            continue;
                        }
                        writer.println("out.print(" + el + ");");
                    }
                } else {
                    writer.println("out.print(" + expression + ");");
                }
            } else {
                writer.println("out.print(" + expression + ");");
            }
            this.writeDebugStartEnd(writer);
        }
    }

    public void endGeneration(int section, JavaCodeWriter writer) throws JspCoreException {
    }
}

