/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagClassInfo;
import com.ibm.ws.jsp.taglib.TagFileClassInfo;
import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.generator.AttributeGenerator;
import com.ibm.ws.jsp.translator.visitor.generator.CustomTagGenerator;
import com.ibm.ws.jsp.translator.visitor.generator.FragmentHelperClassWriter;
import com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils;
import com.ibm.ws.jsp.translator.visitor.generator.JavaCodeWriter;
import com.ibm.ws.jsp.translator.visitor.generator.MethodWriter;
import com.ibm.ws.jsp.translator.visitor.generator.NamedAttributeWriter;
import com.ibm.ws.jsp.translator.visitor.generator.TagGenerator;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseTagGenerator
implements TagGenerator {
    protected int nestingLevel = 0;
    protected boolean isTagFile = false;
    protected boolean hasBody = false;
    protected boolean hasJspBody = false;
    protected boolean isFragment = false;
    protected boolean isRepeatTag = false;
    protected Element element = null;
    protected TagLibraryCache tagLibraryCache = null;
    protected TagClassInfo tagClassInfo = null;
    protected String tagHandlerVar = null;
    protected TagInfo ti = null;
    protected JspConfiguration jspConfiguration = null;
    protected JspCoreContext ctxt = null;
    protected FragmentHelperClassWriter fragmentHelperClassWriter = null;
    protected Map attributeWriterMap = new HashMap();
    protected ValidateResult.CollectedTagData collectedTagData = null;
    protected Map persistentData = null;
    protected JspOptions jspOptions = null;
    protected MethodWriter bodyWriter = new MethodWriter();
    protected CustomTagGenerator.TagInstanceInfo parentTagInstanceInfo = null;
    protected boolean isConvertExpression = false;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.generator.BaseTagGenerator";

    protected BaseTagGenerator(int nestingLevel, boolean isTagFile, boolean hasBody, boolean hasJspBody, String tagHandlerVar, Element element, TagLibraryCache tagLibraryCache, JspConfiguration jspConfiguration, JspCoreContext ctxt, TagClassInfo tagClassInfo, TagInfo ti, Map persistentData, ValidateResult.CollectedTagData collectedTagData, FragmentHelperClassWriter fragmentHelperClassWriter, JspOptions jspOptions) {
        this.nestingLevel = nestingLevel;
        this.isTagFile = isTagFile;
        this.hasBody = hasBody;
        this.hasJspBody = hasJspBody;
        this.tagHandlerVar = tagHandlerVar;
        if (tagHandlerVar.indexOf("_tsx_repeat") != -1) {
            this.isRepeatTag = true;
        }
        this.element = element;
        this.tagLibraryCache = tagLibraryCache;
        this.jspConfiguration = jspConfiguration;
        this.ctxt = ctxt;
        this.tagClassInfo = tagClassInfo;
        this.ti = ti;
        this.persistentData = persistentData;
        this.collectedTagData = collectedTagData;
        this.fragmentHelperClassWriter = fragmentHelperClassWriter;
        this.jspOptions = jspOptions;
    }

    public abstract MethodWriter generateTagStart() throws JspCoreException;

    public abstract MethodWriter generateTagMiddle() throws JspCoreException;

    public abstract MethodWriter generateTagEnd() throws JspCoreException;

    public abstract void generateInitialization(JavaCodeWriter var1);

    public abstract void generateFinally(JavaCodeWriter var1);

    public void generateImports(JavaCodeWriter writer) {
    }

    public void generateDeclarations(JavaCodeWriter writer) {
    }

    public void setParentTagInstanceInfo(CustomTagGenerator.TagInstanceInfo parentTagInstanceInfo) {
        this.parentTagInstanceInfo = parentTagInstanceInfo;
    }

    public void setIsInFragment(boolean isFragment) {
        this.isFragment = isFragment;
    }

    public boolean fragmentWriterUsed() {
        return false;
    }

    public MethodWriter getBodyWriter() {
        return this.bodyWriter;
    }

    protected String createJspId(JspVisitorInputMap inputMap) throws JspCoreException {
        String jspIdPrefix = (String)inputMap.get("JspIdConsumerPrefix");
        if (jspIdPrefix == null) {
            JspResources jspFiles = (JspResources)inputMap.get("JspFiles");
            String name = jspFiles.getGeneratedSourceFile().toString();
            StringBuffer sb = new StringBuffer(32);
            sb.append("jsp_").append(Math.abs(name.hashCode())).append('_');
            jspIdPrefix = sb.toString();
            inputMap.put("JspIdConsumerPrefix", jspIdPrefix);
        }
        Integer jspIdValue = (Integer)inputMap.get("JspIdConsumerCounter");
        jspIdValue = jspIdValue + 1;
        inputMap.put("JspIdConsumerCounter", jspIdValue);
        return jspIdPrefix + jspIdValue.toString();
    }

    public JavaCodeWriter getWriterForChild(int section, Node childElement) throws JspCoreException {
        JavaCodeWriter writerForChild = null;
        if (section == 6) {
            writerForChild = childElement.getNodeType() == 1 ? (childElement.getNamespaceURI() != null && childElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && childElement.getLocalName().equals("attribute") ? (JavaCodeWriter)this.attributeWriterMap.get(childElement) : this.bodyWriter) : this.bodyWriter;
        }
        return writerForChild;
    }

    public void generateSetParent(MethodWriter writer) throws JspCoreException {
        if (this.tagClassInfo.implementsSimpleTag()) {
            String aliasMapVar = null;
            if (this.tagClassInfo instanceof TagFileClassInfo) {
                aliasMapVar = this.generateAliasMap(writer, this.tagHandlerVar);
            }
            writer.print(this.tagHandlerVar);
            if (aliasMapVar == null) {
                writer.println(".setJspContext(pageContext);");
            } else {
                writer.print(".setJspContext(pageContext, ");
                writer.print(aliasMapVar);
                writer.println(");");
            }
            if (this.parentTagInstanceInfo != null) {
                writer.print(this.tagHandlerVar);
                writer.print(".setParent(");
                writer.print(this.parentTagInstanceInfo.getTagHandlerVar());
                writer.println(");");
            }
        } else {
            writer.print(this.tagHandlerVar);
            writer.println(".setPageContext(pageContext);");
            if (this.parentTagInstanceInfo != null) {
                TagClassInfo parentTagClassInfo = this.tagLibraryCache.getTagClassInfo(this.parentTagInstanceInfo.getTi());
                if (parentTagClassInfo.implementsSimpleTag()) {
                    writer.print(this.tagHandlerVar);
                    writer.print(".setParent(");
                    writer.print("new javax.servlet.jsp.tagext.TagAdapter(");
                    writer.print("(javax.servlet.jsp.tagext.SimpleTag) ");
                    writer.print(this.parentTagInstanceInfo.getTagHandlerVar());
                    writer.println("));");
                } else {
                    writer.print(this.tagHandlerVar);
                    writer.print(".setParent((javax.servlet.jsp.tagext.Tag) ");
                    writer.print(this.parentTagInstanceInfo.getTagHandlerVar());
                    writer.println(");");
                }
            } else if (this.isTagFile && !this.jspOptions.isAllowNullParentInTagFile()) {
                writer.print(this.tagHandlerVar);
                writer.print(".setParent(new javax.servlet.jsp.tagext.TagAdapter(");
                writer.print("(javax.servlet.jsp.tagext.SimpleTag) this ));");
            } else {
                writer.print(this.tagHandlerVar);
                writer.print(".setParent(");
                writer.print("null");
                writer.println(");");
            }
        }
    }

    public List generateSetters() throws JspCoreException {
        ArrayList<MethodWriter> setterWriterList = new ArrayList<MethodWriter>();
        JspId jspId = new JspId(this.element.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "generateSetters", "jspId = [" + jspId + "]");
        }
        Iterator itr = jspId.getAttrNameList().iterator();
        while (itr.hasNext()) {
            Attr attr = null;
            String attrName = (String)itr.next();
            if (attrName.indexOf(58) != -1) {
                if (this.element.lookupNamespaceURI(attrName.substring(0, attrName.indexOf(58))) == null) {
                    throw new JspTranslationException("jsp.error.dynamicAttributes.translationException", new Object[]{attrName});
                }
                attr = this.element.getAttributeNodeNS(attrName.substring(0, attrName.indexOf(58)), attrName.substring(attrName.indexOf(58) + 1));
            } else {
                attr = this.element.getAttributeNode(attrName);
            }
            if (attr == null) break;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "generateSetters", "attrName = [" + attrName + "]");
                logger.logp(Level.FINEST, CLASS_NAME, "generateSetters", "attr.getName() = [" + attr.getName() + "]");
            }
            if (attr.getName().equals("jsp:id") || attr.getName().startsWith("xmlns")) continue;
            MethodWriter setterWriter = new MethodWriter();
            TagAttributeInfo tai = this.findTagAttributeInfo(attr.getName());
            boolean isDynamic = false;
            if (tai == null && this.ti.hasDynamicAttributes()) {
                isDynamic = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "generateSetters", "tai = [" + tai + "] isDynamic = [" + isDynamic + "]");
            }
            String evalAttrValue = this.evaluateAttribute(attr.getName(), attr.getValue(), isDynamic, false, false, tai);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "generateSetters", "evalAttrValue = [" + evalAttrValue + "]");
            }
            this.generateSetterCall(attr.getName(), evalAttrValue, attr.getNamespaceURI(), setterWriter, isDynamic);
            setterWriterList.add(setterWriter);
        }
        NodeList nl = this.element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element childElement;
            Node childNode = nl.item(i);
            if (childNode.getNodeType() != 1 || (childElement = (Element)childNode).getNamespaceURI() == null || !childElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !childElement.getLocalName().equals("attribute")) continue;
            String name = childElement.getAttribute("name");
            if (name.indexOf(58) != -1) {
                name = name.substring(name.indexOf(58) + 1);
            }
            TagAttributeInfo tai = this.findTagAttributeInfo(name);
            boolean isAttrFragment = false;
            if (tai != null) {
                isAttrFragment = tai.isFragment();
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "generateSetters", "childElement.getLocalName() = [" + childElement.getLocalName() + "]");
                logger.logp(Level.FINEST, CLASS_NAME, "generateSetters", "name = [" + name + "]");
                logger.logp(Level.FINEST, CLASS_NAME, "generateSetters", "tai = [" + tai + "]");
                logger.logp(Level.FINEST, CLASS_NAME, "generateSetters", "isAttrFragment = [" + isAttrFragment + "]");
            }
            NamedAttributeWriter attributeWriter = this.createJspAttributeWriter(childElement, isAttrFragment);
            setterWriterList.add(attributeWriter);
        }
        return setterWriterList;
    }

    public void generateJspAttributeSetters() throws JspCoreException {
        ArrayList jspAttributeList;
        HashMap jspAttributes = (HashMap)this.persistentData.get("jspAttributes");
        if (jspAttributes != null && (jspAttributeList = (ArrayList)jspAttributes.get(this.element)) != null) {
            for (AttributeGenerator.JspAttribute jspAttribute : jspAttributeList) {
                MethodWriter attributeWriter = this.findAttributeWriter(jspAttribute.getName());
                TagAttributeInfo tai = this.findTagAttributeInfo(jspAttribute.getName());
                boolean isAttrFragment = false;
                boolean isDynamic = false;
                if (tai != null) {
                    isAttrFragment = tai.isFragment();
                }
                if (tai == null && this.ti.hasDynamicAttributes()) {
                    isDynamic = true;
                }
                if (isAttrFragment) continue;
                String evalAttrValue = this.evaluateAttribute(jspAttribute.getName(), jspAttribute.getVarName(), isDynamic, isAttrFragment, true, tai);
                this.generateSetterCall(jspAttribute.getName(), evalAttrValue, jspAttribute.getJspAttrElement().getNamespaceURI(), attributeWriter, isDynamic);
            }
        }
    }

    private String generateAliasMap(JavaCodeWriter writer, String tagHandlerVar) throws JspCoreException {
        TagVariableInfo[] tagVars = this.ti.getTagVariableInfos();
        String aliasMapVar = null;
        boolean aliasSeen = false;
        for (int i = 0; i < tagVars.length; ++i) {
            String aliasName;
            String nameFrom = tagVars[i].getNameFromAttribute();
            if (nameFrom == null || (aliasName = this.element.getAttribute(nameFrom)).equals("")) continue;
            if (!aliasSeen) {
                writer.print("java.util.HashMap ");
                aliasMapVar = tagHandlerVar + "_aliasMap";
                writer.print(aliasMapVar);
                writer.print(" = new java.util.HashMap();");
                writer.println();
                aliasSeen = true;
            }
            writer.print(aliasMapVar);
            writer.print(".put(");
            writer.print(GeneratorUtils.quote(tagVars[i].getNameGiven()));
            writer.print(", ");
            writer.print(GeneratorUtils.quote(aliasName));
            writer.print(");");
            writer.println();
        }
        return aliasMapVar;
    }

    protected TagAttributeInfo findTagAttributeInfo(String attrName) {
        TagAttributeInfo foundAttr = null;
        TagAttributeInfo[] attributes = this.ti.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(attrName)) continue;
            foundAttr = attributes[i];
            break;
        }
        return foundAttr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String evaluateAttribute(String attrName, String attrValue, boolean isDynamic, boolean isAttrFragment, boolean isNamedAttribute, TagAttributeInfo tai) throws JspCoreException {
        String evalAttrValue = attrValue;
        String parameterClassName = "Object";
        String fullParameterClassName = "java.lang.Object";
        if (!isDynamic && (parameterClassName = (fullParameterClassName = this.tagClassInfo.getParameterClassName(attrName, this.ctxt))).startsWith("java.lang.")) {
            parameterClassName = parameterClassName.substring(parameterClassName.indexOf("java.lang.") + 10);
        }
        attrValue = attrValue.replaceAll("&gt;", ">");
        attrValue = attrValue.replaceAll("&lt;", "<");
        attrValue = attrValue.replaceAll("&amp;", "&");
        attrValue = attrValue.replaceAll("<\\%", "<%");
        attrValue = attrValue.replaceAll("%\\>", "%>");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "attrName = [" + attrName + "]");
            logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "attrValue = [" + attrValue + "]");
            logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "isDynamic = [" + isDynamic + "]");
            logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "isAttrFragment = [" + isAttrFragment + "]");
            logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "isNamedAttribute = [" + isNamedAttribute + "]");
            logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "parameterClassName = [" + parameterClassName + "]");
        }
        boolean isELInput = JspTranslatorUtil.isELInterpreterInput(attrValue, this.jspConfiguration);
        this.isConvertExpression = false;
        if (JspTranslatorUtil.isExpression(attrValue)) {
            if (this.jspOptions != null && this.jspOptions.isConvertExpression()) {
                this.isConvertExpression = true;
                evalAttrValue = this.convertString(parameterClassName, attrValue, attrName, this.tagClassInfo.getPropertyEditorClassName(attrName), true);
            } else {
                evalAttrValue = attrValue.substring(2, attrValue.length() - 1);
            }
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) return evalAttrValue;
            logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "isExpression, evalAttrValue = [" + evalAttrValue + "]");
            return evalAttrValue;
        } else if (isNamedAttribute) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "isNamedAttribute = [" + isNamedAttribute + "]");
            }
            if (isAttrFragment || isDynamic) return evalAttrValue;
            evalAttrValue = this.convertString(parameterClassName, attrValue, attrName, this.tagClassInfo.getPropertyEditorClassName(attrName), true);
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) return evalAttrValue;
            logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "converted evalAttrValue = [" + evalAttrValue + "]");
            return evalAttrValue;
        } else if (isELInput || GeneratorUtils.isDeferredInput(tai) || GeneratorUtils.isDeferredMethodInput(tai)) {
            try {
                String type = tai != null ? tai.getTypeName() : "java.lang.Object";
                Class c = JspTranslatorUtil.toClass(fullParameterClassName, this.ctxt.getJspClassloaderContext().getClassLoader());
                StringBuffer sb = new StringBuffer(64);
                String jspCtxt = null;
                jspCtxt = this.isTagFile ? "getJspContext()" : "pageContext";
                sb.append(jspCtxt);
                sb.append(".getELContext()");
                String elContext = sb.toString();
                sb.setLength(0);
                sb.append("new org.apache.jasper.el.ELContextWrapper(");
                sb.append(elContext);
                sb.append(',');
                sb.append("_jspx_fnmap");
                sb.append(')');
                elContext = sb.toString();
                sb.setLength(0);
                String jspIdString = this.element.getAttributeNS("http://java.sun.com/JSP/Page", "id");
                String msg = "";
                if (!jspIdString.equals("")) {
                    JspId jspId = new JspId(jspIdString);
                    msg = jspId.getFilePath() + "(" + jspId.getStartSourceLineNum() + "," + jspId.getStartSourceColNum() + ")";
                }
                sb.append(msg);
                sb.append(" '");
                sb.append(attrValue);
                sb.append('\'');
                String mark = sb.toString();
                sb.setLength(0);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "isELInterperterInput Class= [" + c + "]  type= [" + type + "]");
                }
                if (GeneratorUtils.isDeferredInput(tai) || ValueExpression.class.getName().equals(type)) {
                    evalAttrValue = GeneratorUtils.createValueExpression(sb, mark, elContext, attrValue, isELInput, c, tai, jspCtxt);
                } else if (GeneratorUtils.isDeferredMethodInput(tai) || MethodExpression.class.getName().equals(type)) {
                    if (!JspTranslatorUtil.isELInterpreterInput(attrValue, this.jspConfiguration, true) && "void".equals(GeneratorUtils.getExpectedTypeName(tai))) {
                        throw new JspTranslationException("jsp.error.translation.invalid.void.deferredMethodClass", new Object[]{attrName});
                    }
                    evalAttrValue = GeneratorUtils.createMethodExpression(sb, mark, elContext, attrValue, isELInput, c, tai, jspCtxt);
                } else {
                    evalAttrValue = GeneratorUtils.interpreterCall(this.isTagFile, attrValue, c, "_jspx_fnmap", false);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) return evalAttrValue;
                logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "isELInterperterInput evalAttrValue= [" + evalAttrValue + "]");
                return evalAttrValue;
            }
            catch (ClassNotFoundException e) {
                throw new JspTranslationException(this.element, "jsp.error.loadclass.taghandler.attr", new Object[]{attrName}, e);
            }
        } else {
            if (this.isRepeatTag && (attrName.equals("end") || attrName.equals("start")) && !this.jspOptions.isConvertAttrValueToString()) {
                return evalAttrValue;
            }
            evalAttrValue = this.convertString(parameterClassName, attrValue, attrName, this.tagClassInfo.getPropertyEditorClassName(attrName), false);
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) return evalAttrValue;
            logger.logp(Level.FINER, CLASS_NAME, "evaluateAttribute", "converted string evalAttrValue= [" + evalAttrValue + "]");
        }
        return evalAttrValue;
    }

    protected void generateSetterCall(String attrName, String evalAttrValue, String uri, MethodWriter setterWriter, boolean isDymanic) throws JspCoreException {
        if (isDymanic) {
            setterWriter.print(this.tagHandlerVar);
            setterWriter.print(".");
            setterWriter.print("setDynamicAttribute(");
            if ("".equals(uri) || uri == null) {
                setterWriter.print("null");
            } else {
                setterWriter.print("\"" + uri + "\"");
            }
            setterWriter.print(", \"");
            setterWriter.print(attrName);
            setterWriter.print("\", ");
            setterWriter.print(evalAttrValue);
            setterWriter.println(");");
        } else {
            setterWriter.print(this.tagHandlerVar);
            setterWriter.print(".");
            setterWriter.print(this.tagClassInfo.getSetterMethodName(attrName));
            setterWriter.print("(");
            setterWriter.print(evalAttrValue);
            setterWriter.println(");");
        }
    }

    private String convertString(String parameterClassName, String s, String attrName, String propEditorClassName, boolean isNamedAttribute) {
        String quoted = s;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "convertString", "attrValue: " + s);
        }
        if (this.isConvertExpression) {
            quoted = quoted.substring(2, quoted.length() - 1);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "convertString", "quoted: " + quoted);
            }
        }
        if (!isNamedAttribute) {
            quoted = GeneratorUtils.quote(s);
        }
        if (this.isConvertExpression && !parameterClassName.equals("String")) {
            s = quoted;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "convertString", "s: " + s);
            }
        }
        if (propEditorClassName != null) {
            return "(" + parameterClassName + ")org.apache.jasper.runtime.JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(" + parameterClassName + ".class, \"" + attrName + "\", " + quoted + ", " + propEditorClassName + ".class)";
        }
        if (parameterClassName.equals("String")) {
            if (this.isConvertExpression) {
                return quoted + ".toString()";
            }
            return quoted;
        }
        if (parameterClassName.equals("boolean")) {
            return GeneratorUtils.coerceToPrimitiveBoolean(s, isNamedAttribute);
        }
        if (parameterClassName.equals("Boolean")) {
            return GeneratorUtils.coerceToBoolean(s, isNamedAttribute);
        }
        if (parameterClassName.equals("byte")) {
            return GeneratorUtils.coerceToPrimitiveByte(s, isNamedAttribute);
        }
        if (parameterClassName.equals("Byte")) {
            return GeneratorUtils.coerceToByte(s, isNamedAttribute);
        }
        if (parameterClassName.equals("char")) {
            return GeneratorUtils.coerceToChar(s, isNamedAttribute);
        }
        if (parameterClassName.equals("Character")) {
            return GeneratorUtils.coerceToCharacter(s, isNamedAttribute);
        }
        if (parameterClassName.equals("double")) {
            return GeneratorUtils.coerceToPrimitiveDouble(s, isNamedAttribute);
        }
        if (parameterClassName.equals("Double")) {
            return GeneratorUtils.coerceToDouble(s, isNamedAttribute);
        }
        if (parameterClassName.equals("float")) {
            return GeneratorUtils.coerceToPrimitiveFloat(s, isNamedAttribute);
        }
        if (parameterClassName.equals("Float")) {
            return GeneratorUtils.coerceToFloat(s, isNamedAttribute);
        }
        if (parameterClassName.equals("int")) {
            return GeneratorUtils.coerceToInt(s, isNamedAttribute);
        }
        if (parameterClassName.equals("Integer")) {
            return GeneratorUtils.coerceToInteger(s, isNamedAttribute);
        }
        if (parameterClassName.equals("short")) {
            return GeneratorUtils.coerceToPrimitiveShort(s, isNamedAttribute);
        }
        if (parameterClassName.equals("Short")) {
            return GeneratorUtils.coerceToShort(s, isNamedAttribute);
        }
        if (parameterClassName.equals("long")) {
            return GeneratorUtils.coerceToPrimitiveLong(s, isNamedAttribute);
        }
        if (parameterClassName.equals("Long")) {
            return GeneratorUtils.coerceToLong(s, isNamedAttribute);
        }
        if (parameterClassName.equals("Object")) {
            return "new String(" + quoted + ")";
        }
        if (this.isConvertExpression) {
            return quoted;
        }
        return "(" + parameterClassName + ")org.apache.jasper.runtime.JspRuntimeLibrary.getValueFromPropertyEditorManager(" + parameterClassName + ".class, \"" + attrName + "\", " + quoted + ")";
    }

    private NamedAttributeWriter createJspAttributeWriter(Element attributeElement, boolean isAttrFragment) throws JspCoreException {
        int methodNesting = (Integer)this.persistentData.get("methodNesting");
        String name = attributeElement.getAttribute("name");
        if (name.indexOf(58) != -1) {
            name = name.substring(name.indexOf(58) + 1);
        }
        NamedAttributeWriter attributeWriter = new NamedAttributeWriter(name, GeneratorUtils.nextTemporaryVariableName(this.persistentData));
        if (isAttrFragment) {
            attributeWriter.print("javax.servlet.jsp.tagext.JspFragment " + attributeWriter.getVarName() + " = ");
            FragmentHelperClassWriter.FragmentWriter fragment = this.fragmentHelperClassWriter.openFragment(this.element, this.tagHandlerVar, methodNesting);
            attributeWriter.print("new " + this.fragmentHelperClassWriter.getClassName() + "( ");
            if (this.jspOptions.isUsePageTagPool() || this.jspOptions.isUseThreadTagPool()) {
                attributeWriter.print("_jspx_TagLookup, ");
            }
            String pushBodyCountVar = (String)this.persistentData.get("pushBodyCountVar");
            attributeWriter.print(fragment.getId() + ", pageContext, " + this.tagHandlerVar + ", " + pushBodyCountVar + ")");
            attributeWriter.println(";");
            this.attributeWriterMap.put(attributeElement, fragment);
            this.generateSetterCall(name, attributeWriter.getVarName(), attributeElement.getNamespaceURI(), attributeWriter, false);
        } else {
            this.attributeWriterMap.put(attributeElement, attributeWriter);
        }
        return attributeWriter;
    }

    protected void declareScriptingVars(JavaCodeWriter tagWriter, int scope) {
        Vector vec = this.getScriptingVars(scope);
        if (vec != null) {
            for (int i = 0; i < vec.size(); ++i) {
                Object elem = vec.elementAt(i);
                if (elem instanceof VariableInfo) {
                    VariableInfo varInfo = (VariableInfo)elem;
                    if (!varInfo.getDeclare()) continue;
                    if (this.jspOptions.isUseRepeatInt() && this.isRepeatTag) {
                        tagWriter.print("int");
                        tagWriter.print(" ");
                        tagWriter.print(varInfo.getVarName());
                        tagWriter.println(" = 0;");
                        continue;
                    }
                    String className = varInfo.getClassName();
                    className = this.replaceCharacters(className);
                    tagWriter.print(className);
                    tagWriter.print(" ");
                    tagWriter.print(varInfo.getVarName());
                    tagWriter.println(" = null;");
                    continue;
                }
                TagVariableInfo tagVarInfo = (TagVariableInfo)elem;
                if (!tagVarInfo.getDeclare()) continue;
                String varName = tagVarInfo.getNameGiven();
                if (varName == null) {
                    varName = this.collectedTagData.getTagData().getAttributeString(tagVarInfo.getNameFromAttribute());
                } else if (tagVarInfo.getNameFromAttribute() != null) continue;
                if (this.jspOptions.isUseRepeatInt() && this.isRepeatTag) {
                    tagWriter.print("int");
                    tagWriter.print(" ");
                    tagWriter.print(varName);
                    tagWriter.println(" = 0;");
                    continue;
                }
                String className = tagVarInfo.getClassName();
                className = this.replaceCharacters(className);
                tagWriter.print(className);
                tagWriter.print(" ");
                tagWriter.print(varName);
                tagWriter.println(" = null;");
            }
        }
    }

    protected void saveScriptingVars(JavaCodeWriter tagWriter, int scope) {
        if (this.nestingLevel == 0) {
            return;
        }
        TagVariableInfo[] tagVarInfos = this.ti.getTagVariableInfos();
        VariableInfo[] varInfos = this.ti.getVariableInfo(this.collectedTagData.getTagData());
        if (varInfos == null) {
            varInfos = new VariableInfo[]{};
        }
        if (varInfos.length == 0 && tagVarInfos.length == 0) {
            return;
        }
        if (varInfos.length > 0) {
            for (int i = 0; i < varInfos.length; ++i) {
                if (varInfos[i].getScope() != scope || this.containsVariableInfo(this.getScriptingVars(scope), varInfos[i])) continue;
                String varName = varInfos[i].getVarName();
                String tmpVarName = "_jspx_" + varName + "_" + this.nestingLevel;
                tagWriter.print(tmpVarName);
                tagWriter.print(" = ");
                tagWriter.print(varName);
                tagWriter.println(";");
            }
        } else {
            for (int i = 0; i < tagVarInfos.length; ++i) {
                if (tagVarInfos[i].getScope() != scope || this.containsTagVariableInfo(this.getScriptingVars(scope), tagVarInfos[i])) continue;
                String varName = tagVarInfos[i].getNameGiven();
                if (varName == null) {
                    varName = this.collectedTagData.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                } else if (tagVarInfos[i].getNameFromAttribute() != null) continue;
                String tmpVarName = "_jspx_" + varName + "_" + this.nestingLevel;
                tagWriter.print(tmpVarName);
                tagWriter.print(" = ");
                tagWriter.print(varName);
                tagWriter.println(";");
            }
        }
    }

    protected void restoreScriptingVars(JavaCodeWriter tagWriter, int scope) {
        if (this.nestingLevel == 0) {
            return;
        }
        TagVariableInfo[] tagVarInfos = this.ti.getTagVariableInfos();
        VariableInfo[] varInfos = this.ti.getVariableInfo(this.collectedTagData.getTagData());
        if (varInfos == null) {
            varInfos = new VariableInfo[]{};
        }
        if (varInfos.length == 0 && tagVarInfos.length == 0) {
            return;
        }
        if (varInfos.length > 0) {
            for (int i = 0; i < varInfos.length; ++i) {
                if (varInfos[i].getScope() != scope || this.containsVariableInfo(this.getScriptingVars(scope), varInfos[i])) continue;
                String varName = varInfos[i].getVarName();
                String tmpVarName = "_jspx_" + varName + "_" + this.nestingLevel;
                tagWriter.print(varName);
                tagWriter.print(" = ");
                tagWriter.print(tmpVarName);
                tagWriter.println(";");
            }
        } else {
            for (int i = 0; i < tagVarInfos.length; ++i) {
                if (tagVarInfos[i].getScope() != scope || this.containsTagVariableInfo(this.getScriptingVars(scope), tagVarInfos[i])) continue;
                String varName = tagVarInfos[i].getNameGiven();
                if (varName == null) {
                    varName = this.collectedTagData.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                } else if (tagVarInfos[i].getNameFromAttribute() != null) continue;
                String tmpVarName = "_jspx_" + varName + "_" + this.nestingLevel;
                tagWriter.print(varName);
                tagWriter.print(" = ");
                tagWriter.print(tmpVarName);
                tagWriter.println(";");
            }
        }
    }

    protected void syncScriptingVars(JavaCodeWriter tagWriter, int scope) {
        TagVariableInfo[] tagVarInfos = this.ti.getTagVariableInfos();
        VariableInfo[] varInfos = this.ti.getVariableInfo(this.collectedTagData.getTagData());
        if (varInfos == null) {
            varInfos = new VariableInfo[]{};
        }
        if (varInfos.length == 0 && tagVarInfos.length == 0) {
            return;
        }
        if (varInfos.length > 0) {
            for (int i = 0; i < varInfos.length; ++i) {
                if (varInfos[i].getScope() != scope) continue;
                tagWriter.print(varInfos[i].getVarName());
                tagWriter.print(" = ((");
                String className = varInfos[i].getClassName();
                className = this.replaceCharacters(className);
                tagWriter.print(className);
                tagWriter.print(") pageContext.findAttribute(");
                tagWriter.print(GeneratorUtils.quote(varInfos[i].getVarName()));
                tagWriter.print("))");
                if (this.jspOptions.isUseRepeatInt() && this.isRepeatTag) {
                    tagWriter.println(".intValue();");
                    continue;
                }
                tagWriter.println(";");
            }
        } else {
            for (int i = 0; i < tagVarInfos.length; ++i) {
                if (tagVarInfos[i].getScope() != scope) continue;
                String name = tagVarInfos[i].getNameGiven();
                if (name == null) {
                    name = this.collectedTagData.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                } else if (tagVarInfos[i].getNameFromAttribute() != null) continue;
                tagWriter.print(name);
                tagWriter.print(" = ((");
                String className = tagVarInfos[i].getClassName();
                className = this.replaceCharacters(className);
                tagWriter.print(className);
                tagWriter.print(") pageContext.findAttribute(");
                tagWriter.print(GeneratorUtils.quote(name));
                tagWriter.print("))");
                if (this.jspOptions.isUseRepeatInt() && this.isRepeatTag) {
                    tagWriter.println(".intValue();");
                    continue;
                }
                tagWriter.println(";");
            }
        }
    }

    private MethodWriter findAttributeWriter(String attributeName) {
        MethodWriter attributeWriter = null;
        for (MethodWriter writer : this.attributeWriterMap.values()) {
            if (!(writer instanceof NamedAttributeWriter) || !((NamedAttributeWriter)writer).getAttributeName().equals(attributeName)) continue;
            attributeWriter = writer;
            break;
        }
        return attributeWriter;
    }

    private Vector getScriptingVars(int scope) {
        Vector vec = null;
        switch (scope) {
            case 1: {
                vec = this.collectedTagData.getAtBeginScriptingVars();
                break;
            }
            case 2: {
                if (this.jspOptions.isUseScriptVarDupInit() && this.collectedTagData.getAtEndDuplicateVars() != null) {
                    vec = this.collectedTagData.getAtEndDuplicateVars();
                    break;
                }
                vec = this.collectedTagData.getAtEndScriptingVars();
                break;
            }
            case 0: {
                vec = this.collectedTagData.getNestedScriptingVars();
            }
        }
        return vec;
    }

    private boolean containsVariableInfo(Vector vec, VariableInfo varInfo) {
        boolean found = false;
        for (VariableInfo vi : vec) {
            if (!vi.getVarName().equals(varInfo.getVarName())) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean containsTagVariableInfo(Vector vec, TagVariableInfo tagVarInfo) {
        boolean found = false;
        for (TagVariableInfo tvi : vec) {
            String compareVarName;
            String varName = tvi.getNameGiven();
            if (varName == null) {
                varName = this.collectedTagData.getTagData().getAttributeString(tvi.getNameFromAttribute());
            }
            if ((compareVarName = tagVarInfo.getNameGiven()) == null) {
                compareVarName = this.collectedTagData.getTagData().getAttributeString(tagVarInfo.getNameFromAttribute());
            }
            if (varName == null || compareVarName == null || !varName.equals(compareVarName)) continue;
            found = true;
            break;
        }
        return found;
    }

    private String replaceCharacters(String name) {
        name = name.replaceAll("&gt;", ">");
        name = name.replaceAll("&lt;", "<");
        name = name.replaceAll("&amp;", "&");
        name = name.replaceAll("<\\%", "<%");
        name = name.replaceAll("%\\>", "%>");
        return name;
    }
}

