/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.visitor.generator.CodeGeneratorBase;
import com.ibm.ws.jsp.translator.visitor.generator.FragmentHelperClassWriter;
import com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils;
import com.ibm.ws.jsp.translator.visitor.generator.JavaCodeWriter;
import com.ibm.ws.jsp.translator.visitor.generator.NamedAttributeWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeGenerator
extends CodeGeneratorBase {
    private JspAttribute jspAttribute = null;
    private boolean trim = true;
    private boolean isLiteral = false;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.generator.AttributeGenerator";

    public void startGeneration(int section, JavaCodeWriter writer) throws JspCoreException {
        if (section == 2) {
            ArrayList<JspAttribute> jspAttributeList;
            HashMap jspAttributes;
            if (!this.element.getAttribute("trim").equals("")) {
                this.trim = Boolean.valueOf(this.element.getAttribute("trim"));
            }
            if ((jspAttributes = (HashMap)this.persistentData.get("jspAttributes")) == null) {
                jspAttributes = new HashMap();
                this.persistentData.put("jspAttributes", jspAttributes);
            }
            if ((jspAttributeList = (ArrayList<JspAttribute>)jspAttributes.get(this.element.getParentNode())) == null) {
                jspAttributeList = new ArrayList<JspAttribute>();
                jspAttributes.put(this.element.getParentNode(), jspAttributeList);
            }
            String name = this.element.getAttribute("name");
            String prefix = null;
            if (name.indexOf(58) != -1) {
                prefix = name.substring(0, name.indexOf(58));
                name = name.substring(name.indexOf(58) + 1);
            }
            this.jspAttribute = new JspAttribute(name, prefix, null, this.element, this.isLiteral, this.trim);
            jspAttributeList.add(this.jspAttribute);
        } else if (section == 6) {
            String varName = null;
            if (!(writer instanceof FragmentHelperClassWriter.FragmentWriter)) {
                if (writer instanceof NamedAttributeWriter) {
                    NamedAttributeWriter attributeWriter = (NamedAttributeWriter)writer;
                    varName = attributeWriter.getVarName();
                    this.jspAttribute.setVarName(varName);
                    this.generateAttributeStart(attributeWriter, varName);
                } else {
                    varName = GeneratorUtils.nextTemporaryVariableName(this.persistentData);
                    this.jspAttribute.setVarName(varName);
                    this.generateAttributeStart(writer, varName);
                }
            }
            this.jspAttribute.setIsLiteral(this.isLiteral);
        }
    }

    public void endGeneration(int section, JavaCodeWriter writer) throws JspCoreException {
        if (section == 6) {
            if (writer instanceof FragmentHelperClassWriter.FragmentWriter) {
                FragmentHelperClassWriter.FragmentWriter fragmentWriter = (FragmentHelperClassWriter.FragmentWriter)writer;
                if (this.persistentData.get("methodNesting") == null) {
                    this.persistentData.put("methodNesting", new Integer(0));
                }
                int methodNesting = (Integer)this.persistentData.get("methodNesting");
                this.fragmentHelperClassWriter.closeFragment(fragmentWriter, methodNesting);
            } else if (writer instanceof NamedAttributeWriter) {
                NamedAttributeWriter attributeWriter = (NamedAttributeWriter)writer;
                this.generateAttributeEnd(attributeWriter, attributeWriter.getVarName());
            } else {
                this.generateAttributeEnd(writer, this.jspAttribute.getVarName());
            }
        }
    }

    private void generateAttributeStart(JavaCodeWriter writer, String varName) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "generateAttributeStart", "writer =[" + writer + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "generateAttributeStart", "varName =[" + varName + "]");
        }
        this.writeDebugStartBegin(writer);
        if (this.element.hasChildNodes()) {
            Node attrChildNode = this.element.getFirstChild();
            if (this.element.getChildNodes().getLength() == 1) {
                CDATASection cdata = null;
                if (attrChildNode.getNodeType() == 4) {
                    cdata = (CDATASection)attrChildNode;
                } else if (attrChildNode instanceof Element && attrChildNode.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && attrChildNode.getLocalName().equals("text")) {
                    Element jspElement = (Element)attrChildNode;
                    cdata = (CDATASection)jspElement.getFirstChild();
                }
                if (cdata != null) {
                    String value = cdata.getData();
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "generateAttributeStart", "about to call isELInterpreterInput value =[" + value + "]");
                    }
                    if (!JspTranslatorUtil.isELInterpreterInput(value, this.jspConfiguration)) {
                        this.isLiteral = true;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINEST, CLASS_NAME, "generateAttributeStart", "after call to isELInterpreterInput isLiteral =[" + this.isLiteral + "]");
                        }
                    } else {
                        writer.println("out = pageContext.pushBody();");
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINEST, CLASS_NAME, "generateAttributeStart", "after call to isELInterpreterInput wrote pushBody() line.");
                        }
                    }
                } else {
                    writer.println("out = pageContext.pushBody();");
                }
            } else {
                writer.println("out = pageContext.pushBody();");
            }
        } else {
            writer.println("String " + varName + " = \"\";");
        }
        this.writeDebugStartEnd(writer);
    }

    private void generateAttributeEnd(JavaCodeWriter writer, String varName) {
        if (this.element.hasChildNodes() && !this.isLiteral) {
            this.writeDebugEndBegin(writer);
            writer.println("String " + varName + " = " + "((javax.servlet.jsp.tagext.BodyContent)" + "out).getString();");
            writer.println("out = pageContext.popBody();");
            this.writeDebugEndEnd(writer);
        }
    }

    public class JspAttribute {
        private String name = null;
        private String prefix = null;
        private String varName = null;
        private Element jspAttrElement = null;
        private boolean isLiteral = false;
        private boolean trim = true;

        public JspAttribute(String name, String prefix, String varName, Element jspAttrElement, boolean isLiteral, boolean trim) {
            this.name = name;
            this.prefix = prefix;
            this.varName = varName;
            this.jspAttrElement = jspAttrElement;
            this.isLiteral = isLiteral;
            this.trim = trim;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setVarName(String varName) {
            this.varName = varName;
        }

        public Element getJspAttrElement() {
            return this.jspAttrElement;
        }

        public void setJspAttrElement(Element jspAttrElement) {
            this.jspAttrElement = jspAttrElement;
        }

        public boolean isLiteral() {
            return this.isLiteral;
        }

        public void setIsLiteral(boolean isLiteral) {
            this.isLiteral = isLiteral;
        }

        public boolean trim() {
            return this.trim;
        }

        public void setTrim(boolean trim) {
            this.trim = trim;
        }
    }
}

