/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class JspVisitor {
    protected JspVisitorUsage visitorUsage = null;
    protected JspConfiguration jspConfiguration = null;
    protected JspCoreContext context = null;
    protected HashMap resultMap = null;
    protected JspVisitorInputMap inputMap = null;
    protected int visitCount = 0;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.JspVisitor";

    public JspVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        this.visitorUsage = visitorUsage;
        this.jspConfiguration = jspConfiguration;
        this.context = context;
        this.resultMap = resultMap;
        this.inputMap = inputMap;
    }

    protected abstract void visitJspRootStart(Element var1) throws JspCoreException;

    protected abstract void visitJspRootEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspTextStart(Element var1) throws JspCoreException;

    protected abstract void visitJspTextEnd(Element var1) throws JspCoreException;

    protected abstract void visitIncludeDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitIncludeDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitPageDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitPageDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitTagDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitTagDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitAttributeDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitAttributeDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitVariableDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitVariableDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspDeclarationStart(Element var1) throws JspCoreException;

    protected abstract void visitJspDeclarationEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspExpressionStart(Element var1) throws JspCoreException;

    protected abstract void visitJspExpressionEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspScriptletStart(Element var1) throws JspCoreException;

    protected abstract void visitJspScriptletEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspParamStart(Element var1) throws JspCoreException;

    protected abstract void visitJspParamEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspParamsStart(Element var1) throws JspCoreException;

    protected abstract void visitJspParamsEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspFallbackStart(Element var1) throws JspCoreException;

    protected abstract void visitJspFallbackEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspIncludeStart(Element var1) throws JspCoreException;

    protected abstract void visitJspIncludeEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspForwardStart(Element var1) throws JspCoreException;

    protected abstract void visitJspForwardEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspUseBeanStart(Element var1) throws JspCoreException;

    protected abstract void visitJspUseBeanEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspGetPropertyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspGetPropertyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspSetPropertyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspSetPropertyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspPluginStart(Element var1) throws JspCoreException;

    protected abstract void visitJspPluginEnd(Element var1) throws JspCoreException;

    protected abstract void visitCustomTagStart(Element var1) throws JspCoreException;

    protected abstract void visitCustomTagEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspAttributeStart(Element var1) throws JspCoreException;

    protected abstract void visitJspAttributeEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspElementStart(Element var1) throws JspCoreException;

    protected abstract void visitJspElementEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspBodyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspBodyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspInvokeStart(Element var1) throws JspCoreException;

    protected abstract void visitJspInvokeEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspDoBodyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspDoBodyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspOutputStart(Element var1) throws JspCoreException;

    protected abstract void visitJspOutputEnd(Element var1) throws JspCoreException;

    protected abstract void visitUninterpretedTagStart(Element var1) throws JspCoreException;

    protected abstract void visitUninterpretedTagEnd(Element var1) throws JspCoreException;

    protected abstract void visitCDataTag(CDATASection var1) throws JspCoreException;

    public abstract JspVisitorResult getResult() throws JspCoreException;

    protected boolean isElementTagDependent(Element jspElement) throws JspCoreException {
        return false;
    }

    protected boolean isNodeTagDependent(Node node) throws JspCoreException {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        return this.isElementTagDependent((Element)node);
    }

    protected boolean shouldSkipChildrenForThisVisitor() {
        return false;
    }

    protected boolean shouldSkipChildren(Element jspElement) throws JspCoreException {
        if (!this.shouldSkipChildrenForThisVisitor()) {
            return false;
        }
        String uri = jspElement.getNamespaceURI();
        String name = jspElement.getLocalName();
        if (uri.equalsIgnoreCase("http://java.sun.com/JSP/Page") && name.equalsIgnoreCase("body")) {
            return this.isNodeTagDependent(jspElement.getParentNode());
        }
        if (!this.isElementTagDependent(jspElement)) {
            return false;
        }
        NodeList children = jspElement.getChildNodes();
        if (children.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            String elemURI;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !(elemURI = (element = (Element)node).getNamespaceURI()).equalsIgnoreCase("http://java.sun.com/JSP/Page")) continue;
            String elemName = element.getLocalName();
            return !elemName.equalsIgnoreCase("attribute") && !elemName.equalsIgnoreCase("body");
        }
        return false;
    }

    public void visit(Document jspDocument, int visitCount) throws JspCoreException {
        this.visitCount = visitCount;
        NodeList jspNodes = jspDocument.getChildNodes();
        for (int i = 0; i < jspNodes.getLength(); ++i) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "visit", "jspNodes.item(i) =[" + jspNodes.item(i) + "]");
            }
            Node jspNode = jspNodes.item(i);
            this.processJspElement(jspNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processJspElement(Node jspNode) throws JspCoreException {
        if (jspNode.getNodeType() == 1) {
            Element jspElement = (Element)jspNode;
            String namespaceURI = jspElement.getNamespaceURI();
            String jspElementType = jspElement.getLocalName();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "jspElement =[" + jspElement + "]  namespaceURI= [" + namespaceURI + "] jspElementType= [ " + jspElementType + "]");
            }
            if (namespaceURI != null && namespaceURI.equals("http://java.sun.com/JSP/Page")) {
                if (jspElementType.equals("root")) {
                    this.visitJspRootStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspRootEnd(jspElement);
                    return;
                } else if (jspElementType.equals("text")) {
                    this.visitJspTextStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspTextEnd(jspElement);
                    return;
                } else if (jspElementType.equals("directive.include")) {
                    this.visitIncludeDirectiveStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitIncludeDirectiveEnd(jspElement);
                    return;
                } else if (jspElementType.equals("directive.page")) {
                    this.visitPageDirectiveStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitPageDirectiveEnd(jspElement);
                    return;
                } else if (jspElementType.equals("directive.tag")) {
                    this.visitTagDirectiveStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitTagDirectiveEnd(jspElement);
                    return;
                } else if (jspElementType.equals("directive.attribute")) {
                    this.visitAttributeDirectiveStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitAttributeDirectiveEnd(jspElement);
                    return;
                } else if (jspElementType.equals("directive.variable")) {
                    this.visitVariableDirectiveStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitVariableDirectiveEnd(jspElement);
                    return;
                } else if (jspElementType.equals("declaration")) {
                    this.visitJspDeclarationStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspDeclarationEnd(jspElement);
                    return;
                } else if (jspElementType.equals("expression")) {
                    this.visitJspExpressionStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspExpressionEnd(jspElement);
                    return;
                } else if (jspElementType.equals("scriptlet")) {
                    this.visitJspScriptletStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspScriptletEnd(jspElement);
                    return;
                } else if (jspElementType.equals("param")) {
                    this.visitJspParamStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspParamEnd(jspElement);
                    return;
                } else if (jspElementType.equals("params")) {
                    this.visitJspParamsStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspParamsEnd(jspElement);
                    return;
                } else if (jspElementType.equals("fallback")) {
                    this.visitJspFallbackStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspFallbackEnd(jspElement);
                    return;
                } else if (jspElementType.equals("include")) {
                    this.visitJspIncludeStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspIncludeEnd(jspElement);
                    return;
                } else if (jspElementType.equals("forward")) {
                    this.visitJspForwardStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspForwardEnd(jspElement);
                    return;
                } else if (jspElementType.equals("useBean")) {
                    this.visitJspUseBeanStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspUseBeanEnd(jspElement);
                    return;
                } else if (jspElementType.equals("getProperty")) {
                    this.visitJspGetPropertyStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspGetPropertyEnd(jspElement);
                    return;
                } else if (jspElementType.equals("setProperty")) {
                    this.visitJspSetPropertyStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspSetPropertyEnd(jspElement);
                    return;
                } else if (jspElementType.equals("plugin")) {
                    this.visitJspPluginStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspPluginEnd(jspElement);
                    return;
                } else if (jspElementType.equals("attribute")) {
                    this.visitJspAttributeStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspAttributeEnd(jspElement);
                    return;
                } else if (jspElementType.equals("element")) {
                    this.visitJspElementStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspElementEnd(jspElement);
                    return;
                } else if (jspElementType.equals("body")) {
                    this.visitJspBodyStart(jspElement);
                    if (!this.shouldSkipChildren(jspElement)) {
                        this.processChildren(jspElement);
                    }
                    this.visitJspBodyEnd(jspElement);
                    return;
                } else if (jspElementType.equals("invoke")) {
                    this.visitJspInvokeStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspInvokeEnd(jspElement);
                    return;
                } else if (jspElementType.equals("doBody")) {
                    this.visitJspDoBodyStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspDoBodyEnd(jspElement);
                    return;
                } else {
                    if (!jspElementType.equals("output")) throw new JspTranslationException(jspElement, "jsp.error.element.unknown", new Object[]{jspElement.getTagName()});
                    this.visitJspOutputStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspOutputEnd(jspElement);
                }
                return;
            } else if (jspElement.getTagName().indexOf(58) != -1) {
                this.visitCustomTagStart(jspElement);
                if (!this.shouldSkipChildren(jspElement)) {
                    this.processChildren(jspElement);
                }
                this.visitCustomTagEnd(jspElement);
                return;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "About to call visitUninterpretedTagStart(jspElement), jspElement =[" + jspElement + "]");
                }
                this.visitUninterpretedTagStart(jspElement);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "About to call processChildren(jspElement), jspElement =[" + jspElement + "]");
                }
                this.processChildren(jspElement);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "About to call visitUninterpretedTagEnd(jspElement), jspElement =[" + jspElement + "]");
                }
                this.visitUninterpretedTagEnd(jspElement);
            }
            return;
        } else {
            if (jspNode.getNodeType() != 4) return;
            CDATASection cdata = (CDATASection)jspNode;
            Node parentNode = jspNode.getParentNode();
            if (parentNode.getNamespaceURI() != null && parentNode.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                if (parentNode.getLocalName().equals("text") || parentNode.getLocalName().equals("expression") || parentNode.getLocalName().equals("declaration") || parentNode.getLocalName().equals("scriptlet")) {
                    if (!this.isNodeTagDependent(parentNode)) return;
                    this.visitCDataTag(cdata);
                    return;
                } else {
                    this.visitCDataTag(cdata);
                }
                return;
            } else {
                this.visitCDataTag(cdata);
            }
        }
    }

    private void processChildren(Node jspNode) throws JspCoreException {
        NodeList childJspNodes = jspNode.getChildNodes();
        for (int i = 0; i < childJspNodes.getLength(); ++i) {
            Node n = childJspNodes.item(i);
            this.processJspElement(n);
        }
    }
}

