/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.utils;

import com.ibm.ws.jsp.translator.utils.SmapStratum;
import java.util.ArrayList;
import java.util.List;

public class SmapGenerator {
    private String outputFileName;
    private String defaultStratum = "Java";
    private List strata = new ArrayList();
    private List embedded = new ArrayList();
    private boolean doEmbedded = true;

    public synchronized void setOutputFileName(String x) {
        this.outputFileName = x;
    }

    public synchronized void addStratum(SmapStratum stratum, boolean defaultStratum) {
        this.strata.add(stratum);
        if (defaultStratum) {
            this.defaultStratum = stratum.getStratumName();
        }
    }

    public synchronized void addSmap(String smap, String stratumName) {
        this.embedded.add("*O " + stratumName + "\n" + smap + "*C " + stratumName + "\n");
    }

    public void setDoEmbedded(boolean status) {
        this.doEmbedded = status;
    }

    public synchronized String getString() {
        int i;
        if (this.outputFileName == null) {
            throw new IllegalStateException();
        }
        StringBuffer out = new StringBuffer();
        out.append("SMAP\n");
        out.append(this.outputFileName + '\n');
        out.append(this.defaultStratum + '\n');
        if (this.doEmbedded) {
            int nEmbedded = this.embedded.size();
            for (i = 0; i < nEmbedded; ++i) {
                out.append(this.embedded.get(i));
            }
        }
        int nStrata = this.strata.size();
        for (i = 0; i < nStrata; ++i) {
            SmapStratum s = (SmapStratum)this.strata.get(i);
            out.append(s.getString());
        }
        out.append("*E\n");
        return out.toString();
    }

    public String toString() {
        return this.getString();
    }
}

