/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.utils;

import com.ibm.ws.jsp.translator.utils.SmapGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SDEInstaller {
    private static final boolean verbose = false;
    static final String nameSDE = "SourceDebugExtension";
    byte[] orig;
    byte[] sdeAttr;
    byte[] gen;
    int origPos = 0;
    int genPos = 0;
    int sdeIndex;

    static void install(File inOutClassFile, SmapGenerator smapGenerator) throws IOException {
        File tmpFile = new File(inOutClassFile.getPath() + "tmp");
        new SDEInstaller(inOutClassFile, smapGenerator, tmpFile);
        if (!inOutClassFile.delete()) {
            throw new IOException("inOutClassFile.delete() failed");
        }
        if (!tmpFile.renameTo(inOutClassFile)) {
            throw new IOException("tmpFile.renameTo(inOutClassFile) failed");
        }
    }

    SDEInstaller(File inClassFile, SmapGenerator smapGenerator, File outClassFile) throws IOException {
        if (!inClassFile.exists()) {
            throw new FileNotFoundException("no such file: " + inClassFile);
        }
        this.orig = SDEInstaller.readWhole(inClassFile);
        this.sdeAttr = smapGenerator.toString().getBytes("UTF-8");
        this.gen = new byte[this.orig.length + this.sdeAttr.length + 100];
        this.addSDE();
        FileOutputStream outStream = new FileOutputStream(outClassFile);
        outStream.write(this.gen, 0, this.genPos);
        outStream.close();
    }

    static byte[] readWhole(File input) throws IOException {
        FileInputStream inStream = new FileInputStream(input);
        int len = (int)input.length();
        byte[] bytes = new byte[len];
        if (inStream.read(bytes, 0, len) != len) {
            throw new IOException("expected size: " + len);
        }
        inStream.close();
        return bytes;
    }

    void addSDE() throws UnsupportedEncodingException, IOException {
        this.copy(8);
        int constantPoolCountPos = this.genPos;
        int constantPoolCount = this.readU2();
        this.writeU2(constantPoolCount);
        this.sdeIndex = this.copyConstantPool(constantPoolCount);
        if (this.sdeIndex < 0) {
            this.writeUtf8ForSDE();
            this.sdeIndex = constantPoolCount++;
            this.randomAccessWriteU2(constantPoolCountPos, constantPoolCount);
        }
        this.copy(6);
        int interfaceCount = this.readU2();
        this.writeU2(interfaceCount);
        this.copy(interfaceCount * 2);
        this.copyMembers();
        this.copyMembers();
        int attrCountPos = this.genPos;
        int attrCount = this.readU2();
        this.writeU2(attrCount);
        if (!this.copyAttrs(attrCount)) {
            this.randomAccessWriteU2(attrCountPos, ++attrCount);
        }
        this.writeAttrForSDE(this.sdeIndex);
    }

    void copyMembers() {
        int count = this.readU2();
        this.writeU2(count);
        for (int i = 0; i < count; ++i) {
            this.copy(6);
            int attrCount = this.readU2();
            this.writeU2(attrCount);
            this.copyAttrs(attrCount);
        }
    }

    boolean copyAttrs(int attrCount) {
        boolean sdeFound = false;
        for (int i = 0; i < attrCount; ++i) {
            int nameIndex = this.readU2();
            if (nameIndex == this.sdeIndex) {
                sdeFound = true;
                continue;
            }
            this.writeU2(nameIndex);
            int len = this.readU4();
            this.writeU4(len);
            this.copy(len);
        }
        return sdeFound;
    }

    void writeAttrForSDE(int index) {
        this.writeU2(index);
        this.writeU4(this.sdeAttr.length);
        for (int i = 0; i < this.sdeAttr.length; ++i) {
            this.writeU1(this.sdeAttr[i]);
        }
    }

    void randomAccessWriteU2(int pos, int val) {
        int savePos = this.genPos;
        this.genPos = pos;
        this.writeU2(val);
        this.genPos = savePos;
    }

    int readU1() {
        return this.orig[this.origPos++] & 0xFF;
    }

    int readU2() {
        int res = this.readU1();
        return (res << 8) + this.readU1();
    }

    int readU4() {
        int res = this.readU2();
        return (res << 16) + this.readU2();
    }

    void writeU1(int val) {
        this.gen[this.genPos++] = (byte)val;
    }

    void writeU2(int val) {
        this.writeU1(val >> 8);
        this.writeU1(val & 0xFF);
    }

    void writeU4(int val) {
        this.writeU2(val >> 16);
        this.writeU2(val & 0xFFFF);
    }

    void copy(int count) {
        for (int i = 0; i < count; ++i) {
            this.gen[this.genPos++] = this.orig[this.origPos++];
        }
    }

    byte[] readBytes(int count) {
        byte[] bytes = new byte[count];
        for (int i = 0; i < count; ++i) {
            bytes[i] = this.orig[this.origPos++];
        }
        return bytes;
    }

    void writeBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            this.gen[this.genPos++] = bytes[i];
        }
    }

    int copyConstantPool(int constantPoolCount) throws UnsupportedEncodingException, IOException {
        int sdeIndex = -1;
        block6: for (int i = 1; i < constantPoolCount; ++i) {
            int tag = this.readU1();
            this.writeU1(tag);
            switch (tag) {
                case 7: 
                case 8: {
                    this.copy(2);
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.copy(4);
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.copy(8);
                    ++i;
                    continue block6;
                }
                case 1: {
                    int len = this.readU2();
                    this.writeU2(len);
                    byte[] utf8 = this.readBytes(len);
                    String str = new String(utf8, "UTF-8");
                    if (str.equals(nameSDE)) {
                        sdeIndex = i;
                    }
                    this.writeBytes(utf8);
                    continue block6;
                }
                default: {
                    throw new IOException("unexpected tag: " + tag);
                }
            }
        }
        return sdeIndex;
    }

    void writeUtf8ForSDE() {
        int len = nameSDE.length();
        this.writeU1(1);
        this.writeU2(len);
        for (int i = 0; i < len; ++i) {
            this.writeU1(nameSDE.charAt(i));
        }
    }
}

