/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.resource;

import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.resource.ResourceUtil;
import com.ibm.ws.jsp.translator.resource.ResourcesImpl;
import com.ibm.ws.jsp.translator.utils.NameMangler;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.TagFileResources;
import java.io.File;
import javax.servlet.jsp.tagext.TagFileInfo;

public class TagFileResourcesImpl
extends ResourcesImpl
implements TagFileResources {
    public TagFileResourcesImpl(JspInputSource inputSource, TagFileInfo tfi, JspOptions options, JspCoreContext context) {
        this.inputSource = inputSource;
        if (inputSource.getAbsoluteURL().getProtocol().equals("file")) {
            this.sourceFile = new File(context.getRealPath(inputSource.getRelativeURL()));
        } else {
            String file = inputSource.getContextURL().getFile();
            this.sourceFile = new File(file.substring(file.indexOf("file:") + 5, file.indexOf("!/")));
        }
        String tagFilePath = null;
        String tldOriginatorId = null;
        TagLibraryInfoImpl tli = (TagLibraryInfoImpl)tfi.getTagInfo().getTagLibrary();
        tldOriginatorId = tli.getOriginatorId();
        if (tfi.getPath().startsWith("/WEB-INF/tags")) {
            tagFilePath = tfi.getPath().substring(tfi.getPath().indexOf("/WEB-INF/tags") + 13);
        } else if (tfi.getPath().startsWith("/META-INF/tags")) {
            tagFilePath = tfi.getPath().substring(tfi.getPath().indexOf("/META-INF/tags") + 14);
        }
        tagFilePath = tagFilePath.substring(0, tagFilePath.lastIndexOf("/"));
        tagFilePath = tagFilePath.replace('/', File.separatorChar);
        tagFilePath = Constants.TAGFILE_PACKAGE_PATH + tldOriginatorId + tagFilePath;
        this.packageName = tagFilePath.replace(File.separatorChar, '.');
        this.className = tfi.getPath();
        this.className = this.className.substring(this.className.lastIndexOf(47) + 1);
        this.className = this.className.substring(0, this.className.indexOf(".tag"));
        this.className = NameMangler.mangleClassName(this.className);
        File generatedSourceDir = new File(options.getOutputDir().getPath() + File.separator + tagFilePath);
        String convertedName = generatedSourceDir.getPath() + File.separator + this.className;
        this.generatedSourceFile = new File(convertedName + ".java");
        this.classFile = new File(convertedName + ".class");
        String webinfClassFilePath = context.getRealPath("/WEB-INF/classes") + File.separator + tagFilePath;
        this.webinfClassFile = new File(webinfClassFilePath + File.separator + this.className + ".class");
        this.keepgenerated = options.isKeepGenerated();
        this.keepGeneratedclassfiles = options.isKeepGeneratedclassfiles();
        this.sourceFileTimestamp = this.sourceFile.lastModified();
    }

    public boolean isOutdated() {
        return ResourceUtil.isTagFileOutdated(this.sourceFile, this.generatedSourceFile, this.classFile, this.webinfClassFile);
    }

    public void syncGeneratedSource() {
        ResourceUtil.syncGeneratedSource(this.sourceFile, this.generatedSourceFile);
    }

    public void sync() {
        ResourceUtil.syncTagFile(this.sourceFile, this.generatedSourceFile, this.classFile, this.keepgenerated, this.keepGeneratedclassfiles);
        this.sourceFileTimestamp = this.sourceFile.lastModified();
    }
}

