/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.resource;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.translator.resource.ResourcesImpl;
import com.ibm.ws.jsp.translator.utils.NameMangler;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspResourcesImpl
extends ResourcesImpl
implements JspResources {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.resource.JspResourcesImpl";

    public JspResourcesImpl(JspInputSource inputSource, JspOptions options, JspCoreContext context) {
        this.inputSource = inputSource;
        String jspUri = inputSource.getRelativeURL();
        if (inputSource.getAbsoluteURL().getProtocol().equals("file")) {
            this.sourceFile = new File(context.getRealPath(jspUri));
        } else {
            try {
                this.sourceFile = File.createTempFile("jsp", NameMangler.mangleClassName(jspUri));
                this.sourceFile.deleteOnExit();
            }
            catch (IOException e1) {
                logger.logp(Level.WARNING, CLASS_NAME, "JspResourcesImpl", "Error creating temp file for jsp [" + jspUri + "]", e1);
            }
        }
        try {
            URL outURL = options.getOutputDir().toURL();
            String outURI = outURL.toString();
            if (jspUri.charAt(0) != '/') {
                jspUri = "/" + jspUri;
            }
            File generatedSourceDir = null;
            String convertedName = null;
            String webinfClassFilePath = null;
            if (!options.isUseFullPackageNames()) {
                this.packageName = "com.ibm._jsp";
                String unmangledOutURI = outURI;
                unmangledOutURI = unmangledOutURI.endsWith("/") ? unmangledOutURI + jspUri.substring(1, jspUri.lastIndexOf("/") + 1) : unmangledOutURI + jspUri.substring(0, jspUri.lastIndexOf("/") + 1);
                URL unmangledOutURL = new URL(unmangledOutURI);
                generatedSourceDir = new File(unmangledOutURL.getFile());
                this.className = NameMangler.mangleClassName(jspUri);
                convertedName = generatedSourceDir.getPath() + File.separator + this.className;
                this.generatedSourceFile = new File(convertedName + ".java");
                this.classFile = new File(convertedName + ".class");
                webinfClassFilePath = context.getRealPath("/WEB-INF/classes") + jspUri.substring(0, jspUri.lastIndexOf("/") + 1);
                this.webinfClassFile = new File(webinfClassFilePath + File.separator + this.className + ".class");
            } else {
                this.packageName = jspUri.substring(0, jspUri.lastIndexOf("/") + 1);
                if (!this.packageName.equals("/")) {
                    this.packageName = NameMangler.handlePackageName(this.packageName);
                    this.packageName = "_ibmjsp." + this.packageName.substring(0, this.packageName.length() - 1);
                } else {
                    this.packageName = "_ibmjsp";
                }
                String packageDir = this.packageName.replace('.', '/');
                outURI = outURI.endsWith("/") ? outURI + packageDir : outURI + "/" + packageDir;
                outURL = new URL(outURI);
                generatedSourceDir = new File(outURL.getFile());
                this.className = NameMangler.mangleClassName(jspUri);
                convertedName = generatedSourceDir.getPath() + File.separator + this.className;
                this.generatedSourceFile = new File(convertedName + ".java");
                this.classFile = new File(convertedName + ".class");
                webinfClassFilePath = context.getRealPath("/WEB-INF/classes") + "/" + packageDir;
                this.webinfClassFile = new File(webinfClassFilePath + File.separator + this.className + ".class");
            }
            this.keepgenerated = options.isKeepGenerated();
            this.keepGeneratedclassfiles = options.isKeepGeneratedclassfiles();
            this.sourceFileTimestamp = this.sourceFile.lastModified();
            if (!inputSource.getAbsoluteURL().getProtocol().equals("file") && this.classFile.exists()) {
                this.sourceFile.setLastModified(this.classFile.lastModified());
            }
        }
        catch (MalformedURLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jsp.translator.utils.JspFilesImpl.init", (String)"45", (Object)this);
            logger.logp(Level.WARNING, CLASS_NAME, "JspResourcesImpl", "Error creating temp directory for jsp [" + jspUri + "]", e);
        }
    }
}

