/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.optimizedtag.impl;

import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTag;
import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTagContext;

public class JSTLSetOptimizedTag
implements OptimizedTag {
    private String value = null;
    private String var = null;
    private String scope = null;
    private String target = null;
    private String property = null;

    public boolean canGenTagInMethod(OptimizedTagContext context) {
        return true;
    }

    public boolean doOptimization(OptimizedTagContext context) {
        boolean optimize = true;
        if (context.hasBody() || context.hasJspBody()) {
            optimize = false;
        } else if (context.isJspAttribute("value")) {
            optimize = false;
        } else if (context.isJspAttribute("var")) {
            optimize = false;
        } else if (context.isJspAttribute("scope")) {
            optimize = false;
        } else if (context.isJspAttribute("target")) {
            optimize = false;
        } else if (context.isJspAttribute("property")) {
            optimize = false;
        }
        return optimize;
    }

    public void generateImports(OptimizedTagContext context) {
    }

    public void generateDeclarations(OptimizedTagContext context) {
    }

    public void setAttribute(String attrName, Object attrValue) {
        if (attrName.equals("value")) {
            this.value = (String)attrValue;
        } else if (attrName.equals("var")) {
            this.var = (String)attrValue;
        } else if (attrName.equals("scope")) {
            this.scope = (String)attrValue;
        } else if (attrName.equals("target")) {
            this.target = (String)attrValue;
        } else if (attrName.equals("property")) {
            this.property = (String)attrValue;
        }
    }

    public void generateStart(OptimizedTagContext context) {
        String scopeV = null;
        if (context.hasAttribute("scope")) {
            if (this.scope.equals("page")) {
                scopeV = "PageContext.PAGE_SCOPE";
            } else if (this.scope.equals("request")) {
                scopeV = "PageContext.REQUEST_SCOPE";
            } else if (this.scope.equals("session")) {
                scopeV = "PageContext.SESSION_SCOPE";
            } else if (this.scope.equals("application")) {
                scopeV = "PageContext.APPLICATION_SCOPE";
            }
        }
        String valueV = context.createTemporaryVariable();
        context.writeSource("Object " + valueV + " = " + this.value + ";");
        if (context.hasAttribute("var")) {
            context.writeSource("if (" + valueV + " != null) {");
            if (scopeV == null) {
                context.writeSource("   pageContext.setAttribute(" + this.var + ", " + valueV + ");");
            } else {
                context.writeSource("   pageContext.setAttribute(" + this.var + ", " + valueV + ", " + scopeV + ");");
            }
            context.writeSource("} else {");
            if (scopeV == null) {
                context.writeSource("   pageContext.removeAttribute(" + this.var + ");");
            } else {
                context.writeSource("   pageContext.removeAttribute(" + this.var + ", " + scopeV + ");");
            }
            context.writeSource("}");
        } else if (context.hasAttribute("target")) {
            String targetV = context.createTemporaryVariable();
            context.writeSource("Object " + targetV + " = " + this.target + ";");
            String propertyV = context.createTemporaryVariable();
            context.writeSource("String " + propertyV + " = " + this.property + ";");
            context.writeSource("com.ibm.ws.jsp.translator.optimizedtag.impl.JSTLSetUtil.setProperty(pageContext, " + targetV + ", " + valueV + ", " + propertyV + ");");
        }
    }

    public void generateEnd(OptimizedTagContext context) {
    }
}

