/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.optimizedtag.impl;

import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTag;
import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTagContext;

public class JSTLOutOptimizedTag
implements OptimizedTag {
    String value = null;
    String escapeXml = null;
    String defaultValue = null;

    public boolean canGenTagInMethod(OptimizedTagContext context) {
        return true;
    }

    public boolean doOptimization(OptimizedTagContext context) {
        boolean optimize = true;
        if (context.hasBody() || context.hasJspBody()) {
            optimize = false;
        } else if (context.isJspAttribute("value")) {
            optimize = false;
        } else if (context.isJspAttribute("escapeXml")) {
            optimize = false;
        } else if (context.isJspAttribute("defaultValue")) {
            optimize = false;
        }
        return optimize;
    }

    public void setAttribute(String attrName, Object attrValue) {
        if (attrName.equals("value")) {
            this.value = (String)attrValue;
        } else if (attrName.equals("escapeXml")) {
            this.escapeXml = (String)attrValue;
        } else if (attrName.equals("default")) {
            this.defaultValue = (String)attrValue;
        }
    }

    public void generateImports(OptimizedTagContext context) {
    }

    public void generateDeclarations(OptimizedTagContext context) {
    }

    public void generateStart(OptimizedTagContext context) {
        if (context.hasAttribute("escapeXml")) {
            if (this.escapeXml.equalsIgnoreCase("true")) {
                context.writeSource("boolean escapeXml = true;");
            } else if (this.escapeXml.equalsIgnoreCase("false")) {
                context.writeSource("boolean escapeXml = false;");
            } else {
                context.writeSource("boolean escapeXml = " + this.escapeXml + ";");
            }
        } else {
            context.writeSource("boolean escapeXml = true;");
        }
        String valueV = context.createTemporaryVariable();
        context.writeSource("Object " + valueV + " = " + this.value + ";");
        String defaultValueV = context.createTemporaryVariable();
        context.writeSource("Object " + defaultValueV + " = " + this.defaultValue + ";");
        context.writeSource("if (" + valueV + " != null) {");
        context.writeSource("   com.ibm.ws.jsp.translator.optimizedtag.impl.JSTLOutUtil.writeOut(out, " + valueV + ", escapeXml);");
        context.writeSource("} else if (" + defaultValueV + " != null) {");
        context.writeSource("   com.ibm.ws.jsp.translator.optimizedtag.impl.JSTLOutUtil.writeOut(out, " + defaultValueV + ", escapeXml);");
        context.writeSource("} else {");
        context.writeSource("   out.write(\"\");");
        context.writeSource("}");
    }

    public void generateEnd(OptimizedTagContext context) {
    }
}

