/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.optimizedtag;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTagConfig;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OptimizedTagConfigParser
extends DefaultHandler {
    public static final String DTD_PUBLIC_ID = "http://www.ibm.com/xml/ns/OptimizedTag.xsd";
    public static final String DTD_RESOURCE_PATH = "/com/ibm/ws/jsp/translator/optimizedtag/OptimizedTag.xsd";
    protected SAXParser saxParser = null;
    protected JspCoreContext ctxt = null;
    protected StringBuffer chars = null;
    protected Map optimizedTagConfigMap = new HashMap();
    protected OptimizedTagConfig optimizedTagConfig = null;
    protected String className = null;
    protected String uri = null;
    protected String version = null;
    protected String shortName = null;

    public OptimizedTagConfigParser(JspCoreContext ctxt) throws JspCoreException {
        this.ctxt = ctxt;
        try {
            this.saxParser = ParserFactory.newSAXParser(false, true);
        }
        catch (ParserConfigurationException e) {
            throw new JspCoreException(e);
        }
        catch (SAXException e) {
            throw new JspCoreException(e);
        }
    }

    public Map parse(InputStream is) throws JspCoreException {
        this.optimizedTagConfigMap.clear();
        try {
            ParserFactory.parseDocument(this.saxParser, is, (DefaultHandler)this);
        }
        catch (SAXException e) {
            if (e.getCause() != null) {
                throw new JspCoreException(e.getCause());
            }
            throw new JspCoreException(e);
        }
        catch (IOException e) {
            throw new JspCoreException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        HashMap m = new HashMap();
        m.putAll(this.optimizedTagConfigMap);
        return m;
    }

    public void startElement(String namespaceURI, String localName, String elementName, Attributes attrs) throws SAXException {
        this.chars = new StringBuffer();
        if (elementName.equals("optimized-tag")) {
            this.optimizedTagConfig = new OptimizedTagConfig();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < length; ++i) {
            if (this.chars == null) continue;
            this.chars.append(ch[start + i]);
        }
    }

    public void endElement(String namespaceURI, String localName, String elementName) throws SAXException {
        if (elementName.equals("class-name")) {
            this.className = this.chars.toString().trim();
        } else if (elementName.equals("short-name")) {
            this.shortName = this.chars.toString().trim();
        } else if (elementName.equals("taglib-uri")) {
            this.uri = this.chars.toString().trim();
        } else if (elementName.equals("tlib-version")) {
            this.version = this.chars.toString().trim();
        } else if (elementName.equals("optimized-tag")) {
            try {
                Class<?> optClass = Class.forName(this.className, true, this.ctxt.getJspClassloaderContext().getClassLoader());
                this.optimizedTagConfig.setOptClass(optClass);
                this.optimizedTagConfig.setShortName(this.shortName);
                this.optimizedTagConfig.setTlibUri(this.uri);
                this.optimizedTagConfig.setTlibversion(this.version);
                this.optimizedTagConfigMap.put(this.uri + this.version + this.shortName, this.optimizedTagConfig);
            }
            catch (ClassNotFoundException e) {
                throw new SAXException(e);
            }
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource isrc = null;
        String resourcePath = null;
        if (publicId.equals(DTD_PUBLIC_ID)) {
            resourcePath = DTD_RESOURCE_PATH;
        }
        if (resourcePath != null) {
            InputStream input = this.getClass().getResourceAsStream(resourcePath);
            if (input == null) {
                throw new SAXException("jsp.error.internal.dtd.not.found");
            }
            isrc = new InputSource(input);
        }
        return isrc;
    }
}

