/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.document.Jsp2Dom;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JspDocumentConverter {
    private JspInputSource inputSource = null;
    private String resovledRelativeURL = null;
    private String encodedRelativeURL = null;
    private JspCoreContext ctxt = null;
    private JspConfiguration jspConfiguration = null;
    private JspOptions jspOptions = null;
    private Stack directoryStack = null;
    private Stack dependencyStack = null;
    private List dependencyList = null;
    private Map cdataJspIdMap = null;
    private Map implicitTagLibMap = null;
    private String jspPrefix = "jsp";

    public JspDocumentConverter(JspInputSource inputSource, String resovledRelativeURL, JspCoreContext ctxt, Stack directoryStack, JspConfiguration jspConfiguration, JspOptions jspOptions, Stack dependencyStack, List dependencyList, Map cdataJspIdMap, Map implicitTagLibMap) {
        this.inputSource = inputSource;
        this.resovledRelativeURL = resovledRelativeURL;
        try {
            this.encodedRelativeURL = URLEncoder.encode(resovledRelativeURL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.ctxt = ctxt;
        this.jspConfiguration = jspConfiguration;
        this.jspOptions = jspOptions;
        this.directoryStack = directoryStack;
        this.dependencyStack = dependencyStack;
        this.dependencyList = dependencyList;
        this.cdataJspIdMap = cdataJspIdMap;
        this.implicitTagLibMap = implicitTagLibMap;
    }

    public Document convert() throws JspCoreException {
        Document convertedDocument = null;
        try {
            convertedDocument = ParserFactory.newDocument(false, false);
        }
        catch (ParserConfigurationException e) {
            throw new JspCoreException(e);
        }
        this.convertDocument(convertedDocument, convertedDocument, this.inputSource.getDocument().getChildNodes());
        return convertedDocument;
    }

    private void convertDocument(Document convertedDocument, Node node, NodeList childNodes) throws JspCoreException {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNamespaceURI() != null && childNode.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                this.jspPrefix = childNode.getPrefix();
            }
            if (childNode.getNodeType() == 1) {
                Element element = (Element)childNode;
                if (element.getLocalName() != null && element.getLocalName().equals("directive.include") && element.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                    this.insertInclude(convertedDocument, element.getParentNode(), element.getAttribute("file"));
                    continue;
                }
                Node newNode = convertedDocument.importNode(childNode, false);
                StringBuffer attrNames = new StringBuffer();
                NamedNodeMap attrs = element.getAttributes();
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Attr attr = (Attr)attrs.item(j);
                    if (attr.getNodeName().startsWith("xmlns")) continue;
                    if (attr.getPrefix() != null) {
                        attrNames.append(attr.getPrefix() + ":" + attr.getLocalName() + "~");
                        continue;
                    }
                    attrNames.append(attr.getLocalName() + "~");
                }
                String jspId = null;
                jspId = attrs.getLength() > 0 ? "{" + attrNames.toString() + "}" + this.encodedRelativeURL + "[0,0,0]" : this.encodedRelativeURL + "[0,0,0]";
                ((Element)newNode).setAttributeNS("http://java.sun.com/JSP/Page", this.jspPrefix + ":id", jspId);
                node.appendChild(newNode);
                this.convertDocument(convertedDocument, newNode, childNode.getChildNodes());
                continue;
            }
            if (childNode.getNodeType() == 4) {
                boolean keepWhitespace = false;
                boolean nonWhiteSpaceFound = false;
                if (node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && node.getLocalName().equals("text")) {
                    keepWhitespace = true;
                }
                CDATASection cdata = (CDATASection)childNode;
                for (int j = 0; j < cdata.getLength(); ++j) {
                    char ch = cdata.getData().charAt(j);
                    if (ch == '\n' || ch == ' ' || ch == '\r' || ch == '\t') continue;
                    nonWhiteSpaceFound = true;
                }
                if (nonWhiteSpaceFound) {
                    Node newNode = convertedDocument.importNode(childNode, false);
                    node.appendChild(newNode);
                    continue;
                }
                if (!keepWhitespace) continue;
                Node newNode = convertedDocument.importNode(childNode, false);
                node.appendChild(newNode);
                continue;
            }
            if (childNode.getNodeType() == 3) {
                boolean keepWhitespace = false;
                boolean nonWhiteSpaceFound = false;
                if (node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && node.getLocalName().equals("text")) {
                    keepWhitespace = true;
                }
                Text text = (Text)childNode;
                for (int j = 0; j < text.getLength(); ++j) {
                    char ch = text.getData().charAt(j);
                    if (ch == '\n' || ch == ' ' || ch == '\r' || ch == '\t') continue;
                    nonWhiteSpaceFound = true;
                }
                if (nonWhiteSpaceFound) {
                    CDATASection newNode = convertedDocument.createCDATASection(text.getData());
                    node.appendChild(newNode);
                    continue;
                }
                if (!keepWhitespace) continue;
                CDATASection newNode = convertedDocument.createCDATASection(text.getData());
                node.appendChild(newNode);
                continue;
            }
            Node newNode = convertedDocument.importNode(childNode, false);
            node.appendChild(newNode);
            this.convertDocument(convertedDocument, newNode, childNode.getChildNodes());
        }
    }

    private void insertInclude(Document document, Node parentNode, String includePath) throws JspCoreException {
        String fullPath = this.ctxt.getRealPath(includePath);
        if (this.dependencyStack.contains(fullPath)) {
            throw new JspCoreException("jsp.error.static.include.circular.dependency", new Object[]{fullPath});
        }
        this.dependencyStack.push(fullPath);
        if (this.inputSource.getAbsoluteURL().getProtocol().equals("file")) {
            String depIncludePath = includePath;
            if (!depIncludePath.startsWith("/")) {
                int pos = this.resovledRelativeURL.lastIndexOf("/");
                depIncludePath = pos > 0 ? this.resovledRelativeURL.substring(0, pos + 1) + depIncludePath : "/" + depIncludePath;
            }
            this.dependencyList.add(depIncludePath);
        }
        JspConfiguration includeConfiguration = this.jspConfiguration.getConfigManager().getConfigurationForStaticInclude(includePath, this.jspConfiguration);
        JspInputSource includePathInputSource = this.ctxt.getJspInputSourceFactory().copyJspInputSource(this.inputSource, includePath);
        Jsp2Dom jsp2Dom = new Jsp2Dom(includePathInputSource, this.ctxt, this.directoryStack, includeConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap, true);
        Document includeDocument = jsp2Dom.getJspDocument();
        if (includeDocument.getDocumentElement().getNamespaceURI() != null && includeDocument.getDocumentElement().getNamespaceURI().equals("http://java.sun.com/JSP/Page") && includeDocument.getDocumentElement().getLocalName().equals("root")) {
            for (int i = 0; i < includeDocument.getDocumentElement().getChildNodes().getLength(); ++i) {
                Integer nodeHashCode;
                Node nodeToBeCopied = includeDocument.getDocumentElement().getChildNodes().item(i);
                Node n = document.importNode(nodeToBeCopied, true);
                if (nodeToBeCopied.getNodeType() == 4 && this.cdataJspIdMap.containsKey(nodeHashCode = new Integer(nodeToBeCopied.hashCode()))) {
                    String jspId = (String)this.cdataJspIdMap.remove(nodeHashCode);
                    this.cdataJspIdMap.put(new Integer(n.hashCode()), jspId);
                }
                parentNode.appendChild(n);
            }
        } else {
            for (int i = 0; i < includeDocument.getChildNodes().getLength(); ++i) {
                Node n = document.importNode(includeDocument.getChildNodes().item(i), true);
                parentNode.appendChild(n);
            }
        }
        this.dependencyStack.pop();
    }

    public void printElements(Element element, int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("\t");
        }
        System.out.println("Element - " + element.getNodeName());
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            for (int j = 0; j < level; ++j) {
                System.out.print("\t");
            }
            System.out.println("Attr - " + attr.getName() + " : " + attr.getValue() + " : " + attr.getNamespaceURI());
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String s;
            Node n = nl.item(i);
            if (n instanceof Element) {
                Element childElement = (Element)n;
                System.out.println();
                this.printElements(childElement, level + 1);
                continue;
            }
            if (n instanceof CDATASection) {
                System.out.println();
                CDATASection cdata = (CDATASection)n;
                for (int j = 0; j < level + 1; ++j) {
                    System.out.print("\t");
                }
                s = cdata.getData();
                s = s.replaceAll("\r", "");
                s = s.replaceAll("\n", "{cr}");
                System.out.println("CDATA - [" + s + "]");
                continue;
            }
            if (!(n instanceof Text)) continue;
            System.out.println();
            Text text = (Text)n;
            for (int j = 0; j < level + 1; ++j) {
                System.out.print("\t");
            }
            s = text.getData();
            s = s.replaceAll("\r", "");
            s = s.replaceAll("\n", "{cr}");
            System.out.println("Text - [" + s + "]");
        }
    }
}

